/* packet-dcm.h
 * Definitions for DICOM dissection
 * Copyright 2003, Rich Coe <richcoe2@gmail.com>
 * Copyright 2008-2018, David Aggeler <david_aggeler@hispeed.ch>
 *
 * DICOM communication protocol: https://www.dicomstandard.org/current/
 *
 * Generated automatically by make-packet-dcm.py from the following sources:
 *
 * DICOM PS3.5 2019e - Data Structures and Encoding
 * DICOM PS3.6 2019e - Data Dictionary
 * DICOM PS3.7 2019e - Message Exchange
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef __PACKET_DCM_H__
#define __PACKET_DCM_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "config.h"


#define DCM_VR_AE  1  /* Application Entity        */
#define DCM_VR_AS  2  /* Age String                */
#define DCM_VR_AT  3  /* Attribute Tag             */
#define DCM_VR_CS  4  /* Code String               */
#define DCM_VR_DA  5  /* Date                      */
#define DCM_VR_DS  6  /* Decimal String            */
#define DCM_VR_DT  7  /* Date Time                 */
#define DCM_VR_FL  8  /* Floating Point Single     */
#define DCM_VR_FD  9  /* Floating Point Double     */
#define DCM_VR_IS 10  /* Integer String            */
#define DCM_VR_LO 11  /* Long String               */
#define DCM_VR_LT 12  /* Long Text                 */
#define DCM_VR_OB 13  /* Other Byte                */
#define DCM_VR_OD 14  /* Other Double              */
#define DCM_VR_OF 15  /* Other Float               */
#define DCM_VR_OL 16  /* Other Long                */
#define DCM_VR_OV 17  /* Other 64-bit Very Long    */
#define DCM_VR_OW 18  /* Other Word                */
#define DCM_VR_PN 19  /* Person Name               */
#define DCM_VR_SH 20  /* Short String              */
#define DCM_VR_SL 21  /* Signed Long               */
#define DCM_VR_SQ 22  /* Sequence of Items         */
#define DCM_VR_SS 23  /* Signed Short              */
#define DCM_VR_ST 24  /* Short Text                */
#define DCM_VR_SV 25  /* Signed 64-bit Very Long   */
#define DCM_VR_TM 26  /* Time                      */
#define DCM_VR_UC 27  /* Unlimited Characters      */
#define DCM_VR_UI 28  /* Unique Identifier (UID)   */
#define DCM_VR_UL 29  /* Unsigned Long             */
#define DCM_VR_UN 30  /* Unknown                   */
#define DCM_VR_UR 31  /* Universal Resource Identifier or Universal Resource Locator (URI/URL) */
#define DCM_VR_US 32  /* Unsigned Short            */
#define DCM_VR_UT 33  /* Unlimited Text            */
#define DCM_VR_UV 34  /* Unsigned 64-bit Very Long */

/* Following must be in the same order as the definitions above */
static const gchar* dcm_tag_vr_lookup[] = {
    "  ",
    "AE","AS","AT","CS","DA","DS","DT","FL",
    "FD","IS","LO","LT","OB","OD","OF","OL",
    "OV","OW","PN","SH","SL","SQ","SS","ST",
    "SV","TM","UC","UI","UL","UN","UR","US",
    "UT","UV"
};


/* ---------------------------------------------------------------------
 * DICOM Tag Definitions
 *
 * Some Tags can have different VRs
 *
 * Group 1000 is not supported, multiple tags with same description  (retired anyhow)
 * Group 7Fxx is not supported, multiple tags with same description  (retired anyhow)
 *
 * Tags (0020,3100 to 0020, 31FF) not supported, multiple tags with same description  (retired anyhow)
 *
 * Repeating groups (50xx & 60xx) are manually added. Declared as 5000 & 6000
 */

typedef struct dcm_tag {
    const guint32 tag;
    const gchar *description;
    const gchar *vr;
    const gchar *vm;
    const gboolean is_retired;
    const gboolean add_to_summary;          /* Add to parent's item description */
} dcm_tag_t;

static dcm_tag_t dcm_tag_data[] = {

    /* Command Tags */
    { 0x00000000, "Command Group Length", "UL", "1", 0, 0},
    { 0x00000002, "Affected SOP Class UID", "UI", "1", 0, 0},
    { 0x00000003, "Requested SOP Class UID", "UI", "1", 0, 0},
    { 0x00000100, "Command Field", "US", "1", 0, 0},
    { 0x00000110, "Message ID", "US", "1", 0, 0},
    { 0x00000120, "Message ID Being Responded To", "US", "1", 0, 0},
    { 0x00000600, "Move Destination", "AE", "1", 0, 0},
    { 0x00000700, "Priority", "US", "1", 0, 0},
    { 0x00000800, "Command Data Set Type", "US", "1", 0, 0},
    { 0x00000900, "Status", "US", "1", 0, 0},
    { 0x00000901, "Offending Element", "AT", "1-n", 0, 0},
    { 0x00000902, "Error Comment", "LO", "1", 0, 0},
    { 0x00000903, "Error ID", "US", "1", 0, 0},
    { 0x00001000, "Affected SOP Instance UID", "UI", "1", 0, 0},
    { 0x00001001, "Requested SOP Instance UID", "UI", "1", 0, 0},
    { 0x00001002, "Event Type ID", "US", "1", 0, 0},
    { 0x00001005, "Attribute Identifier List", "AT", "1-n", 0, 0},
    { 0x00001008, "Action Type ID", "US", "1", 0, 0},
    { 0x00001020, "Number of Remaining Sub-operations", "US", "1", 0, 0},
    { 0x00001021, "Number of Completed Sub-operations", "US", "1", 0, 0},
    { 0x00001022, "Number of Failed Sub-operations", "US", "1", 0, 0},
    { 0x00001023, "Number of Warning Sub-operations", "US", "1", 0, 0},
    { 0x00001030, "Move Originator Application Entity Title", "AE", "1", 0, 0},
    { 0x00001031, "Move Originator Message ID", "US", "1", 0, 0},
    { 0x00000001, "Command Length to End", "UL", "1", -1, 0},
    { 0x00000010, "Command Recognition Code", "SH", "1", -1, 0},
    { 0x00000200, "Initiator", "AE", "1", -1, 0},
    { 0x00000300, "Receiver", "AE", "1", -1, 0},
    { 0x00000400, "Find Location", "AE", "1", -1, 0},
    { 0x00000850, "Number of Matches", "US", "1", -1, 0},
    { 0x00000860, "Response Sequence Number", "US", "1", -1, 0},
    { 0x00004000, "Dialog Receiver", "LT", "1", -1, 0},
    { 0x00004010, "Terminal Type", "LT", "1", -1, 0},
    { 0x00005010, "Message Set ID", "SH", "1", -1, 0},
    { 0x00005020, "End Message ID", "SH", "1", -1, 0},
    { 0x00005110, "Display Format", "LT", "1", -1, 0},
    { 0x00005120, "Page Position ID", "LT", "1", -1, 0},
    { 0x00005130, "Text Format ID", "CS", "1", -1, 0},
    { 0x00005140, "Normal/Reverse", "CS", "1", -1, 0},
    { 0x00005150, "Add Gray Scale", "CS", "1", -1, 0},
    { 0x00005160, "Borders", "CS", "1", -1, 0},
    { 0x00005170, "Copies", "IS", "1", -1, 0},
    { 0x00005180, "Command Magnification Type", "CS", "1", -1, 0},
    { 0x00005190, "Erase", "CS", "1", -1, 0},
    { 0x000051A0, "Print", "CS", "1", -1, 0},
    { 0x000051B0, "Overlays", "US", "1-n", -1, 0},

    /* Data Tags */
    { 0x00080001, "Length to End", "UL", "1", -1, 0},
    { 0x00080005, "Specific Character Set", "CS", "1-n", 0, 0},
    { 0x00080006, "Language Code Sequence", "SQ", "1", 0, 0},
    { 0x00080008, "Image Type", "CS", "2-n", 0, 0},
    { 0x00080010, "Recognition Code", "SH", "1", -1, 0},
    { 0x00080012, "Instance Creation Date", "DA", "1", 0, 0},
    { 0x00080013, "Instance Creation Time", "TM", "1", 0, 0},
    { 0x00080014, "Instance Creator UID", "UI", "1", 0, 0},
    { 0x00080015, "Instance Coercion DateTime", "DT", "1", 0, 0},
    { 0x00080016, "SOP Class UID", "UI", "1", 0, 0},
    { 0x00080018, "SOP Instance UID", "UI", "1", 0, 0},
    { 0x0008001A, "Related General SOP Class UID", "UI", "1-n", 0, 0},
    { 0x0008001B, "Original Specialized SOP Class UID", "UI", "1", 0, 0},
    { 0x00080020, "Study Date", "DA", "1", 0, 0},
    { 0x00080021, "Series Date", "DA", "1", 0, 0},
    { 0x00080022, "Acquisition Date", "DA", "1", 0, 0},
    { 0x00080023, "Content Date", "DA", "1", 0, 0},
    { 0x00080024, "Overlay Date", "DA", "1", -1, 0},
    { 0x00080025, "Curve Date", "DA", "1", -1, 0},
    { 0x0008002A, "Acquisition DateTime", "DT", "1", 0, 0},
    { 0x00080030, "Study Time", "TM", "1", 0, 0},
    { 0x00080031, "Series Time", "TM", "1", 0, 0},
    { 0x00080032, "Acquisition Time", "TM", "1", 0, 0},
    { 0x00080033, "Content Time", "TM", "1", 0, 0},
    { 0x00080034, "Overlay Time", "TM", "1", -1, 0},
    { 0x00080035, "Curve Time", "TM", "1", -1, 0},
    { 0x00080040, "Data Set Type", "US", "1", -1, 0},
    { 0x00080041, "Data Set Subtype", "LO", "1", -1, 0},
    { 0x00080042, "Nuclear Medicine Series Type", "CS", "1", -1, 0},
    { 0x00080050, "Accession Number", "SH", "1", 0, 0},
    { 0x00080051, "Issuer of Accession Number Sequence", "SQ", "1", 0, 0},
    { 0x00080052, "Query/Retrieve Level", "CS", "1", 0, 0},
    { 0x00080053, "Query/Retrieve View", "CS", "1", 0, 0},
    { 0x00080054, "Retrieve AE Title", "AE", "1-n", 0, 0},
    { 0x00080055, "Station  AE Title", "AE", "1", 0, 0},
    { 0x00080056, "Instance Availability", "CS", "1", 0, 0},
    { 0x00080058, "Failed SOP Instance UID List", "UI", "1-n", 0, 0},
    { 0x00080060, "Modality", "CS", "1", 0, 0},
    { 0x00080061, "Modalities in Study", "CS", "1-n", 0, 0},
    { 0x00080062, "SOP Classes in Study", "UI", "1-n", 0, 0},
    { 0x00080063, "Anatomic Regions in Study Code Sequence", "SQ", "1", 0, 0},
    { 0x00080064, "Conversion Type", "CS", "1", 0, 0},
    { 0x00080068, "Presentation Intent Type", "CS", "1", 0, 0},
    { 0x00080070, "Manufacturer", "LO", "1", 0, 0},
    { 0x00080080, "Institution Name", "LO", "1", 0, 0},
    { 0x00080081, "Institution Address", "ST", "1", 0, 0},
    { 0x00080082, "Institution Code Sequence", "SQ", "1", 0, 0},
    { 0x00080090, "Referring Physician's Name", "PN", "1", 0, 0},
    { 0x00080092, "Referring Physician's Address", "ST", "1", 0, 0},
    { 0x00080094, "Referring Physician's Telephone Numbers", "SH", "1-n", 0, 0},
    { 0x00080096, "Referring Physician Identification Sequence", "SQ", "1", 0, 0},
    { 0x0008009C, "Consulting Physician's Name", "PN", "1-n", 0, 0},
    { 0x0008009D, "Consulting Physician Identification Sequence", "SQ", "1", 0, 0},
    { 0x00080100, "Code Value", "SH", "1", 0, 0},
    { 0x00080101, "Extended Code Value", "LO", "1", 0, 0},
    { 0x00080102, "Coding Scheme Designator", "SH", "1", 0, 0},
    { 0x00080103, "Coding Scheme Version", "SH", "1", 0, 0},
    { 0x00080104, "Code Meaning", "LO", "1", 0, 0},
    { 0x00080105, "Mapping Resource", "CS", "1", 0, 0},
    { 0x00080106, "Context Group Version", "DT", "1", 0, 0},
    { 0x00080107, "Context Group Local Version", "DT", "1", 0, 0},
    { 0x00080108, "Extended Code Meaning", "LT", "1", 0, 0},
    { 0x00080109, "Coding Scheme Resources Sequence", "SQ", "1", 0, 0},
    { 0x0008010A, "Coding Scheme URL Type", "CS", "1", 0, 0},
    { 0x0008010B, "Context Group Extension Flag", "CS", "1", 0, 0},
    { 0x0008010C, "Coding Scheme UID", "UI", "1", 0, 0},
    { 0x0008010D, "Context Group Extension Creator UID", "UI", "1", 0, 0},
    { 0x0008010E, "Coding Scheme URL", "UR", "1", 0, 0},
    { 0x0008010F, "Context Identifier", "CS", "1", 0, 0},
    { 0x00080110, "Coding Scheme Identification Sequence", "SQ", "1", 0, 0},
    { 0x00080112, "Coding Scheme Registry", "LO", "1", 0, 0},
    { 0x00080114, "Coding Scheme External ID", "ST", "1", 0, 0},
    { 0x00080115, "Coding Scheme Name", "ST", "1", 0, 0},
    { 0x00080116, "Coding Scheme Responsible Organization", "ST", "1", 0, 0},
    { 0x00080117, "Context UID", "UI", "1", 0, 0},
    { 0x00080118, "Mapping Resource UID", "UI", "1", 0, 0},
    { 0x00080119, "Long Code Value", "UC", "1", 0, 0},
    { 0x00080120, "URN Code Value", "UR", "1", 0, 0},
    { 0x00080121, "Equivalent Code Sequence", "SQ", "1", 0, 0},
    { 0x00080122, "Mapping Resource Name", "LO", "1", 0, 0},
    { 0x00080123, "Context Group Identification Sequence", "SQ", "1", 0, 0},
    { 0x00080124, "Mapping Resource Identification Sequence", "SQ", "1", 0, 0},
    { 0x00080201, "Timezone Offset From UTC", "SH", "1", 0, 0},
    { 0x00080220, "Responsible Group Code Sequence", "SQ", "1", 0, 0},
    { 0x00080221, "Equipment Modality", "CS", "1", 0, 0},
    { 0x00080222, "Manufacturer's Related Model Group", "LO", "1", 0, 0},
    { 0x00080300, "Private Data Element Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x00080301, "Private Group Reference", "US", "1", 0, 0},
    { 0x00080302, "Private Creator Reference", "LO", "1", 0, 0},
    { 0x00080303, "Block Identifying Information Status", "CS", "1", 0, 0},
    { 0x00080304, "Nonidentifying Private Elements", "US", "1-n", 0, 0},
    { 0x00080306, "Identifying Private Elements", "US", "1-n", 0, 0},
    { 0x00080305, "Deidentification Action Sequence", "SQ", "1", 0, 0},
    { 0x00080307, "Deidentification Action", "CS", "1", 0, 0},
    { 0x00080308, "Private Data Element", "US", "1", 0, 0},
    { 0x00080309, "Private Data Element Value Multiplicity", "UL", "1-3", 0, 0},
    { 0x0008030A, "Private Data Element Value Representation", "CS", "1", 0, 0},
    { 0x0008030B, "Private Data Element Number of Items", "UL", "1-2", 0, 0},
    { 0x0008030C, "Private Data Element Name", "UC", "1", 0, 0},
    { 0x0008030D, "Private Data Element Keyword", "UC", "1", 0, 0},
    { 0x0008030E, "Private Data Element Description", "UT", "1", 0, 0},
    { 0x0008030F, "Private Data Element Encoding", "UT", "1", 0, 0},
    { 0x00080310, "Private Data Element Definition Sequence", "SQ", "1", 0, 0},
    { 0x00081000, "Network ID", "AE", "1", -1, 0},
    { 0x00081010, "Station Name", "SH", "1", 0, 0},
    { 0x00081030, "Study Description", "LO", "1", 0, 0},
    { 0x00081032, "Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x0008103E, "Series Description", "LO", "1", 0, 0},
    { 0x0008103F, "Series Description Code Sequence", "SQ", "1", 0, 0},
    { 0x00081040, "Institutional Department Name", "LO", "1", 0, 0},
    { 0x00081041, "Institutional Department Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00081048, "Physician(s) of Record", "PN", "1-n", 0, 0},
    { 0x00081049, "Physician(s) of Record Identification Sequence", "SQ", "1", 0, 0},
    { 0x00081050, "Performing Physician's Name", "PN", "1-n", 0, 0},
    { 0x00081052, "Performing Physician Identification Sequence", "SQ", "1", 0, 0},
    { 0x00081060, "Name of Physician(s) Reading Study", "PN", "1-n", 0, 0},
    { 0x00081062, "Physician(s) Reading Study Identification Sequence", "SQ", "1", 0, 0},
    { 0x00081070, "Operators' Name", "PN", "1-n", 0, 0},
    { 0x00081072, "Operator Identification Sequence", "SQ", "1", 0, 0},
    { 0x00081080, "Admitting Diagnoses Description", "LO", "1-n", 0, 0},
    { 0x00081084, "Admitting Diagnoses Code Sequence", "SQ", "1", 0, 0},
    { 0x00081090, "Manufacturer's Model Name", "LO", "1", 0, 0},
    { 0x00081100, "Referenced Results Sequence", "SQ", "1", -1, 0},
    { 0x00081110, "Referenced Study Sequence", "SQ", "1", 0, 0},
    { 0x00081111, "Referenced Performed Procedure Step Sequence", "SQ", "1", 0, 0},
    { 0x00081115, "Referenced Series Sequence", "SQ", "1", 0, 0},
    { 0x00081120, "Referenced Patient Sequence", "SQ", "1", 0, 0},
    { 0x00081125, "Referenced Visit Sequence", "SQ", "1", 0, 0},
    { 0x00081130, "Referenced Overlay Sequence", "SQ", "1", -1, 0},
    { 0x00081134, "Referenced Stereometric Instance Sequence", "SQ", "1", 0, 0},
    { 0x0008113A, "Referenced Waveform Sequence", "SQ", "1", 0, 0},
    { 0x00081140, "Referenced Image Sequence", "SQ", "1", 0, 0},
    { 0x00081145, "Referenced Curve Sequence", "SQ", "1", -1, 0},
    { 0x0008114A, "Referenced Instance Sequence", "SQ", "1", 0, 0},
    { 0x0008114B, "Referenced Real World Value Mapping Instance Sequence", "SQ", "1", 0, 0},
    { 0x00081150, "Referenced SOP Class UID", "UI", "1", 0, 0},
    { 0x00081155, "Referenced SOP Instance UID", "UI", "1", 0, 0},
    { 0x00081156, "Definition Source Sequence", "SQ", "1", 0, 0},
    { 0x0008115A, "SOP Classes Supported", "UI", "1-n", 0, 0},
    { 0x00081160, "Referenced Frame Number", "IS", "1-n", 0, 0},
    { 0x00081161, "Simple Frame List", "UL", "1-n", 0, 0},
    { 0x00081162, "Calculated Frame List", "UL", "3-3n", 0, 0},
    { 0x00081163, "Time Range", "FD", "2", 0, 0},
    { 0x00081164, "Frame Extraction Sequence", "SQ", "1", 0, 0},
    { 0x00081167, "Multi-frame Source SOP Instance UID", "UI", "1", 0, 0},
    { 0x00081190, "Retrieve URL", "UR", "1", 0, 0},
    { 0x00081195, "Transaction UID", "UI", "1", 0, 0},
    { 0x00081196, "Warning Reason", "US", "1", 0, 0},
    { 0x00081197, "Failure Reason", "US", "1", 0, 0},
    { 0x00081198, "Failed SOP Sequence", "SQ", "1", 0, 0},
    { 0x00081199, "Referenced SOP Sequence", "SQ", "1", 0, 0},
    { 0x0008119A, "Other Failures Sequence", "SQ", "1", 0, 0},
    { 0x00081200, "Studies Containing Other Referenced Instances Sequence", "SQ", "1", 0, 0},
    { 0x00081250, "Related Series Sequence", "SQ", "1", 0, 0},
    { 0x00082110, "Lossy Image Compression (Retired)", "CS", "1", -1, 0},
    { 0x00082111, "Derivation Description", "ST", "1", 0, 0},
    { 0x00082112, "Source Image Sequence", "SQ", "1", 0, 0},
    { 0x00082120, "Stage Name", "SH", "1", 0, 0},
    { 0x00082122, "Stage Number", "IS", "1", 0, 0},
    { 0x00082124, "Number of Stages", "IS", "1", 0, 0},
    { 0x00082127, "View Name", "SH", "1", 0, 0},
    { 0x00082128, "View Number", "IS", "1", 0, 0},
    { 0x00082129, "Number of Event Timers", "IS", "1", 0, 0},
    { 0x0008212A, "Number of Views in Stage", "IS", "1", 0, 0},
    { 0x00082130, "Event Elapsed Time(s)", "DS", "1-n", 0, 0},
    { 0x00082132, "Event Timer Name(s)", "LO", "1-n", 0, 0},
    { 0x00082133, "Event Timer Sequence", "SQ", "1", 0, 0},
    { 0x00082134, "Event Time Offset", "FD", "1", 0, 0},
    { 0x00082135, "Event Code Sequence", "SQ", "1", 0, 0},
    { 0x00082142, "Start Trim", "IS", "1", 0, 0},
    { 0x00082143, "Stop Trim", "IS", "1", 0, 0},
    { 0x00082144, "Recommended Display Frame Rate", "IS", "1", 0, 0},
    { 0x00082200, "Transducer Position", "CS", "1", -1, 0},
    { 0x00082204, "Transducer Orientation", "CS", "1", -1, 0},
    { 0x00082208, "Anatomic Structure", "CS", "1", -1, 0},
    { 0x00082218, "Anatomic Region Sequence", "SQ", "1", 0, 0},
    { 0x00082220, "Anatomic Region Modifier Sequence", "SQ", "1", 0, 0},
    { 0x00082228, "Primary Anatomic Structure Sequence", "SQ", "1", 0, 0},
    { 0x00082229, "Anatomic Structure, Space or Region Sequence", "SQ", "1", -1, 0},
    { 0x00082230, "Primary Anatomic Structure Modifier Sequence", "SQ", "1", 0, 0},
    { 0x00082240, "Transducer Position Sequence", "SQ", "1", -1, 0},
    { 0x00082242, "Transducer Position Modifier Sequence", "SQ", "1", -1, 0},
    { 0x00082244, "Transducer Orientation Sequence", "SQ", "1", -1, 0},
    { 0x00082246, "Transducer Orientation Modifier Sequence", "SQ", "1", -1, 0},
    { 0x00082251, "Anatomic Structure Space Or Region Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00082253, "Anatomic Portal Of Entrance Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00082255, "Anatomic Approach Direction Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00082256, "Anatomic Perspective Description (Trial)", "ST", "1", -1, 0},
    { 0x00082257, "Anatomic Perspective Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00082258, "Anatomic Location Of Examining Instrument Description (Trial)", "ST", "1", -1, 0},
    { 0x00082259, "Anatomic Location Of Examining Instrument Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0008225A, "Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0008225C, "On Axis Background Anatomic Structure Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00083001, "Alternate Representation Sequence", "SQ", "1", 0, 0},
    { 0x00083002, "Available Transfer Syntax UID", "UI", "1-n", 0, 0},
    { 0x00083010, "Irradiation Event UID", "UI", "1-n", 0, 0},
    { 0x00083011, "Source Irradiation Event Sequence", "SQ", "1", 0, 0},
    { 0x00083012, "Radiopharmaceutical Administration Event UID", "UI", "1", 0, 0},
    { 0x00084000, "Identifying Comments", "LT", "1", -1, 0},
    { 0x00089007, "Frame Type", "CS", "4", 0, 0},
    { 0x00089092, "Referenced Image Evidence Sequence", "SQ", "1", 0, 0},
    { 0x00089121, "Referenced Raw Data Sequence", "SQ", "1", 0, 0},
    { 0x00089123, "Creator-Version UID", "UI", "1", 0, 0},
    { 0x00089124, "Derivation Image Sequence", "SQ", "1", 0, 0},
    { 0x00089154, "Source Image Evidence Sequence", "SQ", "1", 0, 0},
    { 0x00089205, "Pixel Presentation", "CS", "1", 0, 0},
    { 0x00089206, "Volumetric Properties", "CS", "1", 0, 0},
    { 0x00089207, "Volume Based Calculation Technique", "CS", "1", 0, 0},
    { 0x00089208, "Complex Image Component", "CS", "1", 0, 0},
    { 0x00089209, "Acquisition Contrast", "CS", "1", 0, 0},
    { 0x00089215, "Derivation Code Sequence", "SQ", "1", 0, 0},
    { 0x00089237, "Referenced Presentation State Sequence", "SQ", "1", 0, 0},
    { 0x00089410, "Referenced Other Plane Sequence", "SQ", "1", 0, 0},
    { 0x00089458, "Frame Display Sequence", "SQ", "1", 0, 0},
    { 0x00089459, "Recommended Display Frame Rate in Float", "FL", "1", 0, 0},
    { 0x00089460, "Skip Frame Range Flag", "CS", "1", 0, 0},
    { 0x00100010, "Patient's Name", "PN", "1", 0, 0},
    { 0x00100020, "Patient ID", "LO", "1", 0, 0},
    { 0x00100021, "Issuer of Patient ID", "LO", "1", 0, 0},
    { 0x00100022, "Type of Patient ID", "CS", "1", 0, 0},
    { 0x00100024, "Issuer of Patient ID Qualifiers Sequence", "SQ", "1", 0, 0},
    { 0x00100026, "Source Patient Group Identification Sequence", "SQ", "1", 0, 0},
    { 0x00100027, "Group of Patients Identification Sequence", "SQ", "1", 0, 0},
    { 0x00100028, "Subject Relative Position in Image", "US", "3", 0, 0},
    { 0x00100030, "Patient's Birth Date", "DA", "1", 0, 0},
    { 0x00100032, "Patient's Birth Time", "TM", "1", 0, 0},
    { 0x00100033, "Patient's Birth Date in Alternative Calendar", "LO", "1", 0, 0},
    { 0x00100034, "Patient's Death Date in Alternative Calendar", "LO", "1", 0, 0},
    { 0x00100035, "Patient's Alternative Calendar", "CS", "1", 0, 0},
    { 0x00100040, "Patient's Sex", "CS", "1", 0, 0},
    { 0x00100050, "Patient's Insurance Plan Code Sequence", "SQ", "1", 0, 0},
    { 0x00100101, "Patient's Primary Language Code Sequence", "SQ", "1", 0, 0},
    { 0x00100102, "Patient's Primary Language Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x00100200, "Quality Control Subject", "CS", "1", 0, 0},
    { 0x00100201, "Quality Control Subject Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00100212, "Strain Description", "UC", "1", 0, 0},
    { 0x00100213, "Strain Nomenclature", "LO", "1", 0, 0},
    { 0x00100214, "Strain Stock Number", "LO", "1", 0, 0},
    { 0x00100215, "Strain Source Registry Code Sequence", "SQ", "1", 0, 0},
    { 0x00100216, "Strain Stock Sequence", "SQ", "1", 0, 0},
    { 0x00100217, "Strain Source", "LO", "1", 0, 0},
    { 0x00100218, "Strain Additional Information", "UT", "1", 0, 0},
    { 0x00100219, "Strain Code Sequence", "SQ", "1", 0, 0},
    { 0x00100221, "Genetic Modifications Sequence", "SQ", "1", 0, 0},
    { 0x00100222, "Genetic Modifications Description", "UC", "1", 0, 0},
    { 0x00100223, "Genetic Modifications Nomenclature", "LO", "1", 0, 0},
    { 0x00100229, "Genetic Modifications Code Sequence", "SQ", "1", 0, 0},
    { 0x00101000, "Other Patient IDs", "LO", "1-n", -1, 0},
    { 0x00101001, "Other Patient Names", "PN", "1-n", 0, 0},
    { 0x00101002, "Other Patient IDs Sequence", "SQ", "1", 0, 0},
    { 0x00101005, "Patient's Birth Name", "PN", "1", 0, 0},
    { 0x00101010, "Patient's Age", "AS", "1", 0, 0},
    { 0x00101020, "Patient's Size", "DS", "1", 0, 0},
    { 0x00101021, "Patient's Size Code Sequence", "SQ", "1", 0, 0},
    { 0x00101022, "Patient's Body Mass Index", "DS", "1", 0, 0},
    { 0x00101023, "Measured AP Dimension", "DS", "1", 0, 0},
    { 0x00101024, "Measured Lateral Dimension", "DS", "1", 0, 0},
    { 0x00101030, "Patient's Weight", "DS", "1", 0, 0},
    { 0x00101040, "Patient's Address", "LO", "1", 0, 0},
    { 0x00101050, "Insurance Plan Identification", "LO", "1-n", -1, 0},
    { 0x00101060, "Patient's Mother's Birth Name", "PN", "1", 0, 0},
    { 0x00101080, "Military Rank", "LO", "1", 0, 0},
    { 0x00101081, "Branch of Service", "LO", "1", 0, 0},
    { 0x00101090, "Medical Record Locator", "LO", "1", -1, 0},
    { 0x00101100, "Referenced Patient Photo Sequence", "SQ", "1", 0, 0},
    { 0x00102000, "Medical Alerts", "LO", "1-n", 0, 0},
    { 0x00102110, "Allergies", "LO", "1-n", 0, 0},
    { 0x00102150, "Country of Residence", "LO", "1", 0, 0},
    { 0x00102152, "Region of Residence", "LO", "1", 0, 0},
    { 0x00102154, "Patient's Telephone Numbers", "SH", "1-n", 0, 0},
    { 0x00102155, "Patient's Telecom Information", "LT", "1", 0, 0},
    { 0x00102160, "Ethnic Group", "SH", "1", 0, 0},
    { 0x00102180, "Occupation", "SH", "1", 0, 0},
    { 0x001021A0, "Smoking Status", "CS", "1", 0, 0},
    { 0x001021B0, "Additional Patient History", "LT", "1", 0, 0},
    { 0x001021C0, "Pregnancy Status", "US", "1", 0, 0},
    { 0x001021D0, "Last Menstrual Date", "DA", "1", 0, 0},
    { 0x001021F0, "Patient's Religious Preference", "LO", "1", 0, 0},
    { 0x00102201, "Patient Species Description", "LO", "1", 0, 0},
    { 0x00102202, "Patient Species Code Sequence", "SQ", "1", 0, 0},
    { 0x00102203, "Patient's Sex Neutered", "CS", "1", 0, 0},
    { 0x00102210, "Anatomical Orientation Type", "CS", "1", 0, 0},
    { 0x00102292, "Patient Breed Description", "LO", "1", 0, 0},
    { 0x00102293, "Patient Breed Code Sequence", "SQ", "1", 0, 0},
    { 0x00102294, "Breed Registration Sequence", "SQ", "1", 0, 0},
    { 0x00102295, "Breed Registration Number", "LO", "1", 0, 0},
    { 0x00102296, "Breed Registry Code Sequence", "SQ", "1", 0, 0},
    { 0x00102297, "Responsible Person", "PN", "1", 0, 0},
    { 0x00102298, "Responsible Person Role", "CS", "1", 0, 0},
    { 0x00102299, "Responsible Organization", "LO", "1", 0, 0},
    { 0x00104000, "Patient Comments", "LT", "1", 0, 0},
    { 0x00109431, "Examined Body Thickness", "FL", "1", 0, 0},
    { 0x00120010, "Clinical Trial Sponsor Name", "LO", "1", 0, 0},
    { 0x00120020, "Clinical Trial Protocol ID", "LO", "1", 0, 0},
    { 0x00120021, "Clinical Trial Protocol Name", "LO", "1", 0, 0},
    { 0x00120030, "Clinical Trial Site ID", "LO", "1", 0, 0},
    { 0x00120031, "Clinical Trial Site Name", "LO", "1", 0, 0},
    { 0x00120040, "Clinical Trial Subject ID", "LO", "1", 0, 0},
    { 0x00120042, "Clinical Trial Subject Reading ID", "LO", "1", 0, 0},
    { 0x00120050, "Clinical Trial Time Point ID", "LO", "1", 0, 0},
    { 0x00120051, "Clinical Trial Time Point Description", "ST", "1", 0, 0},
    { 0x00120052, "Longitudinal Temporal Offset from Event", "FD", "1", 0, 0},
    { 0x00120053, "Longitudinal Temporal Event Type", "CS", "1", 0, 0},
    { 0x00120060, "Clinical Trial Coordinating Center Name", "LO", "1", 0, 0},
    { 0x00120062, "Patient Identity Removed", "CS", "1", 0, 0},
    { 0x00120063, "De-identification Method", "LO", "1-n", 0, 0},
    { 0x00120064, "De-identification Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00120071, "Clinical Trial Series ID", "LO", "1", 0, 0},
    { 0x00120072, "Clinical Trial Series Description", "LO", "1", 0, 0},
    { 0x00120081, "Clinical Trial Protocol Ethics Committee Name", "LO", "1", 0, 0},
    { 0x00120082, "Clinical Trial Protocol Ethics Committee Approval Number", "LO", "1", 0, 0},
    { 0x00120083, "Consent for Clinical Trial Use Sequence", "SQ", "1", 0, 0},
    { 0x00120084, "Distribution Type", "CS", "1", 0, 0},
    { 0x00120085, "Consent for Distribution Flag", "CS", "1", 0, 0},
    { 0x00120086, "Ethics Committee Approval Effectiveness Start Date", "DA", "1", 0, 0},
    { 0x00120087, "Ethics Committee Approval Effectiveness End Date", "DA", "1", 0, 0},
    { 0x00140023, "CAD File Format", "ST", "1", -1, 0},
    { 0x00140024, "Component Reference System", "ST", "1", -1, 0},
    { 0x00140025, "Component Manufacturing Procedure", "ST", "1", 0, 0},
    { 0x00140028, "Component Manufacturer", "ST", "1", 0, 0},
    { 0x00140030, "Material Thickness", "DS", "1-n", 0, 0},
    { 0x00140032, "Material Pipe Diameter", "DS", "1-n", 0, 0},
    { 0x00140034, "Material Isolation Diameter", "DS", "1-n", 0, 0},
    { 0x00140042, "Material Grade", "ST", "1", 0, 0},
    { 0x00140044, "Material Properties Description", "ST", "1", 0, 0},
    { 0x00140045, "Material Properties File Format (Retired)", "ST", "1", -1, 0},
    { 0x00140046, "Material Notes", "LT", "1", 0, 0},
    { 0x00140050, "Component Shape", "CS", "1", 0, 0},
    { 0x00140052, "Curvature Type", "CS", "1", 0, 0},
    { 0x00140054, "Outer Diameter", "DS", "1", 0, 0},
    { 0x00140056, "Inner Diameter", "DS", "1", 0, 0},
    { 0x00140100, "Component Welder IDs", "LO", "1-n", 0, 0},
    { 0x00140101, "Secondary Approval Status", "CS", "1", 0, 0},
    { 0x00140102, "Secondary Review Date", "DA", "1", 0, 0},
    { 0x00140103, "Secondary Review Time", "TM", "1", 0, 0},
    { 0x00140104, "Secondary Reviewer Name", "PN", "1", 0, 0},
    { 0x00140105, "Repair ID", "ST", "1", 0, 0},
    { 0x00140106, "Multiple Component Approval Sequence", "SQ", "1", 0, 0},
    { 0x00140107, "Other Approval Status", "CS", "1-n", 0, 0},
    { 0x00140108, "Other Secondary Approval Status", "CS", "1-n", 0, 0},
    { 0x00141010, "Actual Environmental Conditions", "ST", "1", 0, 0},
    { 0x00141020, "Expiry Date", "DA", "1", 0, 0},
    { 0x00141040, "Environmental Conditions", "ST", "1", 0, 0},
    { 0x00142002, "Evaluator Sequence", "SQ", "1", 0, 0},
    { 0x00142004, "Evaluator Number", "IS", "1", 0, 0},
    { 0x00142006, "Evaluator Name", "PN", "1", 0, 0},
    { 0x00142008, "Evaluation Attempt", "IS", "1", 0, 0},
    { 0x00142012, "Indication Sequence", "SQ", "1", 0, 0},
    { 0x00142014, "Indication Number", "IS", "1", 0, 0},
    { 0x00142016, "Indication Label", "SH", "1", 0, 0},
    { 0x00142018, "Indication Description", "ST", "1", 0, 0},
    { 0x0014201A, "Indication Type", "CS", "1-n", 0, 0},
    { 0x0014201C, "Indication Disposition", "CS", "1", 0, 0},
    { 0x0014201E, "Indication ROI Sequence", "SQ", "1", 0, 0},
    { 0x00142030, "Indication Physical Property Sequence", "SQ", "1", 0, 0},
    { 0x00142032, "Property Label", "SH", "1", 0, 0},
    { 0x00142202, "Coordinate System Number of Axes", "IS", "1", 0, 0},
    { 0x00142204, "Coordinate System Axes Sequence", "SQ", "1", 0, 0},
    { 0x00142206, "Coordinate System Axis Description", "ST", "1", 0, 0},
    { 0x00142208, "Coordinate System Data Set Mapping", "CS", "1", 0, 0},
    { 0x0014220A, "Coordinate System Axis Number", "IS", "1", 0, 0},
    { 0x0014220C, "Coordinate System Axis Type", "CS", "1", 0, 0},
    { 0x0014220E, "Coordinate System Axis Units", "CS", "1", 0, 0},
    { 0x00142210, "Coordinate System Axis Values", "OB", "1", 0, 0},
    { 0x00142220, "Coordinate System Transform Sequence", "SQ", "1", 0, 0},
    { 0x00142222, "Transform Description", "ST", "1", 0, 0},
    { 0x00142224, "Transform Number of Axes", "IS", "1", 0, 0},
    { 0x00142226, "Transform Order of Axes", "IS", "1-n", 0, 0},
    { 0x00142228, "Transformed Axis Units", "CS", "1", 0, 0},
    { 0x0014222A, "Coordinate System Transform Rotation and Scale Matrix", "DS", "1-n", 0, 0},
    { 0x0014222C, "Coordinate System Transform Translation Matrix", "DS", "1-n", 0, 0},
    { 0x00143011, "Internal Detector Frame Time", "DS", "1", 0, 0},
    { 0x00143012, "Number of Frames Integrated", "DS", "1", 0, 0},
    { 0x00143020, "Detector Temperature Sequence", "SQ", "1", 0, 0},
    { 0x00143022, "Sensor Name", "ST", "1", 0, 0},
    { 0x00143024, "Horizontal Offset of Sensor", "DS", "1", 0, 0},
    { 0x00143026, "Vertical Offset of Sensor", "DS", "1", 0, 0},
    { 0x00143028, "Sensor Temperature", "DS", "1", 0, 0},
    { 0x00143040, "Dark Current Sequence", "SQ", "1", 0, 0},
    { 0x00143050, "Dark Current Counts", "OB or OW", "1", 0, 0},
    { 0x00143060, "Gain Correction Reference Sequence", "SQ", "1", 0, 0},
    { 0x00143070, "Air Counts", "OB or OW", "1", 0, 0},
    { 0x00143071, "KV Used in Gain Calibration", "DS", "1", 0, 0},
    { 0x00143072, "MA Used in Gain Calibration", "DS", "1", 0, 0},
    { 0x00143073, "Number of Frames Used for Integration", "DS", "1", 0, 0},
    { 0x00143074, "Filter Material Used in Gain Calibration", "LO", "1", 0, 0},
    { 0x00143075, "Filter Thickness Used in Gain Calibration", "DS", "1", 0, 0},
    { 0x00143076, "Date of Gain Calibration", "DA", "1", 0, 0},
    { 0x00143077, "Time of Gain Calibration", "TM", "1", 0, 0},
    { 0x00143080, "Bad Pixel Image", "OB", "1", 0, 0},
    { 0x00143099, "Calibration Notes", "LT", "1", 0, 0},
    { 0x00144002, "Pulser Equipment Sequence", "SQ", "1", 0, 0},
    { 0x00144004, "Pulser Type", "CS", "1", 0, 0},
    { 0x00144006, "Pulser Notes", "LT", "1", 0, 0},
    { 0x00144008, "Receiver Equipment Sequence", "SQ", "1", 0, 0},
    { 0x0014400A, "Amplifier Type", "CS", "1", 0, 0},
    { 0x0014400C, "Receiver Notes", "LT", "1", 0, 0},
    { 0x0014400E, "Pre-Amplifier Equipment Sequence", "SQ", "1", 0, 0},
    { 0x0014400F, "Pre-Amplifier Notes", "LT", "1", 0, 0},
    { 0x00144010, "Transmit Transducer Sequence", "SQ", "1", 0, 0},
    { 0x00144011, "Receive Transducer Sequence", "SQ", "1", 0, 0},
    { 0x00144012, "Number of Elements", "US", "1", 0, 0},
    { 0x00144013, "Element Shape", "CS", "1", 0, 0},
    { 0x00144014, "Element Dimension A", "DS", "1", 0, 0},
    { 0x00144015, "Element Dimension B", "DS", "1", 0, 0},
    { 0x00144016, "Element Pitch A", "DS", "1", 0, 0},
    { 0x00144017, "Measured Beam Dimension A", "DS", "1", 0, 0},
    { 0x00144018, "Measured Beam Dimension B", "DS", "1", 0, 0},
    { 0x00144019, "Location of Measured Beam Diameter", "DS", "1", 0, 0},
    { 0x0014401A, "Nominal Frequency", "DS", "1", 0, 0},
    { 0x0014401B, "Measured Center Frequency", "DS", "1", 0, 0},
    { 0x0014401C, "Measured Bandwidth", "DS", "1", 0, 0},
    { 0x0014401D, "Element Pitch B", "DS", "1", 0, 0},
    { 0x00144020, "Pulser Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144022, "Pulse Width", "DS", "1", 0, 0},
    { 0x00144024, "Excitation Frequency", "DS", "1", 0, 0},
    { 0x00144026, "Modulation Type", "CS", "1", 0, 0},
    { 0x00144028, "Damping", "DS", "1", 0, 0},
    { 0x00144030, "Receiver Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144031, "Acquired Soundpath Length", "DS", "1", 0, 0},
    { 0x00144032, "Acquisition Compression Type", "CS", "1", 0, 0},
    { 0x00144033, "Acquisition Sample Size", "IS", "1", 0, 0},
    { 0x00144034, "Rectifier Smoothing", "DS", "1", 0, 0},
    { 0x00144035, "DAC Sequence", "SQ", "1", 0, 0},
    { 0x00144036, "DAC Type", "CS", "1", 0, 0},
    { 0x00144038, "DAC Gain Points", "DS", "1-n", 0, 0},
    { 0x0014403A, "DAC Time Points", "DS", "1-n", 0, 0},
    { 0x0014403C, "DAC Amplitude", "DS", "1-n", 0, 0},
    { 0x00144040, "Pre-Amplifier Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144050, "Transmit Transducer Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144051, "Receive Transducer Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144052, "Incident Angle", "DS", "1", 0, 0},
    { 0x00144054, "Coupling Technique", "ST", "1", 0, 0},
    { 0x00144056, "Coupling Medium", "ST", "1", 0, 0},
    { 0x00144057, "Coupling Velocity", "DS", "1", 0, 0},
    { 0x00144058, "Probe Center Location X", "DS", "1", 0, 0},
    { 0x00144059, "Probe Center Location Z", "DS", "1", 0, 0},
    { 0x0014405A, "Sound Path Length", "DS", "1", 0, 0},
    { 0x0014405C, "Delay Law Identifier", "ST", "1", 0, 0},
    { 0x00144060, "Gate Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144062, "Gate Threshold", "DS", "1", 0, 0},
    { 0x00144064, "Velocity of Sound", "DS", "1", 0, 0},
    { 0x00144070, "Calibration Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144072, "Calibration Procedure", "ST", "1", 0, 0},
    { 0x00144074, "Procedure Version", "SH", "1", 0, 0},
    { 0x00144076, "Procedure Creation Date", "DA", "1", 0, 0},
    { 0x00144078, "Procedure Expiration Date", "DA", "1", 0, 0},
    { 0x0014407A, "Procedure Last Modified Date", "DA", "1", 0, 0},
    { 0x0014407C, "Calibration Time", "TM", "1-n", 0, 0},
    { 0x0014407E, "Calibration Date", "DA", "1-n", 0, 0},
    { 0x00144080, "Probe Drive Equipment Sequence", "SQ", "1", 0, 0},
    { 0x00144081, "Drive Type", "CS", "1", 0, 0},
    { 0x00144082, "Probe Drive Notes", "LT", "1", 0, 0},
    { 0x00144083, "Drive Probe Sequence", "SQ", "1", 0, 0},
    { 0x00144084, "Probe Inductance", "DS", "1", 0, 0},
    { 0x00144085, "Probe Resistance", "DS", "1", 0, 0},
    { 0x00144086, "Receive Probe Sequence", "SQ", "1", 0, 0},
    { 0x00144087, "Probe Drive Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144088, "Bridge Resistors", "DS", "1", 0, 0},
    { 0x00144089, "Probe Orientation Angle", "DS", "1", 0, 0},
    { 0x0014408B, "User Selected Gain Y", "DS", "1", 0, 0},
    { 0x0014408C, "User Selected Phase", "DS", "1", 0, 0},
    { 0x0014408D, "User Selected Offset X", "DS", "1", 0, 0},
    { 0x0014408E, "User Selected Offset Y", "DS", "1", 0, 0},
    { 0x00144091, "Channel Settings Sequence", "SQ", "1", 0, 0},
    { 0x00144092, "Channel Threshold", "DS", "1", 0, 0},
    { 0x0014409A, "Scanner Settings Sequence", "SQ", "1", 0, 0},
    { 0x0014409B, "Scan Procedure", "ST", "1", 0, 0},
    { 0x0014409C, "Translation Rate X", "DS", "1", 0, 0},
    { 0x0014409D, "Translation Rate Y", "DS", "1", 0, 0},
    { 0x0014409F, "Channel Overlap", "DS", "1", 0, 0},
    { 0x001440A0, "Image Quality Indicator Type", "LO", "1", 0, 0},
    { 0x001440A1, "Image Quality Indicator Material", "LO", "1", 0, 0},
    { 0x001440A2, "Image Quality Indicator Size", "LO", "1", 0, 0},
    { 0x00145002, "LINAC Energy", "IS", "1", 0, 0},
    { 0x00145004, "LINAC Output", "IS", "1", 0, 0},
    { 0x00145100, "Active Aperture", "US", "1", 0, 0},
    { 0x00145101, "Total Aperture", "DS", "1", 0, 0},
    { 0x00145102, "Aperture Elevation", "DS", "1", 0, 0},
    { 0x00145103, "Main Lobe Angle", "DS", "1", 0, 0},
    { 0x00145104, "Main Roof Angle", "DS", "1", 0, 0},
    { 0x00145105, "Connector Type", "CS", "1", 0, 0},
    { 0x00145106, "Wedge Model Number", "SH", "1", 0, 0},
    { 0x00145107, "Wedge Angle Float", "DS", "1", 0, 0},
    { 0x00145108, "Wedge Roof Angle", "DS", "1", 0, 0},
    { 0x00145109, "Wedge Element 1 Position", "CS", "1", 0, 0},
    { 0x0014510A, "Wedge Material Velocity", "DS", "1", 0, 0},
    { 0x0014510B, "Wedge Material", "SH", "1", 0, 0},
    { 0x0014510C, "Wedge Offset Z", "DS", "1", 0, 0},
    { 0x0014510D, "Wedge Origin Offset X", "DS", "1", 0, 0},
    { 0x0014510E, "Wedge Time Delay", "DS", "1", 0, 0},
    { 0x0014510F, "Wedge Name", "SH", "1", 0, 0},
    { 0x00145110, "Wedge Manufacturer Name", "SH", "1", 0, 0},
    { 0x00145111, "Wedge Description", "LO", "1", 0, 0},
    { 0x00145112, "Nominal Beam Angle", "DS", "1", 0, 0},
    { 0x00145113, "Wedge Offset X", "DS", "1", 0, 0},
    { 0x00145114, "Wedge Offset Y", "DS", "1", 0, 0},
    { 0x00145115, "Wedge Total Length", "DS", "1", 0, 0},
    { 0x00145116, "Wedge In Contact Length", "DS", "1", 0, 0},
    { 0x00145117, "Wedge Front Gap", "DS", "1", 0, 0},
    { 0x00145118, "Wedge Total Height", "DS", "1", 0, 0},
    { 0x00145119, "Wedge Front Height", "DS", "1", 0, 0},
    { 0x0014511A, "Wedge Rear Height", "DS", "1", 0, 0},
    { 0x0014511B, "Wedge Total Width", "DS", "1", 0, 0},
    { 0x0014511C, "Wedge In Contact Width", "DS", "1", 0, 0},
    { 0x0014511D, "Wedge Chamfer Height", "DS", "1", 0, 0},
    { 0x0014511E, "Wedge Curve", "CS", "1", 0, 0},
    { 0x0014511F, "Radius Along the Wedge", "DS", "1", 0, 0},
    { 0x00160001, "White Point", "DS", "1", 0, 0},
    { 0x00160002, "Primary Chromaticities", "DS", "3", 0, 0},
    { 0x00160003, "Battery Level", "UT", "1", 0, 0},
    { 0x00160004, "Exposure Time in Seconds", "DS", "1", 0, 0},
    { 0x00160005, "F-Number", "DS", "1", 0, 0},
    { 0x00160006, "OECF Rows", "IS", "1", 0, 0},
    { 0x00160007, "OECF Columns", "IS", "1", 0, 0},
    { 0x00160008, "OECF Column Names", "UC", "1-n", 0, 0},
    { 0x00160009, "OECF Values", "DS", "1-n", 0, 0},
    { 0x0016000A, "Spatial Frequency Response Rows", "IS", "1", 0, 0},
    { 0x0016000B, "Spatial Frequency Response Columns", "IS", "1", 0, 0},
    { 0x0016000C, "Spatial Frequency Response Column Names", "UC", "1-n", 0, 0},
    { 0x0016000D, "Spatial Frequency Response Values", "DS", "1-n", 0, 0},
    { 0x0016000E, "Color Filter Array Pattern Rows", "IS", "1", 0, 0},
    { 0x0016000F, "Color Filter Array Pattern Columns", "IS", "1", 0, 0},
    { 0x00160010, "Color Filter Array Pattern Values", "DS", "1-n", 0, 0},
    { 0x00160011, "Flash Firing Status", "US", "1", 0, 0},
    { 0x00160012, "Flash Return Status", "US", "1", 0, 0},
    { 0x00160013, "Flash Mode", "US", "1", 0, 0},
    { 0x00160014, "Flash Function Present", "US", "1", 0, 0},
    { 0x00160015, "Flash Red Eye Mode", "US", "1", 0, 0},
    { 0x00160016, "Exposure Program", "US", "1", 0, 0},
    { 0x00160017, "Spectral Sensitivity", "UT", "1", 0, 0},
    { 0x00160018, "Photographic Sensitivity", "IS", "1", 0, 0},
    { 0x00160019, "Self Timer Mode", "IS", "1", 0, 0},
    { 0x0016001A, "Sensitivity Type", "US", "1", 0, 0},
    { 0x0016001B, "Standard Output Sensitivity", "IS", "1", 0, 0},
    { 0x0016001C, "Recommended Exposure Index", "IS", "1", 0, 0},
    { 0x0016001D, "ISO Speed", "IS", "1", 0, 0},
    { 0x0016001E, "ISO Speed Latitude yyy", "IS", "1", 0, 0},
    { 0x0016001F, "ISO Speed Latitude zzz", "IS", "1", 0, 0},
    { 0x00160020, "EXIF Version", "UT", "1", 0, 0},
    { 0x00160021, "Shutter Speed Value", "DS", "1", 0, 0},
    { 0x00160022, "Aperture Value", "DS", "1", 0, 0},
    { 0x00160023, "Brightness Value", "DS", "1", 0, 0},
    { 0x00160024, "Exposure Bias Value", "DS", "1", 0, 0},
    { 0x00160025, "Max Aperture Value", "DS", "1", 0, 0},
    { 0x00160026, "Subject Distance", "DS", "1", 0, 0},
    { 0x00160027, "Metering Mode", "US", "1", 0, 0},
    { 0x00160028, "Light Source", "US", "1", 0, 0},
    { 0x00160029, "Focal Length", "DS", "1", 0, 0},
    { 0x0016002A, "Subject Area", "IS", "2-4", 0, 0},
    { 0x0016002B, "Maker Note", "OB", "1", 0, 0},
    { 0x00160030, "Temperature", "DS", "1", 0, 0},
    { 0x00160031, "Humidity", "DS", "1", 0, 0},
    { 0x00160032, "Pressure", "DS", "1", 0, 0},
    { 0x00160033, "Water Depth", "DS", "1", 0, 0},
    { 0x00160034, "Acceleration", "DS", "1", 0, 0},
    { 0x00160035, "Camera Elevation Angle", "DS", "1", 0, 0},
    { 0x00160036, "Flash Energy", "DS", "1-2", 0, 0},
    { 0x00160037, "Subject Location", "IS", "2", 0, 0},
    { 0x00160038, "Photographic Exposure Index", "DS", "1", 0, 0},
    { 0x00160039, "Sensing Method", "US", "1", 0, 0},
    { 0x0016003A, "File Source", "US", "1", 0, 0},
    { 0x0016003B, "Scene Type", "US", "1", 0, 0},
    { 0x00160041, "Custom Rendered", "US", "1", 0, 0},
    { 0x00160042, "Exposure Mode", "US", "1", 0, 0},
    { 0x00160043, "White Balance", "US", "1", 0, 0},
    { 0x00160044, "Digital Zoom Ratio", "DS", "1", 0, 0},
    { 0x00160045, "Focal Length In 35mm Film", "IS", "1", 0, 0},
    { 0x00160046, "Scene Capture Type", "US", "1", 0, 0},
    { 0x00160047, "Gain Control", "US", "1", 0, 0},
    { 0x00160048, "Contrast", "US", "1", 0, 0},
    { 0x00160049, "Saturation", "US", "1", 0, 0},
    { 0x0016004A, "Sharpness", "US", "1", 0, 0},
    { 0x0016004B, "Device Setting Description", "OB", "1", 0, 0},
    { 0x0016004C, "Subject Distance Range", "US", "1", 0, 0},
    { 0x0016004D, "Camera Owner Name", "UT", "1", 0, 0},
    { 0x0016004E, "Lens Specification", "DS", "4", 0, 0},
    { 0x0016004F, "Lens Make", "UT", "1", 0, 0},
    { 0x00160050, "Lens Model", "UT", "1", 0, 0},
    { 0x00160051, "Lens Serial Number", "UT", "1", 0, 0},
    { 0x00160061, "Interoperability Index", "CS", "1", 0, 0},
    { 0x00160062, "Interoperability Version", "OB", "1", 0, 0},
    { 0x00160070, "GPS Version ID", "OB", "1", 0, 0},
    { 0x00160071, "GPS Latitude Ref", "CS", "1", 0, 0},
    { 0x00160072, "GPS Latitude", "DS", "3", 0, 0},
    { 0x00160073, "GPS Longitude Ref", "CS", "1", 0, 0},
    { 0x00160074, "GPS Longitude", "DS", "3", 0, 0},
    { 0x00160075, "GPS Altitude Ref", "US", "1", 0, 0},
    { 0x00160076, "GPS Altitude", "DS", "1", 0, 0},
    { 0x00160077, "GPS Time Stamp", "DT", "1", 0, 0},
    { 0x00160078, "GPS Satellites", "UT", "1", 0, 0},
    { 0x00160079, "GPS Status", "CS", "1", 0, 0},
    { 0x0016007A, "GPS Measure Mode", "CS", "1", 0, 0},
    { 0x0016007B, "GPS DOP", "DS", "1", 0, 0},
    { 0x0016007C, "GPS Speed Ref", "CS", "1", 0, 0},
    { 0x0016007D, "GPS Speed", "DS", "1", 0, 0},
    { 0x0016007E, "GPS Track Ref", "CS", "1", 0, 0},
    { 0x0016007F, "GPS Track", "DS", "1", 0, 0},
    { 0x00160080, "GPS Img Direction Ref", "CS", "1", 0, 0},
    { 0x00160081, "GPS Img Direction", "DS", "1", 0, 0},
    { 0x00160082, "GPS Map Datum", "UT", "1", 0, 0},
    { 0x00160083, "GPS Dest Latitude Ref", "CS", "1", 0, 0},
    { 0x00160084, "GPS Dest Latitude", "DS", "3", 0, 0},
    { 0x00160085, "GPS Dest Longitude Ref", "CS", "1", 0, 0},
    { 0x00160086, "GPS Dest Longitude", "DS", "3", 0, 0},
    { 0x00160087, "GPS Dest Bearing Ref", "CS", "1", 0, 0},
    { 0x00160088, "GPS Dest Bearing", "DS", "1", 0, 0},
    { 0x00160089, "GPS Dest Distance Ref", "CS", "1", 0, 0},
    { 0x0016008A, "GPS Dest Distance", "DS", "1", 0, 0},
    { 0x0016008B, "GPS Processing Method", "OB", "1", 0, 0},
    { 0x0016008C, "GPS Area Information", "OB", "1", 0, 0},
    { 0x0016008D, "GPS Date Stamp", "DT", "1", 0, 0},
    { 0x0016008E, "GPS Differential", "IS", "1", 0, 0},
    { 0x00180010, "Contrast/Bolus Agent", "LO", "1", 0, 0},
    { 0x00180012, "Contrast/Bolus Agent Sequence", "SQ", "1", 0, 0},
    { 0x00180013, "Contrast/Bolus T1 Relaxivity", "FL", "1", 0, 0},
    { 0x00180014, "Contrast/Bolus Administration Route Sequence", "SQ", "1", 0, 0},
    { 0x00180015, "Body Part Examined", "CS", "1", 0, 0},
    { 0x00180020, "Scanning Sequence", "CS", "1-n", 0, 0},
    { 0x00180021, "Sequence Variant", "CS", "1-n", 0, 0},
    { 0x00180022, "Scan Options", "CS", "1-n", 0, 0},
    { 0x00180023, "MR Acquisition Type", "CS", "1", 0, 0},
    { 0x00180024, "Sequence Name", "SH", "1", 0, 0},
    { 0x00180025, "Angio Flag", "CS", "1", 0, 0},
    { 0x00180026, "Intervention Drug Information Sequence", "SQ", "1", 0, 0},
    { 0x00180027, "Intervention Drug Stop Time", "TM", "1", 0, 0},
    { 0x00180028, "Intervention Drug Dose", "DS", "1", 0, 0},
    { 0x00180029, "Intervention Drug Code Sequence", "SQ", "1", 0, 0},
    { 0x0018002A, "Additional Drug Sequence", "SQ", "1", 0, 0},
    { 0x00180030, "Radionuclide", "LO", "1-n", -1, 0},
    { 0x00180031, "Radiopharmaceutical", "LO", "1", 0, 0},
    { 0x00180032, "Energy Window Centerline", "DS", "1", -1, 0},
    { 0x00180033, "Energy Window Total Width", "DS", "1-n", -1, 0},
    { 0x00180034, "Intervention Drug Name", "LO", "1", 0, 0},
    { 0x00180035, "Intervention Drug Start Time", "TM", "1", 0, 0},
    { 0x00180036, "Intervention Sequence", "SQ", "1", 0, 0},
    { 0x00180037, "Therapy Type", "CS", "1", -1, 0},
    { 0x00180038, "Intervention Status", "CS", "1", 0, 0},
    { 0x00180039, "Therapy Description", "CS", "1", -1, 0},
    { 0x0018003A, "Intervention Description", "ST", "1", 0, 0},
    { 0x00180040, "Cine Rate", "IS", "1", 0, 0},
    { 0x00180042, "Initial Cine Run State", "CS", "1", 0, 0},
    { 0x00180050, "Slice Thickness", "DS", "1", 0, 0},
    { 0x00180060, "KVP", "DS", "1", 0, 0},
    { 0x00180061, "", "DS", "1", -1, 0},
    { 0x00180070, "Counts Accumulated", "IS", "1", 0, 0},
    { 0x00180071, "Acquisition Termination Condition", "CS", "1", 0, 0},
    { 0x00180072, "Effective Duration", "DS", "1", 0, 0},
    { 0x00180073, "Acquisition Start Condition", "CS", "1", 0, 0},
    { 0x00180074, "Acquisition Start Condition Data", "IS", "1", 0, 0},
    { 0x00180075, "Acquisition Termination Condition Data", "IS", "1", 0, 0},
    { 0x00180080, "Repetition Time", "DS", "1", 0, 0},
    { 0x00180081, "Echo Time", "DS", "1", 0, 0},
    { 0x00180082, "Inversion Time", "DS", "1", 0, 0},
    { 0x00180083, "Number of Averages", "DS", "1", 0, 0},
    { 0x00180084, "Imaging Frequency", "DS", "1", 0, 0},
    { 0x00180085, "Imaged Nucleus", "SH", "1", 0, 0},
    { 0x00180086, "Echo Number(s)", "IS", "1-n", 0, 0},
    { 0x00180087, "Magnetic Field Strength", "DS", "1", 0, 0},
    { 0x00180088, "Spacing Between Slices", "DS", "1", 0, 0},
    { 0x00180089, "Number of Phase Encoding Steps", "IS", "1", 0, 0},
    { 0x00180090, "Data Collection Diameter", "DS", "1", 0, 0},
    { 0x00180091, "Echo Train Length", "IS", "1", 0, 0},
    { 0x00180093, "Percent Sampling", "DS", "1", 0, 0},
    { 0x00180094, "Percent Phase Field of View", "DS", "1", 0, 0},
    { 0x00180095, "Pixel Bandwidth", "DS", "1", 0, 0},
    { 0x00181000, "Device Serial Number", "LO", "1", 0, 0},
    { 0x00181002, "Device UID", "UI", "1", 0, 0},
    { 0x00181003, "Device ID", "LO", "1", 0, 0},
    { 0x00181004, "Plate ID", "LO", "1", 0, 0},
    { 0x00181005, "Generator ID", "LO", "1", 0, 0},
    { 0x00181006, "Grid ID", "LO", "1", 0, 0},
    { 0x00181007, "Cassette ID", "LO", "1", 0, 0},
    { 0x00181008, "Gantry ID", "LO", "1", 0, 0},
    { 0x00181009, "Unique Device Identifier", "UT", "1", 0, 0},
    { 0x0018100A, "UDI Sequence", "SQ", "1", 0, 0},
    { 0x0018100B, "Manufacturer's Device Class UID", "UI", "1-n", 0, 0},
    { 0x00181010, "Secondary Capture Device ID", "LO", "1", 0, 0},
    { 0x00181011, "Hardcopy Creation Device ID", "LO", "1", -1, 0},
    { 0x00181012, "Date of Secondary Capture", "DA", "1", 0, 0},
    { 0x00181014, "Time of Secondary Capture", "TM", "1", 0, 0},
    { 0x00181016, "Secondary Capture Device Manufacturer", "LO", "1", 0, 0},
    { 0x00181017, "Hardcopy Device Manufacturer", "LO", "1", -1, 0},
    { 0x00181018, "Secondary Capture Device Manufacturer's Model Name", "LO", "1", 0, 0},
    { 0x00181019, "Secondary Capture Device Software Versions", "LO", "1-n", 0, 0},
    { 0x0018101A, "Hardcopy Device Software Version", "LO", "1-n", -1, 0},
    { 0x0018101B, "Hardcopy Device Manufacturer's Model Name", "LO", "1", -1, 0},
    { 0x00181020, "Software Versions", "LO", "1-n", 0, 0},
    { 0x00181022, "Video Image Format Acquired", "SH", "1", 0, 0},
    { 0x00181023, "Digital Image Format Acquired", "LO", "1", 0, 0},
    { 0x00181030, "Protocol Name", "LO", "1", 0, 0},
    { 0x00181040, "Contrast/Bolus Route", "LO", "1", 0, 0},
    { 0x00181041, "Contrast/Bolus Volume", "DS", "1", 0, 0},
    { 0x00181042, "Contrast/Bolus Start Time", "TM", "1", 0, 0},
    { 0x00181043, "Contrast/Bolus Stop Time", "TM", "1", 0, 0},
    { 0x00181044, "Contrast/Bolus Total Dose", "DS", "1", 0, 0},
    { 0x00181045, "Syringe Counts", "IS", "1", 0, 0},
    { 0x00181046, "Contrast Flow Rate", "DS", "1-n", 0, 0},
    { 0x00181047, "Contrast Flow Duration", "DS", "1-n", 0, 0},
    { 0x00181048, "Contrast/Bolus Ingredient", "CS", "1", 0, 0},
    { 0x00181049, "Contrast/Bolus Ingredient Concentration", "DS", "1", 0, 0},
    { 0x00181050, "Spatial Resolution", "DS", "1", 0, 0},
    { 0x00181060, "Trigger Time", "DS", "1", 0, 0},
    { 0x00181061, "Trigger Source or Type", "LO", "1", 0, 0},
    { 0x00181062, "Nominal Interval", "IS", "1", 0, 0},
    { 0x00181063, "Frame Time", "DS", "1", 0, 0},
    { 0x00181064, "Cardiac Framing Type", "LO", "1", 0, 0},
    { 0x00181065, "Frame Time Vector", "DS", "1-n", 0, 0},
    { 0x00181066, "Frame Delay", "DS", "1", 0, 0},
    { 0x00181067, "Image Trigger Delay", "DS", "1", 0, 0},
    { 0x00181068, "Multiplex Group Time Offset", "DS", "1", 0, 0},
    { 0x00181069, "Trigger Time Offset", "DS", "1", 0, 0},
    { 0x0018106A, "Synchronization Trigger", "CS", "1", 0, 0},
    { 0x0018106C, "Synchronization Channel", "US", "2", 0, 0},
    { 0x0018106E, "Trigger Sample Position", "UL", "1", 0, 0},
    { 0x00181070, "Radiopharmaceutical Route", "LO", "1", 0, 0},
    { 0x00181071, "Radiopharmaceutical Volume", "DS", "1", 0, 0},
    { 0x00181072, "Radiopharmaceutical Start Time", "TM", "1", 0, 0},
    { 0x00181073, "Radiopharmaceutical Stop Time", "TM", "1", 0, 0},
    { 0x00181074, "Radionuclide Total Dose", "DS", "1", 0, 0},
    { 0x00181075, "Radionuclide Half Life", "DS", "1", 0, 0},
    { 0x00181076, "Radionuclide Positron Fraction", "DS", "1", 0, 0},
    { 0x00181077, "Radiopharmaceutical Specific Activity", "DS", "1", 0, 0},
    { 0x00181078, "Radiopharmaceutical Start DateTime", "DT", "1", 0, 0},
    { 0x00181079, "Radiopharmaceutical Stop DateTime", "DT", "1", 0, 0},
    { 0x00181080, "Beat Rejection Flag", "CS", "1", 0, 0},
    { 0x00181081, "Low R-R Value", "IS", "1", 0, 0},
    { 0x00181082, "High R-R Value", "IS", "1", 0, 0},
    { 0x00181083, "Intervals Acquired", "IS", "1", 0, 0},
    { 0x00181084, "Intervals Rejected", "IS", "1", 0, 0},
    { 0x00181085, "PVC Rejection", "LO", "1", 0, 0},
    { 0x00181086, "Skip Beats", "IS", "1", 0, 0},
    { 0x00181088, "Heart Rate", "IS", "1", 0, 0},
    { 0x00181090, "Cardiac Number of Images", "IS", "1", 0, 0},
    { 0x00181094, "Trigger Window", "IS", "1", 0, 0},
    { 0x00181100, "Reconstruction Diameter", "DS", "1", 0, 0},
    { 0x00181110, "Distance Source to Detector", "DS", "1", 0, 0},
    { 0x00181111, "Distance Source to Patient", "DS", "1", 0, 0},
    { 0x00181114, "Estimated Radiographic Magnification Factor", "DS", "1", 0, 0},
    { 0x00181120, "Gantry/Detector Tilt", "DS", "1", 0, 0},
    { 0x00181121, "Gantry/Detector Slew", "DS", "1", 0, 0},
    { 0x00181130, "Table Height", "DS", "1", 0, 0},
    { 0x00181131, "Table Traverse", "DS", "1", 0, 0},
    { 0x00181134, "Table Motion", "CS", "1", 0, 0},
    { 0x00181135, "Table Vertical Increment", "DS", "1-n", 0, 0},
    { 0x00181136, "Table Lateral Increment", "DS", "1-n", 0, 0},
    { 0x00181137, "Table Longitudinal Increment", "DS", "1-n", 0, 0},
    { 0x00181138, "Table Angle", "DS", "1", 0, 0},
    { 0x0018113A, "Table Type", "CS", "1", 0, 0},
    { 0x00181140, "Rotation Direction", "CS", "1", 0, 0},
    { 0x00181141, "Angular Position", "DS", "1", -1, 0},
    { 0x00181142, "Radial Position", "DS", "1-n", 0, 0},
    { 0x00181143, "Scan Arc", "DS", "1", 0, 0},
    { 0x00181144, "Angular Step", "DS", "1", 0, 0},
    { 0x00181145, "Center of Rotation Offset", "DS", "1", 0, 0},
    { 0x00181146, "Rotation Offset", "DS", "1-n", -1, 0},
    { 0x00181147, "Field of View Shape", "CS", "1", 0, 0},
    { 0x00181149, "Field of View Dimension(s)", "IS", "1-2", 0, 0},
    { 0x00181150, "Exposure Time", "IS", "1", 0, 0},
    { 0x00181151, "X-Ray Tube Current", "IS", "1", 0, 0},
    { 0x00181152, "Exposure", "IS", "1", 0, 0},
    { 0x00181153, "Exposure in uAs", "IS", "1", 0, 0},
    { 0x00181154, "Average Pulse Width", "DS", "1", 0, 0},
    { 0x00181155, "Radiation Setting", "CS", "1", 0, 0},
    { 0x00181156, "Rectification Type", "CS", "1", 0, 0},
    { 0x0018115A, "Radiation Mode", "CS", "1", 0, 0},
    { 0x0018115E, "Image and Fluoroscopy Area Dose Product", "DS", "1", 0, 0},
    { 0x00181160, "Filter Type", "SH", "1", 0, 0},
    { 0x00181161, "Type of Filters", "LO", "1-n", 0, 0},
    { 0x00181162, "Intensifier Size", "DS", "1", 0, 0},
    { 0x00181164, "Imager Pixel Spacing", "DS", "2", 0, 0},
    { 0x00181166, "Grid", "CS", "1-n", 0, 0},
    { 0x00181170, "Generator Power", "IS", "1", 0, 0},
    { 0x00181180, "Collimator/grid Name", "SH", "1", 0, 0},
    { 0x00181181, "Collimator Type", "CS", "1", 0, 0},
    { 0x00181182, "Focal Distance", "IS", "1-2", 0, 0},
    { 0x00181183, "X Focus Center", "DS", "1-2", 0, 0},
    { 0x00181184, "Y Focus Center", "DS", "1-2", 0, 0},
    { 0x00181190, "Focal Spot(s)", "DS", "1-n", 0, 0},
    { 0x00181191, "Anode Target Material", "CS", "1", 0, 0},
    { 0x001811A0, "Body Part Thickness", "DS", "1", 0, 0},
    { 0x001811A2, "Compression Force", "DS", "1", 0, 0},
    { 0x001811A3, "Compression Pressure", "DS", "1", 0, 0},
    { 0x001811A4, "Paddle Description", "LO", "1", 0, 0},
    { 0x001811A5, "Compression Contact Area", "DS", "1", 0, 0},
    { 0x00181200, "Date of Last Calibration", "DA", "1-n", 0, 0},
    { 0x00181201, "Time of Last Calibration", "TM", "1-n", 0, 0},
    { 0x00181202, "DateTime of Last Calibration", "DT", "1", 0, 0},
    { 0x00181210, "Convolution Kernel", "SH", "1-n", 0, 0},
    { 0x00181240, "Upper/Lower Pixel Values", "IS", "1-n", -1, 0},
    { 0x00181242, "Actual Frame Duration", "IS", "1", 0, 0},
    { 0x00181243, "Count Rate", "IS", "1", 0, 0},
    { 0x00181244, "Preferred Playback Sequencing", "US", "1", 0, 0},
    { 0x00181250, "Receive Coil Name", "SH", "1", 0, 0},
    { 0x00181251, "Transmit Coil Name", "SH", "1", 0, 0},
    { 0x00181260, "Plate Type", "SH", "1", 0, 0},
    { 0x00181261, "Phosphor Type", "LO", "1", 0, 0},
    { 0x00181271, "Water Equivalent Diameter", "FD", "1", 0, 0},
    { 0x00181272, "Water Equivalent Diameter Calculation Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00181300, "Scan Velocity", "DS", "1", 0, 0},
    { 0x00181301, "Whole Body Technique", "CS", "1-n", 0, 0},
    { 0x00181302, "Scan Length", "IS", "1", 0, 0},
    { 0x00181310, "Acquisition Matrix", "US", "4", 0, 0},
    { 0x00181312, "In-plane Phase Encoding Direction", "CS", "1", 0, 0},
    { 0x00181314, "Flip Angle", "DS", "1", 0, 0},
    { 0x00181315, "Variable Flip Angle Flag", "CS", "1", 0, 0},
    { 0x00181316, "SAR", "DS", "1", 0, 0},
    { 0x00181318, "dB/dt", "DS", "1", 0, 0},
    { 0x00181320, "B1rms", "FL", "1", 0, 0},
    { 0x00181400, "Acquisition Device Processing Description", "LO", "1", 0, 0},
    { 0x00181401, "Acquisition Device Processing Code", "LO", "1", 0, 0},
    { 0x00181402, "Cassette Orientation", "CS", "1", 0, 0},
    { 0x00181403, "Cassette Size", "CS", "1", 0, 0},
    { 0x00181404, "Exposures on Plate", "US", "1", 0, 0},
    { 0x00181405, "Relative X-Ray Exposure", "IS", "1", 0, 0},
    { 0x00181411, "Exposure Index", "DS", "1", 0, 0},
    { 0x00181412, "Target Exposure Index", "DS", "1", 0, 0},
    { 0x00181413, "Deviation Index", "DS", "1", 0, 0},
    { 0x00181450, "Column Angulation", "DS", "1", 0, 0},
    { 0x00181460, "Tomo Layer Height", "DS", "1", 0, 0},
    { 0x00181470, "Tomo Angle", "DS", "1", 0, 0},
    { 0x00181480, "Tomo Time", "DS", "1", 0, 0},
    { 0x00181490, "Tomo Type", "CS", "1", 0, 0},
    { 0x00181491, "Tomo Class", "CS", "1", 0, 0},
    { 0x00181495, "Number of Tomosynthesis Source Images", "IS", "1", 0, 0},
    { 0x00181500, "Positioner Motion", "CS", "1", 0, 0},
    { 0x00181508, "Positioner Type", "CS", "1", 0, 0},
    { 0x00181510, "Positioner Primary Angle", "DS", "1", 0, 0},
    { 0x00181511, "Positioner Secondary Angle", "DS", "1", 0, 0},
    { 0x00181520, "Positioner Primary Angle Increment", "DS", "1-n", 0, 0},
    { 0x00181521, "Positioner Secondary Angle Increment", "DS", "1-n", 0, 0},
    { 0x00181530, "Detector Primary Angle", "DS", "1", 0, 0},
    { 0x00181531, "Detector Secondary Angle", "DS", "1", 0, 0},
    { 0x00181600, "Shutter Shape", "CS", "1-3", 0, 0},
    { 0x00181602, "Shutter Left Vertical Edge", "IS", "1", 0, 0},
    { 0x00181604, "Shutter Right Vertical Edge", "IS", "1", 0, 0},
    { 0x00181606, "Shutter Upper Horizontal Edge", "IS", "1", 0, 0},
    { 0x00181608, "Shutter Lower Horizontal Edge", "IS", "1", 0, 0},
    { 0x00181610, "Center of Circular Shutter", "IS", "2", 0, 0},
    { 0x00181612, "Radius of Circular Shutter", "IS", "1", 0, 0},
    { 0x00181620, "Vertices of the Polygonal Shutter", "IS", "2-2n", 0, 0},
    { 0x00181622, "Shutter Presentation Value", "US", "1", 0, 0},
    { 0x00181623, "Shutter Overlay Group", "US", "1", 0, 0},
    { 0x00181624, "Shutter Presentation Color CIELab Value", "US", "3", 0, 0},
    { 0x00181630, "Outline Shape Type", "CS", "1", 0, 0},
    { 0x00181631, "Outline Left Vertical Edge", "FD", "1", 0, 0},
    { 0x00181632, "Outline Right Vertical Edge", "FD", "1", 0, 0},
    { 0x00181633, "Outline Upper Horizontal Edge", "FD", "1", 0, 0},
    { 0x00181634, "Outline Lower Horizontal Edge", "FD", "1", 0, 0},
    { 0x00181635, "Center of Circular Outline", "FD", "2", 0, 0},
    { 0x00181636, "Diameter of Circular Outline", "FD", "1", 0, 0},
    { 0x00181637, "Number of Polygonal Vertices", "UL", "1", 0, 0},
    { 0x00181638, "Vertices of the Polygonal Outline", "OF", "1", 0, 0},
    { 0x00181700, "Collimator Shape", "CS", "1-3", 0, 0},
    { 0x00181702, "Collimator Left Vertical Edge", "IS", "1", 0, 0},
    { 0x00181704, "Collimator Right Vertical Edge", "IS", "1", 0, 0},
    { 0x00181706, "Collimator Upper Horizontal Edge", "IS", "1", 0, 0},
    { 0x00181708, "Collimator Lower Horizontal Edge", "IS", "1", 0, 0},
    { 0x00181710, "Center of Circular Collimator", "IS", "2", 0, 0},
    { 0x00181712, "Radius of Circular Collimator", "IS", "1", 0, 0},
    { 0x00181720, "Vertices of the Polygonal Collimator", "IS", "2-2n", 0, 0},
    { 0x00181800, "Acquisition Time Synchronized", "CS", "1", 0, 0},
    { 0x00181801, "Time Source", "SH", "1", 0, 0},
    { 0x00181802, "Time Distribution Protocol", "CS", "1", 0, 0},
    { 0x00181803, "NTP Source Address", "LO", "1", 0, 0},
    { 0x00182001, "Page Number Vector", "IS", "1-n", 0, 0},
    { 0x00182002, "Frame Label Vector", "SH", "1-n", 0, 0},
    { 0x00182003, "Frame Primary Angle Vector", "DS", "1-n", 0, 0},
    { 0x00182004, "Frame Secondary Angle Vector", "DS", "1-n", 0, 0},
    { 0x00182005, "Slice Location Vector", "DS", "1-n", 0, 0},
    { 0x00182006, "Display Window Label Vector", "SH", "1-n", 0, 0},
    { 0x00182010, "Nominal Scanned Pixel Spacing", "DS", "2", 0, 0},
    { 0x00182020, "Digitizing Device Transport Direction", "CS", "1", 0, 0},
    { 0x00182030, "Rotation of Scanned Film", "DS", "1", 0, 0},
    { 0x00182041, "Biopsy Target Sequence", "SQ", "1", 0, 0},
    { 0x00182042, "Target UID", "UI", "1", 0, 0},
    { 0x00182043, "Localizing Cursor Position", "FL", "2", 0, 0},
    { 0x00182044, "Calculated Target Position", "FL", "3", 0, 0},
    { 0x00182045, "Target Label", "SH", "1", 0, 0},
    { 0x00182046, "Displayed Z Value", "FL", "1", 0, 0},
    { 0x00183100, "IVUS Acquisition", "CS", "1", 0, 0},
    { 0x00183101, "IVUS Pullback Rate", "DS", "1", 0, 0},
    { 0x00183102, "IVUS Gated Rate", "DS", "1", 0, 0},
    { 0x00183103, "IVUS Pullback Start Frame Number", "IS", "1", 0, 0},
    { 0x00183104, "IVUS Pullback Stop Frame Number", "IS", "1", 0, 0},
    { 0x00183105, "Lesion Number", "IS", "1-n", 0, 0},
    { 0x00184000, "Acquisition Comments", "LT", "1", -1, 0},
    { 0x00185000, "Output Power", "SH", "1-n", 0, 0},
    { 0x00185010, "Transducer Data", "LO", "1-n", 0, 0},
    { 0x00185012, "Focus Depth", "DS", "1", 0, 0},
    { 0x00185020, "Processing Function", "LO", "1", 0, 0},
    { 0x00185021, "Postprocessing Function", "LO", "1", -1, 0},
    { 0x00185022, "Mechanical Index", "DS", "1", 0, 0},
    { 0x00185024, "Bone Thermal Index", "DS", "1", 0, 0},
    { 0x00185026, "Cranial Thermal Index", "DS", "1", 0, 0},
    { 0x00185027, "Soft Tissue Thermal Index", "DS", "1", 0, 0},
    { 0x00185028, "Soft Tissue-focus Thermal Index", "DS", "1", 0, 0},
    { 0x00185029, "Soft Tissue-surface Thermal Index", "DS", "1", 0, 0},
    { 0x00185030, "Dynamic Range", "DS", "1", -1, 0},
    { 0x00185040, "Total Gain", "DS", "1", -1, 0},
    { 0x00185050, "Depth of Scan Field", "IS", "1", 0, 0},
    { 0x00185100, "Patient Position", "CS", "1", 0, -1},
    { 0x00185101, "View Position", "CS", "1", 0, 0},
    { 0x00185104, "Projection Eponymous Name Code Sequence", "SQ", "1", 0, 0},
    { 0x00185210, "Image Transformation Matrix", "DS", "6", -1, 0},
    { 0x00185212, "Image Translation Vector", "DS", "3", -1, 0},
    { 0x00186000, "Sensitivity", "DS", "1", 0, 0},
    { 0x00186011, "Sequence of Ultrasound Regions", "SQ", "1", 0, 0},
    { 0x00186012, "Region Spatial Format", "US", "1", 0, 0},
    { 0x00186014, "Region Data Type", "US", "1", 0, 0},
    { 0x00186016, "Region Flags", "UL", "1", 0, 0},
    { 0x00186018, "Region Location Min X0", "UL", "1", 0, 0},
    { 0x0018601A, "Region Location Min Y0", "UL", "1", 0, 0},
    { 0x0018601C, "Region Location Max X1", "UL", "1", 0, 0},
    { 0x0018601E, "Region Location Max Y1", "UL", "1", 0, 0},
    { 0x00186020, "Reference Pixel X0", "SL", "1", 0, 0},
    { 0x00186022, "Reference Pixel Y0", "SL", "1", 0, 0},
    { 0x00186024, "Physical Units X Direction", "US", "1", 0, 0},
    { 0x00186026, "Physical Units Y Direction", "US", "1", 0, 0},
    { 0x00186028, "Reference Pixel Physical Value X", "FD", "1", 0, 0},
    { 0x0018602A, "Reference Pixel Physical Value Y", "FD", "1", 0, 0},
    { 0x0018602C, "Physical Delta X", "FD", "1", 0, 0},
    { 0x0018602E, "Physical Delta Y", "FD", "1", 0, 0},
    { 0x00186030, "Transducer Frequency", "UL", "1", 0, 0},
    { 0x00186031, "Transducer Type", "CS", "1", 0, 0},
    { 0x00186032, "Pulse Repetition Frequency", "UL", "1", 0, 0},
    { 0x00186034, "Doppler Correction Angle", "FD", "1", 0, 0},
    { 0x00186036, "Steering Angle", "FD", "1", 0, 0},
    { 0x00186038, "Doppler Sample Volume X Position (Retired)", "UL", "1", -1, 0},
    { 0x00186039, "Doppler Sample Volume X Position", "SL", "1", 0, 0},
    { 0x0018603A, "Doppler Sample Volume Y Position (Retired)", "UL", "1", -1, 0},
    { 0x0018603B, "Doppler Sample Volume Y Position", "SL", "1", 0, 0},
    { 0x0018603C, "TM-Line Position X0 (Retired)", "UL", "1", -1, 0},
    { 0x0018603D, "TM-Line Position X0", "SL", "1", 0, 0},
    { 0x0018603E, "TM-Line Position Y0 (Retired)", "UL", "1", -1, 0},
    { 0x0018603F, "TM-Line Position Y0", "SL", "1", 0, 0},
    { 0x00186040, "TM-Line Position X1 (Retired)", "UL", "1", -1, 0},
    { 0x00186041, "TM-Line Position X1", "SL", "1", 0, 0},
    { 0x00186042, "TM-Line Position Y1 (Retired)", "UL", "1", -1, 0},
    { 0x00186043, "TM-Line Position Y1", "SL", "1", 0, 0},
    { 0x00186044, "Pixel Component Organization", "US", "1", 0, 0},
    { 0x00186046, "Pixel Component Mask", "UL", "1", 0, 0},
    { 0x00186048, "Pixel Component Range Start", "UL", "1", 0, 0},
    { 0x0018604A, "Pixel Component Range Stop", "UL", "1", 0, 0},
    { 0x0018604C, "Pixel Component Physical Units", "US", "1", 0, 0},
    { 0x0018604E, "Pixel Component Data Type", "US", "1", 0, 0},
    { 0x00186050, "Number of Table Break Points", "UL", "1", 0, 0},
    { 0x00186052, "Table of X Break Points", "UL", "1-n", 0, 0},
    { 0x00186054, "Table of Y Break Points", "FD", "1-n", 0, 0},
    { 0x00186056, "Number of Table Entries", "UL", "1", 0, 0},
    { 0x00186058, "Table of Pixel Values", "UL", "1-n", 0, 0},
    { 0x0018605A, "Table of Parameter Values", "FL", "1-n", 0, 0},
    { 0x00186060, "R Wave Time Vector", "FL", "1-n", 0, 0},
    { 0x00187000, "Detector Conditions Nominal Flag", "CS", "1", 0, 0},
    { 0x00187001, "Detector Temperature", "DS", "1", 0, 0},
    { 0x00187004, "Detector Type", "CS", "1", 0, 0},
    { 0x00187005, "Detector Configuration", "CS", "1", 0, 0},
    { 0x00187006, "Detector Description", "LT", "1", 0, 0},
    { 0x00187008, "Detector Mode", "LT", "1", 0, 0},
    { 0x0018700A, "Detector ID", "SH", "1", 0, 0},
    { 0x0018700C, "Date of Last Detector Calibration", "DA", "1", 0, 0},
    { 0x0018700E, "Time of Last Detector Calibration", "TM", "1", 0, 0},
    { 0x00187010, "Exposures on Detector Since Last Calibration", "IS", "1", 0, 0},
    { 0x00187011, "Exposures on Detector Since Manufactured", "IS", "1", 0, 0},
    { 0x00187012, "Detector Time Since Last Exposure", "DS", "1", 0, 0},
    { 0x00187014, "Detector Active Time", "DS", "1", 0, 0},
    { 0x00187016, "Detector Activation Offset From Exposure", "DS", "1", 0, 0},
    { 0x0018701A, "Detector Binning", "DS", "2", 0, 0},
    { 0x00187020, "Detector Element Physical Size", "DS", "2", 0, 0},
    { 0x00187022, "Detector Element Spacing", "DS", "2", 0, 0},
    { 0x00187024, "Detector Active Shape", "CS", "1", 0, 0},
    { 0x00187026, "Detector Active Dimension(s)", "DS", "1-2", 0, 0},
    { 0x00187028, "Detector Active Origin", "DS", "2", 0, 0},
    { 0x0018702A, "Detector Manufacturer Name", "LO", "1", 0, 0},
    { 0x0018702B, "Detector Manufacturer's Model Name", "LO", "1", 0, 0},
    { 0x00187030, "Field of View Origin", "DS", "2", 0, 0},
    { 0x00187032, "Field of View Rotation", "DS", "1", 0, 0},
    { 0x00187034, "Field of View Horizontal Flip", "CS", "1", 0, 0},
    { 0x00187036, "Pixel Data Area Origin Relative To FOV", "FL", "2", 0, 0},
    { 0x00187038, "Pixel Data Area Rotation Angle Relative To FOV", "FL", "1", 0, 0},
    { 0x00187040, "Grid Absorbing Material", "LT", "1", 0, 0},
    { 0x00187041, "Grid Spacing Material", "LT", "1", 0, 0},
    { 0x00187042, "Grid Thickness", "DS", "1", 0, 0},
    { 0x00187044, "Grid Pitch", "DS", "1", 0, 0},
    { 0x00187046, "Grid Aspect Ratio", "IS", "2", 0, 0},
    { 0x00187048, "Grid Period", "DS", "1", 0, 0},
    { 0x0018704C, "Grid Focal Distance", "DS", "1", 0, 0},
    { 0x00187050, "Filter Material", "CS", "1-n", 0, 0},
    { 0x00187052, "Filter Thickness Minimum", "DS", "1-n", 0, 0},
    { 0x00187054, "Filter Thickness Maximum", "DS", "1-n", 0, 0},
    { 0x00187056, "Filter Beam Path Length Minimum", "FL", "1-n", 0, 0},
    { 0x00187058, "Filter Beam Path Length Maximum", "FL", "1-n", 0, 0},
    { 0x00187060, "Exposure Control Mode", "CS", "1", 0, 0},
    { 0x00187062, "Exposure Control Mode Description", "LT", "1", 0, 0},
    { 0x00187064, "Exposure Status", "CS", "1", 0, 0},
    { 0x00187065, "Phototimer Setting", "DS", "1", 0, 0},
    { 0x00188150, "Exposure Time in uS", "DS", "1", 0, 0},
    { 0x00188151, "X-Ray Tube Current in uA", "DS", "1", 0, 0},
    { 0x00189004, "Content Qualification", "CS", "1", 0, 0},
    { 0x00189005, "Pulse Sequence Name", "SH", "1", 0, 0},
    { 0x00189006, "MR Imaging Modifier Sequence", "SQ", "1", 0, 0},
    { 0x00189008, "Echo Pulse Sequence", "CS", "1", 0, 0},
    { 0x00189009, "Inversion Recovery", "CS", "1", 0, 0},
    { 0x00189010, "Flow Compensation", "CS", "1", 0, 0},
    { 0x00189011, "Multiple Spin Echo", "CS", "1", 0, 0},
    { 0x00189012, "Multi-planar Excitation", "CS", "1", 0, 0},
    { 0x00189014, "Phase Contrast", "CS", "1", 0, 0},
    { 0x00189015, "Time of Flight Contrast", "CS", "1", 0, 0},
    { 0x00189016, "Spoiling", "CS", "1", 0, 0},
    { 0x00189017, "Steady State Pulse Sequence", "CS", "1", 0, 0},
    { 0x00189018, "Echo Planar Pulse Sequence", "CS", "1", 0, 0},
    { 0x00189019, "Tag Angle First Axis", "FD", "1", 0, 0},
    { 0x00189020, "Magnetization Transfer", "CS", "1", 0, 0},
    { 0x00189021, "T2 Preparation", "CS", "1", 0, 0},
    { 0x00189022, "Blood Signal Nulling", "CS", "1", 0, 0},
    { 0x00189024, "Saturation Recovery", "CS", "1", 0, 0},
    { 0x00189025, "Spectrally Selected Suppression", "CS", "1", 0, 0},
    { 0x00189026, "Spectrally Selected Excitation", "CS", "1", 0, 0},
    { 0x00189027, "Spatial Pre-saturation", "CS", "1", 0, 0},
    { 0x00189028, "Tagging", "CS", "1", 0, 0},
    { 0x00189029, "Oversampling Phase", "CS", "1", 0, 0},
    { 0x00189030, "Tag Spacing First Dimension", "FD", "1", 0, 0},
    { 0x00189032, "Geometry of k-Space Traversal", "CS", "1", 0, 0},
    { 0x00189033, "Segmented k-Space Traversal", "CS", "1", 0, 0},
    { 0x00189034, "Rectilinear Phase Encode Reordering", "CS", "1", 0, 0},
    { 0x00189035, "Tag Thickness", "FD", "1", 0, 0},
    { 0x00189036, "Partial Fourier Direction", "CS", "1", 0, 0},
    { 0x00189037, "Cardiac Synchronization Technique", "CS", "1", 0, 0},
    { 0x00189041, "Receive Coil Manufacturer Name", "LO", "1", 0, 0},
    { 0x00189042, "MR Receive Coil Sequence", "SQ", "1", 0, 0},
    { 0x00189043, "Receive Coil Type", "CS", "1", 0, 0},
    { 0x00189044, "Quadrature Receive Coil", "CS", "1", 0, 0},
    { 0x00189045, "Multi-Coil Definition Sequence", "SQ", "1", 0, 0},
    { 0x00189046, "Multi-Coil Configuration", "LO", "1", 0, 0},
    { 0x00189047, "Multi-Coil Element Name", "SH", "1", 0, 0},
    { 0x00189048, "Multi-Coil Element Used", "CS", "1", 0, 0},
    { 0x00189049, "MR Transmit Coil Sequence", "SQ", "1", 0, 0},
    { 0x00189050, "Transmit Coil Manufacturer Name", "LO", "1", 0, 0},
    { 0x00189051, "Transmit Coil Type", "CS", "1", 0, 0},
    { 0x00189052, "Spectral Width", "FD", "1-2", 0, 0},
    { 0x00189053, "Chemical Shift Reference", "FD", "1-2", 0, 0},
    { 0x00189054, "Volume Localization Technique", "CS", "1", 0, 0},
    { 0x00189058, "MR Acquisition Frequency Encoding Steps", "US", "1", 0, 0},
    { 0x00189059, "De-coupling", "CS", "1", 0, 0},
    { 0x00189060, "De-coupled Nucleus", "CS", "1-2", 0, 0},
    { 0x00189061, "De-coupling Frequency", "FD", "1-2", 0, 0},
    { 0x00189062, "De-coupling Method", "CS", "1", 0, 0},
    { 0x00189063, "De-coupling Chemical Shift Reference", "FD", "1-2", 0, 0},
    { 0x00189064, "k-space Filtering", "CS", "1", 0, 0},
    { 0x00189065, "Time Domain Filtering", "CS", "1-2", 0, 0},
    { 0x00189066, "Number of Zero Fills", "US", "1-2", 0, 0},
    { 0x00189067, "Baseline Correction", "CS", "1", 0, 0},
    { 0x00189069, "Parallel Reduction Factor In-plane", "FD", "1", 0, 0},
    { 0x00189070, "Cardiac R-R Interval Specified", "FD", "1", 0, 0},
    { 0x00189073, "Acquisition Duration", "FD", "1", 0, 0},
    { 0x00189074, "Frame Acquisition DateTime", "DT", "1", 0, 0},
    { 0x00189075, "Diffusion Directionality", "CS", "1", 0, 0},
    { 0x00189076, "Diffusion Gradient Direction Sequence", "SQ", "1", 0, 0},
    { 0x00189077, "Parallel Acquisition", "CS", "1", 0, 0},
    { 0x00189078, "Parallel Acquisition Technique", "CS", "1", 0, 0},
    { 0x00189079, "Inversion Times", "FD", "1-n", 0, 0},
    { 0x00189080, "Metabolite Map Description", "ST", "1", 0, 0},
    { 0x00189081, "Partial Fourier", "CS", "1", 0, 0},
    { 0x00189082, "Effective Echo Time", "FD", "1", 0, 0},
    { 0x00189083, "Metabolite Map Code Sequence", "SQ", "1", 0, 0},
    { 0x00189084, "Chemical Shift Sequence", "SQ", "1", 0, 0},
    { 0x00189085, "Cardiac Signal Source", "CS", "1", 0, 0},
    { 0x00189087, "Diffusion b-value", "FD", "1", 0, 0},
    { 0x00189089, "Diffusion Gradient Orientation", "FD", "3", 0, 0},
    { 0x00189090, "Velocity Encoding Direction", "FD", "3", 0, 0},
    { 0x00189091, "Velocity Encoding Minimum Value", "FD", "1", 0, 0},
    { 0x00189092, "Velocity Encoding Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189093, "Number of k-Space Trajectories", "US", "1", 0, 0},
    { 0x00189094, "Coverage of k-Space", "CS", "1", 0, 0},
    { 0x00189095, "Spectroscopy Acquisition Phase Rows", "UL", "1", 0, 0},
    { 0x00189096, "Parallel Reduction Factor In-plane (Retired)", "FD", "1", -1, 0},
    { 0x00189098, "Transmitter Frequency", "FD", "1-2", 0, 0},
    { 0x00189100, "Resonant Nucleus", "CS", "1-2", 0, 0},
    { 0x00189101, "Frequency Correction", "CS", "1", 0, 0},
    { 0x00189103, "MR Spectroscopy FOV/Geometry Sequence", "SQ", "1", 0, 0},
    { 0x00189104, "Slab Thickness", "FD", "1", 0, 0},
    { 0x00189105, "Slab Orientation", "FD", "3", 0, 0},
    { 0x00189106, "Mid Slab Position", "FD", "3", 0, 0},
    { 0x00189107, "MR Spatial Saturation Sequence", "SQ", "1", 0, 0},
    { 0x00189112, "MR Timing and Related Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00189114, "MR Echo Sequence", "SQ", "1", 0, 0},
    { 0x00189115, "MR Modifier Sequence", "SQ", "1", 0, 0},
    { 0x00189117, "MR Diffusion Sequence", "SQ", "1", 0, 0},
    { 0x00189118, "Cardiac Synchronization Sequence", "SQ", "1", 0, 0},
    { 0x00189119, "MR Averages Sequence", "SQ", "1", 0, 0},
    { 0x00189125, "MR FOV/Geometry Sequence", "SQ", "1", 0, 0},
    { 0x00189126, "Volume Localization Sequence", "SQ", "1", 0, 0},
    { 0x00189127, "Spectroscopy Acquisition Data Columns", "UL", "1", 0, 0},
    { 0x00189147, "Diffusion Anisotropy Type", "CS", "1", 0, 0},
    { 0x00189151, "Frame Reference DateTime", "DT", "1", 0, 0},
    { 0x00189152, "MR Metabolite Map Sequence", "SQ", "1", 0, 0},
    { 0x00189155, "Parallel Reduction Factor out-of-plane", "FD", "1", 0, 0},
    { 0x00189159, "Spectroscopy Acquisition Out-of-plane Phase Steps", "UL", "1", 0, 0},
    { 0x00189166, "Bulk Motion Status", "CS", "1", -1, 0},
    { 0x00189168, "Parallel Reduction Factor Second In-plane", "FD", "1", 0, 0},
    { 0x00189169, "Cardiac Beat Rejection Technique", "CS", "1", 0, 0},
    { 0x00189170, "Respiratory Motion Compensation Technique", "CS", "1", 0, 0},
    { 0x00189171, "Respiratory Signal Source", "CS", "1", 0, 0},
    { 0x00189172, "Bulk Motion Compensation Technique", "CS", "1", 0, 0},
    { 0x00189173, "Bulk Motion Signal Source", "CS", "1", 0, 0},
    { 0x00189174, "Applicable Safety Standard Agency", "CS", "1", 0, 0},
    { 0x00189175, "Applicable Safety Standard Description", "LO", "1", 0, 0},
    { 0x00189176, "Operating Mode Sequence", "SQ", "1", 0, 0},
    { 0x00189177, "Operating Mode Type", "CS", "1", 0, 0},
    { 0x00189178, "Operating Mode", "CS", "1", 0, 0},
    { 0x00189179, "Specific Absorption Rate Definition", "CS", "1", 0, 0},
    { 0x00189180, "Gradient Output Type", "CS", "1", 0, 0},
    { 0x00189181, "Specific Absorption Rate Value", "FD", "1", 0, 0},
    { 0x00189182, "Gradient Output", "FD", "1", 0, 0},
    { 0x00189183, "Flow Compensation Direction", "CS", "1", 0, 0},
    { 0x00189184, "Tagging Delay", "FD", "1", 0, 0},
    { 0x00189185, "Respiratory Motion Compensation Technique Description", "ST", "1", 0, 0},
    { 0x00189186, "Respiratory Signal Source ID", "SH", "1", 0, 0},
    { 0x00189195, "Chemical Shift Minimum Integration Limit in Hz", "FD", "1", -1, 0},
    { 0x00189196, "Chemical Shift Maximum Integration Limit in Hz", "FD", "1", -1, 0},
    { 0x00189197, "MR Velocity Encoding Sequence", "SQ", "1", 0, 0},
    { 0x00189198, "First Order Phase Correction", "CS", "1", 0, 0},
    { 0x00189199, "Water Referenced Phase Correction", "CS", "1", 0, 0},
    { 0x00189200, "MR Spectroscopy Acquisition Type", "CS", "1", 0, 0},
    { 0x00189214, "Respiratory Cycle Position", "CS", "1", 0, 0},
    { 0x00189217, "Velocity Encoding Maximum Value", "FD", "1", 0, 0},
    { 0x00189218, "Tag Spacing Second Dimension", "FD", "1", 0, 0},
    { 0x00189219, "Tag Angle Second Axis", "SS", "1", 0, 0},
    { 0x00189220, "Frame Acquisition Duration", "FD", "1", 0, 0},
    { 0x00189226, "MR Image Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00189227, "MR Spectroscopy Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00189231, "MR Acquisition Phase Encoding Steps in-plane", "US", "1", 0, 0},
    { 0x00189232, "MR Acquisition Phase Encoding Steps out-of-plane", "US", "1", 0, 0},
    { 0x00189234, "Spectroscopy Acquisition Phase Columns", "UL", "1", 0, 0},
    { 0x00189236, "Cardiac Cycle Position", "CS", "1", 0, 0},
    { 0x00189239, "Specific Absorption Rate Sequence", "SQ", "1", 0, 0},
    { 0x00189240, "RF Echo Train Length", "US", "1", 0, 0},
    { 0x00189241, "Gradient Echo Train Length", "US", "1", 0, 0},
    { 0x00189250, "Arterial Spin Labeling Contrast", "CS", "1", 0, 0},
    { 0x00189251, "MR Arterial Spin Labeling Sequence", "SQ", "1", 0, 0},
    { 0x00189252, "ASL Technique Description", "LO", "1", 0, 0},
    { 0x00189253, "ASL Slab Number", "US", "1", 0, 0},
    { 0x00189254, "ASL Slab Thickness", "FD", "1", 0, 0},
    { 0x00189255, "ASL Slab Orientation", "FD", "3", 0, 0},
    { 0x00189256, "ASL Mid Slab Position", "FD", "3", 0, 0},
    { 0x00189257, "ASL Context", "CS", "1", 0, 0},
    { 0x00189258, "ASL Pulse Train Duration", "UL", "1", 0, 0},
    { 0x00189259, "ASL Crusher Flag", "CS", "1", 0, 0},
    { 0x0018925A, "ASL Crusher Flow Limit", "FD", "1", 0, 0},
    { 0x0018925B, "ASL Crusher Description", "LO", "1", 0, 0},
    { 0x0018925C, "ASL Bolus Cut-off Flag", "CS", "1", 0, 0},
    { 0x0018925D, "ASL Bolus Cut-off Timing Sequence", "SQ", "1", 0, 0},
    { 0x0018925E, "ASL Bolus Cut-off Technique", "LO", "1", 0, 0},
    { 0x0018925F, "ASL Bolus Cut-off Delay Time", "UL", "1", 0, 0},
    { 0x00189260, "ASL Slab Sequence", "SQ", "1", 0, 0},
    { 0x00189295, "Chemical Shift Minimum Integration Limit in ppm", "FD", "1", 0, 0},
    { 0x00189296, "Chemical Shift Maximum Integration Limit in ppm", "FD", "1", 0, 0},
    { 0x00189297, "Water Reference Acquisition", "CS", "1", 0, 0},
    { 0x00189298, "Echo Peak Position", "IS", "1", 0, 0},
    { 0x00189301, "CT Acquisition Type Sequence", "SQ", "1", 0, 0},
    { 0x00189302, "Acquisition Type", "CS", "1", 0, 0},
    { 0x00189303, "Tube Angle", "FD", "1", 0, 0},
    { 0x00189304, "CT Acquisition Details Sequence", "SQ", "1", 0, 0},
    { 0x00189305, "Revolution Time", "FD", "1", 0, 0},
    { 0x00189306, "Single Collimation Width", "FD", "1", 0, 0},
    { 0x00189307, "Total Collimation Width", "FD", "1", 0, 0},
    { 0x00189308, "CT Table Dynamics Sequence", "SQ", "1", 0, 0},
    { 0x00189309, "Table Speed", "FD", "1", 0, 0},
    { 0x00189310, "Table Feed per Rotation", "FD", "1", 0, 0},
    { 0x00189311, "Spiral Pitch Factor", "FD", "1", 0, 0},
    { 0x00189312, "CT Geometry Sequence", "SQ", "1", 0, 0},
    { 0x00189313, "Data Collection Center (Patient)", "FD", "3", 0, 0},
    { 0x00189314, "CT Reconstruction Sequence", "SQ", "1", 0, 0},
    { 0x00189315, "Reconstruction Algorithm", "CS", "1", 0, 0},
    { 0x00189316, "Convolution Kernel Group", "CS", "1", 0, 0},
    { 0x00189317, "Reconstruction Field of View", "FD", "2", 0, 0},
    { 0x00189318, "Reconstruction Target Center (Patient)", "FD", "3", 0, 0},
    { 0x00189319, "Reconstruction Angle", "FD", "1", 0, 0},
    { 0x00189320, "Image Filter", "SH", "1", 0, 0},
    { 0x00189321, "CT Exposure Sequence", "SQ", "1", 0, 0},
    { 0x00189322, "Reconstruction Pixel Spacing", "FD", "2", 0, 0},
    { 0x00189323, "Exposure Modulation Type", "CS", "1-n", 0, 0},
    { 0x00189324, "Estimated Dose Saving", "FD", "1", 0, 0},
    { 0x00189325, "CT X-Ray Details Sequence", "SQ", "1", 0, 0},
    { 0x00189326, "CT Position Sequence", "SQ", "1", 0, 0},
    { 0x00189327, "Table Position", "FD", "1", 0, 0},
    { 0x00189328, "Exposure Time in ms", "FD", "1", 0, 0},
    { 0x00189329, "CT Image Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00189330, "X-Ray Tube Current in mA", "FD", "1", 0, 0},
    { 0x00189332, "Exposure in mAs", "FD", "1", 0, 0},
    { 0x00189333, "Constant Volume Flag", "CS", "1", 0, 0},
    { 0x00189334, "Fluoroscopy Flag", "CS", "1", 0, 0},
    { 0x00189335, "Distance Source to Data Collection Center", "FD", "1", 0, 0},
    { 0x00189337, "Contrast/Bolus Agent Number", "US", "1", 0, 0},
    { 0x00189338, "Contrast/Bolus Ingredient Code Sequence", "SQ", "1", 0, 0},
    { 0x00189340, "Contrast Administration Profile Sequence", "SQ", "1", 0, 0},
    { 0x00189341, "Contrast/Bolus Usage Sequence", "SQ", "1", 0, 0},
    { 0x00189342, "Contrast/Bolus Agent Administered", "CS", "1", 0, 0},
    { 0x00189343, "Contrast/Bolus Agent Detected", "CS", "1", 0, 0},
    { 0x00189344, "Contrast/Bolus Agent Phase", "CS", "1", 0, 0},
    { 0x00189345, "CTDIvol", "FD", "1", 0, 0},
    { 0x00189346, "CTDI Phantom Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00189351, "Calcium Scoring Mass Factor Patient", "FL", "1", 0, 0},
    { 0x00189352, "Calcium Scoring Mass Factor Device", "FL", "3", 0, 0},
    { 0x00189353, "Energy Weighting Factor", "FL", "1", 0, 0},
    { 0x00189360, "CT Additional X-Ray Source Sequence", "SQ", "1", 0, 0},
    { 0x00189361, "Multi-energy CT Acquisition", "CS", "1", 0, 0},
    { 0x00189362, "Multi-energy CT Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189363, "Multi-energy CT Processing Sequence", "SQ", "1", 0, 0},
    { 0x00189364, "Multi-energy CT Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x00189365, "Multi-energy CT X-Ray Source Sequence", "SQ", "1", 0, 0},
    { 0x00189366, "X-Ray Source Index", "US", "1", 0, 0},
    { 0x00189367, "X-Ray Source ID", "UC", "1", 0, 0},
    { 0x00189368, "Multi-energy Source Technique", "CS", "1", 0, 0},
    { 0x00189369, "Source Start DateTime", "DT", "1", 0, 0},
    { 0x0018936A, "Source End DateTime", "DT", "1", 0, 0},
    { 0x0018936B, "Switching Phase Number", "US", "1", 0, 0},
    { 0x0018936C, "Switching Phase Nominal Duration", "DS", "1", 0, 0},
    { 0x0018936D, "Switching Phase Transition Duration", "DS", "1", 0, 0},
    { 0x0018936E, "Effective Bin Energy", "DS", "1", 0, 0},
    { 0x0018936F, "Multi-energy CT X-Ray Detector Sequence", "SQ", "1", 0, 0},
    { 0x00189370, "X-Ray Detector Index", "US", "1", 0, 0},
    { 0x00189371, "X-Ray Detector ID", "UC", "1", 0, 0},
    { 0x00189372, "Multi-energy Detector Type", "CS", "1", 0, 0},
    { 0x00189373, "X-Ray Detector Label", "ST", "1", 0, 0},
    { 0x00189374, "Nominal Max Energy", "DS", "1", 0, 0},
    { 0x00189375, "Nominal Min Energy", "DS", "1", 0, 0},
    { 0x00189376, "Referenced X-Ray Detector Index", "US", "1-n", 0, 0},
    { 0x00189377, "Referenced X-Ray Source Index", "US", "1-n", 0, 0},
    { 0x00189378, "Referenced Path Index", "US", "1-n", 0, 0},
    { 0x00189379, "Multi-energy CT Path Sequence", "SQ", "1", 0, 0},
    { 0x0018937A, "Multi-energy CT Path Index", "US", "1", 0, 0},
    { 0x0018937B, "Multi-energy Acquisition Description", "UT", "1", 0, 0},
    { 0x0018937C, "Monoenergetic Energy Equivalent", "FD", "1", 0, 0},
    { 0x0018937D, "Material Code Sequence", "SQ", "1", 0, 0},
    { 0x0018937E, "Decomposition Method", "CS", "1", 0, 0},
    { 0x0018937F, "Decomposition Description", "UT", "1", 0, 0},
    { 0x00189380, "Decomposition Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x00189381, "Decomposition Material Sequence", "SQ", "1", 0, 0},
    { 0x00189382, "Material Attenuation Sequence", "SQ", "1", 0, 0},
    { 0x00189383, "Photon Energy", "DS", "1", 0, 0},
    { 0x00189384, "X-Ray Mass Attenuation Coefficient", "DS", "1", 0, 0},
    { 0x00189401, "Projection Pixel Calibration Sequence", "SQ", "1", 0, 0},
    { 0x00189402, "Distance Source to Isocenter", "FL", "1", 0, 0},
    { 0x00189403, "Distance Object to Table Top", "FL", "1", 0, 0},
    { 0x00189404, "Object Pixel Spacing in Center of Beam", "FL", "2", 0, 0},
    { 0x00189405, "Positioner Position Sequence", "SQ", "1", 0, 0},
    { 0x00189406, "Table Position Sequence", "SQ", "1", 0, 0},
    { 0x00189407, "Collimator Shape Sequence", "SQ", "1", 0, 0},
    { 0x00189410, "Planes in Acquisition", "CS", "1", 0, 0},
    { 0x00189412, "XA/XRF Frame Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x00189417, "Frame Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189420, "X-Ray Receptor Type", "CS", "1", 0, 0},
    { 0x00189423, "Acquisition Protocol Name", "LO", "1", 0, 0},
    { 0x00189424, "Acquisition Protocol Description", "LT", "1", 0, 0},
    { 0x00189425, "Contrast/Bolus Ingredient Opaque", "CS", "1", 0, 0},
    { 0x00189426, "Distance Receptor Plane to Detector Housing", "FL", "1", 0, 0},
    { 0x00189427, "Intensifier Active Shape", "CS", "1", 0, 0},
    { 0x00189428, "Intensifier Active Dimension(s)", "FL", "1-2", 0, 0},
    { 0x00189429, "Physical Detector Size", "FL", "2", 0, 0},
    { 0x00189430, "Position of Isocenter Projection", "FL", "2", 0, 0},
    { 0x00189432, "Field of View Sequence", "SQ", "1", 0, 0},
    { 0x00189433, "Field of View Description", "LO", "1", 0, 0},
    { 0x00189434, "Exposure Control Sensing Regions Sequence", "SQ", "1", 0, 0},
    { 0x00189435, "Exposure Control Sensing Region Shape", "CS", "1", 0, 0},
    { 0x00189436, "Exposure Control Sensing Region Left Vertical Edge", "SS", "1", 0, 0},
    { 0x00189437, "Exposure Control Sensing Region Right Vertical Edge", "SS", "1", 0, 0},
    { 0x00189438, "Exposure Control Sensing Region Upper Horizontal Edge", "SS", "1", 0, 0},
    { 0x00189439, "Exposure Control Sensing Region Lower Horizontal Edge", "SS", "1", 0, 0},
    { 0x00189440, "Center of Circular Exposure Control Sensing Region", "SS", "2", 0, 0},
    { 0x00189441, "Radius of Circular Exposure Control Sensing Region", "US", "1", 0, 0},
    { 0x00189442, "Vertices of the Polygonal Exposure Control Sensing Region", "SS", "2-n", 0, 0},
    { 0x00189445, "", "", "", -1, 0},
    { 0x00189447, "Column Angulation (Patient)", "FL", "1", 0, 0},
    { 0x00189449, "Beam Angle", "FL", "1", 0, 0},
    { 0x00189451, "Frame Detector Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00189452, "Calculated Anatomy Thickness", "FL", "1", 0, 0},
    { 0x00189455, "Calibration Sequence", "SQ", "1", 0, 0},
    { 0x00189456, "Object Thickness Sequence", "SQ", "1", 0, 0},
    { 0x00189457, "Plane Identification", "CS", "1", 0, 0},
    { 0x00189461, "Field of View Dimension(s) in Float", "FL", "1-2", 0, 0},
    { 0x00189462, "Isocenter Reference System Sequence", "SQ", "1", 0, 0},
    { 0x00189463, "Positioner Isocenter Primary Angle", "FL", "1", 0, 0},
    { 0x00189464, "Positioner Isocenter Secondary Angle", "FL", "1", 0, 0},
    { 0x00189465, "Positioner Isocenter Detector Rotation Angle", "FL", "1", 0, 0},
    { 0x00189466, "Table X Position to Isocenter", "FL", "1", 0, 0},
    { 0x00189467, "Table Y Position to Isocenter", "FL", "1", 0, 0},
    { 0x00189468, "Table Z Position to Isocenter", "FL", "1", 0, 0},
    { 0x00189469, "Table Horizontal Rotation Angle", "FL", "1", 0, 0},
    { 0x00189470, "Table Head Tilt Angle", "FL", "1", 0, 0},
    { 0x00189471, "Table Cradle Tilt Angle", "FL", "1", 0, 0},
    { 0x00189472, "Frame Display Shutter Sequence", "SQ", "1", 0, 0},
    { 0x00189473, "Acquired Image Area Dose Product", "FL", "1", 0, 0},
    { 0x00189474, "C-arm Positioner Tabletop Relationship", "CS", "1", 0, 0},
    { 0x00189476, "X-Ray Geometry Sequence", "SQ", "1", 0, 0},
    { 0x00189477, "Irradiation Event Identification Sequence", "SQ", "1", 0, 0},
    { 0x00189504, "X-Ray 3D Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00189506, "Contributing Sources Sequence", "SQ", "1", 0, 0},
    { 0x00189507, "X-Ray 3D Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189508, "Primary Positioner Scan Arc", "FL", "1", 0, 0},
    { 0x00189509, "Secondary Positioner Scan Arc", "FL", "1", 0, 0},
    { 0x00189510, "Primary Positioner Scan Start Angle", "FL", "1", 0, 0},
    { 0x00189511, "Secondary Positioner Scan Start Angle", "FL", "1", 0, 0},
    { 0x00189514, "Primary Positioner Increment", "FL", "1", 0, 0},
    { 0x00189515, "Secondary Positioner Increment", "FL", "1", 0, 0},
    { 0x00189516, "Start Acquisition DateTime", "DT", "1", 0, 0},
    { 0x00189517, "End Acquisition DateTime", "DT", "1", 0, 0},
    { 0x00189518, "Primary Positioner Increment Sign", "SS", "1", 0, 0},
    { 0x00189519, "Secondary Positioner Increment Sign", "SS", "1", 0, 0},
    { 0x00189524, "Application Name", "LO", "1", 0, 0},
    { 0x00189525, "Application Version", "LO", "1", 0, 0},
    { 0x00189526, "Application Manufacturer", "LO", "1", 0, 0},
    { 0x00189527, "Algorithm Type", "CS", "1", 0, 0},
    { 0x00189528, "Algorithm Description", "LO", "1", 0, 0},
    { 0x00189530, "X-Ray 3D Reconstruction Sequence", "SQ", "1", 0, 0},
    { 0x00189531, "Reconstruction Description", "LO", "1", 0, 0},
    { 0x00189538, "Per Projection Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189541, "Detector Position Sequence", "SQ", "1", 0, 0},
    { 0x00189542, "X-Ray Acquisition Dose Sequence", "SQ", "1", 0, 0},
    { 0x00189543, "X-Ray Source Isocenter Primary Angle", "FD", "1", 0, 0},
    { 0x00189544, "X-Ray Source Isocenter Secondary Angle", "FD", "1", 0, 0},
    { 0x00189545, "Breast Support Isocenter Primary Angle", "FD", "1", 0, 0},
    { 0x00189546, "Breast Support Isocenter Secondary Angle", "FD", "1", 0, 0},
    { 0x00189547, "Breast Support X Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189548, "Breast Support Y Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189549, "Breast Support Z Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189550, "Detector Isocenter Primary Angle", "FD", "1", 0, 0},
    { 0x00189551, "Detector Isocenter Secondary Angle", "FD", "1", 0, 0},
    { 0x00189552, "Detector X Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189553, "Detector Y Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189554, "Detector Z Position to Isocenter", "FD", "1", 0, 0},
    { 0x00189555, "X-Ray Grid Sequence", "SQ", "1", 0, 0},
    { 0x00189556, "X-Ray Filter Sequence", "SQ", "1", 0, 0},
    { 0x00189557, "Detector Active Area TLHC Position", "FD", "3", 0, 0},
    { 0x00189558, "Detector Active Area Orientation", "FD", "6", 0, 0},
    { 0x00189559, "Positioner Primary Angle Direction", "CS", "1", 0, 0},
    { 0x00189601, "Diffusion b-matrix Sequence", "SQ", "1", 0, 0},
    { 0x00189602, "Diffusion b-value XX", "FD", "1", 0, 0},
    { 0x00189603, "Diffusion b-value XY", "FD", "1", 0, 0},
    { 0x00189604, "Diffusion b-value XZ", "FD", "1", 0, 0},
    { 0x00189605, "Diffusion b-value YY", "FD", "1", 0, 0},
    { 0x00189606, "Diffusion b-value YZ", "FD", "1", 0, 0},
    { 0x00189607, "Diffusion b-value ZZ", "FD", "1", 0, 0},
    { 0x00189621, "Functional MR Sequence", "SQ", "1", 0, 0},
    { 0x00189622, "Functional Settling Phase Frames Present", "CS", "1", 0, 0},
    { 0x00189623, "Functional Sync Pulse", "DT", "1", 0, 0},
    { 0x00189624, "Settling Phase Frame", "CS", "1", 0, 0},
    { 0x00189701, "Decay Correction DateTime", "DT", "1", 0, 0},
    { 0x00189715, "Start Density Threshold", "FD", "1", 0, 0},
    { 0x00189716, "Start Relative Density Difference Threshold", "FD", "1", 0, 0},
    { 0x00189717, "Start Cardiac Trigger Count Threshold", "FD", "1", 0, 0},
    { 0x00189718, "Start Respiratory Trigger Count Threshold", "FD", "1", 0, 0},
    { 0x00189719, "Termination Counts Threshold", "FD", "1", 0, 0},
    { 0x00189720, "Termination Density Threshold", "FD", "1", 0, 0},
    { 0x00189721, "Termination Relative Density Threshold", "FD", "1", 0, 0},
    { 0x00189722, "Termination Time Threshold", "FD", "1", 0, 0},
    { 0x00189723, "Termination Cardiac Trigger Count Threshold", "FD", "1", 0, 0},
    { 0x00189724, "Termination Respiratory Trigger Count Threshold", "FD", "1", 0, 0},
    { 0x00189725, "Detector Geometry", "CS", "1", 0, 0},
    { 0x00189726, "Transverse Detector Separation", "FD", "1", 0, 0},
    { 0x00189727, "Axial Detector Dimension", "FD", "1", 0, 0},
    { 0x00189729, "Radiopharmaceutical Agent Number", "US", "1", 0, 0},
    { 0x00189732, "PET Frame Acquisition Sequence", "SQ", "1", 0, 0},
    { 0x00189733, "PET Detector Motion Details Sequence", "SQ", "1", 0, 0},
    { 0x00189734, "PET Table Dynamics Sequence", "SQ", "1", 0, 0},
    { 0x00189735, "PET Position Sequence", "SQ", "1", 0, 0},
    { 0x00189736, "PET Frame Correction Factors Sequence", "SQ", "1", 0, 0},
    { 0x00189737, "Radiopharmaceutical Usage Sequence", "SQ", "1", 0, 0},
    { 0x00189738, "Attenuation Correction Source", "CS", "1", 0, 0},
    { 0x00189739, "Number of Iterations", "US", "1", 0, 0},
    { 0x00189740, "Number of Subsets", "US", "1", 0, 0},
    { 0x00189749, "PET Reconstruction Sequence", "SQ", "1", 0, 0},
    { 0x00189751, "PET Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00189755, "Time of Flight Information Used", "CS", "1", 0, 0},
    { 0x00189756, "Reconstruction Type", "CS", "1", 0, 0},
    { 0x00189758, "Decay Corrected", "CS", "1", 0, 0},
    { 0x00189759, "Attenuation Corrected", "CS", "1", 0, 0},
    { 0x00189760, "Scatter Corrected", "CS", "1", 0, 0},
    { 0x00189761, "Dead Time Corrected", "CS", "1", 0, 0},
    { 0x00189762, "Gantry Motion Corrected", "CS", "1", 0, 0},
    { 0x00189763, "Patient Motion Corrected", "CS", "1", 0, 0},
    { 0x00189764, "Count Loss Normalization Corrected", "CS", "1", 0, 0},
    { 0x00189765, "Randoms Corrected", "CS", "1", 0, 0},
    { 0x00189766, "Non-uniform Radial Sampling Corrected", "CS", "1", 0, 0},
    { 0x00189767, "Sensitivity Calibrated", "CS", "1", 0, 0},
    { 0x00189768, "Detector Normalization Correction", "CS", "1", 0, 0},
    { 0x00189769, "Iterative Reconstruction Method", "CS", "1", 0, 0},
    { 0x00189770, "Attenuation Correction Temporal Relationship", "CS", "1", 0, 0},
    { 0x00189771, "Patient Physiological State Sequence", "SQ", "1", 0, 0},
    { 0x00189772, "Patient Physiological State Code Sequence", "SQ", "1", 0, 0},
    { 0x00189801, "Depth(s) of Focus", "FD", "1-n", 0, 0},
    { 0x00189803, "Excluded Intervals Sequence", "SQ", "1", 0, 0},
    { 0x00189804, "Exclusion Start DateTime", "DT", "1", 0, 0},
    { 0x00189805, "Exclusion Duration", "FD", "1", 0, 0},
    { 0x00189806, "US Image Description Sequence", "SQ", "1", 0, 0},
    { 0x00189807, "Image Data Type Sequence", "SQ", "1", 0, 0},
    { 0x00189808, "Data Type", "CS", "1", 0, 0},
    { 0x00189809, "Transducer Scan Pattern Code Sequence", "SQ", "1", 0, 0},
    { 0x0018980B, "Aliased Data Type", "CS", "1", 0, 0},
    { 0x0018980C, "Position Measuring Device Used", "CS", "1", 0, 0},
    { 0x0018980D, "Transducer Geometry Code Sequence", "SQ", "1", 0, 0},
    { 0x0018980E, "Transducer Beam Steering Code Sequence", "SQ", "1", 0, 0},
    { 0x0018980F, "Transducer Application Code Sequence", "SQ", "1", 0, 0},
    { 0x00189810, "Zero Velocity Pixel Value", "US or SS", "1", 0, 0},
    { 0x00189900, "Reference Location Label", "LO", "1", 0, 0},
    { 0x00189901, "Reference Location Description", "UT", "1", 0, 0},
    { 0x00189902, "Reference Basis Code Sequence", "SQ", "1", 0, 0},
    { 0x00189903, "Reference Geometry Code Sequence", "SQ", "1", 0, 0},
    { 0x00189904, "Offset Distance", "DS", "1", 0, 0},
    { 0x00189905, "Offset Direction", "CS", "1", 0, 0},
    { 0x00189906, "Potential Scheduled Protocol Code Sequence", "SQ", "1", 0, 0},
    { 0x00189907, "Potential Requested Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x00189908, "Potential Reasons for Procedure", "UC", "1-n", 0, 0},
    { 0x00189909, "Potential Reasons for Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x0018990A, "Potential Diagnostic Tasks", "UC", "1-n", 0, 0},
    { 0x0018990B, "Contraindications Code Sequence", "SQ", "1", 0, 0},
    { 0x0018990C, "Referenced Defined Protocol Sequence", "SQ", "1", 0, 0},
    { 0x0018990D, "Referenced Performed Protocol Sequence", "SQ", "1", 0, 0},
    { 0x0018990E, "Predecessor Protocol Sequence", "SQ", "1", 0, 0},
    { 0x0018990F, "Protocol Planning Information", "UT", "1", 0, 0},
    { 0x00189910, "Protocol Design Rationale", "UT", "1", 0, 0},
    { 0x00189911, "Patient Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189912, "Model Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189913, "Parameters Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189914, "Instruction Sequence", "SQ", "1", 0, 0},
    { 0x00189915, "Instruction Index", "US", "1", 0, 0},
    { 0x00189916, "Instruction Text", "LO", "1", 0, 0},
    { 0x00189917, "Instruction Description", "UT", "1", 0, 0},
    { 0x00189918, "Instruction Performed Flag", "CS", "1", 0, 0},
    { 0x00189919, "Instruction Performed DateTime", "DT", "1", 0, 0},
    { 0x0018991A, "Instruction Performance Comment", "UT", "1", 0, 0},
    { 0x0018991B, "Patient Positioning Instruction Sequence", "SQ", "1", 0, 0},
    { 0x0018991C, "Positioning Method Code Sequence", "SQ", "1", 0, 0},
    { 0x0018991D, "Positioning Landmark Sequence", "SQ", "1", 0, 0},
    { 0x0018991E, "Target Frame of Reference UID", "UI", "1", 0, 0},
    { 0x0018991F, "Acquisition Protocol Element Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189920, "Acquisition Protocol Element Sequence", "SQ", "1", 0, 0},
    { 0x00189921, "Protocol Element Number", "US", "1", 0, 0},
    { 0x00189922, "Protocol Element Name", "LO", "1", 0, 0},
    { 0x00189923, "Protocol Element Characteristics Summary", "UT", "1", 0, 0},
    { 0x00189924, "Protocol Element Purpose", "UT", "1", 0, 0},
    { 0x00189930, "Acquisition Motion", "CS", "1", 0, 0},
    { 0x00189931, "Acquisition Start Location Sequence", "SQ", "1", 0, 0},
    { 0x00189932, "Acquisition End Location Sequence", "SQ", "1", 0, 0},
    { 0x00189933, "Reconstruction Protocol Element Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189934, "Reconstruction Protocol Element Sequence", "SQ", "1", 0, 0},
    { 0x00189935, "Storage Protocol Element Specification Sequence", "SQ", "1", 0, 0},
    { 0x00189936, "Storage Protocol Element Sequence", "SQ", "1", 0, 0},
    { 0x00189937, "Requested Series Description", "LO", "1", 0, 0},
    { 0x00189938, "Source Acquisition Protocol Element Number", "US", "1-n", 0, 0},
    { 0x00189939, "Source Acquisition Beam Number", "US", "1-n", 0, 0},
    { 0x0018993A, "Source Reconstruction Protocol Element Number", "US", "1-n", 0, 0},
    { 0x0018993B, "Reconstruction Start Location Sequence", "SQ", "1", 0, 0},
    { 0x0018993C, "Reconstruction End Location Sequence", "SQ", "1", 0, 0},
    { 0x0018993D, "Reconstruction Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x0018993E, "Reconstruction Target Center Location Sequence", "SQ", "1", 0, 0},
    { 0x00189941, "Image Filter Description", "UT", "1", 0, 0},
    { 0x00189942, "CTDIvol Notification Trigger", "FD", "1", 0, 0},
    { 0x00189943, "DLP Notification Trigger", "FD", "1", 0, 0},
    { 0x00189944, "Auto KVP Selection Type", "CS", "1", 0, 0},
    { 0x00189945, "Auto KVP Upper Bound", "FD", "1", 0, 0},
    { 0x00189946, "Auto KVP Lower Bound", "FD", "1", 0, 0},
    { 0x00189947, "Protocol Defined Patient Position", "CS", "1", 0, 0},
    { 0x0018A001, "Contributing Equipment Sequence", "SQ", "1", 0, 0},
    { 0x0018A002, "Contribution DateTime", "DT", "1", 0, 0},
    { 0x0018A003, "Contribution Description", "ST", "1", 0, 0},
    { 0x0020000D, "Study Instance UID", "UI", "1", 0, 0},
    { 0x0020000E, "Series Instance UID", "UI", "1", 0, 0},
    { 0x00200010, "Study ID", "SH", "1", 0, 0},
    { 0x00200011, "Series Number", "IS", "1", 0, 0},
    { 0x00200012, "Acquisition Number", "IS", "1", 0, 0},
    { 0x00200013, "Instance Number", "IS", "1", 0, 0},
    { 0x00200014, "Isotope Number", "IS", "1", -1, 0},
    { 0x00200015, "Phase Number", "IS", "1", -1, 0},
    { 0x00200016, "Interval Number", "IS", "1", -1, 0},
    { 0x00200017, "Time Slot Number", "IS", "1", -1, 0},
    { 0x00200018, "Angle Number", "IS", "1", -1, 0},
    { 0x00200019, "Item Number", "IS", "1", 0, 0},
    { 0x00200020, "Patient Orientation", "CS", "2", 0, 0},
    { 0x00200022, "Overlay Number", "IS", "1", -1, 0},
    { 0x00200024, "Curve Number", "IS", "1", -1, 0},
    { 0x00200026, "LUT Number", "IS", "1", -1, 0},
    { 0x00200030, "Image Position", "DS", "3", -1, 0},
    { 0x00200032, "Image Position (Patient)", "DS", "3", 0, 0},
    { 0x00200035, "Image Orientation", "DS", "6", -1, 0},
    { 0x00200037, "Image Orientation (Patient)", "DS", "6", 0, 0},
    { 0x00200050, "Location", "DS", "1", -1, 0},
    { 0x00200052, "Frame of Reference UID", "UI", "1", 0, 0},
    { 0x00200060, "Laterality", "CS", "1", 0, 0},
    { 0x00200062, "Image Laterality", "CS", "1", 0, 0},
    { 0x00200070, "Image Geometry Type", "LO", "1", -1, 0},
    { 0x00200080, "Masking Image", "CS", "1-n", -1, 0},
    { 0x002000AA, "Report Number", "IS", "1", -1, 0},
    { 0x00200100, "Temporal Position Identifier", "IS", "1", 0, 0},
    { 0x00200105, "Number of Temporal Positions", "IS", "1", 0, 0},
    { 0x00200110, "Temporal Resolution", "DS", "1", 0, 0},
    { 0x00200200, "Synchronization Frame of Reference UID", "UI", "1", 0, 0},
    { 0x00200242, "SOP Instance UID of Concatenation Source", "UI", "1", 0, 0},
    { 0x00201000, "Series in Study", "IS", "1", -1, 0},
    { 0x00201001, "Acquisitions in Series", "IS", "1", -1, 0},
    { 0x00201002, "Images in Acquisition", "IS", "1", 0, 0},
    { 0x00201003, "Images in Series", "IS", "1", -1, 0},
    { 0x00201004, "Acquisitions in Study", "IS", "1", -1, 0},
    { 0x00201005, "Images in Study", "IS", "1", -1, 0},
    { 0x00201020, "Reference", "LO", "1-n", -1, 0},
    { 0x0020103F, "Target Position Reference Indicator", "LO", "1", 0, 0},
    { 0x00201040, "Position Reference Indicator", "LO", "1", 0, 0},
    { 0x00201041, "Slice Location", "DS", "1", 0, 0},
    { 0x00201070, "Other Study Numbers", "IS", "1-n", -1, 0},
    { 0x00201200, "Number of Patient Related Studies", "IS", "1", 0, 0},
    { 0x00201202, "Number of Patient Related Series", "IS", "1", 0, 0},
    { 0x00201204, "Number of Patient Related Instances", "IS", "1", 0, 0},
    { 0x00201206, "Number of Study Related Series", "IS", "1", 0, 0},
    { 0x00201208, "Number of Study Related Instances", "IS", "1", 0, 0},
    { 0x00201209, "Number of Series Related Instances", "IS", "1", 0, 0},
    { 0x00203100, "Source Image IDs", "CS", "1-n", -1, 0},
    { 0x00203401, "Modifying Device ID", "CS", "1", -1, 0},
    { 0x00203402, "Modified Image ID", "CS", "1", -1, 0},
    { 0x00203403, "Modified Image Date", "DA", "1", -1, 0},
    { 0x00203404, "Modifying Device Manufacturer", "LO", "1", -1, 0},
    { 0x00203405, "Modified Image Time", "TM", "1", -1, 0},
    { 0x00203406, "Modified Image Description", "LO", "1", -1, 0},
    { 0x00204000, "Image Comments", "LT", "1", 0, 0},
    { 0x00205000, "Original Image Identification", "AT", "1-n", -1, 0},
    { 0x00205002, "Original Image Identification Nomenclature", "LO", "1-n", -1, 0},
    { 0x00209056, "Stack ID", "SH", "1", 0, 0},
    { 0x00209057, "In-Stack Position Number", "UL", "1", 0, 0},
    { 0x00209071, "Frame Anatomy Sequence", "SQ", "1", 0, 0},
    { 0x00209072, "Frame Laterality", "CS", "1", 0, 0},
    { 0x00209111, "Frame Content Sequence", "SQ", "1", 0, 0},
    { 0x00209113, "Plane Position Sequence", "SQ", "1", 0, 0},
    { 0x00209116, "Plane Orientation Sequence", "SQ", "1", 0, 0},
    { 0x00209128, "Temporal Position Index", "UL", "1", 0, 0},
    { 0x00209153, "Nominal Cardiac Trigger Delay Time", "FD", "1", 0, 0},
    { 0x00209154, "Nominal Cardiac Trigger Time Prior To R-Peak", "FL", "1", 0, 0},
    { 0x00209155, "Actual Cardiac Trigger Time Prior To R-Peak", "FL", "1", 0, 0},
    { 0x00209156, "Frame Acquisition Number", "US", "1", 0, 0},
    { 0x00209157, "Dimension Index Values", "UL", "1-n", 0, 0},
    { 0x00209158, "Frame Comments", "LT", "1", 0, 0},
    { 0x00209161, "Concatenation UID", "UI", "1", 0, 0},
    { 0x00209162, "In-concatenation Number", "US", "1", 0, 0},
    { 0x00209163, "In-concatenation Total Number", "US", "1", 0, 0},
    { 0x00209164, "Dimension Organization UID", "UI", "1", 0, 0},
    { 0x00209165, "Dimension Index Pointer", "AT", "1", 0, 0},
    { 0x00209167, "Functional Group Pointer", "AT", "1", 0, 0},
    { 0x00209170, "Unassigned Shared Converted Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00209171, "Unassigned Per-Frame Converted Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00209172, "Conversion Source Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00209213, "Dimension Index Private Creator", "LO", "1", 0, 0},
    { 0x00209221, "Dimension Organization Sequence", "SQ", "1", 0, 0},
    { 0x00209222, "Dimension Index Sequence", "SQ", "1", 0, 0},
    { 0x00209228, "Concatenation Frame Offset Number", "UL", "1", 0, 0},
    { 0x00209238, "Functional Group Private Creator", "LO", "1", 0, 0},
    { 0x00209241, "Nominal Percentage of Cardiac Phase", "FL", "1", 0, 0},
    { 0x00209245, "Nominal Percentage of Respiratory Phase", "FL", "1", 0, 0},
    { 0x00209246, "Starting Respiratory Amplitude", "FL", "1", 0, 0},
    { 0x00209247, "Starting Respiratory Phase", "CS", "1", 0, 0},
    { 0x00209248, "Ending Respiratory Amplitude", "FL", "1", 0, 0},
    { 0x00209249, "Ending Respiratory Phase", "CS", "1", 0, 0},
    { 0x00209250, "Respiratory Trigger Type", "CS", "1", 0, 0},
    { 0x00209251, "R-R Interval Time Nominal", "FD", "1", 0, 0},
    { 0x00209252, "Actual Cardiac Trigger Delay Time", "FD", "1", 0, 0},
    { 0x00209253, "Respiratory Synchronization Sequence", "SQ", "1", 0, 0},
    { 0x00209254, "Respiratory Interval Time", "FD", "1", 0, 0},
    { 0x00209255, "Nominal Respiratory Trigger Delay Time", "FD", "1", 0, 0},
    { 0x00209256, "Respiratory Trigger Delay Threshold", "FD", "1", 0, 0},
    { 0x00209257, "Actual Respiratory Trigger Delay Time", "FD", "1", 0, 0},
    { 0x00209301, "Image Position (Volume)", "FD", "3", 0, 0},
    { 0x00209302, "Image Orientation (Volume)", "FD", "6", 0, 0},
    { 0x00209307, "Ultrasound Acquisition Geometry", "CS", "1", 0, 0},
    { 0x00209308, "Apex Position", "FD", "3", 0, 0},
    { 0x00209309, "Volume to Transducer Mapping Matrix", "FD", "16", 0, 0},
    { 0x0020930A, "Volume to Table Mapping Matrix", "FD", "16", 0, 0},
    { 0x0020930B, "Volume to Transducer Relationship", "CS", "1", 0, 0},
    { 0x0020930C, "Patient Frame of Reference Source", "CS", "1", 0, 0},
    { 0x0020930D, "Temporal Position Time Offset", "FD", "1", 0, 0},
    { 0x0020930E, "Plane Position (Volume) Sequence", "SQ", "1", 0, 0},
    { 0x0020930F, "Plane Orientation (Volume) Sequence", "SQ", "1", 0, 0},
    { 0x00209310, "Temporal Position Sequence", "SQ", "1", 0, 0},
    { 0x00209311, "Dimension Organization Type", "CS", "1", 0, 0},
    { 0x00209312, "Volume Frame of Reference UID", "UI", "1", 0, 0},
    { 0x00209313, "Table Frame of Reference UID", "UI", "1", 0, 0},
    { 0x00209421, "Dimension Description Label", "LO", "1", 0, 0},
    { 0x00209450, "Patient Orientation in Frame Sequence", "SQ", "1", 0, 0},
    { 0x00209453, "Frame Label", "LO", "1", 0, 0},
    { 0x00209518, "Acquisition Index", "US", "1-n", 0, 0},
    { 0x00209529, "Contributing SOP Instances Reference Sequence", "SQ", "1", 0, 0},
    { 0x00209536, "Reconstruction Index", "US", "1", 0, 0},
    { 0x00220001, "Light Path Filter Pass-Through Wavelength", "US", "1", 0, 0},
    { 0x00220002, "Light Path Filter Pass Band", "US", "2", 0, 0},
    { 0x00220003, "Image Path Filter Pass-Through Wavelength", "US", "1", 0, 0},
    { 0x00220004, "Image Path Filter Pass Band", "US", "2", 0, 0},
    { 0x00220005, "Patient Eye Movement Commanded", "CS", "1", 0, 0},
    { 0x00220006, "Patient Eye Movement Command Code Sequence", "SQ", "1", 0, 0},
    { 0x00220007, "Spherical Lens Power", "FL", "1", 0, 0},
    { 0x00220008, "Cylinder Lens Power", "FL", "1", 0, 0},
    { 0x00220009, "Cylinder Axis", "FL", "1", 0, 0},
    { 0x0022000A, "Emmetropic Magnification", "FL", "1", 0, 0},
    { 0x0022000B, "Intra Ocular Pressure", "FL", "1", 0, 0},
    { 0x0022000C, "Horizontal Field of View", "FL", "1", 0, 0},
    { 0x0022000D, "Pupil Dilated", "CS", "1", 0, 0},
    { 0x0022000E, "Degree of Dilation", "FL", "1", 0, 0},
    { 0x00220010, "Stereo Baseline Angle", "FL", "1", 0, 0},
    { 0x00220011, "Stereo Baseline Displacement", "FL", "1", 0, 0},
    { 0x00220012, "Stereo Horizontal Pixel Offset", "FL", "1", 0, 0},
    { 0x00220013, "Stereo Vertical Pixel Offset", "FL", "1", 0, 0},
    { 0x00220014, "Stereo Rotation", "FL", "1", 0, 0},
    { 0x00220015, "Acquisition Device Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00220016, "Illumination Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00220017, "Light Path Filter Type Stack Code Sequence", "SQ", "1", 0, 0},
    { 0x00220018, "Image Path Filter Type Stack Code Sequence", "SQ", "1", 0, 0},
    { 0x00220019, "Lenses Code Sequence", "SQ", "1", 0, 0},
    { 0x0022001A, "Channel Description Code Sequence", "SQ", "1", 0, 0},
    { 0x0022001B, "Refractive State Sequence", "SQ", "1", 0, 0},
    { 0x0022001C, "Mydriatic Agent Code Sequence", "SQ", "1", 0, 0},
    { 0x0022001D, "Relative Image Position Code Sequence", "SQ", "1", 0, 0},
    { 0x0022001E, "Camera Angle of View", "FL", "1", 0, 0},
    { 0x00220020, "Stereo Pairs Sequence", "SQ", "1", 0, 0},
    { 0x00220021, "Left Image Sequence", "SQ", "1", 0, 0},
    { 0x00220022, "Right Image Sequence", "SQ", "1", 0, 0},
    { 0x00220028, "Stereo Pairs Present", "CS", "1", 0, 0},
    { 0x00220030, "Axial Length of the Eye", "FL", "1", 0, 0},
    { 0x00220031, "Ophthalmic Frame Location Sequence", "SQ", "1", 0, 0},
    { 0x00220032, "Reference Coordinates", "FL", "2-2n", 0, 0},
    { 0x00220035, "Depth Spatial Resolution", "FL", "1", 0, 0},
    { 0x00220036, "Maximum Depth Distortion", "FL", "1", 0, 0},
    { 0x00220037, "Along-scan Spatial Resolution", "FL", "1", 0, 0},
    { 0x00220038, "Maximum Along-scan Distortion", "FL", "1", 0, 0},
    { 0x00220039, "Ophthalmic Image Orientation", "CS", "1", 0, 0},
    { 0x00220041, "Depth of Transverse Image", "FL", "1", 0, 0},
    { 0x00220042, "Mydriatic Agent Concentration Units Sequence", "SQ", "1", 0, 0},
    { 0x00220048, "Across-scan Spatial Resolution", "FL", "1", 0, 0},
    { 0x00220049, "Maximum Across-scan Distortion", "FL", "1", 0, 0},
    { 0x0022004E, "Mydriatic Agent Concentration", "DS", "1", 0, 0},
    { 0x00220055, "Illumination Wave Length", "FL", "1", 0, 0},
    { 0x00220056, "Illumination Power", "FL", "1", 0, 0},
    { 0x00220057, "Illumination Bandwidth", "FL", "1", 0, 0},
    { 0x00220058, "Mydriatic Agent Sequence", "SQ", "1", 0, 0},
    { 0x00221007, "Ophthalmic Axial Measurements Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00221008, "Ophthalmic Axial Measurements Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00221009, "Ophthalmic Axial Measurements Device Type", "CS", "1", 0, 0},
    { 0x00221010, "Ophthalmic Axial Length Measurements Type", "CS", "1", 0, 0},
    { 0x00221012, "Ophthalmic Axial Length Sequence", "SQ", "1", 0, 0},
    { 0x00221019, "Ophthalmic Axial Length", "FL", "1", 0, 0},
    { 0x00221024, "Lens Status Code Sequence", "SQ", "1", 0, 0},
    { 0x00221025, "Vitreous Status Code Sequence", "SQ", "1", 0, 0},
    { 0x00221028, "IOL Formula Code Sequence", "SQ", "1", 0, 0},
    { 0x00221029, "IOL Formula Detail", "LO", "1", 0, 0},
    { 0x00221033, "Keratometer Index", "FL", "1", 0, 0},
    { 0x00221035, "Source of Ophthalmic Axial Length Code Sequence", "SQ", "1", 0, 0},
    { 0x00221036, "Source of Corneal Size Data Code Sequence", "SQ", "1", 0, 0},
    { 0x00221037, "Target Refraction", "FL", "1", 0, 0},
    { 0x00221039, "Refractive Procedure Occurred", "CS", "1", 0, 0},
    { 0x00221040, "Refractive Surgery Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00221044, "Ophthalmic Ultrasound Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00221045, "Surgically Induced Astigmatism Sequence", "SQ", "1", 0, 0},
    { 0x00221046, "Type of Optical Correction", "CS", "1", 0, 0},
    { 0x00221047, "Toric IOL Power Sequence", "SQ", "1", 0, 0},
    { 0x00221048, "Predicted Toric Error Sequence", "SQ", "1", 0, 0},
    { 0x00221049, "Pre-Selected for Implantation", "CS", "1", 0, 0},
    { 0x0022104A, "Toric IOL Power for Exact Emmetropia Sequence", "SQ", "1", 0, 0},
    { 0x0022104B, "Toric IOL Power for Exact Target Refraction Sequence", "SQ", "1", 0, 0},
    { 0x00221050, "Ophthalmic Axial Length Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00221053, "IOL Power", "FL", "1", 0, 0},
    { 0x00221054, "Predicted Refractive Error", "FL", "1", 0, 0},
    { 0x00221059, "Ophthalmic Axial Length Velocity", "FL", "1", 0, 0},
    { 0x00221065, "Lens Status Description", "LO", "1", 0, 0},
    { 0x00221066, "Vitreous Status Description", "LO", "1", 0, 0},
    { 0x00221090, "IOL Power Sequence", "SQ", "1", 0, 0},
    { 0x00221092, "Lens Constant Sequence", "SQ", "1", 0, 0},
    { 0x00221093, "IOL Manufacturer", "LO", "1", 0, 0},
    { 0x00221094, "Lens Constant Description", "LO", "1", -1, 0},
    { 0x00221095, "Implant Name", "LO", "1", 0, 0},
    { 0x00221096, "Keratometry Measurement Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00221097, "Implant Part Number", "LO", "1", 0, 0},
    { 0x00221100, "Referenced Ophthalmic Axial Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00221101, "Ophthalmic Axial Length Measurements Segment Name Code Sequence", "SQ", "1", 0, 0},
    { 0x00221103, "Refractive Error Before Refractive Surgery Code Sequence", "SQ", "1", 0, 0},
    { 0x00221121, "IOL Power For Exact Emmetropia", "FL", "1", 0, 0},
    { 0x00221122, "IOL Power For Exact Target Refraction", "FL", "1", 0, 0},
    { 0x00221125, "Anterior Chamber Depth Definition Code Sequence", "SQ", "1", 0, 0},
    { 0x00221127, "Lens Thickness Sequence", "SQ", "1", 0, 0},
    { 0x00221128, "Anterior Chamber Depth Sequence", "SQ", "1", 0, 0},
    { 0x0022112A, "Calculation Comment Sequence", "SQ", "1", 0, 0},
    { 0x0022112B, "Calculation Comment Type", "CS", "1", 0, 0},
    { 0x0022112C, "Calculation Comment", "LT", "1", 0, 0},
    { 0x00221130, "Lens Thickness", "FL", "1", 0, 0},
    { 0x00221131, "Anterior Chamber Depth", "FL", "1", 0, 0},
    { 0x00221132, "Source of Lens Thickness Data Code Sequence", "SQ", "1", 0, 0},
    { 0x00221133, "Source of Anterior Chamber Depth Data Code Sequence", "SQ", "1", 0, 0},
    { 0x00221134, "Source of Refractive Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00221135, "Source of Refractive Measurements Code Sequence", "SQ", "1", 0, 0},
    { 0x00221140, "Ophthalmic Axial Length Measurement Modified", "CS", "1", 0, 0},
    { 0x00221150, "Ophthalmic Axial Length Data Source Code Sequence", "SQ", "1", 0, 0},
    { 0x00221153, "Ophthalmic Axial Length Acquisition Method Code Sequence", "SQ", "1", -1, 0},
    { 0x00221155, "Signal to Noise Ratio", "FL", "1", 0, 0},
    { 0x00221159, "Ophthalmic Axial Length Data Source Description", "LO", "1", 0, 0},
    { 0x00221210, "Ophthalmic Axial Length Measurements Total Length Sequence", "SQ", "1", 0, 0},
    { 0x00221211, "Ophthalmic Axial Length Measurements Segmental Length Sequence", "SQ", "1", 0, 0},
    { 0x00221212, "Ophthalmic Axial Length Measurements Length Summation Sequence", "SQ", "1", 0, 0},
    { 0x00221220, "Ultrasound Ophthalmic Axial Length Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00221225, "Optical Ophthalmic Axial Length Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00221230, "Ultrasound Selected Ophthalmic Axial Length Sequence", "SQ", "1", 0, 0},
    { 0x00221250, "Ophthalmic Axial Length Selection Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00221255, "Optical Selected Ophthalmic Axial Length Sequence", "SQ", "1", 0, 0},
    { 0x00221257, "Selected Segmental Ophthalmic Axial Length Sequence", "SQ", "1", 0, 0},
    { 0x00221260, "Selected Total Ophthalmic Axial Length Sequence", "SQ", "1", 0, 0},
    { 0x00221262, "Ophthalmic Axial Length Quality Metric Sequence", "SQ", "1", 0, 0},
    { 0x00221265, "Ophthalmic Axial Length Quality Metric Type Code Sequence", "SQ", "1", -1, 0},
    { 0x00221273, "Ophthalmic Axial Length Quality Metric Type Description", "LO", "1", -1, 0},
    { 0x00221300, "Intraocular Lens Calculations Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00221310, "Intraocular Lens Calculations Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00221330, "Referenced Ophthalmic Axial Length Measurement QC Image Sequence", "SQ", "1", 0, 0},
    { 0x00221415, "Ophthalmic Mapping Device Type", "CS", "1", 0, 0},
    { 0x00221420, "Acquisition Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00221423, "Acquisition Method Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x00221436, "Ophthalmic Thickness Map Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00221443, "Ophthalmic Thickness Mapping Normals Sequence", "SQ", "1", 0, 0},
    { 0x00221445, "Retinal Thickness Definition Code Sequence", "SQ", "1", 0, 0},
    { 0x00221450, "Pixel Value Mapping to Coded Concept Sequence", "SQ", "1", 0, 0},
    { 0x00221452, "Mapped Pixel Value", "US or SS", "1", 0, 0},
    { 0x00221454, "Pixel Value Mapping Explanation", "LO", "1", 0, 0},
    { 0x00221458, "Ophthalmic Thickness Map Quality Threshold Sequence", "SQ", "1", 0, 0},
    { 0x00221460, "Ophthalmic Thickness Map Threshold Quality Rating", "FL", "1", 0, 0},
    { 0x00221463, "Anatomic Structure Reference Point", "FL", "2", 0, 0},
    { 0x00221465, "Registration to Localizer Sequence", "SQ", "1", 0, 0},
    { 0x00221466, "Registered Localizer Units", "CS", "1", 0, 0},
    { 0x00221467, "Registered Localizer Top Left Hand Corner", "FL", "2", 0, 0},
    { 0x00221468, "Registered Localizer Bottom Right Hand Corner", "FL", "2", 0, 0},
    { 0x00221470, "Ophthalmic Thickness Map Quality Rating Sequence", "SQ", "1", 0, 0},
    { 0x00221472, "Relevant OPT Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00221512, "Transformation Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00221513, "Transformation Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x00221515, "Ophthalmic Axial Length Method", "CS", "1", 0, 0},
    { 0x00221517, "Ophthalmic FOV", "FL", "1", 0, 0},
    { 0x00221518, "Two Dimensional to Three Dimensional Map Sequence", "SQ", "1", 0, 0},
    { 0x00221525, "Wide Field Ophthalmic Photography Quality Rating Sequence", "SQ", "1", 0, 0},
    { 0x00221526, "Wide Field Ophthalmic Photography Quality Threshold Sequence", "SQ", "1", 0, 0},
    { 0x00221527, "Wide Field Ophthalmic Photography Threshold Quality Rating", "FL", "1", 0, 0},
    { 0x00221528, "X Coordinates Center Pixel View Angle", "FL", "1", 0, 0},
    { 0x00221529, "Y Coordinates Center Pixel View Angle", "FL", "1", 0, 0},
    { 0x00221530, "Number of Map Points", "UL", "1", 0, 0},
    { 0x00221531, "Two Dimensional to Three Dimensional Map Data", "OF", "1", 0, 0},
    { 0x00221612, "Derivation Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x00221615, "Ophthalmic Image Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00221616, "Ophthalmic Image Type Description", "LO", "1", 0, 0},
    { 0x00221618, "Scan Pattern Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00221620, "Referenced Surface Mesh Identification Sequence", "SQ", "1", 0, 0},
    { 0x00221622, "Ophthalmic Volumetric Properties Flag", "CS", "1", 0, 0},
    { 0x00221624, "Ophthalmic Anatomic Reference Point X-Coordinate", "FL", "1", 0, 0},
    { 0x00221626, "Ophthalmic Anatomic Reference Point Y-Coordinate", "FL", "1", 0, 0},
    { 0x00221628, "Ophthalmic En Face Image Quality Rating Sequence", "SQ", "1", 0, 0},
    { 0x00221630, "Quality Threshold", "DS", "1", 0, 0},
    { 0x00221640, "OCT B-scan Analysis Acquisition Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00221642, "Number of B-scans Per Frame", "UL", "1", 0, 0},
    { 0x00221643, "B-scan Slab Thickness", "FL", "1", 0, 0},
    { 0x00221644, "Distance Between B-scan Slabs", "FL", "1", 0, 0},
    { 0x00221645, "B-scan Cycle Time", "FL", "1", 0, 0},
    { 0x00221646, "B-scan Cycle Time Vector", "FL", "1-n", 0, 0},
    { 0x00221649, "A-scan Rate", "FL", "1", 0, 0},
    { 0x00221650, "B-scan Rate", "FL", "1", 0, 0},
    { 0x00221658, "Surface Mesh Z-Pixel Offset", "UL", "1", 0, 0},
    { 0x00240010, "Visual Field Horizontal Extent", "FL", "1", 0, 0},
    { 0x00240011, "Visual Field Vertical Extent", "FL", "1", 0, 0},
    { 0x00240012, "Visual Field Shape", "CS", "1", 0, 0},
    { 0x00240016, "Screening Test Mode Code Sequence", "SQ", "1", 0, 0},
    { 0x00240018, "Maximum Stimulus Luminance", "FL", "1", 0, 0},
    { 0x00240020, "Background Luminance", "FL", "1", 0, 0},
    { 0x00240021, "Stimulus Color Code Sequence", "SQ", "1", 0, 0},
    { 0x00240024, "Background Illumination Color Code Sequence", "SQ", "1", 0, 0},
    { 0x00240025, "Stimulus Area", "FL", "1", 0, 0},
    { 0x00240028, "Stimulus Presentation Time", "FL", "1", 0, 0},
    { 0x00240032, "Fixation Sequence", "SQ", "1", 0, 0},
    { 0x00240033, "Fixation Monitoring Code Sequence", "SQ", "1", 0, 0},
    { 0x00240034, "Visual Field Catch Trial Sequence", "SQ", "1", 0, 0},
    { 0x00240035, "Fixation Checked Quantity", "US", "1", 0, 0},
    { 0x00240036, "Patient Not Properly Fixated Quantity", "US", "1", 0, 0},
    { 0x00240037, "Presented Visual Stimuli Data Flag", "CS", "1", 0, 0},
    { 0x00240038, "Number of Visual Stimuli", "US", "1", 0, 0},
    { 0x00240039, "Excessive Fixation Losses Data Flag", "CS", "1", 0, 0},
    { 0x00240040, "Excessive Fixation Losses", "CS", "1", 0, 0},
    { 0x00240042, "Stimuli Retesting Quantity", "US", "1", 0, 0},
    { 0x00240044, "Comments on Patient's Performance of Visual Field", "LT", "1", 0, 0},
    { 0x00240045, "False Negatives Estimate Flag", "CS", "1", 0, 0},
    { 0x00240046, "False Negatives Estimate", "FL", "1", 0, 0},
    { 0x00240048, "Negative Catch Trials Quantity", "US", "1", 0, 0},
    { 0x00240050, "False Negatives Quantity", "US", "1", 0, 0},
    { 0x00240051, "Excessive False Negatives Data Flag", "CS", "1", 0, 0},
    { 0x00240052, "Excessive False Negatives", "CS", "1", 0, 0},
    { 0x00240053, "False Positives Estimate Flag", "CS", "1", 0, 0},
    { 0x00240054, "False Positives Estimate", "FL", "1", 0, 0},
    { 0x00240055, "Catch Trials Data Flag", "CS", "1", 0, 0},
    { 0x00240056, "Positive Catch Trials Quantity", "US", "1", 0, 0},
    { 0x00240057, "Test Point Normals Data Flag", "CS", "1", 0, 0},
    { 0x00240058, "Test Point Normals Sequence", "SQ", "1", 0, 0},
    { 0x00240059, "Global Deviation Probability Normals Flag", "CS", "1", 0, 0},
    { 0x00240060, "False Positives Quantity", "US", "1", 0, 0},
    { 0x00240061, "Excessive False Positives Data Flag", "CS", "1", 0, 0},
    { 0x00240062, "Excessive False Positives", "CS", "1", 0, 0},
    { 0x00240063, "Visual Field Test Normals Flag", "CS", "1", 0, 0},
    { 0x00240064, "Results Normals Sequence", "SQ", "1", 0, 0},
    { 0x00240065, "Age Corrected Sensitivity Deviation Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x00240066, "Global Deviation From Normal", "FL", "1", 0, 0},
    { 0x00240067, "Generalized Defect Sensitivity Deviation Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x00240068, "Localized Deviation From Normal", "FL", "1", 0, 0},
    { 0x00240069, "Patient Reliability Indicator", "LO", "1", 0, 0},
    { 0x00240070, "Visual Field Mean Sensitivity", "FL", "1", 0, 0},
    { 0x00240071, "Global Deviation Probability", "FL", "1", 0, 0},
    { 0x00240072, "Local Deviation Probability Normals Flag", "CS", "1", 0, 0},
    { 0x00240073, "Localized Deviation Probability", "FL", "1", 0, 0},
    { 0x00240074, "Short Term Fluctuation Calculated", "CS", "1", 0, 0},
    { 0x00240075, "Short Term Fluctuation", "FL", "1", 0, 0},
    { 0x00240076, "Short Term Fluctuation Probability Calculated", "CS", "1", 0, 0},
    { 0x00240077, "Short Term Fluctuation Probability", "FL", "1", 0, 0},
    { 0x00240078, "Corrected Localized Deviation From Normal Calculated", "CS", "1", 0, 0},
    { 0x00240079, "Corrected Localized Deviation From Normal", "FL", "1", 0, 0},
    { 0x00240080, "Corrected Localized Deviation From Normal Probability Calculated", "CS", "1", 0, 0},
    { 0x00240081, "Corrected Localized Deviation From Normal Probability", "FL", "1", 0, 0},
    { 0x00240083, "Global Deviation Probability Sequence", "SQ", "1", 0, 0},
    { 0x00240085, "Localized Deviation Probability Sequence", "SQ", "1", 0, 0},
    { 0x00240086, "Foveal Sensitivity Measured", "CS", "1", 0, 0},
    { 0x00240087, "Foveal Sensitivity", "FL", "1", 0, 0},
    { 0x00240088, "Visual Field Test Duration", "FL", "1", 0, 0},
    { 0x00240089, "Visual Field Test Point Sequence", "SQ", "1", 0, 0},
    { 0x00240090, "Visual Field Test Point X-Coordinate", "FL", "1", 0, 0},
    { 0x00240091, "Visual Field Test Point Y-Coordinate", "FL", "1", 0, 0},
    { 0x00240092, "Age Corrected Sensitivity Deviation Value", "FL", "1", 0, 0},
    { 0x00240093, "Stimulus Results", "CS", "1", 0, 0},
    { 0x00240094, "Sensitivity Value", "FL", "1", 0, 0},
    { 0x00240095, "Retest Stimulus Seen", "CS", "1", 0, 0},
    { 0x00240096, "Retest Sensitivity Value", "FL", "1", 0, 0},
    { 0x00240097, "Visual Field Test Point Normals Sequence", "SQ", "1", 0, 0},
    { 0x00240098, "Quantified Defect", "FL", "1", 0, 0},
    { 0x00240100, "Age Corrected Sensitivity Deviation Probability Value", "FL", "1", 0, 0},
    { 0x00240102, "Generalized Defect Corrected Sensitivity Deviation Flag", "CS", "1", 0, 0},
    { 0x00240103, "Generalized Defect Corrected Sensitivity Deviation Value", "FL", "1", 0, 0},
    { 0x00240104, "Generalized Defect Corrected Sensitivity Deviation Probability Value", "FL", "1", 0, 0},
    { 0x00240105, "Minimum Sensitivity Value", "FL", "1", 0, 0},
    { 0x00240106, "Blind Spot Localized", "CS", "1", 0, 0},
    { 0x00240107, "Blind Spot X-Coordinate", "FL", "1", 0, 0},
    { 0x00240108, "Blind Spot Y-Coordinate", "FL", "1", 0, 0},
    { 0x00240110, "Visual Acuity Measurement Sequence", "SQ", "1", 0, 0},
    { 0x00240112, "Refractive Parameters Used on Patient Sequence", "SQ", "1", 0, 0},
    { 0x00240113, "Measurement Laterality", "CS", "1", 0, 0},
    { 0x00240114, "Ophthalmic Patient Clinical Information Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00240115, "Ophthalmic Patient Clinical Information Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00240117, "Foveal Point Normative Data Flag", "CS", "1", 0, 0},
    { 0x00240118, "Foveal Point Probability Value", "FL", "1", 0, 0},
    { 0x00240120, "Screening Baseline Measured", "CS", "1", 0, 0},
    { 0x00240122, "Screening Baseline Measured Sequence", "SQ", "1", 0, 0},
    { 0x00240124, "Screening Baseline Type", "CS", "1", 0, 0},
    { 0x00240126, "Screening Baseline Value", "FL", "1", 0, 0},
    { 0x00240202, "Algorithm Source", "LO", "1", 0, 0},
    { 0x00240306, "Data Set Name", "LO", "1", 0, 0},
    { 0x00240307, "Data Set Version", "LO", "1", 0, 0},
    { 0x00240308, "Data Set Source", "LO", "1", 0, 0},
    { 0x00240309, "Data Set Description", "LO", "1", 0, 0},
    { 0x00240317, "Visual Field Test Reliability Global Index Sequence", "SQ", "1", 0, 0},
    { 0x00240320, "Visual Field Global Results Index Sequence", "SQ", "1", 0, 0},
    { 0x00240325, "Data Observation Sequence", "SQ", "1", 0, 0},
    { 0x00240338, "Index Normals Flag", "CS", "1", 0, 0},
    { 0x00240341, "Index Probability", "FL", "1", 0, 0},
    { 0x00240344, "Index Probability Sequence", "SQ", "1", 0, 0},
    { 0x00280002, "Samples per Pixel", "US", "1", 0, 0},
    { 0x00280003, "Samples per Pixel Used", "US", "1", 0, 0},
    { 0x00280004, "Photometric Interpretation", "CS", "1", 0, 0},
    { 0x00280005, "Image Dimensions", "US", "1", -1, 0},
    { 0x00280006, "Planar Configuration", "US", "1", 0, 0},
    { 0x00280008, "Number of Frames", "IS", "1", 0, 0},
    { 0x00280009, "Frame Increment Pointer", "AT", "1-n", 0, 0},
    { 0x0028000A, "Frame Dimension Pointer", "AT", "1-n", 0, 0},
    { 0x00280010, "Rows", "US", "1", 0, 0},
    { 0x00280011, "Columns", "US", "1", 0, 0},
    { 0x00280012, "Planes", "US", "1", -1, 0},
    { 0x00280014, "Ultrasound Color Data Present", "US", "1", 0, 0},
    { 0x00280020, "", "", "", -1, 0},
    { 0x00280030, "Pixel Spacing", "DS", "2", 0, 0},
    { 0x00280031, "Zoom Factor", "DS", "2", 0, 0},
    { 0x00280032, "Zoom Center", "DS", "2", 0, 0},
    { 0x00280034, "Pixel Aspect Ratio", "IS", "2", 0, 0},
    { 0x00280040, "Image Format", "CS", "1", -1, 0},
    { 0x00280050, "Manipulated Image", "LO", "1-n", -1, 0},
    { 0x00280051, "Corrected Image", "CS", "1-n", 0, 0},
    { 0x0028005F, "Compression Recognition Code", "LO", "1", -1, 0},
    { 0x00280060, "Compression Code", "CS", "1", -1, 0},
    { 0x00280061, "Compression Originator", "SH", "1", -1, 0},
    { 0x00280062, "Compression Label", "LO", "1", -1, 0},
    { 0x00280063, "Compression Description", "SH", "1", -1, 0},
    { 0x00280065, "Compression Sequence", "CS", "1-n", -1, 0},
    { 0x00280066, "Compression Step Pointers", "AT", "1-n", -1, 0},
    { 0x00280068, "Repeat Interval", "US", "1", -1, 0},
    { 0x00280069, "Bits Grouped", "US", "1", -1, 0},
    { 0x00280070, "Perimeter Table", "US", "1-n", -1, 0},
    { 0x00280071, "Perimeter Value", "US or SS", "1", -1, 0},
    { 0x00280080, "Predictor Rows", "US", "1", -1, 0},
    { 0x00280081, "Predictor Columns", "US", "1", -1, 0},
    { 0x00280082, "Predictor Constants", "US", "1-n", -1, 0},
    { 0x00280090, "Blocked Pixels", "CS", "1", -1, 0},
    { 0x00280091, "Block Rows", "US", "1", -1, 0},
    { 0x00280092, "Block Columns", "US", "1", -1, 0},
    { 0x00280093, "Row Overlap", "US", "1", -1, 0},
    { 0x00280094, "Column Overlap", "US", "1", -1, 0},
    { 0x00280100, "Bits Allocated", "US", "1", 0, 0},
    { 0x00280101, "Bits Stored", "US", "1", 0, 0},
    { 0x00280102, "High Bit", "US", "1", 0, 0},
    { 0x00280103, "Pixel Representation", "US", "1", 0, 0},
    { 0x00280104, "Smallest Valid Pixel Value", "US or SS", "1", -1, 0},
    { 0x00280105, "Largest Valid Pixel Value", "US or SS", "1", -1, 0},
    { 0x00280106, "Smallest Image Pixel Value", "US or SS", "1", 0, 0},
    { 0x00280107, "Largest Image Pixel Value", "US or SS", "1", 0, 0},
    { 0x00280108, "Smallest Pixel Value in Series", "US or SS", "1", 0, 0},
    { 0x00280109, "Largest Pixel Value in Series", "US or SS", "1", 0, 0},
    { 0x00280110, "Smallest Image Pixel Value in Plane", "US or SS", "1", -1, 0},
    { 0x00280111, "Largest Image Pixel Value in Plane", "US or SS", "1", -1, 0},
    { 0x00280120, "Pixel Padding Value", "US or SS", "1", 0, 0},
    { 0x00280121, "Pixel Padding Range Limit", "US or SS", "1", 0, 0},
    { 0x00280122, "Float Pixel Padding Value", "FL", "1", 0, 0},
    { 0x00280123, "Double Float Pixel Padding Value", "FD", "1", 0, 0},
    { 0x00280124, "Float Pixel Padding Range Limit", "FL", "1", 0, 0},
    { 0x00280125, "Double Float Pixel Padding Range Limit", "FD", "1", 0, 0},
    { 0x00280200, "Image Location", "US", "1", -1, 0},
    { 0x00280300, "Quality Control Image", "CS", "1", 0, 0},
    { 0x00280301, "Burned In Annotation", "CS", "1", 0, 0},
    { 0x00280302, "Recognizable Visual Features", "CS", "1", 0, 0},
    { 0x00280303, "Longitudinal Temporal Information Modified", "CS", "1", 0, 0},
    { 0x00280304, "Referenced Color Palette Instance UID", "UI", "1", 0, 0},
    { 0x00280400, "Transform Label", "LO", "1", -1, 0},
    { 0x00280401, "Transform Version Number", "LO", "1", -1, 0},
    { 0x00280402, "Number of Transform Steps", "US", "1", -1, 0},
    { 0x00280403, "Sequence of Compressed Data", "LO", "1-n", -1, 0},
    { 0x00280404, "Details of Coefficients", "AT", "1-n", -1, 0},
    { 0x00280400, "Rows For Nth Order Coefficients", "US", "1", -1, 0},
    { 0x00280401, "Columns For Nth Order Coefficients", "US", "1", -1, 0},
    { 0x00280402, "Coefficient Coding", "LO", "1-n", -1, 0},
    { 0x00280403, "Coefficient Coding Pointers", "AT", "1-n", -1, 0},
    { 0x00280700, "DCT Label", "LO", "1", -1, 0},
    { 0x00280701, "Data Block Description", "CS", "1-n", -1, 0},
    { 0x00280702, "Data Block", "AT", "1-n", -1, 0},
    { 0x00280710, "Normalization Factor Format", "US", "1", -1, 0},
    { 0x00280720, "Zonal Map Number Format", "US", "1", -1, 0},
    { 0x00280721, "Zonal Map Location", "AT", "1-n", -1, 0},
    { 0x00280722, "Zonal Map Format", "US", "1", -1, 0},
    { 0x00280730, "Adaptive Map Format", "US", "1", -1, 0},
    { 0x00280740, "Code Number Format", "US", "1", -1, 0},
    { 0x00280800, "Code Label", "CS", "1-n", -1, 0},
    { 0x00280802, "Number of Tables", "US", "1", -1, 0},
    { 0x00280803, "Code Table Location", "AT", "1-n", -1, 0},
    { 0x00280804, "Bits For Code Word", "US", "1", -1, 0},
    { 0x00280808, "Image Data Location", "AT", "1-n", -1, 0},
    { 0x00280A02, "Pixel Spacing Calibration Type", "CS", "1", 0, 0},
    { 0x00280A04, "Pixel Spacing Calibration Description", "LO", "1", 0, 0},
    { 0x00281040, "Pixel Intensity Relationship", "CS", "1", 0, 0},
    { 0x00281041, "Pixel Intensity Relationship Sign", "SS", "1", 0, 0},
    { 0x00281050, "Window Center", "DS", "1-n", 0, 0},
    { 0x00281051, "Window Width", "DS", "1-n", 0, 0},
    { 0x00281052, "Rescale Intercept", "DS", "1", 0, 0},
    { 0x00281053, "Rescale Slope", "DS", "1", 0, 0},
    { 0x00281054, "Rescale Type", "LO", "1", 0, 0},
    { 0x00281055, "Window Center & Width Explanation", "LO", "1-n", 0, 0},
    { 0x00281056, "VOI LUT Function", "CS", "1", 0, 0},
    { 0x00281080, "Gray Scale", "CS", "1", -1, 0},
    { 0x00281090, "Recommended Viewing Mode", "CS", "1", 0, 0},
    { 0x00281100, "Gray Lookup Table Descriptor", "US or SS", "3", -1, 0},
    { 0x00281101, "Red Palette Color Lookup Table Descriptor", "US or SS", "3", 0, 0},
    { 0x00281102, "Green Palette Color Lookup Table Descriptor", "US or SS", "3", 0, 0},
    { 0x00281103, "Blue Palette Color Lookup Table Descriptor", "US or SS", "3", 0, 0},
    { 0x00281104, "Alpha Palette Color Lookup Table Descriptor", "US", "3", 0, 0},
    { 0x00281111, "Large Red Palette Color Lookup Table Descriptor", "US or SS", "4", -1, 0},
    { 0x00281112, "Large Green Palette Color Lookup Table Descriptor", "US or SS", "4", -1, 0},
    { 0x00281113, "Large Blue Palette Color Lookup Table Descriptor", "US or SS", "4", -1, 0},
    { 0x00281199, "Palette Color Lookup Table UID", "UI", "1", 0, 0},
    { 0x00281200, "Gray Lookup Table Data", "US or SS or OW", "1-n or 1", -1, 0},
    { 0x00281201, "Red Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281202, "Green Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281203, "Blue Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281204, "Alpha Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281211, "Large Red Palette Color Lookup Table Data", "OW", "1", -1, 0},
    { 0x00281212, "Large Green Palette Color Lookup Table Data", "OW", "1", -1, 0},
    { 0x00281213, "Large Blue Palette Color Lookup Table Data", "OW", "1", -1, 0},
    { 0x00281214, "Large Palette Color Lookup Table UID", "UI", "1", -1, 0},
    { 0x00281221, "Segmented Red Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281222, "Segmented Green Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281223, "Segmented Blue Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281224, "Segmented Alpha Palette Color Lookup Table Data", "OW", "1", 0, 0},
    { 0x00281230, "Stored Value Color Range Sequence", "SQ", "1", 0, 0},
    { 0x00281231, "Minimum Stored Value Mapped", "FD", "1", 0, 0},
    { 0x00281232, "Maximum Stored Value Mapped", "FD", "1", 0, 0},
    { 0x00281300, "Breast Implant Present", "CS", "1", 0, 0},
    { 0x00281350, "Partial View", "CS", "1", 0, 0},
    { 0x00281351, "Partial View Description", "ST", "1", 0, 0},
    { 0x00281352, "Partial View Code Sequence", "SQ", "1", 0, 0},
    { 0x0028135A, "Spatial Locations Preserved", "CS", "1", 0, 0},
    { 0x00281401, "Data Frame Assignment Sequence", "SQ", "1", 0, 0},
    { 0x00281402, "Data Path Assignment", "CS", "1", 0, 0},
    { 0x00281403, "Bits Mapped to Color Lookup Table", "US", "1", 0, 0},
    { 0x00281404, "Blending LUT 1 Sequence", "SQ", "1", 0, 0},
    { 0x00281405, "Blending LUT 1 Transfer Function", "CS", "1", 0, 0},
    { 0x00281406, "Blending Weight Constant", "FD", "1", 0, 0},
    { 0x00281407, "Blending Lookup Table Descriptor", "US", "3", 0, 0},
    { 0x00281408, "Blending Lookup Table Data", "OW", "1", 0, 0},
    { 0x0028140B, "Enhanced Palette Color Lookup Table Sequence", "SQ", "1", 0, 0},
    { 0x0028140C, "Blending LUT 2 Sequence", "SQ", "1", 0, 0},
    { 0x0028140D, "Blending LUT 2 Transfer Function", "CS", "1", 0, 0},
    { 0x0028140E, "Data Path ID", "CS", "1", 0, 0},
    { 0x0028140F, "RGB LUT Transfer Function", "CS", "1", 0, 0},
    { 0x00281410, "Alpha LUT Transfer Function", "CS", "1", 0, 0},
    { 0x00282000, "ICC Profile", "OB", "1", 0, 0},
    { 0x00282002, "Color Space", "CS", "1", 0, 0},
    { 0x00282110, "Lossy Image Compression", "CS", "1", 0, 0},
    { 0x00282112, "Lossy Image Compression Ratio", "DS", "1-n", 0, 0},
    { 0x00282114, "Lossy Image Compression Method", "CS", "1-n", 0, 0},
    { 0x00283000, "Modality LUT Sequence", "SQ", "1", 0, 0},
    { 0x00283002, "LUT Descriptor", "US or SS", "3", 0, 0},
    { 0x00283003, "LUT Explanation", "LO", "1", 0, 0},
    { 0x00283004, "Modality LUT Type", "LO", "1", 0, 0},
    { 0x00283006, "LUT Data", "US or OW", "1-n or 1", 0, 0},
    { 0x00283010, "VOI LUT Sequence", "SQ", "1", 0, 0},
    { 0x00283110, "Softcopy VOI LUT Sequence", "SQ", "1", 0, 0},
    { 0x00284000, "Image Presentation Comments", "LT", "1", -1, 0},
    { 0x00285000, "Bi-Plane Acquisition Sequence", "SQ", "1", -1, 0},
    { 0x00286010, "Representative Frame Number", "US", "1", 0, 0},
    { 0x00286020, "Frame Numbers of Interest (FOI)", "US", "1-n", 0, 0},
    { 0x00286022, "Frame of Interest Description", "LO", "1-n", 0, 0},
    { 0x00286023, "Frame of Interest Type", "CS", "1-n", 0, 0},
    { 0x00286030, "Mask Pointer(s)", "US", "1-n", -1, 0},
    { 0x00286040, "R Wave Pointer", "US", "1-n", 0, 0},
    { 0x00286100, "Mask Subtraction Sequence", "SQ", "1", 0, 0},
    { 0x00286101, "Mask Operation", "CS", "1", 0, 0},
    { 0x00286102, "Applicable Frame Range", "US", "2-2n", 0, 0},
    { 0x00286110, "Mask Frame Numbers", "US", "1-n", 0, 0},
    { 0x00286112, "Contrast Frame Averaging", "US", "1", 0, 0},
    { 0x00286114, "Mask Sub-pixel Shift", "FL", "2", 0, 0},
    { 0x00286120, "TID Offset", "SS", "1", 0, 0},
    { 0x00286190, "Mask Operation Explanation", "ST", "1", 0, 0},
    { 0x00287000, "Equipment Administrator Sequence", "SQ", "1", 0, 0},
    { 0x00287001, "Number of Display Subsystems", "US", "1", 0, 0},
    { 0x00287002, "Current Configuration ID", "US", "1", 0, 0},
    { 0x00287003, "Display Subsystem ID", "US", "1", 0, 0},
    { 0x00287004, "Display Subsystem Name", "SH", "1", 0, 0},
    { 0x00287005, "Display Subsystem Description", "LO", "1", 0, 0},
    { 0x00287006, "System Status", "CS", "1", 0, 0},
    { 0x00287007, "System Status Comment", "LO", "1", 0, 0},
    { 0x00287008, "Target Luminance Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x00287009, "Luminance Characteristics ID", "US", "1", 0, 0},
    { 0x0028700A, "Display Subsystem Configuration Sequence", "SQ", "1", 0, 0},
    { 0x0028700B, "Configuration ID", "US", "1", 0, 0},
    { 0x0028700C, "Configuration Name", "SH", "1", 0, 0},
    { 0x0028700D, "Configuration Description", "LO", "1", 0, 0},
    { 0x0028700E, "Referenced Target Luminance Characteristics ID", "US", "1", 0, 0},
    { 0x0028700F, "QA Results Sequence", "SQ", "1", 0, 0},
    { 0x00287010, "Display Subsystem QA Results Sequence", "SQ", "1", 0, 0},
    { 0x00287011, "Configuration QA Results Sequence", "SQ", "1", 0, 0},
    { 0x00287012, "Measurement Equipment Sequence", "SQ", "1", 0, 0},
    { 0x00287013, "Measurement Functions", "CS", "1-n", 0, 0},
    { 0x00287014, "Measurement Equipment Type", "CS", "1", 0, 0},
    { 0x00287015, "Visual Evaluation Result Sequence", "SQ", "1", 0, 0},
    { 0x00287016, "Display Calibration Result Sequence", "SQ", "1", 0, 0},
    { 0x00287017, "DDL Value", "US", "1", 0, 0},
    { 0x00287018, "CIExy White Point", "FL", "2", 0, 0},
    { 0x00287019, "Display Function Type", "CS", "1", 0, 0},
    { 0x0028701A, "Gamma Value", "FL", "1", 0, 0},
    { 0x0028701B, "Number of Luminance Points", "US", "1", 0, 0},
    { 0x0028701C, "Luminance Response Sequence", "SQ", "1", 0, 0},
    { 0x0028701D, "Target Minimum Luminance", "FL", "1", 0, 0},
    { 0x0028701E, "Target Maximum Luminance", "FL", "1", 0, 0},
    { 0x0028701F, "Luminance Value", "FL", "1", 0, 0},
    { 0x00287020, "Luminance Response Description", "LO", "1", 0, 0},
    { 0x00287021, "White Point Flag", "CS", "1", 0, 0},
    { 0x00287022, "Display Device Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00287023, "Display Subsystem Sequence", "SQ", "1", 0, 0},
    { 0x00287024, "Luminance Result Sequence", "SQ", "1", 0, 0},
    { 0x00287025, "Ambient Light Value Source", "CS", "1", 0, 0},
    { 0x00287026, "Measured Characteristics", "CS", "1-n", 0, 0},
    { 0x00287027, "Luminance Uniformity Result Sequence", "SQ", "1", 0, 0},
    { 0x00287028, "Visual Evaluation Test Sequence", "SQ", "1", 0, 0},
    { 0x00287029, "Test Result", "CS", "1", 0, 0},
    { 0x0028702A, "Test Result Comment", "LO", "1", 0, 0},
    { 0x0028702B, "Test Image Validation", "CS", "1", 0, 0},
    { 0x0028702C, "Test Pattern Code Sequence", "SQ", "1", 0, 0},
    { 0x0028702D, "Measurement Pattern Code Sequence", "SQ", "1", 0, 0},
    { 0x0028702E, "Visual Evaluation Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00287FE0, "Pixel Data Provider URL", "UR", "1", 0, 0},
    { 0x00289001, "Data Point Rows", "UL", "1", 0, 0},
    { 0x00289002, "Data Point Columns", "UL", "1", 0, 0},
    { 0x00289003, "Signal Domain Columns", "CS", "1", 0, 0},
    { 0x00289099, "Largest Monochrome Pixel Value", "US", "1", -1, 0},
    { 0x00289108, "Data Representation", "CS", "1", 0, 0},
    { 0x00289110, "Pixel Measures Sequence", "SQ", "1", 0, 0},
    { 0x00289132, "Frame VOI LUT Sequence", "SQ", "1", 0, 0},
    { 0x00289145, "Pixel Value Transformation Sequence", "SQ", "1", 0, 0},
    { 0x00289235, "Signal Domain Rows", "CS", "1", 0, 0},
    { 0x00289411, "Display Filter Percentage", "FL", "1", 0, 0},
    { 0x00289415, "Frame Pixel Shift Sequence", "SQ", "1", 0, 0},
    { 0x00289416, "Subtraction Item ID", "US", "1", 0, 0},
    { 0x00289422, "Pixel Intensity Relationship LUT Sequence", "SQ", "1", 0, 0},
    { 0x00289443, "Frame Pixel Data Properties Sequence", "SQ", "1", 0, 0},
    { 0x00289444, "Geometrical Properties", "CS", "1", 0, 0},
    { 0x00289445, "Geometric Maximum Distortion", "FL", "1", 0, 0},
    { 0x00289446, "Image Processing Applied", "CS", "1-n", 0, 0},
    { 0x00289454, "Mask Selection Mode", "CS", "1", 0, 0},
    { 0x00289474, "LUT Function", "CS", "1", 0, 0},
    { 0x00289478, "Mask Visibility Percentage", "FL", "1", 0, 0},
    { 0x00289501, "Pixel Shift Sequence", "SQ", "1", 0, 0},
    { 0x00289502, "Region Pixel Shift Sequence", "SQ", "1", 0, 0},
    { 0x00289503, "Vertices of the Region", "SS", "2-2n", 0, 0},
    { 0x00289505, "Multi-frame Presentation Sequence", "SQ", "1", 0, 0},
    { 0x00289506, "Pixel Shift Frame Range", "US", "2-2n", 0, 0},
    { 0x00289507, "LUT Frame Range", "US", "2-2n", 0, 0},
    { 0x00289520, "Image to Equipment Mapping Matrix", "DS", "16", 0, 0},
    { 0x00289537, "Equipment Coordinate System Identification", "CS", "1", 0, 0},
    { 0x0032000A, "Study Status ID", "CS", "1", -1, 0},
    { 0x0032000C, "Study Priority ID", "CS", "1", -1, 0},
    { 0x00320012, "Study ID Issuer", "LO", "1", -1, 0},
    { 0x00320032, "Study Verified Date", "DA", "1", -1, 0},
    { 0x00320033, "Study Verified Time", "TM", "1", -1, 0},
    { 0x00320034, "Study Read Date", "DA", "1", -1, 0},
    { 0x00320035, "Study Read Time", "TM", "1", -1, 0},
    { 0x00321000, "Scheduled Study Start Date", "DA", "1", -1, 0},
    { 0x00321001, "Scheduled Study Start Time", "TM", "1", -1, 0},
    { 0x00321010, "Scheduled Study Stop Date", "DA", "1", -1, 0},
    { 0x00321011, "Scheduled Study Stop Time", "TM", "1", -1, 0},
    { 0x00321020, "Scheduled Study Location", "LO", "1", -1, 0},
    { 0x00321021, "Scheduled Study Location AE Title", "AE", "1-n", -1, 0},
    { 0x00321030, "Reason for Study", "LO", "1", -1, 0},
    { 0x00321031, "Requesting Physician Identification Sequence", "SQ", "1", 0, 0},
    { 0x00321032, "Requesting Physician", "PN", "1", 0, 0},
    { 0x00321033, "Requesting Service", "LO", "1", 0, 0},
    { 0x00321034, "Requesting Service Code Sequence", "SQ", "1", 0, 0},
    { 0x00321040, "Study Arrival Date", "DA", "1", -1, 0},
    { 0x00321041, "Study Arrival Time", "TM", "1", -1, 0},
    { 0x00321050, "Study Completion Date", "DA", "1", -1, 0},
    { 0x00321051, "Study Completion Time", "TM", "1", -1, 0},
    { 0x00321055, "Study Component Status ID", "CS", "1", -1, 0},
    { 0x00321060, "Requested Procedure Description", "LO", "1", 0, 0},
    { 0x00321064, "Requested Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x00321066, "Reason for Visit", "UT", "1", 0, 0},
    { 0x00321067, "Reason for Visit Code Sequence", "SQ", "1", 0, 0},
    { 0x00321070, "Requested Contrast Agent", "LO", "1", 0, 0},
    { 0x00324000, "Study Comments", "LT", "1", -1, 0},
    { 0x00340001, "Flow Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00340002, "Flow Identifier", "OB", "1", 0, 0},
    { 0x00340003, "Flow Transfer Syntax UID", "UI", "1", 0, 0},
    { 0x00340004, "Flow RTP Sampling Rate", "UL", "1", 0, 0},
    { 0x00340005, "Source Identifier", "OB", "1", 0, 0},
    { 0x00340007, "Frame Origin Timestamp", "OB", "1", 0, 0},
    { 0x00340008, "Includes Imaging Subject", "CS", "1", 0, 0},
    { 0x00340009, "Frame Usefulness Group Sequence", "SQ", "1", 0, 0},
    { 0x0034000A, "Real-Time Bulk Data Flow Sequence", "SQ", "1", 0, 0},
    { 0x0034000B, "Camera Position Group Sequence", "SQ", "1", 0, 0},
    { 0x0034000C, "Includes Information", "CS", "1", 0, 0},
    { 0x0034000D, "Time of Frame Group Sequence", "SQ", "1", 0, 0},
    { 0x00380004, "Referenced Patient Alias Sequence", "SQ", "1", 0, 0},
    { 0x00380008, "Visit Status ID", "CS", "1", 0, 0},
    { 0x00380010, "Admission ID", "LO", "1", 0, 0},
    { 0x00380011, "Issuer of Admission ID", "LO", "1", -1, 0},
    { 0x00380014, "Issuer of Admission ID Sequence", "SQ", "1", 0, 0},
    { 0x00380016, "Route of Admissions", "LO", "1", 0, 0},
    { 0x0038001A, "Scheduled Admission Date", "DA", "1", -1, 0},
    { 0x0038001B, "Scheduled Admission Time", "TM", "1", -1, 0},
    { 0x0038001C, "Scheduled Discharge Date", "DA", "1", -1, 0},
    { 0x0038001D, "Scheduled Discharge Time", "TM", "1", -1, 0},
    { 0x0038001E, "Scheduled Patient Institution Residence", "LO", "1", -1, 0},
    { 0x00380020, "Admitting Date", "DA", "1", 0, 0},
    { 0x00380021, "Admitting Time", "TM", "1", 0, 0},
    { 0x00380030, "Discharge Date", "DA", "1", -1, 0},
    { 0x00380032, "Discharge Time", "TM", "1", -1, 0},
    { 0x00380040, "Discharge Diagnosis Description", "LO", "1", -1, 0},
    { 0x00380044, "Discharge Diagnosis Code Sequence", "SQ", "1", -1, 0},
    { 0x00380050, "Special Needs", "LO", "1", 0, 0},
    { 0x00380060, "Service Episode ID", "LO", "1", 0, 0},
    { 0x00380061, "Issuer of Service Episode ID", "LO", "1", -1, 0},
    { 0x00380062, "Service Episode Description", "LO", "1", 0, 0},
    { 0x00380064, "Issuer of Service Episode ID Sequence", "SQ", "1", 0, 0},
    { 0x00380100, "Pertinent Documents Sequence", "SQ", "1", 0, 0},
    { 0x00380101, "Pertinent Resources Sequence", "SQ", "1", 0, 0},
    { 0x00380102, "Resource Description", "LO", "1", 0, 0},
    { 0x00380300, "Current Patient Location", "LO", "1", 0, 0},
    { 0x00380400, "Patient's Institution Residence", "LO", "1", 0, 0},
    { 0x00380500, "Patient State", "LO", "1", 0, 0},
    { 0x00380502, "Patient Clinical Trial Participation Sequence", "SQ", "1", 0, 0},
    { 0x00384000, "Visit Comments", "LT", "1", 0, 0},
    { 0x003A0004, "Waveform Originality", "CS", "1", 0, 0},
    { 0x003A0005, "Number of Waveform Channels", "US", "1", 0, 0},
    { 0x003A0010, "Number of Waveform Samples", "UL", "1", 0, 0},
    { 0x003A001A, "Sampling Frequency", "DS", "1", 0, 0},
    { 0x003A0020, "Multiplex Group Label", "SH", "1", 0, 0},
    { 0x003A0200, "Channel Definition Sequence", "SQ", "1", 0, 0},
    { 0x003A0202, "Waveform Channel Number", "IS", "1", 0, 0},
    { 0x003A0203, "Channel Label", "SH", "1", 0, 0},
    { 0x003A0205, "Channel Status", "CS", "1-n", 0, 0},
    { 0x003A0208, "Channel Source Sequence", "SQ", "1", 0, 0},
    { 0x003A0209, "Channel Source Modifiers Sequence", "SQ", "1", 0, 0},
    { 0x003A020A, "Source Waveform Sequence", "SQ", "1", 0, 0},
    { 0x003A020C, "Channel Derivation Description", "LO", "1", 0, 0},
    { 0x003A0210, "Channel Sensitivity", "DS", "1", 0, 0},
    { 0x003A0211, "Channel Sensitivity Units Sequence", "SQ", "1", 0, 0},
    { 0x003A0212, "Channel Sensitivity Correction Factor", "DS", "1", 0, 0},
    { 0x003A0213, "Channel Baseline", "DS", "1", 0, 0},
    { 0x003A0214, "Channel Time Skew", "DS", "1", 0, 0},
    { 0x003A0215, "Channel Sample Skew", "DS", "1", 0, 0},
    { 0x003A0218, "Channel Offset", "DS", "1", 0, 0},
    { 0x003A021A, "Waveform Bits Stored", "US", "1", 0, 0},
    { 0x003A0220, "Filter Low Frequency", "DS", "1", 0, 0},
    { 0x003A0221, "Filter High Frequency", "DS", "1", 0, 0},
    { 0x003A0222, "Notch Filter Frequency", "DS", "1", 0, 0},
    { 0x003A0223, "Notch Filter Bandwidth", "DS", "1", 0, 0},
    { 0x003A0230, "Waveform Data Display Scale", "FL", "1", 0, 0},
    { 0x003A0231, "Waveform Display Background CIELab Value", "US", "3", 0, 0},
    { 0x003A0240, "Waveform Presentation Group Sequence", "SQ", "1", 0, 0},
    { 0x003A0241, "Presentation Group Number", "US", "1", 0, 0},
    { 0x003A0242, "Channel Display Sequence", "SQ", "1", 0, 0},
    { 0x003A0244, "Channel Recommended Display CIELab Value", "US", "3", 0, 0},
    { 0x003A0245, "Channel Position", "FL", "1", 0, 0},
    { 0x003A0246, "Display Shading Flag", "CS", "1", 0, 0},
    { 0x003A0247, "Fractional Channel Display Scale", "FL", "1", 0, 0},
    { 0x003A0248, "Absolute Channel Display Scale", "FL", "1", 0, 0},
    { 0x003A0300, "Multiplexed Audio Channels Description Code Sequence", "SQ", "1", 0, 0},
    { 0x003A0301, "Channel Identification Code", "IS", "1", 0, 0},
    { 0x003A0302, "Channel Mode", "CS", "1", 0, 0},
    { 0x00400001, "Scheduled Station AE Title", "AE", "1-n", 0, 0},
    { 0x00400002, "Scheduled Procedure Step Start Date", "DA", "1", 0, 0},
    { 0x00400003, "Scheduled Procedure Step Start Time", "TM", "1", 0, 0},
    { 0x00400004, "Scheduled Procedure Step End Date", "DA", "1", 0, 0},
    { 0x00400005, "Scheduled Procedure Step End Time", "TM", "1", 0, 0},
    { 0x00400006, "Scheduled Performing Physician's Name", "PN", "1", 0, 0},
    { 0x00400007, "Scheduled Procedure Step Description", "LO", "1", 0, 0},
    { 0x00400008, "Scheduled Protocol Code Sequence", "SQ", "1", 0, 0},
    { 0x00400009, "Scheduled Procedure Step ID", "SH", "1", 0, 0},
    { 0x0040000A, "Stage Code Sequence", "SQ", "1", 0, 0},
    { 0x0040000B, "Scheduled Performing Physician Identification Sequence", "SQ", "1", 0, 0},
    { 0x00400010, "Scheduled Station Name", "SH", "1-n", 0, 0},
    { 0x00400011, "Scheduled Procedure Step Location", "SH", "1", 0, 0},
    { 0x00400012, "Pre-Medication", "LO", "1", 0, 0},
    { 0x00400020, "Scheduled Procedure Step Status", "CS", "1", 0, 0},
    { 0x00400026, "Order Placer Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00400027, "Order Filler Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00400031, "Local Namespace Entity ID", "UT", "1", 0, 0},
    { 0x00400032, "Universal Entity ID", "UT", "1", 0, 0},
    { 0x00400033, "Universal Entity ID Type", "CS", "1", 0, 0},
    { 0x00400035, "Identifier Type Code", "CS", "1", 0, 0},
    { 0x00400036, "Assigning Facility Sequence", "SQ", "1", 0, 0},
    { 0x00400039, "Assigning Jurisdiction Code Sequence", "SQ", "1", 0, 0},
    { 0x0040003A, "Assigning Agency or Department Code Sequence", "SQ", "1", 0, 0},
    { 0x00400100, "Scheduled Procedure Step Sequence", "SQ", "1", 0, 0},
    { 0x00400220, "Referenced Non-Image Composite SOP Instance Sequence", "SQ", "1", 0, 0},
    { 0x00400241, "Performed Station AE Title", "AE", "1", 0, 0},
    { 0x00400242, "Performed Station Name", "SH", "1", 0, 0},
    { 0x00400243, "Performed Location", "SH", "1", 0, 0},
    { 0x00400244, "Performed Procedure Step Start Date", "DA", "1", 0, 0},
    { 0x00400245, "Performed Procedure Step Start Time", "TM", "1", 0, 0},
    { 0x00400250, "Performed Procedure Step End Date", "DA", "1", 0, 0},
    { 0x00400251, "Performed Procedure Step End Time", "TM", "1", 0, 0},
    { 0x00400252, "Performed Procedure Step Status", "CS", "1", 0, 0},
    { 0x00400253, "Performed Procedure Step ID", "SH", "1", 0, 0},
    { 0x00400254, "Performed Procedure Step Description", "LO", "1", 0, 0},
    { 0x00400255, "Performed Procedure Type Description", "LO", "1", 0, 0},
    { 0x00400260, "Performed Protocol Code Sequence", "SQ", "1", 0, 0},
    { 0x00400261, "Performed Protocol Type", "CS", "1", 0, 0},
    { 0x00400270, "Scheduled Step Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00400275, "Request Attributes Sequence", "SQ", "1", 0, 0},
    { 0x00400280, "Comments on the Performed Procedure Step", "ST", "1", 0, 0},
    { 0x00400281, "Performed Procedure Step Discontinuation Reason Code Sequence", "SQ", "1", 0, 0},
    { 0x00400293, "Quantity Sequence", "SQ", "1", 0, 0},
    { 0x00400294, "Quantity", "DS", "1", 0, 0},
    { 0x00400295, "Measuring Units Sequence", "SQ", "1", 0, 0},
    { 0x00400296, "Billing Item Sequence", "SQ", "1", 0, 0},
    { 0x00400300, "Total Time of Fluoroscopy", "US", "1", -1, 0},
    { 0x00400301, "Total Number of Exposures", "US", "1", -1, 0},
    { 0x00400302, "Entrance Dose", "US", "1", 0, 0},
    { 0x00400303, "Exposed Area", "US", "1-2", 0, 0},
    { 0x00400306, "Distance Source to Entrance", "DS", "1", 0, 0},
    { 0x00400307, "Distance Source to Support", "DS", "1", -1, 0},
    { 0x0040030E, "Exposure Dose Sequence", "SQ", "1", -1, 0},
    { 0x00400310, "Comments on Radiation Dose", "ST", "1", 0, 0},
    { 0x00400312, "X-Ray Output", "DS", "1", 0, 0},
    { 0x00400314, "Half Value Layer", "DS", "1", 0, 0},
    { 0x00400316, "Organ Dose", "DS", "1", 0, 0},
    { 0x00400318, "Organ Exposed", "CS", "1", 0, 0},
    { 0x00400320, "Billing Procedure Step Sequence", "SQ", "1", 0, 0},
    { 0x00400321, "Film Consumption Sequence", "SQ", "1", 0, 0},
    { 0x00400324, "Billing Supplies and Devices Sequence", "SQ", "1", 0, 0},
    { 0x00400330, "Referenced Procedure Step Sequence", "SQ", "1", -1, 0},
    { 0x00400340, "Performed Series Sequence", "SQ", "1", 0, 0},
    { 0x00400400, "Comments on the Scheduled Procedure Step", "LT", "1", 0, 0},
    { 0x00400440, "Protocol Context Sequence", "SQ", "1", 0, 0},
    { 0x00400441, "Content Item Modifier Sequence", "SQ", "1", 0, 0},
    { 0x00400500, "Scheduled Specimen Sequence", "SQ", "1", 0, 0},
    { 0x0040050A, "Specimen Accession Number", "LO", "1", -1, 0},
    { 0x00400512, "Container Identifier", "LO", "1", 0, 0},
    { 0x00400513, "Issuer of the Container Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00400515, "Alternate Container Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00400518, "Container Type Code Sequence", "SQ", "1", 0, 0},
    { 0x0040051A, "Container Description", "LO", "1", 0, 0},
    { 0x00400520, "Container Component Sequence", "SQ", "1", 0, 0},
    { 0x00400550, "Specimen Sequence", "SQ", "1", -1, 0},
    { 0x00400551, "Specimen Identifier", "LO", "1", 0, 0},
    { 0x00400552, "Specimen Description Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00400553, "Specimen Description (Trial)", "ST", "1", -1, 0},
    { 0x00400554, "Specimen UID", "UI", "1", 0, 0},
    { 0x00400555, "Acquisition Context Sequence", "SQ", "1", 0, 0},
    { 0x00400556, "Acquisition Context Description", "ST", "1", 0, 0},
    { 0x0040059A, "Specimen Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00400560, "Specimen Description Sequence", "SQ", "1", 0, 0},
    { 0x00400562, "Issuer of the Specimen Identifier Sequence", "SQ", "1", 0, 0},
    { 0x00400600, "Specimen Short Description", "LO", "1", 0, 0},
    { 0x00400602, "Specimen Detailed Description", "UT", "1", 0, 0},
    { 0x00400610, "Specimen Preparation Sequence", "SQ", "1", 0, 0},
    { 0x00400612, "Specimen Preparation Step Content Item Sequence", "SQ", "1", 0, 0},
    { 0x00400620, "Specimen Localization Content Item Sequence", "SQ", "1", 0, 0},
    { 0x004006FA, "Slide Identifier", "LO", "1", -1, 0},
    { 0x00400710, "Whole Slide Microscopy Image Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x0040071A, "Image Center Point Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x0040072A, "X Offset in Slide Coordinate System", "DS", "1", 0, 0},
    { 0x0040073A, "Y Offset in Slide Coordinate System", "DS", "1", 0, 0},
    { 0x0040074A, "Z Offset in Slide Coordinate System", "DS", "1", 0, 0},
    { 0x004008D8, "Pixel Spacing Sequence", "SQ", "1", -1, 0},
    { 0x004008DA, "Coordinate System Axis Code Sequence", "SQ", "1", -1, 0},
    { 0x004008EA, "Measurement Units Code Sequence", "SQ", "1", 0, 0},
    { 0x004009F8, "Vital Stain Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x00401001, "Requested Procedure ID", "SH", "1", 0, 0},
    { 0x00401002, "Reason for the Requested Procedure", "LO", "1", 0, 0},
    { 0x00401003, "Requested Procedure Priority", "SH", "1", 0, 0},
    { 0x00401004, "Patient Transport Arrangements", "LO", "1", 0, 0},
    { 0x00401005, "Requested Procedure Location", "LO", "1", 0, 0},
    { 0x00401006, "Placer Order Number / Procedure", "SH", "1", -1, 0},
    { 0x00401007, "Filler Order Number / Procedure", "SH", "1", -1, 0},
    { 0x00401008, "Confidentiality Code", "LO", "1", 0, 0},
    { 0x00401009, "Reporting Priority", "SH", "1", 0, 0},
    { 0x0040100A, "Reason for Requested Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x00401010, "Names of Intended Recipients of Results", "PN", "1-n", 0, 0},
    { 0x00401011, "Intended Recipients of Results Identification Sequence", "SQ", "1", 0, 0},
    { 0x00401012, "Reason For Performed Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x00401060, "Requested Procedure Description (Trial)", "LO", "1", -1, 0},
    { 0x00401101, "Person Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x00401102, "Person's Address", "ST", "1", 0, 0},
    { 0x00401103, "Person's Telephone Numbers", "LO", "1-n", 0, 0},
    { 0x00401104, "Person's Telecom Information", "LT", "1", 0, 0},
    { 0x00401400, "Requested Procedure Comments", "LT", "1", 0, 0},
    { 0x00402001, "Reason for the Imaging Service Request", "LO", "1", -1, 0},
    { 0x00402004, "Issue Date of Imaging Service Request", "DA", "1", 0, 0},
    { 0x00402005, "Issue Time of Imaging Service Request", "TM", "1", 0, 0},
    { 0x00402006, "Placer Order Number / Imaging Service Request (Retired)", "SH", "1", -1, 0},
    { 0x00402007, "Filler Order Number / Imaging Service Request (Retired)", "SH", "1", -1, 0},
    { 0x00402008, "Order Entered By", "PN", "1", 0, 0},
    { 0x00402009, "Order Enterer's Location", "SH", "1", 0, 0},
    { 0x00402010, "Order Callback Phone Number", "SH", "1", 0, 0},
    { 0x00402011, "Order Callback Telecom Information", "LT", "1", 0, 0},
    { 0x00402016, "Placer Order Number / Imaging Service Request", "LO", "1", 0, 0},
    { 0x00402017, "Filler Order Number / Imaging Service Request", "LO", "1", 0, 0},
    { 0x00402400, "Imaging Service Request Comments", "LT", "1", 0, 0},
    { 0x00403001, "Confidentiality Constraint on Patient Data Description", "LO", "1", 0, 0},
    { 0x00404001, "General Purpose Scheduled Procedure Step Status", "CS", "1", -1, 0},
    { 0x00404002, "General Purpose Performed Procedure Step Status", "CS", "1", -1, 0},
    { 0x00404003, "General Purpose Scheduled Procedure Step Priority", "CS", "1", -1, 0},
    { 0x00404004, "Scheduled Processing Applications Code Sequence", "SQ", "1", -1, 0},
    { 0x00404005, "Scheduled Procedure Step Start DateTime", "DT", "1", 0, 0},
    { 0x00404006, "Multiple Copies Flag", "CS", "1", -1, 0},
    { 0x00404007, "Performed Processing Applications Code Sequence", "SQ", "1", -1, 0},
    { 0x00404008, "Scheduled Procedure Step Expiration DateTime", "DT", "1", 0, 0},
    { 0x00404009, "Human Performer Code Sequence", "SQ", "1", 0, 0},
    { 0x00404010, "Scheduled Procedure Step Modification DateTime", "DT", "1", 0, 0},
    { 0x00404011, "Expected Completion DateTime", "DT", "1", 0, 0},
    { 0x00404015, "Resulting General Purpose Performed Procedure Steps Sequence", "SQ", "1", -1, 0},
    { 0x00404016, "Referenced General Purpose Scheduled Procedure Step Sequence", "SQ", "1", -1, 0},
    { 0x00404018, "Scheduled Workitem Code Sequence", "SQ", "1", 0, 0},
    { 0x00404019, "Performed Workitem Code Sequence", "SQ", "1", 0, 0},
    { 0x00404020, "Input Availability Flag", "CS", "1", -1, 0},
    { 0x00404021, "Input Information Sequence", "SQ", "1", 0, 0},
    { 0x00404022, "Relevant Information Sequence", "SQ", "1", -1, 0},
    { 0x00404023, "Referenced General Purpose Scheduled Procedure Step Transaction UID", "UI", "1", -1, 0},
    { 0x00404025, "Scheduled Station Name Code Sequence", "SQ", "1", 0, 0},
    { 0x00404026, "Scheduled Station Class Code Sequence", "SQ", "1", 0, 0},
    { 0x00404027, "Scheduled Station Geographic Location Code Sequence", "SQ", "1", 0, 0},
    { 0x00404028, "Performed Station Name Code Sequence", "SQ", "1", 0, 0},
    { 0x00404029, "Performed Station Class Code Sequence", "SQ", "1", 0, 0},
    { 0x00404030, "Performed Station Geographic Location Code Sequence", "SQ", "1", 0, 0},
    { 0x00404031, "Requested Subsequent Workitem Code Sequence", "SQ", "1", -1, 0},
    { 0x00404032, "Non-DICOM Output Code Sequence", "SQ", "1", -1, 0},
    { 0x00404033, "Output Information Sequence", "SQ", "1", 0, 0},
    { 0x00404034, "Scheduled Human Performers Sequence", "SQ", "1", 0, 0},
    { 0x00404035, "Actual Human Performers Sequence", "SQ", "1", 0, 0},
    { 0x00404036, "Human Performer's Organization", "LO", "1", 0, 0},
    { 0x00404037, "Human Performer's Name", "PN", "1", 0, 0},
    { 0x00404040, "Raw Data Handling", "CS", "1", 0, 0},
    { 0x00404041, "Input Readiness State", "CS", "1", 0, 0},
    { 0x00404050, "Performed Procedure Step Start DateTime", "DT", "1", 0, 0},
    { 0x00404051, "Performed Procedure Step End DateTime", "DT", "1", 0, 0},
    { 0x00404052, "Procedure Step Cancellation DateTime", "DT", "1", 0, 0},
    { 0x00404070, "Output Destination Sequence", "SQ", "1", 0, 0},
    { 0x00404071, "DICOM Storage Sequence", "SQ", "1", 0, 0},
    { 0x00404072, "STOW-RS Storage Sequence", "SQ", "1", 0, 0},
    { 0x00404073, "Storage URL", "UR", "1", 0, 0},
    { 0x00404074, "XDS Storage Sequence", "SQ", "1", 0, 0},
    { 0x00408302, "Entrance Dose in mGy", "DS", "1", 0, 0},
    { 0x00408303, "Entrance Dose Derivation", "CS", "1", 0, 0},
    { 0x00409092, "Parametric Map Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00409094, "Referenced Image Real World Value Mapping Sequence", "SQ", "1", 0, 0},
    { 0x00409096, "Real World Value Mapping Sequence", "SQ", "1", 0, 0},
    { 0x00409098, "Pixel Value Mapping Code Sequence", "SQ", "1", 0, 0},
    { 0x00409210, "LUT Label", "SH", "1", 0, 0},
    { 0x00409211, "Real World Value Last Value Mapped", "US or SS", "1", 0, 0},
    { 0x00409212, "Real World Value LUT Data", "FD", "1-n", 0, 0},
    { 0x00409213, "Double Float Real World Value Last Value Mapped", "FD", "1", 0, 0},
    { 0x00409214, "Double Float Real World Value First Value Mapped", "FD", "1", 0, 0},
    { 0x00409216, "Real World Value First Value Mapped", "US or SS", "1", 0, 0},
    { 0x00409220, "Quantity Definition Sequence", "SQ", "1", 0, 0},
    { 0x00409224, "Real World Value Intercept", "FD", "1", 0, 0},
    { 0x00409225, "Real World Value Slope", "FD", "1", 0, 0},
    { 0x0040A007, "Findings Flag (Trial)", "CS", "1", -1, 0},
    { 0x0040A010, "Relationship Type", "CS", "1", 0, 0},
    { 0x0040A020, "Findings Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A021, "Findings Group UID (Trial)", "UI", "1", -1, 0},
    { 0x0040A022, "Referenced Findings Group UID (Trial)", "UI", "1", -1, 0},
    { 0x0040A023, "Findings Group Recording Date (Trial)", "DA", "1", -1, 0},
    { 0x0040A024, "Findings Group Recording Time (Trial)", "TM", "1", -1, 0},
    { 0x0040A026, "Findings Source Category Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A027, "Verifying Organization", "LO", "1", 0, 0},
    { 0x0040A028, "Documenting Organization Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A030, "Verification DateTime", "DT", "1", 0, 0},
    { 0x0040A032, "Observation DateTime", "DT", "1", 0, 0},
    { 0x0040A040, "Value Type", "CS", "1", 0, 0},
    { 0x0040A043, "Concept Name Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A047, "Measurement Precision Description (Trial)", "LO", "1", -1, 0},
    { 0x0040A050, "Continuity Of Content", "CS", "1", 0, 0},
    { 0x0040A057, "Urgency or Priority Alerts (Trial)", "CS", "1-n", -1, 0},
    { 0x0040A060, "Sequencing Indicator (Trial)", "LO", "1", -1, 0},
    { 0x0040A066, "Document Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A067, "Document Author (Trial)", "PN", "1", -1, 0},
    { 0x0040A068, "Document Author Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A070, "Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A073, "Verifying Observer Sequence", "SQ", "1", 0, 0},
    { 0x0040A074, "Object Binary Identifier (Trial)", "OB", "1", -1, 0},
    { 0x0040A075, "Verifying Observer Name", "PN", "1", 0, 0},
    { 0x0040A076, "Documenting Observer Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A078, "Author Observer Sequence", "SQ", "1", 0, 0},
    { 0x0040A07A, "Participant Sequence", "SQ", "1", 0, 0},
    { 0x0040A07C, "Custodial Organization Sequence", "SQ", "1", 0, 0},
    { 0x0040A080, "Participation Type", "CS", "1", 0, 0},
    { 0x0040A082, "Participation DateTime", "DT", "1", 0, 0},
    { 0x0040A084, "Observer Type", "CS", "1", 0, 0},
    { 0x0040A085, "Procedure Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A088, "Verifying Observer Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A089, "Object Directory Binary Identifier (Trial)", "OB", "1", -1, 0},
    { 0x0040A090, "Equivalent CDA Document Sequence", "SQ", "1", -1, 0},
    { 0x0040A0B0, "Referenced Waveform Channels", "US", "2-2n", 0, 0},
    { 0x0040A110, "Date of Document or Verbal Transaction (Trial)", "DA", "1", -1, 0},
    { 0x0040A112, "Time of Document Creation or Verbal Transaction (Trial)", "TM", "1", -1, 0},
    { 0x0040A120, "DateTime", "DT", "1", 0, 0},
    { 0x0040A121, "Date", "DA", "1", 0, 0},
    { 0x0040A122, "Time", "TM", "1", 0, 0},
    { 0x0040A123, "Person Name", "PN", "1", 0, 0},
    { 0x0040A124, "UID", "UI", "1", 0, 0},
    { 0x0040A125, "Report Status ID (Trial)", "CS", "2", -1, 0},
    { 0x0040A130, "Temporal Range Type", "CS", "1", 0, 0},
    { 0x0040A132, "Referenced Sample Positions", "UL", "1-n", 0, 0},
    { 0x0040A136, "Referenced Frame Numbers", "US", "1-n", -1, 0},
    { 0x0040A138, "Referenced Time Offsets", "DS", "1-n", 0, 0},
    { 0x0040A13A, "Referenced DateTime", "DT", "1-n", 0, 0},
    { 0x0040A160, "Text Value", "UT", "1", 0, 0},
    { 0x0040A161, "Floating Point Value", "FD", "1-n", 0, 0},
    { 0x0040A162, "Rational Numerator Value", "SL", "1-n", 0, 0},
    { 0x0040A163, "Rational Denominator Value", "UL", "1-n", 0, 0},
    { 0x0040A167, "Observation Category Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A168, "Concept Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A16A, "Bibliographic Citation (Trial)", "ST", "1", -1, 0},
    { 0x0040A170, "Purpose of Reference Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A171, "Observation UID", "UI", "1", 0, 0},
    { 0x0040A172, "Referenced Observation UID (Trial)", "UI", "1", -1, 0},
    { 0x0040A173, "Referenced Observation Class (Trial)", "CS", "1", -1, 0},
    { 0x0040A174, "Referenced Object Observation Class (Trial)", "CS", "1", -1, 0},
    { 0x0040A180, "Annotation Group Number", "US", "1", 0, 0},
    { 0x0040A192, "Observation Date (Trial)", "DA", "1", -1, 0},
    { 0x0040A193, "Observation Time (Trial)", "TM", "1", -1, 0},
    { 0x0040A194, "Measurement Automation (Trial)", "CS", "1", -1, 0},
    { 0x0040A195, "Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A224, "Identification Description (Trial)", "ST", "1", -1, 0},
    { 0x0040A290, "Coordinates Set Geometric Type (Trial)", "CS", "1", -1, 0},
    { 0x0040A296, "Algorithm Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A297, "Algorithm Description (Trial)", "ST", "1", -1, 0},
    { 0x0040A29A, "Pixel Coordinates Set (Trial)", "SL", "2-2n", -1, 0},
    { 0x0040A300, "Measured Value Sequence", "SQ", "1", 0, 0},
    { 0x0040A301, "Numeric Value Qualifier Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A307, "Current Observer (Trial)", "PN", "1", -1, 0},
    { 0x0040A30A, "Numeric Value", "DS", "1-n", 0, 0},
    { 0x0040A313, "Referenced Accession Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A33A, "Report Status Comment (Trial)", "ST", "1", -1, 0},
    { 0x0040A340, "Procedure Context Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A352, "Verbal Source (Trial)", "PN", "1", -1, 0},
    { 0x0040A353, "Address (Trial)", "ST", "1", -1, 0},
    { 0x0040A354, "Telephone Number (Trial)", "LO", "1", -1, 0},
    { 0x0040A358, "Verbal Source Identifier Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A360, "Predecessor Documents Sequence", "SQ", "1", 0, 0},
    { 0x0040A370, "Referenced Request Sequence", "SQ", "1", 0, 0},
    { 0x0040A372, "Performed Procedure Code Sequence", "SQ", "1", 0, 0},
    { 0x0040A375, "Current Requested Procedure Evidence Sequence", "SQ", "1", 0, 0},
    { 0x0040A380, "Report Detail Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A385, "Pertinent Other Evidence Sequence", "SQ", "1", 0, 0},
    { 0x0040A390, "HL7 Structured Document Reference Sequence", "SQ", "1", 0, 0},
    { 0x0040A402, "Observation Subject UID (Trial)", "UI", "1", -1, 0},
    { 0x0040A403, "Observation Subject Class (Trial)", "CS", "1", -1, 0},
    { 0x0040A404, "Observation Subject Type Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A491, "Completion Flag", "CS", "1", 0, 0},
    { 0x0040A492, "Completion Flag Description", "LO", "1", 0, 0},
    { 0x0040A493, "Verification Flag", "CS", "1", 0, 0},
    { 0x0040A494, "Archive Requested", "CS", "1", 0, 0},
    { 0x0040A496, "Preliminary Flag", "CS", "1", 0, 0},
    { 0x0040A504, "Content Template Sequence", "SQ", "1", 0, 0},
    { 0x0040A525, "Identical Documents Sequence", "SQ", "1", 0, 0},
    { 0x0040A600, "Observation Subject Context Flag (Trial)", "CS", "1", -1, 0},
    { 0x0040A601, "Observer Context Flag (Trial)", "CS", "1", -1, 0},
    { 0x0040A603, "Procedure Context Flag (Trial)", "CS", "1", -1, 0},
    { 0x0040A730, "Content Sequence", "SQ", "1", 0, 0},
    { 0x0040A731, "Relationship Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A732, "Relationship Type Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A744, "Language Code Sequence (Trial)", "SQ", "1", -1, 0},
    { 0x0040A992, "Uniform Resource Locator (Trial)", "ST", "1", -1, 0},
    { 0x0040B020, "Waveform Annotation Sequence", "SQ", "1", 0, 0},
    { 0x0040DB00, "Template Identifier", "CS", "1", 0, 0},
    { 0x0040DB06, "Template Version", "DT", "1", -1, 0},
    { 0x0040DB07, "Template Local Version", "DT", "1", -1, 0},
    { 0x0040DB0B, "Template Extension Flag", "CS", "1", -1, 0},
    { 0x0040DB0C, "Template Extension Organization UID", "UI", "1", -1, 0},
    { 0x0040DB0D, "Template Extension Creator UID", "UI", "1", -1, 0},
    { 0x0040DB73, "Referenced Content Item Identifier", "UL", "1-n", 0, 0},
    { 0x0040E001, "HL7 Instance Identifier", "ST", "1", 0, 0},
    { 0x0040E004, "HL7 Document Effective Time", "DT", "1", 0, 0},
    { 0x0040E006, "HL7 Document Type Code Sequence", "SQ", "1", 0, 0},
    { 0x0040E008, "Document Class Code Sequence", "SQ", "1", 0, 0},
    { 0x0040E010, "Retrieve URI", "UR", "1", 0, 0},
    { 0x0040E011, "Retrieve Location UID", "UI", "1", 0, 0},
    { 0x0040E020, "Type of Instances", "CS", "1", 0, 0},
    { 0x0040E021, "DICOM Retrieval Sequence", "SQ", "1", 0, 0},
    { 0x0040E022, "DICOM Media Retrieval Sequence", "SQ", "1", 0, 0},
    { 0x0040E023, "WADO Retrieval Sequence", "SQ", "1", 0, 0},
    { 0x0040E024, "XDS Retrieval Sequence", "SQ", "1", 0, 0},
    { 0x0040E025, "WADO-RS Retrieval Sequence", "SQ", "1", 0, 0},
    { 0x0040E030, "Repository Unique ID", "UI", "1", 0, 0},
    { 0x0040E031, "Home Community ID", "UI", "1", 0, 0},
    { 0x00420010, "Document Title", "ST", "1", 0, 0},
    { 0x00420011, "Encapsulated Document", "OB", "1", 0, 0},
    { 0x00420012, "MIME Type of Encapsulated Document", "LO", "1", 0, 0},
    { 0x00420013, "Source Instance Sequence", "SQ", "1", 0, 0},
    { 0x00420014, "List of MIME Types", "LO", "1-n", 0, 0},
    { 0x00420015, "Encapsulated Document Length", "UL", "1", 0, 0},
    { 0x00440001, "Product Package Identifier", "ST", "1", 0, 0},
    { 0x00440002, "Substance Administration Approval", "CS", "1", 0, 0},
    { 0x00440003, "Approval Status Further Description", "LT", "1", 0, 0},
    { 0x00440004, "Approval Status DateTime", "DT", "1", 0, 0},
    { 0x00440007, "Product Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00440008, "Product Name", "LO", "1-n", 0, 0},
    { 0x00440009, "Product Description", "LT", "1", 0, 0},
    { 0x0044000A, "Product Lot Identifier", "LO", "1", 0, 0},
    { 0x0044000B, "Product Expiration DateTime", "DT", "1", 0, 0},
    { 0x00440010, "Substance Administration DateTime", "DT", "1", 0, 0},
    { 0x00440011, "Substance Administration Notes", "LO", "1", 0, 0},
    { 0x00440012, "Substance Administration Device ID", "LO", "1", 0, 0},
    { 0x00440013, "Product Parameter Sequence", "SQ", "1", 0, 0},
    { 0x00440019, "Substance Administration Parameter Sequence", "SQ", "1", 0, 0},
    { 0x00440100, "Approval Sequence", "SQ", "1", 0, 0},
    { 0x00440101, "Assertion Code Sequence", "SQ", "1", 0, 0},
    { 0x00440102, "Assertion UID", "UI", "1", 0, 0},
    { 0x00440103, "Asserter Identification Sequence", "SQ", "1", 0, 0},
    { 0x00440104, "Assertion DateTime", "DT", "1", 0, 0},
    { 0x00440105, "Assertion Expiration DateTime", "DT", "1", 0, 0},
    { 0x00440106, "Assertion Comments", "UT", "1", 0, 0},
    { 0x00440107, "Related Assertion Sequence", "SQ", "1", 0, 0},
    { 0x00440108, "Referenced Assertion UID", "UI", "1", 0, 0},
    { 0x00440109, "Approval Subject Sequence", "SQ", "1", 0, 0},
    { 0x0044010A, "Organizational Role Code Sequence", "SQ", "1", 0, 0},
    { 0x00460012, "Lens Description", "LO", "1", 0, 0},
    { 0x00460014, "Right Lens Sequence", "SQ", "1", 0, 0},
    { 0x00460015, "Left Lens Sequence", "SQ", "1", 0, 0},
    { 0x00460016, "Unspecified Laterality Lens Sequence", "SQ", "1", 0, 0},
    { 0x00460018, "Cylinder Sequence", "SQ", "1", 0, 0},
    { 0x00460028, "Prism Sequence", "SQ", "1", 0, 0},
    { 0x00460030, "Horizontal Prism Power", "FD", "1", 0, 0},
    { 0x00460032, "Horizontal Prism Base", "CS", "1", 0, 0},
    { 0x00460034, "Vertical Prism Power", "FD", "1", 0, 0},
    { 0x00460036, "Vertical Prism Base", "CS", "1", 0, 0},
    { 0x00460038, "Lens Segment Type", "CS", "1", 0, 0},
    { 0x00460040, "Optical Transmittance", "FD", "1", 0, 0},
    { 0x00460042, "Channel Width", "FD", "1", 0, 0},
    { 0x00460044, "Pupil Size", "FD", "1", 0, 0},
    { 0x00460046, "Corneal Size", "FD", "1", 0, 0},
    { 0x00460047, "Corneal Size Sequence", "SQ", "1", 0, 0},
    { 0x00460050, "Autorefraction Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460052, "Autorefraction Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460060, "Distance Pupillary Distance", "FD", "1", 0, 0},
    { 0x00460062, "Near Pupillary Distance", "FD", "1", 0, 0},
    { 0x00460063, "Intermediate Pupillary Distance", "FD", "1", 0, 0},
    { 0x00460064, "Other Pupillary Distance", "FD", "1", 0, 0},
    { 0x00460070, "Keratometry Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460071, "Keratometry Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460074, "Steep Keratometric Axis Sequence", "SQ", "1", 0, 0},
    { 0x00460075, "Radius of Curvature", "FD", "1", 0, 0},
    { 0x00460076, "Keratometric Power", "FD", "1", 0, 0},
    { 0x00460077, "Keratometric Axis", "FD", "1", 0, 0},
    { 0x00460080, "Flat Keratometric Axis Sequence", "SQ", "1", 0, 0},
    { 0x00460092, "Background Color", "CS", "1", 0, 0},
    { 0x00460094, "Optotype", "CS", "1", 0, 0},
    { 0x00460095, "Optotype Presentation", "CS", "1", 0, 0},
    { 0x00460097, "Subjective Refraction Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460098, "Subjective Refraction Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460100, "Add Near Sequence", "SQ", "1", 0, 0},
    { 0x00460101, "Add Intermediate Sequence", "SQ", "1", 0, 0},
    { 0x00460102, "Add Other Sequence", "SQ", "1", 0, 0},
    { 0x00460104, "Add Power", "FD", "1", 0, 0},
    { 0x00460106, "Viewing Distance", "FD", "1", 0, 0},
    { 0x00460110, "Cornea Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00460111, "Source of Cornea Measurement Data Code Sequence", "SQ", "1", 0, 0},
    { 0x00460112, "Steep Corneal Axis Sequence", "SQ", "1", 0, 0},
    { 0x00460113, "Flat Corneal Axis Sequence", "SQ", "1", 0, 0},
    { 0x00460114, "Corneal Power", "FD", "1", 0, 0},
    { 0x00460115, "Corneal Axis", "FD", "1", 0, 0},
    { 0x00460116, "Cornea Measurement Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00460117, "Refractive Index of Cornea", "FL", "1", 0, 0},
    { 0x00460118, "Refractive Index of Aqueous Humor", "FL", "1", 0, 0},
    { 0x00460121, "Visual Acuity Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00460122, "Visual Acuity Right Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460123, "Visual Acuity Left Eye Sequence", "SQ", "1", 0, 0},
    { 0x00460124, "Visual Acuity Both Eyes Open Sequence", "SQ", "1", 0, 0},
    { 0x00460125, "Viewing Distance Type", "CS", "1", 0, 0},
    { 0x00460135, "Visual Acuity Modifiers", "SS", "2", 0, 0},
    { 0x00460137, "Decimal Visual Acuity", "FD", "1", 0, 0},
    { 0x00460139, "Optotype Detailed Definition", "LO", "1", 0, 0},
    { 0x00460145, "Referenced Refractive Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00460146, "Sphere Power", "FD", "1", 0, 0},
    { 0x00460147, "Cylinder Power", "FD", "1", 0, 0},
    { 0x00460201, "Corneal Topography Surface", "CS", "1", 0, 0},
    { 0x00460202, "Corneal Vertex Location", "FL", "2", 0, 0},
    { 0x00460203, "Pupil Centroid X-Coordinate", "FL", "1", 0, 0},
    { 0x00460204, "Pupil Centroid Y-Coordinate", "FL", "1", 0, 0},
    { 0x00460205, "Equivalent Pupil Radius", "FL", "1", 0, 0},
    { 0x00460207, "Corneal Topography Map Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00460208, "Vertices of the Outline of Pupil", "IS", "2-2n", 0, 0},
    { 0x00460210, "Corneal Topography Mapping Normals Sequence", "SQ", "1", 0, 0},
    { 0x00460211, "Maximum Corneal Curvature Sequence", "SQ", "1", 0, 0},
    { 0x00460212, "Maximum Corneal Curvature", "FL", "1", 0, 0},
    { 0x00460213, "Maximum Corneal Curvature Location", "FL", "2", 0, 0},
    { 0x00460215, "Minimum Keratometric Sequence", "SQ", "1", 0, 0},
    { 0x00460218, "Simulated Keratometric Cylinder Sequence", "SQ", "1", 0, 0},
    { 0x00460220, "Average Corneal Power", "FL", "1", 0, 0},
    { 0x00460224, "Corneal I-S Value", "FL", "1", 0, 0},
    { 0x00460227, "Analyzed Area", "FL", "1", 0, 0},
    { 0x00460230, "Surface Regularity Index", "FL", "1", 0, 0},
    { 0x00460232, "Surface Asymmetry Index", "FL", "1", 0, 0},
    { 0x00460234, "Corneal Eccentricity Index", "FL", "1", 0, 0},
    { 0x00460236, "Keratoconus Prediction Index", "FL", "1", 0, 0},
    { 0x00460238, "Decimal Potential Visual Acuity", "FL", "1", 0, 0},
    { 0x00460242, "Corneal Topography Map Quality Evaluation", "CS", "1", 0, 0},
    { 0x00460244, "Source Image Corneal Processed Data Sequence", "SQ", "1", 0, 0},
    { 0x00460247, "Corneal Point Location", "FL", "3", 0, 0},
    { 0x00460248, "Corneal Point Estimated", "CS", "1", 0, 0},
    { 0x00460249, "Axial Power", "FL", "1", 0, 0},
    { 0x00460250, "Tangential Power", "FL", "1", 0, 0},
    { 0x00460251, "Refractive Power", "FL", "1", 0, 0},
    { 0x00460252, "Relative Elevation", "FL", "1", 0, 0},
    { 0x00460253, "Corneal Wavefront", "FL", "1", 0, 0},
    { 0x00480001, "Imaged Volume Width", "FL", "1", 0, 0},
    { 0x00480002, "Imaged Volume Height", "FL", "1", 0, 0},
    { 0x00480003, "Imaged Volume Depth", "FL", "1", 0, 0},
    { 0x00480006, "Total Pixel Matrix Columns", "UL", "1", 0, 0},
    { 0x00480007, "Total Pixel Matrix Rows", "UL", "1", 0, 0},
    { 0x00480008, "Total Pixel Matrix Origin Sequence", "SQ", "1", 0, 0},
    { 0x00480010, "Specimen Label in Image", "CS", "1", 0, 0},
    { 0x00480011, "Focus Method", "CS", "1", 0, 0},
    { 0x00480012, "Extended Depth of Field", "CS", "1", 0, 0},
    { 0x00480013, "Number of Focal Planes", "US", "1", 0, 0},
    { 0x00480014, "Distance Between Focal Planes", "FL", "1", 0, 0},
    { 0x00480015, "Recommended Absent Pixel CIELab Value", "US", "3", 0, 0},
    { 0x00480100, "Illuminator Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00480102, "Image Orientation (Slide)", "DS", "6", 0, 0},
    { 0x00480105, "Optical Path Sequence", "SQ", "1", 0, 0},
    { 0x00480106, "Optical Path Identifier", "SH", "1", 0, 0},
    { 0x00480107, "Optical Path Description", "ST", "1", 0, 0},
    { 0x00480108, "Illumination Color Code Sequence", "SQ", "1", 0, 0},
    { 0x00480110, "Specimen Reference Sequence", "SQ", "1", 0, 0},
    { 0x00480111, "Condenser Lens Power", "DS", "1", 0, 0},
    { 0x00480112, "Objective Lens Power", "DS", "1", 0, 0},
    { 0x00480113, "Objective Lens Numerical Aperture", "DS", "1", 0, 0},
    { 0x00480120, "Palette Color Lookup Table Sequence", "SQ", "1", 0, 0},
    { 0x00480200, "Referenced Image Navigation Sequence", "SQ", "1", 0, 0},
    { 0x00480201, "Top Left Hand Corner of Localizer Area", "US", "2", 0, 0},
    { 0x00480202, "Bottom Right Hand Corner of Localizer Area", "US", "2", 0, 0},
    { 0x00480207, "Optical Path Identification Sequence", "SQ", "1", 0, 0},
    { 0x0048021A, "Plane Position (Slide) Sequence", "SQ", "1", 0, 0},
    { 0x0048021E, "Column Position In Total Image Pixel Matrix", "SL", "1", 0, 0},
    { 0x0048021F, "Row Position In Total Image Pixel Matrix", "SL", "1", 0, 0},
    { 0x00480301, "Pixel Origin Interpretation", "CS", "1", 0, 0},
    { 0x00480302, "Number of Optical Paths", "UL", "1", 0, 0},
    { 0x00480303, "Total Pixel Matrix Focal Planes", "UL", "1", 0, 0},
    { 0x00500004, "Calibration Image", "CS", "1", 0, 0},
    { 0x00500010, "Device Sequence", "SQ", "1", 0, 0},
    { 0x00500012, "Container Component Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00500013, "Container Component Thickness", "FD", "1", 0, 0},
    { 0x00500014, "Device Length", "DS", "1", 0, 0},
    { 0x00500015, "Container Component Width", "FD", "1", 0, 0},
    { 0x00500016, "Device Diameter", "DS", "1", 0, 0},
    { 0x00500017, "Device Diameter Units", "CS", "1", 0, 0},
    { 0x00500018, "Device Volume", "DS", "1", 0, 0},
    { 0x00500019, "Inter-Marker Distance", "DS", "1", 0, 0},
    { 0x0050001A, "Container Component Material", "CS", "1", 0, 0},
    { 0x0050001B, "Container Component ID", "LO", "1", 0, 0},
    { 0x0050001C, "Container Component Length", "FD", "1", 0, 0},
    { 0x0050001D, "Container Component Diameter", "FD", "1", 0, 0},
    { 0x0050001E, "Container Component Description", "LO", "1", 0, 0},
    { 0x00500020, "Device Description", "LO", "1", 0, 0},
    { 0x00500021, "Long Device Description", "ST", "1", 0, 0},
    { 0x00520001, "Contrast/Bolus Ingredient Percent by Volume", "FL", "1", 0, 0},
    { 0x00520002, "OCT Focal Distance", "FD", "1", 0, 0},
    { 0x00520003, "Beam Spot Size", "FD", "1", 0, 0},
    { 0x00520004, "Effective Refractive Index", "FD", "1", 0, 0},
    { 0x00520006, "OCT Acquisition Domain", "CS", "1", 0, 0},
    { 0x00520007, "OCT Optical Center Wavelength", "FD", "1", 0, 0},
    { 0x00520008, "Axial Resolution", "FD", "1", 0, 0},
    { 0x00520009, "Ranging Depth", "FD", "1", 0, 0},
    { 0x00520011, "A-line Rate", "FD", "1", 0, 0},
    { 0x00520012, "A-lines Per Frame", "US", "1", 0, 0},
    { 0x00520013, "Catheter Rotational Rate", "FD", "1", 0, 0},
    { 0x00520014, "A-line Pixel Spacing", "FD", "1", 0, 0},
    { 0x00520016, "Mode of Percutaneous Access Sequence", "SQ", "1", 0, 0},
    { 0x00520025, "Intravascular OCT Frame Type Sequence", "SQ", "1", 0, 0},
    { 0x00520026, "OCT Z Offset Applied", "CS", "1", 0, 0},
    { 0x00520027, "Intravascular Frame Content Sequence", "SQ", "1", 0, 0},
    { 0x00520028, "Intravascular Longitudinal Distance", "FD", "1", 0, 0},
    { 0x00520029, "Intravascular OCT Frame Content Sequence", "SQ", "1", 0, 0},
    { 0x00520030, "OCT Z Offset Correction", "SS", "1", 0, 0},
    { 0x00520031, "Catheter Direction of Rotation", "CS", "1", 0, 0},
    { 0x00520033, "Seam Line Location", "FD", "1", 0, 0},
    { 0x00520034, "First A-line Location", "FD", "1", 0, 0},
    { 0x00520036, "Seam Line Index", "US", "1", 0, 0},
    { 0x00520038, "Number of Padded A-lines", "US", "1", 0, 0},
    { 0x00520039, "Interpolation Type", "CS", "1", 0, 0},
    { 0x0052003A, "Refractive Index Applied", "CS", "1", 0, 0},
    { 0x00540010, "Energy Window Vector", "US", "1-n", 0, 0},
    { 0x00540011, "Number of Energy Windows", "US", "1", 0, 0},
    { 0x00540012, "Energy Window Information Sequence", "SQ", "1", 0, 0},
    { 0x00540013, "Energy Window Range Sequence", "SQ", "1", 0, 0},
    { 0x00540014, "Energy Window Lower Limit", "DS", "1", 0, 0},
    { 0x00540015, "Energy Window Upper Limit", "DS", "1", 0, 0},
    { 0x00540016, "Radiopharmaceutical Information Sequence", "SQ", "1", 0, 0},
    { 0x00540017, "Residual Syringe Counts", "IS", "1", 0, 0},
    { 0x00540018, "Energy Window Name", "SH", "1", 0, 0},
    { 0x00540020, "Detector Vector", "US", "1-n", 0, 0},
    { 0x00540021, "Number of Detectors", "US", "1", 0, 0},
    { 0x00540022, "Detector Information Sequence", "SQ", "1", 0, 0},
    { 0x00540030, "Phase Vector", "US", "1-n", 0, 0},
    { 0x00540031, "Number of Phases", "US", "1", 0, 0},
    { 0x00540032, "Phase Information Sequence", "SQ", "1", 0, 0},
    { 0x00540033, "Number of Frames in Phase", "US", "1", 0, 0},
    { 0x00540036, "Phase Delay", "IS", "1", 0, 0},
    { 0x00540038, "Pause Between Frames", "IS", "1", 0, 0},
    { 0x00540039, "Phase Description", "CS", "1", 0, 0},
    { 0x00540050, "Rotation Vector", "US", "1-n", 0, 0},
    { 0x00540051, "Number of Rotations", "US", "1", 0, 0},
    { 0x00540052, "Rotation Information Sequence", "SQ", "1", 0, 0},
    { 0x00540053, "Number of Frames in Rotation", "US", "1", 0, 0},
    { 0x00540060, "R-R Interval Vector", "US", "1-n", 0, 0},
    { 0x00540061, "Number of R-R Intervals", "US", "1", 0, 0},
    { 0x00540062, "Gated Information Sequence", "SQ", "1", 0, 0},
    { 0x00540063, "Data Information Sequence", "SQ", "1", 0, 0},
    { 0x00540070, "Time Slot Vector", "US", "1-n", 0, 0},
    { 0x00540071, "Number of Time Slots", "US", "1", 0, 0},
    { 0x00540072, "Time Slot Information Sequence", "SQ", "1", 0, 0},
    { 0x00540073, "Time Slot Time", "DS", "1", 0, 0},
    { 0x00540080, "Slice Vector", "US", "1-n", 0, 0},
    { 0x00540081, "Number of Slices", "US", "1", 0, 0},
    { 0x00540090, "Angular View Vector", "US", "1-n", 0, 0},
    { 0x00540100, "Time Slice Vector", "US", "1-n", 0, 0},
    { 0x00540101, "Number of Time Slices", "US", "1", 0, 0},
    { 0x00540200, "Start Angle", "DS", "1", 0, 0},
    { 0x00540202, "Type of Detector Motion", "CS", "1", 0, 0},
    { 0x00540210, "Trigger Vector", "IS", "1-n", 0, 0},
    { 0x00540211, "Number of Triggers in Phase", "US", "1", 0, 0},
    { 0x00540220, "View Code Sequence", "SQ", "1", 0, 0},
    { 0x00540222, "View Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x00540300, "Radionuclide Code Sequence", "SQ", "1", 0, 0},
    { 0x00540302, "Administration Route Code Sequence", "SQ", "1", 0, 0},
    { 0x00540304, "Radiopharmaceutical Code Sequence", "SQ", "1", 0, 0},
    { 0x00540306, "Calibration Data Sequence", "SQ", "1", 0, 0},
    { 0x00540308, "Energy Window Number", "US", "1", 0, 0},
    { 0x00540400, "Image ID", "SH", "1", 0, 0},
    { 0x00540410, "Patient Orientation Code Sequence", "SQ", "1", 0, 0},
    { 0x00540412, "Patient Orientation Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x00540414, "Patient Gantry Relationship Code Sequence", "SQ", "1", 0, 0},
    { 0x00540500, "Slice Progression Direction", "CS", "1", 0, 0},
    { 0x00540501, "Scan Progression Direction", "CS", "1", 0, 0},
    { 0x00541000, "Series Type", "CS", "2", 0, 0},
    { 0x00541001, "Units", "CS", "1", 0, 0},
    { 0x00541002, "Counts Source", "CS", "1", 0, 0},
    { 0x00541004, "Reprojection Method", "CS", "1", 0, 0},
    { 0x00541006, "SUV Type", "CS", "1", 0, 0},
    { 0x00541100, "Randoms Correction Method", "CS", "1", 0, 0},
    { 0x00541101, "Attenuation Correction Method", "LO", "1", 0, 0},
    { 0x00541102, "Decay Correction", "CS", "1", 0, 0},
    { 0x00541103, "Reconstruction Method", "LO", "1", 0, 0},
    { 0x00541104, "Detector Lines of Response Used", "LO", "1", 0, 0},
    { 0x00541105, "Scatter Correction Method", "LO", "1", 0, 0},
    { 0x00541200, "Axial Acceptance", "DS", "1", 0, 0},
    { 0x00541201, "Axial Mash", "IS", "2", 0, 0},
    { 0x00541202, "Transverse Mash", "IS", "1", 0, 0},
    { 0x00541203, "Detector Element Size", "DS", "2", 0, 0},
    { 0x00541210, "Coincidence Window Width", "DS", "1", 0, 0},
    { 0x00541220, "Secondary Counts Type", "CS", "1-n", 0, 0},
    { 0x00541300, "Frame Reference Time", "DS", "1", 0, 0},
    { 0x00541310, "Primary (Prompts) Counts Accumulated", "IS", "1", 0, 0},
    { 0x00541311, "Secondary Counts Accumulated", "IS", "1-n", 0, 0},
    { 0x00541320, "Slice Sensitivity Factor", "DS", "1", 0, 0},
    { 0x00541321, "Decay Factor", "DS", "1", 0, 0},
    { 0x00541322, "Dose Calibration Factor", "DS", "1", 0, 0},
    { 0x00541323, "Scatter Fraction Factor", "DS", "1", 0, 0},
    { 0x00541324, "Dead Time Factor", "DS", "1", 0, 0},
    { 0x00541330, "Image Index", "US", "1", 0, 0},
    { 0x00541400, "Counts Included", "CS", "1-n", -1, 0},
    { 0x00541401, "Dead Time Correction Flag", "CS", "1", -1, 0},
    { 0x00603000, "Histogram Sequence", "SQ", "1", 0, 0},
    { 0x00603002, "Histogram Number of Bins", "US", "1", 0, 0},
    { 0x00603004, "Histogram First Bin Value", "US or SS", "1", 0, 0},
    { 0x00603006, "Histogram Last Bin Value", "US or SS", "1", 0, 0},
    { 0x00603008, "Histogram Bin Width", "US", "1", 0, 0},
    { 0x00603010, "Histogram Explanation", "LO", "1", 0, 0},
    { 0x00603020, "Histogram Data", "UL", "1-n", 0, 0},
    { 0x00620001, "Segmentation Type", "CS", "1", 0, 0},
    { 0x00620002, "Segment Sequence", "SQ", "1", 0, 0},
    { 0x00620003, "Segmented Property Category Code Sequence", "SQ", "1", 0, 0},
    { 0x00620004, "Segment Number", "US", "1", 0, 0},
    { 0x00620005, "Segment Label", "LO", "1", 0, 0},
    { 0x00620006, "Segment Description", "ST", "1", 0, 0},
    { 0x00620007, "Segmentation Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x00620008, "Segment Algorithm Type", "CS", "1", 0, 0},
    { 0x00620009, "Segment Algorithm Name", "LO", "1", 0, 0},
    { 0x0062000A, "Segment Identification Sequence", "SQ", "1", 0, 0},
    { 0x0062000B, "Referenced Segment Number", "US", "1-n", 0, 0},
    { 0x0062000C, "Recommended Display Grayscale Value", "US", "1", 0, 0},
    { 0x0062000D, "Recommended Display CIELab Value", "US", "3", 0, 0},
    { 0x0062000E, "Maximum Fractional Value", "US", "1", 0, 0},
    { 0x0062000F, "Segmented Property Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00620010, "Segmentation Fractional Type", "CS", "1", 0, 0},
    { 0x00620011, "Segmented Property Type Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x00620012, "Used Segments Sequence", "SQ", "1", 0, 0},
    { 0x00620013, "Segments Overlap", "CS", "1", 0, 0},
    { 0x00620020, "Tracking ID", "UT", "1", 0, 0},
    { 0x00620021, "Tracking UID", "UI", "1", 0, 0},
    { 0x00640002, "Deformable Registration Sequence", "SQ", "1", 0, 0},
    { 0x00640003, "Source Frame of Reference UID", "UI", "1", 0, 0},
    { 0x00640005, "Deformable Registration Grid Sequence", "SQ", "1", 0, 0},
    { 0x00640007, "Grid Dimensions", "UL", "3", 0, 0},
    { 0x00640008, "Grid Resolution", "FD", "3", 0, 0},
    { 0x00640009, "Vector Grid Data", "OF", "1", 0, 0},
    { 0x0064000F, "Pre Deformation Matrix Registration Sequence", "SQ", "1", 0, 0},
    { 0x00640010, "Post Deformation Matrix Registration Sequence", "SQ", "1", 0, 0},
    { 0x00660001, "Number of Surfaces", "UL", "1", 0, 0},
    { 0x00660002, "Surface Sequence", "SQ", "1", 0, 0},
    { 0x00660003, "Surface Number", "UL", "1", 0, 0},
    { 0x00660004, "Surface Comments", "LT", "1", 0, 0},
    { 0x00660009, "Surface Processing", "CS", "1", 0, 0},
    { 0x0066000A, "Surface Processing Ratio", "FL", "1", 0, 0},
    { 0x0066000B, "Surface Processing Description", "LO", "1", 0, 0},
    { 0x0066000C, "Recommended Presentation Opacity", "FL", "1", 0, 0},
    { 0x0066000D, "Recommended Presentation Type", "CS", "1", 0, 0},
    { 0x0066000E, "Finite Volume", "CS", "1", 0, 0},
    { 0x00660010, "Manifold", "CS", "1", 0, 0},
    { 0x00660011, "Surface Points Sequence", "SQ", "1", 0, 0},
    { 0x00660012, "Surface Points Normals Sequence", "SQ", "1", 0, 0},
    { 0x00660013, "Surface Mesh Primitives Sequence", "SQ", "1", 0, 0},
    { 0x00660015, "Number of Surface Points", "UL", "1", 0, 0},
    { 0x00660016, "Point Coordinates Data", "OF", "1", 0, 0},
    { 0x00660017, "Point Position Accuracy", "FL", "3", 0, 0},
    { 0x00660018, "Mean Point Distance", "FL", "1", 0, 0},
    { 0x00660019, "Maximum Point Distance", "FL", "1", 0, 0},
    { 0x0066001A, "Points Bounding Box Coordinates", "FL", "6", 0, 0},
    { 0x0066001B, "Axis of Rotation", "FL", "3", 0, 0},
    { 0x0066001C, "Center of Rotation", "FL", "3", 0, 0},
    { 0x0066001E, "Number of Vectors", "UL", "1", 0, 0},
    { 0x0066001F, "Vector Dimensionality", "US", "1", 0, 0},
    { 0x00660020, "Vector Accuracy", "FL", "1-n", 0, 0},
    { 0x00660021, "Vector Coordinate Data", "OF", "1", 0, 0},
    { 0x00660023, "Triangle Point Index List", "OW", "1", -1, 0},
    { 0x00660024, "Edge Point Index List", "OW", "1", -1, 0},
    { 0x00660025, "Vertex Point Index List", "OW", "1", -1, 0},
    { 0x00660026, "Triangle Strip Sequence", "SQ", "1", 0, 0},
    { 0x00660027, "Triangle Fan Sequence", "SQ", "1", 0, 0},
    { 0x00660028, "Line Sequence", "SQ", "1", 0, 0},
    { 0x00660029, "Primitive Point Index List", "OW", "1", -1, 0},
    { 0x0066002A, "Surface Count", "UL", "1", 0, 0},
    { 0x0066002B, "Referenced Surface Sequence", "SQ", "1", 0, 0},
    { 0x0066002C, "Referenced Surface Number", "UL", "1", 0, 0},
    { 0x0066002D, "Segment Surface Generation Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x0066002E, "Segment Surface Source Instance Sequence", "SQ", "1", 0, 0},
    { 0x0066002F, "Algorithm Family Code Sequence", "SQ", "1", 0, 0},
    { 0x00660030, "Algorithm Name Code Sequence", "SQ", "1", 0, 0},
    { 0x00660031, "Algorithm Version", "LO", "1", 0, 0},
    { 0x00660032, "Algorithm Parameters", "LT", "1", 0, 0},
    { 0x00660034, "Facet Sequence", "SQ", "1", 0, 0},
    { 0x00660035, "Surface Processing Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x00660036, "Algorithm Name", "LO", "1", 0, 0},
    { 0x00660037, "Recommended Point Radius", "FL", "1", 0, 0},
    { 0x00660038, "Recommended Line Thickness", "FL", "1", 0, 0},
    { 0x00660040, "Long Primitive Point Index List", "OL", "1", 0, 0},
    { 0x00660041, "Long Triangle Point Index List", "OL", "1", 0, 0},
    { 0x00660042, "Long Edge Point Index List", "OL", "1", 0, 0},
    { 0x00660043, "Long Vertex Point Index List", "OL", "1", 0, 0},
    { 0x00660101, "Track Set Sequence", "SQ", "1", 0, 0},
    { 0x00660102, "Track Sequence", "SQ", "1", 0, 0},
    { 0x00660103, "Recommended Display CIELab Value List", "OW", "1", 0, 0},
    { 0x00660104, "Tracking Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x00660105, "Track Set Number", "UL", "1", 0, 0},
    { 0x00660106, "Track Set Label", "LO", "1", 0, 0},
    { 0x00660107, "Track Set Description", "UT", "1", 0, 0},
    { 0x00660108, "Track Set Anatomical Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00660121, "Measurements Sequence", "SQ", "1", 0, 0},
    { 0x00660124, "Track Set Statistics Sequence", "SQ", "1", 0, 0},
    { 0x00660125, "Floating Point Values", "OF", "1", 0, 0},
    { 0x00660129, "Track Point Index List", "OL", "1", 0, 0},
    { 0x00660130, "Track Statistics Sequence", "SQ", "1", 0, 0},
    { 0x00660132, "Measurement Values Sequence", "SQ", "1", 0, 0},
    { 0x00660133, "Diffusion Acquisition Code Sequence", "SQ", "1", 0, 0},
    { 0x00660134, "Diffusion Model Code Sequence", "SQ", "1", 0, 0},
    { 0x00686210, "Implant Size", "LO", "1", 0, 0},
    { 0x00686221, "Implant Template Version", "LO", "1", 0, 0},
    { 0x00686222, "Replaced Implant Template Sequence", "SQ", "1", 0, 0},
    { 0x00686223, "Implant Type", "CS", "1", 0, 0},
    { 0x00686224, "Derivation Implant Template Sequence", "SQ", "1", 0, 0},
    { 0x00686225, "Original Implant Template Sequence", "SQ", "1", 0, 0},
    { 0x00686226, "Effective DateTime", "DT", "1", 0, 0},
    { 0x00686230, "Implant Target Anatomy Sequence", "SQ", "1", 0, 0},
    { 0x00686260, "Information From Manufacturer Sequence", "SQ", "1", 0, 0},
    { 0x00686265, "Notification From Manufacturer Sequence", "SQ", "1", 0, 0},
    { 0x00686270, "Information Issue DateTime", "DT", "1", 0, 0},
    { 0x00686280, "Information Summary", "ST", "1", 0, 0},
    { 0x006862A0, "Implant Regulatory Disapproval Code Sequence", "SQ", "1", 0, 0},
    { 0x006862A5, "Overall Template Spatial Tolerance", "FD", "1", 0, 0},
    { 0x006862C0, "HPGL Document Sequence", "SQ", "1", 0, 0},
    { 0x006862D0, "HPGL Document ID", "US", "1", 0, 0},
    { 0x006862D5, "HPGL Document Label", "LO", "1", 0, 0},
    { 0x006862E0, "View Orientation Code Sequence", "SQ", "1", 0, 0},
    { 0x006862F0, "View Orientation Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x006862F2, "HPGL Document Scaling", "FD", "1", 0, 0},
    { 0x00686300, "HPGL Document", "OB", "1", 0, 0},
    { 0x00686310, "HPGL Contour Pen Number", "US", "1", 0, 0},
    { 0x00686320, "HPGL Pen Sequence", "SQ", "1", 0, 0},
    { 0x00686330, "HPGL Pen Number", "US", "1", 0, 0},
    { 0x00686340, "HPGL Pen Label", "LO", "1", 0, 0},
    { 0x00686345, "HPGL Pen Description", "ST", "1", 0, 0},
    { 0x00686346, "Recommended Rotation Point", "FD", "2", 0, 0},
    { 0x00686347, "Bounding Rectangle", "FD", "4", 0, 0},
    { 0x00686350, "Implant Template 3D Model Surface Number", "US", "1-n", 0, 0},
    { 0x00686360, "Surface Model Description Sequence", "SQ", "1", 0, 0},
    { 0x00686380, "Surface Model Label", "LO", "1", 0, 0},
    { 0x00686390, "Surface Model Scaling Factor", "FD", "1", 0, 0},
    { 0x006863A0, "Materials Code Sequence", "SQ", "1", 0, 0},
    { 0x006863A4, "Coating Materials Code Sequence", "SQ", "1", 0, 0},
    { 0x006863A8, "Implant Type Code Sequence", "SQ", "1", 0, 0},
    { 0x006863AC, "Fixation Method Code Sequence", "SQ", "1", 0, 0},
    { 0x006863B0, "Mating Feature Sets Sequence", "SQ", "1", 0, 0},
    { 0x006863C0, "Mating Feature Set ID", "US", "1", 0, 0},
    { 0x006863D0, "Mating Feature Set Label", "LO", "1", 0, 0},
    { 0x006863E0, "Mating Feature Sequence", "SQ", "1", 0, 0},
    { 0x006863F0, "Mating Feature ID", "US", "1", 0, 0},
    { 0x00686400, "Mating Feature Degree of Freedom Sequence", "SQ", "1", 0, 0},
    { 0x00686410, "Degree of Freedom ID", "US", "1", 0, 0},
    { 0x00686420, "Degree of Freedom Type", "CS", "1", 0, 0},
    { 0x00686430, "2D Mating Feature Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x00686440, "Referenced HPGL Document ID", "US", "1", 0, 0},
    { 0x00686450, "2D Mating Point", "FD", "2", 0, 0},
    { 0x00686460, "2D Mating Axes", "FD", "4", 0, 0},
    { 0x00686470, "2D Degree of Freedom Sequence", "SQ", "1", 0, 0},
    { 0x00686490, "3D Degree of Freedom Axis", "FD", "3", 0, 0},
    { 0x006864A0, "Range of Freedom", "FD", "2", 0, 0},
    { 0x006864C0, "3D Mating Point", "FD", "3", 0, 0},
    { 0x006864D0, "3D Mating Axes", "FD", "9", 0, 0},
    { 0x006864F0, "2D Degree of Freedom Axis", "FD", "3", 0, 0},
    { 0x00686500, "Planning Landmark Point Sequence", "SQ", "1", 0, 0},
    { 0x00686510, "Planning Landmark Line Sequence", "SQ", "1", 0, 0},
    { 0x00686520, "Planning Landmark Plane Sequence", "SQ", "1", 0, 0},
    { 0x00686530, "Planning Landmark ID", "US", "1", 0, 0},
    { 0x00686540, "Planning Landmark Description", "LO", "1", 0, 0},
    { 0x00686545, "Planning Landmark Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x00686550, "2D Point Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x00686560, "2D Point Coordinates", "FD", "2", 0, 0},
    { 0x00686590, "3D Point Coordinates", "FD", "3", 0, 0},
    { 0x006865A0, "2D Line Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x006865B0, "2D Line Coordinates", "FD", "4", 0, 0},
    { 0x006865D0, "3D Line Coordinates", "FD", "6", 0, 0},
    { 0x006865E0, "2D Plane Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x006865F0, "2D Plane Intersection", "FD", "4", 0, 0},
    { 0x00686610, "3D Plane Origin", "FD", "3", 0, 0},
    { 0x00686620, "3D Plane Normal", "FD", "3", 0, 0},
    { 0x00687001, "Model Modification", "CS", "1", 0, 0},
    { 0x00687002, "Model Mirroring", "CS", "1", 0, 0},
    { 0x00687003, "Model Usage Code Sequence", "SQ", "1", 0, 0},
    { 0x00700001, "Graphic Annotation Sequence", "SQ", "1", 0, 0},
    { 0x00700002, "Graphic Layer", "CS", "1", 0, 0},
    { 0x00700003, "Bounding Box Annotation Units", "CS", "1", 0, 0},
    { 0x00700004, "Anchor Point Annotation Units", "CS", "1", 0, 0},
    { 0x00700005, "Graphic Annotation Units", "CS", "1", 0, 0},
    { 0x00700006, "Unformatted Text Value", "ST", "1", 0, 0},
    { 0x00700008, "Text Object Sequence", "SQ", "1", 0, 0},
    { 0x00700009, "Graphic Object Sequence", "SQ", "1", 0, 0},
    { 0x00700010, "Bounding Box Top Left Hand Corner", "FL", "2", 0, 0},
    { 0x00700011, "Bounding Box Bottom Right Hand Corner", "FL", "2", 0, 0},
    { 0x00700012, "Bounding Box Text Horizontal Justification", "CS", "1", 0, 0},
    { 0x00700014, "Anchor Point", "FL", "2", 0, 0},
    { 0x00700015, "Anchor Point Visibility", "CS", "1", 0, 0},
    { 0x00700020, "Graphic Dimensions", "US", "1", 0, 0},
    { 0x00700021, "Number of Graphic Points", "US", "1", 0, 0},
    { 0x00700022, "Graphic Data", "FL", "2-n", 0, 0},
    { 0x00700023, "Graphic Type", "CS", "1", 0, 0},
    { 0x00700024, "Graphic Filled", "CS", "1", 0, 0},
    { 0x00700040, "Image Rotation (Retired)", "IS", "1", -1, 0},
    { 0x00700041, "Image Horizontal Flip", "CS", "1", 0, 0},
    { 0x00700042, "Image Rotation", "US", "1", 0, 0},
    { 0x00700050, "Displayed Area Top Left Hand Corner (Trial)", "US", "2", -1, 0},
    { 0x00700051, "Displayed Area Bottom Right Hand Corner (Trial)", "US", "2", -1, 0},
    { 0x00700052, "Displayed Area Top Left Hand Corner", "SL", "2", 0, 0},
    { 0x00700053, "Displayed Area Bottom Right Hand Corner", "SL", "2", 0, 0},
    { 0x0070005A, "Displayed Area Selection Sequence", "SQ", "1", 0, 0},
    { 0x00700060, "Graphic Layer Sequence", "SQ", "1", 0, 0},
    { 0x00700062, "Graphic Layer Order", "IS", "1", 0, 0},
    { 0x00700066, "Graphic Layer Recommended Display Grayscale Value", "US", "1", 0, 0},
    { 0x00700067, "Graphic Layer Recommended Display RGB Value", "US", "3", -1, 0},
    { 0x00700068, "Graphic Layer Description", "LO", "1", 0, 0},
    { 0x00700080, "Content Label", "CS", "1", 0, 0},
    { 0x00700081, "Content Description", "LO", "1", 0, 0},
    { 0x00700082, "Presentation Creation Date", "DA", "1", 0, 0},
    { 0x00700083, "Presentation Creation Time", "TM", "1", 0, 0},
    { 0x00700084, "Content Creator's Name", "PN", "1", 0, 0},
    { 0x00700086, "Content Creator's Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x00700087, "Alternate Content Description Sequence", "SQ", "1", 0, 0},
    { 0x00700100, "Presentation Size Mode", "CS", "1", 0, 0},
    { 0x00700101, "Presentation Pixel Spacing", "DS", "2", 0, 0},
    { 0x00700102, "Presentation Pixel Aspect Ratio", "IS", "2", 0, 0},
    { 0x00700103, "Presentation Pixel Magnification Ratio", "FL", "1", 0, 0},
    { 0x00700207, "Graphic Group Label", "LO", "1", 0, 0},
    { 0x00700208, "Graphic Group Description", "ST", "1", 0, 0},
    { 0x00700209, "Compound Graphic Sequence", "SQ", "1", 0, 0},
    { 0x00700226, "Compound Graphic Instance ID", "UL", "1", 0, 0},
    { 0x00700227, "Font Name", "LO", "1", 0, 0},
    { 0x00700228, "Font Name Type", "CS", "1", 0, 0},
    { 0x00700229, "CSS Font Name", "LO", "1", 0, 0},
    { 0x00700230, "Rotation Angle", "FD", "1", 0, 0},
    { 0x00700231, "Text Style Sequence", "SQ", "1", 0, 0},
    { 0x00700232, "Line Style Sequence", "SQ", "1", 0, 0},
    { 0x00700233, "Fill Style Sequence", "SQ", "1", 0, 0},
    { 0x00700234, "Graphic Group Sequence", "SQ", "1", 0, 0},
    { 0x00700241, "Text Color CIELab Value", "US", "3", 0, 0},
    { 0x00700242, "Horizontal Alignment", "CS", "1", 0, 0},
    { 0x00700243, "Vertical Alignment", "CS", "1", 0, 0},
    { 0x00700244, "Shadow Style", "CS", "1", 0, 0},
    { 0x00700245, "Shadow Offset X", "FL", "1", 0, 0},
    { 0x00700246, "Shadow Offset Y", "FL", "1", 0, 0},
    { 0x00700247, "Shadow Color CIELab Value", "US", "3", 0, 0},
    { 0x00700248, "Underlined", "CS", "1", 0, 0},
    { 0x00700249, "Bold", "CS", "1", 0, 0},
    { 0x00700250, "Italic", "CS", "1", 0, 0},
    { 0x00700251, "Pattern On Color CIELab Value", "US", "3", 0, 0},
    { 0x00700252, "Pattern Off Color CIELab Value", "US", "3", 0, 0},
    { 0x00700253, "Line Thickness", "FL", "1", 0, 0},
    { 0x00700254, "Line Dashing Style", "CS", "1", 0, 0},
    { 0x00700255, "Line Pattern", "UL", "1", 0, 0},
    { 0x00700256, "Fill Pattern", "OB", "1", 0, 0},
    { 0x00700257, "Fill Mode", "CS", "1", 0, 0},
    { 0x00700258, "Shadow Opacity", "FL", "1", 0, 0},
    { 0x00700261, "Gap Length", "FL", "1", 0, 0},
    { 0x00700262, "Diameter of Visibility", "FL", "1", 0, 0},
    { 0x00700273, "Rotation Point", "FL", "2", 0, 0},
    { 0x00700274, "Tick Alignment", "CS", "1", 0, 0},
    { 0x00700278, "Show Tick Label", "CS", "1", 0, 0},
    { 0x00700279, "Tick Label Alignment", "CS", "1", 0, 0},
    { 0x00700282, "Compound Graphic Units", "CS", "1", 0, 0},
    { 0x00700284, "Pattern On Opacity", "FL", "1", 0, 0},
    { 0x00700285, "Pattern Off Opacity", "FL", "1", 0, 0},
    { 0x00700287, "Major Ticks Sequence", "SQ", "1", 0, 0},
    { 0x00700288, "Tick Position", "FL", "1", 0, 0},
    { 0x00700289, "Tick Label", "SH", "1", 0, 0},
    { 0x00700294, "Compound Graphic Type", "CS", "1", 0, 0},
    { 0x00700295, "Graphic Group ID", "UL", "1", 0, 0},
    { 0x00700306, "Shape Type", "CS", "1", 0, 0},
    { 0x00700308, "Registration Sequence", "SQ", "1", 0, 0},
    { 0x00700309, "Matrix Registration Sequence", "SQ", "1", 0, 0},
    { 0x0070030A, "Matrix Sequence", "SQ", "1", 0, 0},
    { 0x0070030B, "Frame of Reference to Displayed Coordinate System Transformation Matrix", "FD", "16", 0, 0},
    { 0x0070030C, "Frame of Reference Transformation Matrix Type", "CS", "1", 0, 0},
    { 0x0070030D, "Registration Type Code Sequence", "SQ", "1", 0, 0},
    { 0x0070030F, "Fiducial Description", "ST", "1", 0, 0},
    { 0x00700310, "Fiducial Identifier", "SH", "1", 0, 0},
    { 0x00700311, "Fiducial Identifier Code Sequence", "SQ", "1", 0, 0},
    { 0x00700312, "Contour Uncertainty Radius", "FD", "1", 0, 0},
    { 0x00700314, "Used Fiducials Sequence", "SQ", "1", 0, 0},
    { 0x00700318, "Graphic Coordinates Data Sequence", "SQ", "1", 0, 0},
    { 0x0070031A, "Fiducial UID", "UI", "1", 0, 0},
    { 0x0070031B, "Referenced Fiducial UID", "UI", "1", 0, 0},
    { 0x0070031C, "Fiducial Set Sequence", "SQ", "1", 0, 0},
    { 0x0070031E, "Fiducial Sequence", "SQ", "1", 0, 0},
    { 0x0070031F, "Fiducials Property Category Code Sequence", "SQ", "1", 0, 0},
    { 0x00700401, "Graphic Layer Recommended Display CIELab Value", "US", "3", 0, 0},
    { 0x00700402, "Blending Sequence", "SQ", "1", 0, 0},
    { 0x00700403, "Relative Opacity", "FL", "1", 0, 0},
    { 0x00700404, "Referenced Spatial Registration Sequence", "SQ", "1", 0, 0},
    { 0x00700405, "Blending Position", "CS", "1", 0, 0},
    { 0x00701101, "Presentation Display Collection UID", "UI", "1", 0, 0},
    { 0x00701102, "Presentation Sequence Collection UID", "UI", "1", 0, 0},
    { 0x00701103, "Presentation Sequence Position Index", "US", "1", 0, 0},
    { 0x00701104, "Rendered Image Reference Sequence", "SQ", "1", 0, 0},
    { 0x00701201, "Volumetric Presentation State Input Sequence", "SQ", "1", 0, 0},
    { 0x00701202, "Presentation Input Type", "CS", "1", 0, 0},
    { 0x00701203, "Input Sequence Position Index", "US", "1", 0, 0},
    { 0x00701204, "Crop", "CS", "1", 0, 0},
    { 0x00701205, "Cropping Specification Index", "US", "1-n", 0, 0},
    { 0x00701206, "Compositing Method", "CS", "1", -1, 0},
    { 0x00701207, "Volumetric Presentation Input Number", "US", "1", 0, 0},
    { 0x00701208, "Image Volume Geometry", "CS", "1", 0, 0},
    { 0x00701209, "Volumetric Presentation Input Set UID", "UI", "1", 0, 0},
    { 0x0070120A, "Volumetric Presentation Input Set Sequence", "SQ", "1", 0, 0},
    { 0x0070120B, "Global Crop", "CS", "1", 0, 0},
    { 0x0070120C, "Global Cropping Specification Index", "US", "1-n", 0, 0},
    { 0x0070120D, "Rendering Method", "CS", "1", 0, 0},
    { 0x00701301, "Volume Cropping Sequence", "SQ", "1", 0, 0},
    { 0x00701302, "Volume Cropping Method", "CS", "1", 0, 0},
    { 0x00701303, "Bounding Box Crop", "FD", "6", 0, 0},
    { 0x00701304, "Oblique Cropping Plane Sequence", "SQ", "1", 0, 0},
    { 0x00701305, "Plane", "FD", "4", 0, 0},
    { 0x00701306, "Plane Normal", "FD", "3", 0, 0},
    { 0x00701309, "Cropping Specification Number", "US", "1", 0, 0},
    { 0x00701501, "Multi-Planar Reconstruction Style", "CS", "1", 0, 0},
    { 0x00701502, "MPR Thickness Type", "CS", "1", 0, 0},
    { 0x00701503, "MPR Slab Thickness", "FD", "1", 0, 0},
    { 0x00701505, "MPR Top Left Hand Corner", "FD", "3", 0, 0},
    { 0x00701507, "MPR View Width Direction", "FD", "3", 0, 0},
    { 0x00701508, "MPR View Width", "FD", "1", 0, 0},
    { 0x0070150C, "Number of Volumetric Curve Points", "UL", "1", 0, 0},
    { 0x0070150D, "Volumetric Curve Points", "OD", "1", 0, 0},
    { 0x00701511, "MPR View Height Direction", "FD", "3", 0, 0},
    { 0x00701512, "MPR View Height", "FD", "1", 0, 0},
    { 0x00701602, "Render Projection", "CS", "1", 0, 0},
    { 0x00701603, "Viewpoint Position", "FD", "3", 0, 0},
    { 0x00701604, "Viewpoint LookAt Point", "FD", "3", 0, 0},
    { 0x00701605, "Viewpoint Up Direction", "FD", "3", 0, 0},
    { 0x00701606, "Render Field of View", "FD", "6", 0, 0},
    { 0x00701607, "Sampling Step Size", "FD", "1", 0, 0},
    { 0x00701701, "Shading Style", "CS", "1", 0, 0},
    { 0x00701702, "Ambient Reflection Intensity", "FD", "1", 0, 0},
    { 0x00701703, "Light Direction", "FD", "3", 0, 0},
    { 0x00701704, "Diffuse Reflection Intensity", "FD", "1", 0, 0},
    { 0x00701705, "Specular Reflection Intensity", "FD", "1", 0, 0},
    { 0x00701706, "Shininess", "FD", "1", 0, 0},
    { 0x00701801, "Presentation State Classification Component Sequence", "SQ", "1", 0, 0},
    { 0x00701802, "Component Type", "CS", "1", 0, 0},
    { 0x00701803, "Component Input Sequence", "SQ", "1", 0, 0},
    { 0x00701804, "Volumetric Presentation Input Index", "US", "1", 0, 0},
    { 0x00701805, "Presentation State Compositor Component Sequence", "SQ", "1", 0, 0},
    { 0x00701806, "Weighting Transfer Function Sequence", "SQ", "1", 0, 0},
    { 0x00701807, "Weighting Lookup Table Descriptor", "US", "3", 0, 0},
    { 0x00701808, "Weighting Lookup Table Data", "OB", "1", 0, 0},
    { 0x00701901, "Volumetric Annotation Sequence", "SQ", "1", 0, 0},
    { 0x00701903, "Referenced Structured Context Sequence", "SQ", "1", 0, 0},
    { 0x00701904, "Referenced Content Item", "UI", "1", 0, 0},
    { 0x00701905, "Volumetric Presentation Input Annotation Sequence", "SQ", "1", 0, 0},
    { 0x00701907, "Annotation Clipping", "CS", "1", 0, 0},
    { 0x00701A01, "Presentation Animation Style", "CS", "1", 0, 0},
    { 0x00701A03, "Recommended Animation Rate", "FD", "1", 0, 0},
    { 0x00701A04, "Animation Curve Sequence", "SQ", "1", 0, 0},
    { 0x00701A05, "Animation Step Size", "FD", "1", 0, 0},
    { 0x00701A06, "Swivel Range", "FD", "1", 0, 0},
    { 0x00701A07, "Volumetric Curve Up Directions", "OD", "1", 0, 0},
    { 0x00701A08, "Volume Stream Sequence", "SQ", "1", 0, 0},
    { 0x00701A09, "RGBA Transfer Function Description", "LO", "1", 0, 0},
    { 0x00701B01, "Advanced Blending Sequence", "SQ", "1", 0, 0},
    { 0x00701B02, "Blending Input Number", "US", "1", 0, 0},
    { 0x00701B03, "Blending Display Input Sequence", "SQ", "1", 0, 0},
    { 0x00701B04, "Blending Display Sequence", "SQ", "1", 0, 0},
    { 0x00701B06, "Blending Mode", "CS", "1", 0, 0},
    { 0x00701B07, "Time Series Blending", "CS", "1", 0, 0},
    { 0x00701B08, "Geometry for Display", "CS", "1", 0, 0},
    { 0x00701B11, "Threshold Sequence", "SQ", "1", 0, 0},
    { 0x00701B12, "Threshold Value Sequence", "SQ", "1", 0, 0},
    { 0x00701B13, "Threshold Type", "CS", "1", 0, 0},
    { 0x00701B14, "Threshold Value", "FD", "1", 0, 0},
    { 0x00720002, "Hanging Protocol Name", "SH", "1", 0, 0},
    { 0x00720004, "Hanging Protocol Description", "LO", "1", 0, 0},
    { 0x00720006, "Hanging Protocol Level", "CS", "1", 0, 0},
    { 0x00720008, "Hanging Protocol Creator", "LO", "1", 0, 0},
    { 0x0072000A, "Hanging Protocol Creation DateTime", "DT", "1", 0, 0},
    { 0x0072000C, "Hanging Protocol Definition Sequence", "SQ", "1", 0, 0},
    { 0x0072000E, "Hanging Protocol User Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x00720010, "Hanging Protocol User Group Name", "LO", "1", 0, 0},
    { 0x00720012, "Source Hanging Protocol Sequence", "SQ", "1", 0, 0},
    { 0x00720014, "Number of Priors Referenced", "US", "1", 0, 0},
    { 0x00720020, "Image Sets Sequence", "SQ", "1", 0, 0},
    { 0x00720022, "Image Set Selector Sequence", "SQ", "1", 0, 0},
    { 0x00720024, "Image Set Selector Usage Flag", "CS", "1", 0, 0},
    { 0x00720026, "Selector Attribute", "AT", "1", 0, 0},
    { 0x00720028, "Selector Value Number", "US", "1", 0, 0},
    { 0x00720030, "Time Based Image Sets Sequence", "SQ", "1", 0, 0},
    { 0x00720032, "Image Set Number", "US", "1", 0, 0},
    { 0x00720034, "Image Set Selector Category", "CS", "1", 0, 0},
    { 0x00720038, "Relative Time", "US", "2", 0, 0},
    { 0x0072003A, "Relative Time Units", "CS", "1", 0, 0},
    { 0x0072003C, "Abstract Prior Value", "SS", "2", 0, 0},
    { 0x0072003E, "Abstract Prior Code Sequence", "SQ", "1", 0, 0},
    { 0x00720040, "Image Set Label", "LO", "1", 0, 0},
    { 0x00720050, "Selector Attribute VR", "CS", "1", 0, 0},
    { 0x00720052, "Selector Sequence Pointer", "AT", "1-n", 0, 0},
    { 0x00720054, "Selector Sequence Pointer Private Creator", "LO", "1-n", 0, 0},
    { 0x00720056, "Selector Attribute Private Creator", "LO", "1", 0, 0},
    { 0x0072005E, "Selector AE Value", "AE", "1-n", 0, 0},
    { 0x0072005F, "Selector AS Value", "AS", "1-n", 0, 0},
    { 0x00720060, "Selector AT Value", "AT", "1-n", 0, 0},
    { 0x00720061, "Selector DA Value", "DA", "1-n", 0, 0},
    { 0x00720062, "Selector CS Value", "CS", "1-n", 0, 0},
    { 0x00720063, "Selector DT Value", "DT", "1-n", 0, 0},
    { 0x00720064, "Selector IS Value", "IS", "1-n", 0, 0},
    { 0x00720065, "Selector OB Value", "OB", "1", 0, 0},
    { 0x00720066, "Selector LO Value", "LO", "1-n", 0, 0},
    { 0x00720067, "Selector OF Value", "OF", "1", 0, 0},
    { 0x00720068, "Selector LT Value", "LT", "1", 0, 0},
    { 0x00720069, "Selector OW Value", "OW", "1", 0, 0},
    { 0x0072006A, "Selector PN Value", "PN", "1-n", 0, 0},
    { 0x0072006B, "Selector TM Value", "TM", "1-n", 0, 0},
    { 0x0072006C, "Selector SH Value", "SH", "1-n", 0, 0},
    { 0x0072006D, "Selector UN Value", "UN", "1", 0, 0},
    { 0x0072006E, "Selector ST Value", "ST", "1", 0, 0},
    { 0x0072006F, "Selector UC Value", "UC", "1-n", 0, 0},
    { 0x00720070, "Selector UT Value", "UT", "1", 0, 0},
    { 0x00720071, "Selector UR Value", "UR", "1", 0, 0},
    { 0x00720072, "Selector DS Value", "DS", "1-n", 0, 0},
    { 0x00720073, "Selector OD Value", "OD", "1", 0, 0},
    { 0x00720074, "Selector FD Value", "FD", "1-n", 0, 0},
    { 0x00720075, "Selector OL Value", "OL", "1", 0, 0},
    { 0x00720076, "Selector FL Value", "FL", "1-n", 0, 0},
    { 0x00720078, "Selector UL Value", "UL", "1-n", 0, 0},
    { 0x0072007A, "Selector US Value", "US", "1-n", 0, 0},
    { 0x0072007C, "Selector SL Value", "SL", "1-n", 0, 0},
    { 0x0072007E, "Selector SS Value", "SS", "1-n", 0, 0},
    { 0x0072007F, "Selector UI Value", "UI", "1-n", 0, 0},
    { 0x00720080, "Selector Code Sequence Value", "SQ", "1", 0, 0},
    { 0x00720100, "Number of Screens", "US", "1", 0, 0},
    { 0x00720102, "Nominal Screen Definition Sequence", "SQ", "1", 0, 0},
    { 0x00720104, "Number of Vertical Pixels", "US", "1", 0, 0},
    { 0x00720106, "Number of Horizontal Pixels", "US", "1", 0, 0},
    { 0x00720108, "Display Environment Spatial Position", "FD", "4", 0, 0},
    { 0x0072010A, "Screen Minimum Grayscale Bit Depth", "US", "1", 0, 0},
    { 0x0072010C, "Screen Minimum Color Bit Depth", "US", "1", 0, 0},
    { 0x0072010E, "Application Maximum Repaint Time", "US", "1", 0, 0},
    { 0x00720200, "Display Sets Sequence", "SQ", "1", 0, 0},
    { 0x00720202, "Display Set Number", "US", "1", 0, 0},
    { 0x00720203, "Display Set Label", "LO", "1", 0, 0},
    { 0x00720204, "Display Set Presentation Group", "US", "1", 0, 0},
    { 0x00720206, "Display Set Presentation Group Description", "LO", "1", 0, 0},
    { 0x00720208, "Partial Data Display Handling", "CS", "1", 0, 0},
    { 0x00720210, "Synchronized Scrolling Sequence", "SQ", "1", 0, 0},
    { 0x00720212, "Display Set Scrolling Group", "US", "2-n", 0, 0},
    { 0x00720214, "Navigation Indicator Sequence", "SQ", "1", 0, 0},
    { 0x00720216, "Navigation Display Set", "US", "1", 0, 0},
    { 0x00720218, "Reference Display Sets", "US", "1-n", 0, 0},
    { 0x00720300, "Image Boxes Sequence", "SQ", "1", 0, 0},
    { 0x00720302, "Image Box Number", "US", "1", 0, 0},
    { 0x00720304, "Image Box Layout Type", "CS", "1", 0, 0},
    { 0x00720306, "Image Box Tile Horizontal Dimension", "US", "1", 0, 0},
    { 0x00720308, "Image Box Tile Vertical Dimension", "US", "1", 0, 0},
    { 0x00720310, "Image Box Scroll Direction", "CS", "1", 0, 0},
    { 0x00720312, "Image Box Small Scroll Type", "CS", "1", 0, 0},
    { 0x00720314, "Image Box Small Scroll Amount", "US", "1", 0, 0},
    { 0x00720316, "Image Box Large Scroll Type", "CS", "1", 0, 0},
    { 0x00720318, "Image Box Large Scroll Amount", "US", "1", 0, 0},
    { 0x00720320, "Image Box Overlap Priority", "US", "1", 0, 0},
    { 0x00720330, "Cine Relative to Real-Time", "FD", "1", 0, 0},
    { 0x00720400, "Filter Operations Sequence", "SQ", "1", 0, 0},
    { 0x00720402, "Filter-by Category", "CS", "1", 0, 0},
    { 0x00720404, "Filter-by Attribute Presence", "CS", "1", 0, 0},
    { 0x00720406, "Filter-by Operator", "CS", "1", 0, 0},
    { 0x00720420, "Structured Display Background CIELab Value", "US", "3", 0, 0},
    { 0x00720421, "Empty Image Box CIELab Value", "US", "3", 0, 0},
    { 0x00720422, "Structured Display Image Box Sequence", "SQ", "1", 0, 0},
    { 0x00720424, "Structured Display Text Box Sequence", "SQ", "1", 0, 0},
    { 0x00720427, "Referenced First Frame Sequence", "SQ", "1", 0, 0},
    { 0x00720430, "Image Box Synchronization Sequence", "SQ", "1", 0, 0},
    { 0x00720432, "Synchronized Image Box List", "US", "2-n", 0, 0},
    { 0x00720434, "Type of Synchronization", "CS", "1", 0, 0},
    { 0x00720500, "Blending Operation Type", "CS", "1", 0, 0},
    { 0x00720510, "Reformatting Operation Type", "CS", "1", 0, 0},
    { 0x00720512, "Reformatting Thickness", "FD", "1", 0, 0},
    { 0x00720514, "Reformatting Interval", "FD", "1", 0, 0},
    { 0x00720516, "Reformatting Operation Initial View Direction", "CS", "1", 0, 0},
    { 0x00720520, "3D Rendering Type", "CS", "1-n", 0, 0},
    { 0x00720600, "Sorting Operations Sequence", "SQ", "1", 0, 0},
    { 0x00720602, "Sort-by Category", "CS", "1", 0, 0},
    { 0x00720604, "Sorting Direction", "CS", "1", 0, 0},
    { 0x00720700, "Display Set Patient Orientation", "CS", "2", 0, 0},
    { 0x00720702, "VOI Type", "CS", "1", 0, 0},
    { 0x00720704, "Pseudo-Color Type", "CS", "1", 0, 0},
    { 0x00720705, "Pseudo-Color Palette Instance Reference Sequence", "SQ", "1", 0, 0},
    { 0x00720706, "Show Grayscale Inverted", "CS", "1", 0, 0},
    { 0x00720710, "Show Image True Size Flag", "CS", "1", 0, 0},
    { 0x00720712, "Show Graphic Annotation Flag", "CS", "1", 0, 0},
    { 0x00720714, "Show Patient Demographics Flag", "CS", "1", 0, 0},
    { 0x00720716, "Show Acquisition Techniques Flag", "CS", "1", 0, 0},
    { 0x00720717, "Display Set Horizontal Justification", "CS", "1", 0, 0},
    { 0x00720718, "Display Set Vertical Justification", "CS", "1", 0, 0},
    { 0x00740120, "Continuation Start Meterset", "FD", "1", 0, 0},
    { 0x00740121, "Continuation End Meterset", "FD", "1", 0, 0},
    { 0x00741000, "Procedure Step State", "CS", "1", 0, 0},
    { 0x00741002, "Procedure Step Progress Information Sequence", "SQ", "1", 0, 0},
    { 0x00741004, "Procedure Step Progress", "DS", "1", 0, 0},
    { 0x00741006, "Procedure Step Progress Description", "ST", "1", 0, 0},
    { 0x00741007, "Procedure Step Progress Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00741008, "Procedure Step Communications URI Sequence", "SQ", "1", 0, 0},
    { 0x0074100A, "Contact URI", "UR", "1", 0, 0},
    { 0x0074100C, "Contact Display Name", "LO", "1", 0, 0},
    { 0x0074100E, "Procedure Step Discontinuation Reason Code Sequence", "SQ", "1", 0, 0},
    { 0x00741020, "Beam Task Sequence", "SQ", "1", 0, 0},
    { 0x00741022, "Beam Task Type", "CS", "1", 0, 0},
    { 0x00741024, "Beam Order Index (Trial)", "IS", "1", -1, 0},
    { 0x00741025, "Autosequence Flag", "CS", "1", 0, 0},
    { 0x00741026, "Table Top Vertical Adjusted Position", "FD", "1", 0, 0},
    { 0x00741027, "Table Top Longitudinal Adjusted Position", "FD", "1", 0, 0},
    { 0x00741028, "Table Top Lateral Adjusted Position", "FD", "1", 0, 0},
    { 0x0074102A, "Patient Support Adjusted Angle", "FD", "1", 0, 0},
    { 0x0074102B, "Table Top Eccentric Adjusted Angle", "FD", "1", 0, 0},
    { 0x0074102C, "Table Top Pitch Adjusted Angle", "FD", "1", 0, 0},
    { 0x0074102D, "Table Top Roll Adjusted Angle", "FD", "1", 0, 0},
    { 0x00741030, "Delivery Verification Image Sequence", "SQ", "1", 0, 0},
    { 0x00741032, "Verification Image Timing", "CS", "1", 0, 0},
    { 0x00741034, "Double Exposure Flag", "CS", "1", 0, 0},
    { 0x00741036, "Double Exposure Ordering", "CS", "1", 0, 0},
    { 0x00741038, "Double Exposure Meterset (Trial)", "DS", "1", -1, 0},
    { 0x0074103A, "Double Exposure Field Delta (Trial)", "DS", "4", -1, 0},
    { 0x00741040, "Related Reference RT Image Sequence", "SQ", "1", 0, 0},
    { 0x00741042, "General Machine Verification Sequence", "SQ", "1", 0, 0},
    { 0x00741044, "Conventional Machine Verification Sequence", "SQ", "1", 0, 0},
    { 0x00741046, "Ion Machine Verification Sequence", "SQ", "1", 0, 0},
    { 0x00741048, "Failed Attributes Sequence", "SQ", "1", 0, 0},
    { 0x0074104A, "Overridden Attributes Sequence", "SQ", "1", 0, 0},
    { 0x0074104C, "Conventional Control Point Verification Sequence", "SQ", "1", 0, 0},
    { 0x0074104E, "Ion Control Point Verification Sequence", "SQ", "1", 0, 0},
    { 0x00741050, "Attribute Occurrence Sequence", "SQ", "1", 0, 0},
    { 0x00741052, "Attribute Occurrence Pointer", "AT", "1", 0, 0},
    { 0x00741054, "Attribute Item Selector", "UL", "1", 0, 0},
    { 0x00741056, "Attribute Occurrence Private Creator", "LO", "1", 0, 0},
    { 0x00741057, "Selector Sequence Pointer Items", "IS", "1-n", 0, 0},
    { 0x00741200, "Scheduled Procedure Step Priority", "CS", "1", 0, 0},
    { 0x00741202, "Worklist Label", "LO", "1", 0, 0},
    { 0x00741204, "Procedure Step Label", "LO", "1", 0, 0},
    { 0x00741210, "Scheduled Processing Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00741212, "Performed Processing Parameters Sequence", "SQ", "1", 0, 0},
    { 0x00741216, "Unified Procedure Step Performed Procedure Sequence", "SQ", "1", 0, 0},
    { 0x00741220, "Related Procedure Step Sequence", "SQ", "1", -1, 0},
    { 0x00741222, "Procedure Step Relationship Type", "LO", "1", -1, 0},
    { 0x00741224, "Replaced Procedure Step Sequence", "SQ", "1", 0, 0},
    { 0x00741230, "Deletion Lock", "LO", "1", 0, 0},
    { 0x00741234, "Receiving AE", "AE", "1", 0, 0},
    { 0x00741236, "Requesting AE", "AE", "1", 0, 0},
    { 0x00741238, "Reason for Cancellation", "LT", "1", 0, 0},
    { 0x00741242, "SCP Status", "CS", "1", 0, 0},
    { 0x00741244, "Subscription List Status", "CS", "1", 0, 0},
    { 0x00741246, "Unified Procedure Step List Status", "CS", "1", 0, 0},
    { 0x00741324, "Beam Order Index", "UL", "1", 0, 0},
    { 0x00741338, "Double Exposure Meterset", "FD", "1", 0, 0},
    { 0x0074133A, "Double Exposure Field Delta", "FD", "4", 0, 0},
    { 0x00741401, "Brachy Task Sequence", "SQ", "1", 0, 0},
    { 0x00741402, "Continuation Start Total Reference Air Kerma", "DS", "1", 0, 0},
    { 0x00741403, "Continuation End Total Reference Air Kerma", "DS", "1", 0, 0},
    { 0x00741404, "Continuation Pulse Number", "IS", "1", 0, 0},
    { 0x00741405, "Channel Delivery Order Sequence", "SQ", "1", 0, 0},
    { 0x00741406, "Referenced Channel Number", "IS", "1", 0, 0},
    { 0x00741407, "Start Cumulative Time Weight", "DS", "1", 0, 0},
    { 0x00741408, "End Cumulative Time Weight", "DS", "1", 0, 0},
    { 0x00741409, "Omitted Channel Sequence", "SQ", "1", 0, 0},
    { 0x0074140A, "Reason for Channel Omission", "CS", "1", 0, 0},
    { 0x0074140B, "Reason for Channel Omission Description", "LO", "1", 0, 0},
    { 0x0074140C, "Channel Delivery Order Index", "IS", "1", 0, 0},
    { 0x0074140D, "Channel Delivery Continuation Sequence", "SQ", "1", 0, 0},
    { 0x0074140E, "Omitted Application Setup Sequence", "SQ", "1", 0, 0},
    { 0x00760001, "Implant Assembly Template Name", "LO", "1", 0, 0},
    { 0x00760003, "Implant Assembly Template Issuer", "LO", "1", 0, 0},
    { 0x00760006, "Implant Assembly Template Version", "LO", "1", 0, 0},
    { 0x00760008, "Replaced Implant Assembly Template Sequence", "SQ", "1", 0, 0},
    { 0x0076000A, "Implant Assembly Template Type", "CS", "1", 0, 0},
    { 0x0076000C, "Original Implant Assembly Template Sequence", "SQ", "1", 0, 0},
    { 0x0076000E, "Derivation Implant Assembly Template Sequence", "SQ", "1", 0, 0},
    { 0x00760010, "Implant Assembly Template Target Anatomy Sequence", "SQ", "1", 0, 0},
    { 0x00760020, "Procedure Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00760030, "Surgical Technique", "LO", "1", 0, 0},
    { 0x00760032, "Component Types Sequence", "SQ", "1", 0, 0},
    { 0x00760034, "Component Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00760036, "Exclusive Component Type", "CS", "1", 0, 0},
    { 0x00760038, "Mandatory Component Type", "CS", "1", 0, 0},
    { 0x00760040, "Component Sequence", "SQ", "1", 0, 0},
    { 0x00760055, "Component ID", "US", "1", 0, 0},
    { 0x00760060, "Component Assembly Sequence", "SQ", "1", 0, 0},
    { 0x00760070, "Component 1 Referenced ID", "US", "1", 0, 0},
    { 0x00760080, "Component 1 Referenced Mating Feature Set ID", "US", "1", 0, 0},
    { 0x00760090, "Component 1 Referenced Mating Feature ID", "US", "1", 0, 0},
    { 0x007600A0, "Component 2 Referenced ID", "US", "1", 0, 0},
    { 0x007600B0, "Component 2 Referenced Mating Feature Set ID", "US", "1", 0, 0},
    { 0x007600C0, "Component 2 Referenced Mating Feature ID", "US", "1", 0, 0},
    { 0x00780001, "Implant Template Group Name", "LO", "1", 0, 0},
    { 0x00780010, "Implant Template Group Description", "ST", "1", 0, 0},
    { 0x00780020, "Implant Template Group Issuer", "LO", "1", 0, 0},
    { 0x00780024, "Implant Template Group Version", "LO", "1", 0, 0},
    { 0x00780026, "Replaced Implant Template Group Sequence", "SQ", "1", 0, 0},
    { 0x00780028, "Implant Template Group Target Anatomy Sequence", "SQ", "1", 0, 0},
    { 0x0078002A, "Implant Template Group Members Sequence", "SQ", "1", 0, 0},
    { 0x0078002E, "Implant Template Group Member ID", "US", "1", 0, 0},
    { 0x00780050, "3D Implant Template Group Member Matching Point", "FD", "3", 0, 0},
    { 0x00780060, "3D Implant Template Group Member Matching Axes", "FD", "9", 0, 0},
    { 0x00780070, "Implant Template Group Member Matching 2D Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x00780090, "2D Implant Template Group Member Matching Point", "FD", "2", 0, 0},
    { 0x007800A0, "2D Implant Template Group Member Matching Axes", "FD", "4", 0, 0},
    { 0x007800B0, "Implant Template Group Variation Dimension Sequence", "SQ", "1", 0, 0},
    { 0x007800B2, "Implant Template Group Variation Dimension Name", "LO", "1", 0, 0},
    { 0x007800B4, "Implant Template Group Variation Dimension Rank Sequence", "SQ", "1", 0, 0},
    { 0x007800B6, "Referenced Implant Template Group Member ID", "US", "1", 0, 0},
    { 0x007800B8, "Implant Template Group Variation Dimension Rank", "US", "1", 0, 0},
    { 0x00800001, "Surface Scan Acquisition Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00800002, "Surface Scan Mode Code Sequence", "SQ", "1", 0, 0},
    { 0x00800003, "Registration Method Code Sequence", "SQ", "1", 0, 0},
    { 0x00800004, "Shot Duration Time", "FD", "1", 0, 0},
    { 0x00800005, "Shot Offset Time", "FD", "1", 0, 0},
    { 0x00800006, "Surface Point Presentation Value Data", "US", "1-n", 0, 0},
    { 0x00800007, "Surface Point Color CIELab Value Data", "US", "3-3n", 0, 0},
    { 0x00800008, "UV Mapping Sequence", "SQ", "1", 0, 0},
    { 0x00800009, "Texture Label", "SH", "1", 0, 0},
    { 0x00800010, "U Value Data", "OF", "1", 0, 0},
    { 0x00800011, "V Value Data", "OF", "1", 0, 0},
    { 0x00800012, "Referenced Texture Sequence", "SQ", "1", 0, 0},
    { 0x00800013, "Referenced Surface Data Sequence", "SQ", "1", 0, 0},
    { 0x00820001, "Assessment Summary", "CS", "1", 0, 0},
    { 0x00820003, "Assessment Summary Description", "UT", "1", 0, 0},
    { 0x00820004, "Assessed SOP Instance Sequence", "SQ", "1", 0, 0},
    { 0x00820005, "Referenced Comparison SOP Instance Sequence", "SQ", "1", 0, 0},
    { 0x00820006, "Number of Assessment Observations", "UL", "1", 0, 0},
    { 0x00820007, "Assessment Observations Sequence", "SQ", "1", 0, 0},
    { 0x00820008, "Observation Significance", "CS", "1", 0, 0},
    { 0x0082000A, "Observation Description", "UT", "1", 0, 0},
    { 0x0082000C, "Structured Constraint Observation Sequence", "SQ", "1", 0, 0},
    { 0x00820010, "Assessed Attribute Value Sequence", "SQ", "1", 0, 0},
    { 0x00820016, "Assessment Set ID", "LO", "1", 0, 0},
    { 0x00820017, "Assessment Requester Sequence", "SQ", "1", 0, 0},
    { 0x00820018, "Selector Attribute Name", "LO", "1", 0, 0},
    { 0x00820019, "Selector Attribute Keyword", "LO", "1", 0, 0},
    { 0x00820021, "Assessment Type Code Sequence", "SQ", "1", 0, 0},
    { 0x00820022, "Observation Basis Code Sequence", "SQ", "1", 0, 0},
    { 0x00820023, "Assessment Label", "LO", "1", 0, 0},
    { 0x00820032, "Constraint Type", "CS", "1", 0, 0},
    { 0x00820033, "Specification Selection Guidance", "UT", "1", 0, 0},
    { 0x00820034, "Constraint Value Sequence", "SQ", "1", 0, 0},
    { 0x00820035, "Recommended Default Value Sequence", "SQ", "1", 0, 0},
    { 0x00820036, "Constraint Violation Significance", "CS", "1", 0, 0},
    { 0x00820037, "Constraint Violation Condition", "UT", "1", 0, 0},
    { 0x00820038, "Modifiable Constraint Flag", "CS", "1", 0, 0},
    { 0x00880130, "Storage Media File-set ID", "SH", "1", 0, 0},
    { 0x00880140, "Storage Media File-set UID", "UI", "1", 0, 0},
    { 0x00880200, "Icon Image Sequence", "SQ", "1", 0, 0},
    { 0x00880904, "Topic Title", "LO", "1", -1, 0},
    { 0x00880906, "Topic Subject", "ST", "1", -1, 0},
    { 0x00880910, "Topic Author", "LO", "1", -1, 0},
    { 0x00880912, "Topic Keywords", "LO", "1-32", -1, 0},
    { 0x01000410, "SOP Instance Status", "CS", "1", 0, 0},
    { 0x01000420, "SOP Authorization DateTime", "DT", "1", 0, 0},
    { 0x01000424, "SOP Authorization Comment", "LT", "1", 0, 0},
    { 0x01000426, "Authorization Equipment Certification Number", "LO", "1", 0, 0},
    { 0x04000005, "MAC ID Number", "US", "1", 0, 0},
    { 0x04000010, "MAC Calculation Transfer Syntax UID", "UI", "1", 0, 0},
    { 0x04000015, "MAC Algorithm", "CS", "1", 0, 0},
    { 0x04000020, "Data Elements Signed", "AT", "1-n", 0, 0},
    { 0x04000100, "Digital Signature UID", "UI", "1", 0, 0},
    { 0x04000105, "Digital Signature DateTime", "DT", "1", 0, 0},
    { 0x04000110, "Certificate Type", "CS", "1", 0, 0},
    { 0x04000115, "Certificate of Signer", "OB", "1", 0, 0},
    { 0x04000120, "Signature", "OB", "1", 0, 0},
    { 0x04000305, "Certified Timestamp Type", "CS", "1", 0, 0},
    { 0x04000310, "Certified Timestamp", "OB", "1", 0, 0},
    { 0x04000315, "", "FL", "1", -1, 0},
    { 0x04000401, "Digital Signature Purpose Code Sequence", "SQ", "1", 0, 0},
    { 0x04000402, "Referenced Digital Signature Sequence", "SQ", "1", 0, 0},
    { 0x04000403, "Referenced SOP Instance MAC Sequence", "SQ", "1", 0, 0},
    { 0x04000404, "MAC", "OB", "1", 0, 0},
    { 0x04000500, "Encrypted Attributes Sequence", "SQ", "1", 0, 0},
    { 0x04000510, "Encrypted Content Transfer Syntax UID", "UI", "1", 0, 0},
    { 0x04000520, "Encrypted Content", "OB", "1", 0, 0},
    { 0x04000550, "Modified Attributes Sequence", "SQ", "1", 0, 0},
    { 0x04000551, "Nonconforming Modified Attributes Sequence", "SQ", "1", 0, 0},
    { 0x04000552, "Nonconforming Data Element Value", "OB", "1", 0, 0},
    { 0x04000561, "Original Attributes Sequence", "SQ", "1", 0, 0},
    { 0x04000562, "Attribute Modification DateTime", "DT", "1", 0, 0},
    { 0x04000563, "Modifying System", "LO", "1", 0, 0},
    { 0x04000564, "Source of Previous Values", "LO", "1", 0, 0},
    { 0x04000565, "Reason for the Attribute Modification", "CS", "1", 0, 0},
    { 0x04000600, "Instance Origin Status", "CS", "1", 0, 0},
    { 0x10000000, "Escape Triplet", "US", "3", -1, 0},
    { 0x10000001, "Run Length Triplet", "US", "3", -1, 0},
    { 0x10000002, "Huffman Table Size", "US", "1", -1, 0},
    { 0x10000003, "Huffman Table Triplet", "US", "3", -1, 0},
    { 0x10000004, "Shift Table Size", "US", "1", -1, 0},
    { 0x10000005, "Shift Table Triplet", "US", "3", -1, 0},
    { 0x10100000, "Zonal Map", "US", "1-n", -1, 0},
    { 0x20000010, "Number of Copies", "IS", "1", 0, 0},
    { 0x2000001E, "Printer Configuration Sequence", "SQ", "1", 0, 0},
    { 0x20000020, "Print Priority", "CS", "1", 0, 0},
    { 0x20000030, "Medium Type", "CS", "1", 0, 0},
    { 0x20000040, "Film Destination", "CS", "1", 0, 0},
    { 0x20000050, "Film Session Label", "LO", "1", 0, 0},
    { 0x20000060, "Memory Allocation", "IS", "1", 0, 0},
    { 0x20000061, "Maximum Memory Allocation", "IS", "1", 0, 0},
    { 0x20000062, "Color Image Printing Flag", "CS", "1", -1, 0},
    { 0x20000063, "Collation Flag", "CS", "1", -1, 0},
    { 0x20000065, "Annotation Flag", "CS", "1", -1, 0},
    { 0x20000067, "Image Overlay Flag", "CS", "1", -1, 0},
    { 0x20000069, "Presentation LUT Flag", "CS", "1", -1, 0},
    { 0x2000006A, "Image Box Presentation LUT Flag", "CS", "1", -1, 0},
    { 0x200000A0, "Memory Bit Depth", "US", "1", 0, 0},
    { 0x200000A1, "Printing Bit Depth", "US", "1", 0, 0},
    { 0x200000A2, "Media Installed Sequence", "SQ", "1", 0, 0},
    { 0x200000A4, "Other Media Available Sequence", "SQ", "1", 0, 0},
    { 0x200000A8, "Supported Image Display Formats Sequence", "SQ", "1", 0, 0},
    { 0x20000500, "Referenced Film Box Sequence", "SQ", "1", 0, 0},
    { 0x20000510, "Referenced Stored Print Sequence", "SQ", "1", -1, 0},
    { 0x20100010, "Image Display Format", "ST", "1", 0, 0},
    { 0x20100030, "Annotation Display Format ID", "CS", "1", 0, 0},
    { 0x20100040, "Film Orientation", "CS", "1", 0, 0},
    { 0x20100050, "Film Size ID", "CS", "1", 0, 0},
    { 0x20100052, "Printer Resolution ID", "CS", "1", 0, 0},
    { 0x20100054, "Default Printer Resolution ID", "CS", "1", 0, 0},
    { 0x20100060, "Magnification Type", "CS", "1", 0, 0},
    { 0x20100080, "Smoothing Type", "CS", "1", 0, 0},
    { 0x201000A6, "Default Magnification Type", "CS", "1", 0, 0},
    { 0x201000A7, "Other Magnification Types Available", "CS", "1-n", 0, 0},
    { 0x201000A8, "Default Smoothing Type", "CS", "1", 0, 0},
    { 0x201000A9, "Other Smoothing Types Available", "CS", "1-n", 0, 0},
    { 0x20100100, "Border Density", "CS", "1", 0, 0},
    { 0x20100110, "Empty Image Density", "CS", "1", 0, 0},
    { 0x20100120, "Min Density", "US", "1", 0, 0},
    { 0x20100130, "Max Density", "US", "1", 0, 0},
    { 0x20100140, "Trim", "CS", "1", 0, 0},
    { 0x20100150, "Configuration Information", "ST", "1", 0, 0},
    { 0x20100152, "Configuration Information Description", "LT", "1", 0, 0},
    { 0x20100154, "Maximum Collated Films", "IS", "1", 0, 0},
    { 0x2010015E, "Illumination", "US", "1", 0, 0},
    { 0x20100160, "Reflected Ambient Light", "US", "1", 0, 0},
    { 0x20100376, "Printer Pixel Spacing", "DS", "2", 0, 0},
    { 0x20100500, "Referenced Film Session Sequence", "SQ", "1", 0, 0},
    { 0x20100510, "Referenced Image Box Sequence", "SQ", "1", 0, 0},
    { 0x20100520, "Referenced Basic Annotation Box Sequence", "SQ", "1", 0, 0},
    { 0x20200010, "Image Box Position", "US", "1", 0, 0},
    { 0x20200020, "Polarity", "CS", "1", 0, 0},
    { 0x20200030, "Requested Image Size", "DS", "1", 0, 0},
    { 0x20200040, "Requested Decimate/Crop Behavior", "CS", "1", 0, 0},
    { 0x20200050, "Requested Resolution ID", "CS", "1", 0, 0},
    { 0x202000A0, "Requested Image Size Flag", "CS", "1", 0, 0},
    { 0x202000A2, "Decimate/Crop Result", "CS", "1", 0, 0},
    { 0x20200110, "Basic Grayscale Image Sequence", "SQ", "1", 0, 0},
    { 0x20200111, "Basic Color Image Sequence", "SQ", "1", 0, 0},
    { 0x20200130, "Referenced Image Overlay Box Sequence", "SQ", "1", -1, 0},
    { 0x20200140, "Referenced VOI LUT Box Sequence", "SQ", "1", -1, 0},
    { 0x20300010, "Annotation Position", "US", "1", 0, 0},
    { 0x20300020, "Text String", "LO", "1", 0, 0},
    { 0x20400010, "Referenced Overlay Plane Sequence", "SQ", "1", -1, 0},
    { 0x20400011, "Referenced Overlay Plane Groups", "US", "1-99", -1, 0},
    { 0x20400020, "Overlay Pixel Data Sequence", "SQ", "1", -1, 0},
    { 0x20400060, "Overlay Magnification Type", "CS", "1", -1, 0},
    { 0x20400070, "Overlay Smoothing Type", "CS", "1", -1, 0},
    { 0x20400072, "Overlay or Image Magnification", "CS", "1", -1, 0},
    { 0x20400074, "Magnify to Number of Columns", "US", "1", -1, 0},
    { 0x20400080, "Overlay Foreground Density", "CS", "1", -1, 0},
    { 0x20400082, "Overlay Background Density", "CS", "1", -1, 0},
    { 0x20400090, "Overlay Mode", "CS", "1", -1, 0},
    { 0x20400100, "Threshold Density", "CS", "1", -1, 0},
    { 0x20400500, "Referenced Image Box Sequence (Retired)", "SQ", "1", -1, 0},
    { 0x20500010, "Presentation LUT Sequence", "SQ", "1", 0, 0},
    { 0x20500020, "Presentation LUT Shape", "CS", "1", 0, 0},
    { 0x20500500, "Referenced Presentation LUT Sequence", "SQ", "1", 0, 0},
    { 0x21000010, "Print Job ID", "SH", "1", -1, 0},
    { 0x21000020, "Execution Status", "CS", "1", 0, 0},
    { 0x21000030, "Execution Status Info", "CS", "1", 0, 0},
    { 0x21000040, "Creation Date", "DA", "1", 0, 0},
    { 0x21000050, "Creation Time", "TM", "1", 0, 0},
    { 0x21000070, "Originator", "AE", "1", 0, 0},
    { 0x21000140, "Destination AE", "AE", "1", 0, 0},
    { 0x21000160, "Owner ID", "SH", "1", 0, 0},
    { 0x21000170, "Number of Films", "IS", "1", 0, 0},
    { 0x21000500, "Referenced Print Job Sequence (Pull Stored Print)", "SQ", "1", -1, 0},
    { 0x21100010, "Printer Status", "CS", "1", 0, 0},
    { 0x21100020, "Printer Status Info", "CS", "1", 0, 0},
    { 0x21100030, "Printer Name", "LO", "1", 0, 0},
    { 0x21100099, "Print Queue ID", "SH", "1", -1, 0},
    { 0x21200010, "Queue Status", "CS", "1", -1, 0},
    { 0x21200050, "Print Job Description Sequence", "SQ", "1", -1, 0},
    { 0x21200070, "Referenced Print Job Sequence", "SQ", "1", -1, 0},
    { 0x21300010, "Print Management Capabilities Sequence", "SQ", "1", -1, 0},
    { 0x21300015, "Printer Characteristics Sequence", "SQ", "1", -1, 0},
    { 0x21300030, "Film Box Content Sequence", "SQ", "1", -1, 0},
    { 0x21300040, "Image Box Content Sequence", "SQ", "1", -1, 0},
    { 0x21300050, "Annotation Content Sequence", "SQ", "1", -1, 0},
    { 0x21300060, "Image Overlay Box Content Sequence", "SQ", "1", -1, 0},
    { 0x21300080, "Presentation LUT Content Sequence", "SQ", "1", -1, 0},
    { 0x213000A0, "Proposed Study Sequence", "SQ", "1", -1, 0},
    { 0x213000C0, "Original Image Sequence", "SQ", "1", -1, 0},
    { 0x22000001, "Label Using Information Extracted From Instances", "CS", "1", 0, 0},
    { 0x22000002, "Label Text", "UT", "1", 0, 0},
    { 0x22000003, "Label Style Selection", "CS", "1", 0, 0},
    { 0x22000004, "Media Disposition", "LT", "1", 0, 0},
    { 0x22000005, "Barcode Value", "LT", "1", 0, 0},
    { 0x22000006, "Barcode Symbology", "CS", "1", 0, 0},
    { 0x22000007, "Allow Media Splitting", "CS", "1", 0, 0},
    { 0x22000008, "Include Non-DICOM Objects", "CS", "1", 0, 0},
    { 0x22000009, "Include Display Application", "CS", "1", 0, 0},
    { 0x2200000A, "Preserve Composite Instances After Media Creation", "CS", "1", 0, 0},
    { 0x2200000B, "Total Number of Pieces of Media Created", "US", "1", 0, 0},
    { 0x2200000C, "Requested Media Application Profile", "LO", "1", 0, 0},
    { 0x2200000D, "Referenced Storage Media Sequence", "SQ", "1", 0, 0},
    { 0x2200000E, "Failure Attributes", "AT", "1-n", 0, 0},
    { 0x2200000F, "Allow Lossy Compression", "CS", "1", 0, 0},
    { 0x22000020, "Request Priority", "CS", "1", 0, 0},
    { 0x30020002, "RT Image Label", "SH", "1", 0, 0},
    { 0x30020003, "RT Image Name", "LO", "1", 0, 0},
    { 0x30020004, "RT Image Description", "ST", "1", 0, 0},
    { 0x3002000A, "Reported Values Origin", "CS", "1", 0, 0},
    { 0x3002000C, "RT Image Plane", "CS", "1", 0, 0},
    { 0x3002000D, "X-Ray Image Receptor Translation", "DS", "3", 0, 0},
    { 0x3002000E, "X-Ray Image Receptor Angle", "DS", "1", 0, 0},
    { 0x30020010, "RT Image Orientation", "DS", "6", 0, 0},
    { 0x30020011, "Image Plane Pixel Spacing", "DS", "2", 0, 0},
    { 0x30020012, "RT Image Position", "DS", "2", 0, 0},
    { 0x30020020, "Radiation Machine Name", "SH", "1", 0, 0},
    { 0x30020022, "Radiation Machine SAD", "DS", "1", 0, 0},
    { 0x30020024, "Radiation Machine SSD", "DS", "1", 0, 0},
    { 0x30020026, "RT Image SID", "DS", "1", 0, 0},
    { 0x30020028, "Source to Reference Object Distance", "DS", "1", 0, 0},
    { 0x30020029, "Fraction Number", "IS", "1", 0, 0},
    { 0x30020030, "Exposure Sequence", "SQ", "1", 0, 0},
    { 0x30020032, "Meterset Exposure", "DS", "1", 0, 0},
    { 0x30020034, "Diaphragm Position", "DS", "4", 0, 0},
    { 0x30020040, "Fluence Map Sequence", "SQ", "1", 0, 0},
    { 0x30020041, "Fluence Data Source", "CS", "1", 0, 0},
    { 0x30020042, "Fluence Data Scale", "DS", "1", 0, 0},
    { 0x30020050, "Primary Fluence Mode Sequence", "SQ", "1", 0, 0},
    { 0x30020051, "Fluence Mode", "CS", "1", 0, 0},
    { 0x30020052, "Fluence Mode ID", "SH", "1", 0, 0},
    { 0x30040001, "DVH Type", "CS", "1", 0, 0},
    { 0x30040002, "Dose Units", "CS", "1", 0, 0},
    { 0x30040004, "Dose Type", "CS", "1", 0, 0},
    { 0x30040005, "Spatial Transform of Dose", "CS", "1", 0, 0},
    { 0x30040006, "Dose Comment", "LO", "1", 0, 0},
    { 0x30040008, "Normalization Point", "DS", "3", 0, 0},
    { 0x3004000A, "Dose Summation Type", "CS", "1", 0, 0},
    { 0x3004000C, "Grid Frame Offset Vector", "DS", "2-n", 0, 0},
    { 0x3004000E, "Dose Grid Scaling", "DS", "1", 0, 0},
    { 0x30040010, "RT Dose ROI Sequence", "SQ", "1", 0, 0},
    { 0x30040012, "Dose Value", "DS", "1", 0, 0},
    { 0x30040014, "Tissue Heterogeneity Correction", "CS", "1-3", 0, 0},
    { 0x30040040, "DVH Normalization Point", "DS", "3", 0, 0},
    { 0x30040042, "DVH Normalization Dose Value", "DS", "1", 0, 0},
    { 0x30040050, "DVH Sequence", "SQ", "1", 0, 0},
    { 0x30040052, "DVH Dose Scaling", "DS", "1", 0, 0},
    { 0x30040054, "DVH Volume Units", "CS", "1", 0, 0},
    { 0x30040056, "DVH Number of Bins", "IS", "1", 0, 0},
    { 0x30040058, "DVH Data", "DS", "2-2n", 0, 0},
    { 0x30040060, "DVH Referenced ROI Sequence", "SQ", "1", 0, 0},
    { 0x30040062, "DVH ROI Contribution Type", "CS", "1", 0, 0},
    { 0x30040070, "DVH Minimum Dose", "DS", "1", 0, 0},
    { 0x30040072, "DVH Maximum Dose", "DS", "1", 0, 0},
    { 0x30040074, "DVH Mean Dose", "DS", "1", 0, 0},
    { 0x30060002, "Structure Set Label", "SH", "1", 0, 0},
    { 0x30060004, "Structure Set Name", "LO", "1", 0, 0},
    { 0x30060006, "Structure Set Description", "ST", "1", 0, 0},
    { 0x30060008, "Structure Set Date", "DA", "1", 0, 0},
    { 0x30060009, "Structure Set Time", "TM", "1", 0, 0},
    { 0x30060010, "Referenced Frame of Reference Sequence", "SQ", "1", 0, 0},
    { 0x30060012, "RT Referenced Study Sequence", "SQ", "1", 0, 0},
    { 0x30060014, "RT Referenced Series Sequence", "SQ", "1", 0, 0},
    { 0x30060016, "Contour Image Sequence", "SQ", "1", 0, 0},
    { 0x30060018, "Predecessor Structure Set Sequence", "SQ", "1", 0, 0},
    { 0x30060020, "Structure Set ROI Sequence", "SQ", "1", 0, 0},
    { 0x30060022, "ROI Number", "IS", "1", 0, -1},
    { 0x30060024, "Referenced Frame of Reference UID", "UI", "1", 0, 0},
    { 0x30060026, "ROI Name", "LO", "1", 0, -1},
    { 0x30060028, "ROI Description", "ST", "1", 0, 0},
    { 0x3006002A, "ROI Display Color", "IS", "3", 0, 0},
    { 0x3006002C, "ROI Volume", "DS", "1", 0, 0},
    { 0x30060030, "RT Related ROI Sequence", "SQ", "1", 0, 0},
    { 0x30060033, "RT ROI Relationship", "CS", "1", 0, 0},
    { 0x30060036, "ROI Generation Algorithm", "CS", "1", 0, 0},
    { 0x30060037, "ROI Derivation Algorithm Identification Sequence", "SQ", "1", 0, 0},
    { 0x30060038, "ROI Generation Description", "LO", "1", 0, 0},
    { 0x30060039, "ROI Contour Sequence", "SQ", "1", 0, 0},
    { 0x30060040, "Contour Sequence", "SQ", "1", 0, 0},
    { 0x30060042, "Contour Geometric Type", "CS", "1", 0, -1},
    { 0x30060044, "Contour Slab Thickness", "DS", "1", 0, 0},
    { 0x30060045, "Contour Offset Vector", "DS", "3", 0, 0},
    { 0x30060046, "Number of Contour Points", "IS", "1", 0, 0},
    { 0x30060048, "Contour Number", "IS", "1", 0, 0},
    { 0x30060049, "Attached Contours", "IS", "1-n", 0, 0},
    { 0x30060050, "Contour Data", "DS", "3-3n", 0, 0},
    { 0x30060080, "RT ROI Observations Sequence", "SQ", "1", 0, 0},
    { 0x30060082, "Observation Number", "IS", "1", 0, -1},
    { 0x30060084, "Referenced ROI Number", "IS", "1", 0, 0},
    { 0x30060085, "ROI Observation Label", "SH", "1", 0, -1},
    { 0x30060086, "RT ROI Identification Code Sequence", "SQ", "1", 0, 0},
    { 0x30060088, "ROI Observation Description", "ST", "1", 0, 0},
    { 0x300600A0, "Related RT ROI Observations Sequence", "SQ", "1", 0, 0},
    { 0x300600A4, "RT ROI Interpreted Type", "CS", "1", 0, -1},
    { 0x300600A6, "ROI Interpreter", "PN", "1", 0, 0},
    { 0x300600B0, "ROI Physical Properties Sequence", "SQ", "1", 0, 0},
    { 0x300600B2, "ROI Physical Property", "CS", "1", 0, 0},
    { 0x300600B4, "ROI Physical Property Value", "DS", "1", 0, 0},
    { 0x300600B6, "ROI Elemental Composition Sequence", "SQ", "1", 0, 0},
    { 0x300600B7, "ROI Elemental Composition Atomic Number", "US", "1", 0, 0},
    { 0x300600B8, "ROI Elemental Composition Atomic Mass Fraction", "FL", "1", 0, 0},
    { 0x300600B9, "Additional RT ROI Identification Code Sequence", "SQ", "1", -1, 0},
    { 0x300600C0, "Frame of Reference Relationship Sequence", "SQ", "1", -1, 0},
    { 0x300600C2, "Related Frame of Reference UID", "UI", "1", -1, 0},
    { 0x300600C4, "Frame of Reference Transformation Type", "CS", "1", -1, 0},
    { 0x300600C6, "Frame of Reference Transformation Matrix", "DS", "16", 0, 0},
    { 0x300600C8, "Frame of Reference Transformation Comment", "LO", "1", 0, 0},
    { 0x300600C9, "Patient Location Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x300600CA, "Patient Location Coordinates Code Sequence", "SQ", "1", 0, 0},
    { 0x300600CB, "Patient Support Position Sequence", "SQ", "1", 0, 0},
    { 0x30080010, "Measured Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x30080012, "Measured Dose Description", "ST", "1", 0, 0},
    { 0x30080014, "Measured Dose Type", "CS", "1", 0, 0},
    { 0x30080016, "Measured Dose Value", "DS", "1", 0, 0},
    { 0x30080020, "Treatment Session Beam Sequence", "SQ", "1", 0, 0},
    { 0x30080021, "Treatment Session Ion Beam Sequence", "SQ", "1", 0, 0},
    { 0x30080022, "Current Fraction Number", "IS", "1", 0, 0},
    { 0x30080024, "Treatment Control Point Date", "DA", "1", 0, 0},
    { 0x30080025, "Treatment Control Point Time", "TM", "1", 0, 0},
    { 0x3008002A, "Treatment Termination Status", "CS", "1", 0, 0},
    { 0x3008002B, "Treatment Termination Code", "SH", "1", 0, 0},
    { 0x3008002C, "Treatment Verification Status", "CS", "1", 0, 0},
    { 0x30080030, "Referenced Treatment Record Sequence", "SQ", "1", 0, 0},
    { 0x30080032, "Specified Primary Meterset", "DS", "1", 0, 0},
    { 0x30080033, "Specified Secondary Meterset", "DS", "1", 0, 0},
    { 0x30080036, "Delivered Primary Meterset", "DS", "1", 0, 0},
    { 0x30080037, "Delivered Secondary Meterset", "DS", "1", 0, 0},
    { 0x3008003A, "Specified Treatment Time", "DS", "1", 0, 0},
    { 0x3008003B, "Delivered Treatment Time", "DS", "1", 0, 0},
    { 0x30080040, "Control Point Delivery Sequence", "SQ", "1", 0, 0},
    { 0x30080041, "Ion Control Point Delivery Sequence", "SQ", "1", 0, 0},
    { 0x30080042, "Specified Meterset", "DS", "1", 0, 0},
    { 0x30080044, "Delivered Meterset", "DS", "1", 0, 0},
    { 0x30080045, "Meterset Rate Set", "FL", "1", 0, 0},
    { 0x30080046, "Meterset Rate Delivered", "FL", "1", 0, 0},
    { 0x30080047, "Scan Spot Metersets Delivered", "FL", "1-n", 0, 0},
    { 0x30080048, "Dose Rate Delivered", "DS", "1", 0, 0},
    { 0x30080050, "Treatment Summary Calculated Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x30080052, "Cumulative Dose to Dose Reference", "DS", "1", 0, 0},
    { 0x30080054, "First Treatment Date", "DA", "1", 0, 0},
    { 0x30080056, "Most Recent Treatment Date", "DA", "1", 0, 0},
    { 0x3008005A, "Number of Fractions Delivered", "IS", "1", 0, 0},
    { 0x30080060, "Override Sequence", "SQ", "1", 0, 0},
    { 0x30080061, "Parameter Sequence Pointer", "AT", "1", 0, 0},
    { 0x30080062, "Override Parameter Pointer", "AT", "1", 0, 0},
    { 0x30080063, "Parameter Item Index", "IS", "1", 0, 0},
    { 0x30080064, "Measured Dose Reference Number", "IS", "1", 0, 0},
    { 0x30080065, "Parameter Pointer", "AT", "1", 0, 0},
    { 0x30080066, "Override Reason", "ST", "1", 0, 0},
    { 0x30080067, "Parameter Value Number", "US", "1", 0, 0},
    { 0x30080068, "Corrected Parameter Sequence", "SQ", "1", 0, 0},
    { 0x3008006A, "Correction Value", "FL", "1", 0, 0},
    { 0x30080070, "Calculated Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x30080072, "Calculated Dose Reference Number", "IS", "1", 0, 0},
    { 0x30080074, "Calculated Dose Reference Description", "ST", "1", 0, 0},
    { 0x30080076, "Calculated Dose Reference Dose Value", "DS", "1", 0, 0},
    { 0x30080078, "Start Meterset", "DS", "1", 0, 0},
    { 0x3008007A, "End Meterset", "DS", "1", 0, 0},
    { 0x30080080, "Referenced Measured Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x30080082, "Referenced Measured Dose Reference Number", "IS", "1", 0, 0},
    { 0x30080090, "Referenced Calculated Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x30080092, "Referenced Calculated Dose Reference Number", "IS", "1", 0, 0},
    { 0x300800A0, "Beam Limiting Device Leaf Pairs Sequence", "SQ", "1", 0, 0},
    { 0x300800B0, "Recorded Wedge Sequence", "SQ", "1", 0, 0},
    { 0x300800C0, "Recorded Compensator Sequence", "SQ", "1", 0, 0},
    { 0x300800D0, "Recorded Block Sequence", "SQ", "1", 0, 0},
    { 0x300800E0, "Treatment Summary Measured Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x300800F0, "Recorded Snout Sequence", "SQ", "1", 0, 0},
    { 0x300800F2, "Recorded Range Shifter Sequence", "SQ", "1", 0, 0},
    { 0x300800F4, "Recorded Lateral Spreading Device Sequence", "SQ", "1", 0, 0},
    { 0x300800F6, "Recorded Range Modulator Sequence", "SQ", "1", 0, 0},
    { 0x30080100, "Recorded Source Sequence", "SQ", "1", 0, 0},
    { 0x30080105, "Source Serial Number", "LO", "1", 0, 0},
    { 0x30080110, "Treatment Session Application Setup Sequence", "SQ", "1", 0, 0},
    { 0x30080116, "Application Setup Check", "CS", "1", 0, 0},
    { 0x30080120, "Recorded Brachy Accessory Device Sequence", "SQ", "1", 0, 0},
    { 0x30080122, "Referenced Brachy Accessory Device Number", "IS", "1", 0, 0},
    { 0x30080130, "Recorded Channel Sequence", "SQ", "1", 0, 0},
    { 0x30080132, "Specified Channel Total Time", "DS", "1", 0, 0},
    { 0x30080134, "Delivered Channel Total Time", "DS", "1", 0, 0},
    { 0x30080136, "Specified Number of Pulses", "IS", "1", 0, 0},
    { 0x30080138, "Delivered Number of Pulses", "IS", "1", 0, 0},
    { 0x3008013A, "Specified Pulse Repetition Interval", "DS", "1", 0, 0},
    { 0x3008013C, "Delivered Pulse Repetition Interval", "DS", "1", 0, 0},
    { 0x30080140, "Recorded Source Applicator Sequence", "SQ", "1", 0, 0},
    { 0x30080142, "Referenced Source Applicator Number", "IS", "1", 0, 0},
    { 0x30080150, "Recorded Channel Shield Sequence", "SQ", "1", 0, 0},
    { 0x30080152, "Referenced Channel Shield Number", "IS", "1", 0, 0},
    { 0x30080160, "Brachy Control Point Delivered Sequence", "SQ", "1", 0, 0},
    { 0x30080162, "Safe Position Exit Date", "DA", "1", 0, 0},
    { 0x30080164, "Safe Position Exit Time", "TM", "1", 0, 0},
    { 0x30080166, "Safe Position Return Date", "DA", "1", 0, 0},
    { 0x30080168, "Safe Position Return Time", "TM", "1", 0, 0},
    { 0x30080171, "Pulse Specific Brachy Control Point Delivered Sequence", "SQ", "1", 0, 0},
    { 0x30080172, "Pulse Number", "US", "1", 0, 0},
    { 0x30080173, "Brachy Pulse Control Point Delivered Sequence", "SQ", "1", 0, 0},
    { 0x30080200, "Current Treatment Status", "CS", "1", 0, 0},
    { 0x30080202, "Treatment Status Comment", "ST", "1", 0, 0},
    { 0x30080220, "Fraction Group Summary Sequence", "SQ", "1", 0, 0},
    { 0x30080223, "Referenced Fraction Number", "IS", "1", 0, 0},
    { 0x30080224, "Fraction Group Type", "CS", "1", 0, 0},
    { 0x30080230, "Beam Stopper Position", "CS", "1", 0, 0},
    { 0x30080240, "Fraction Status Summary Sequence", "SQ", "1", 0, 0},
    { 0x30080250, "Treatment Date", "DA", "1", 0, 0},
    { 0x30080251, "Treatment Time", "TM", "1", 0, 0},
    { 0x300A0002, "RT Plan Label", "SH", "1", 0, 0},
    { 0x300A0003, "RT Plan Name", "LO", "1", 0, 0},
    { 0x300A0004, "RT Plan Description", "ST", "1", 0, 0},
    { 0x300A0006, "RT Plan Date", "DA", "1", 0, 0},
    { 0x300A0007, "RT Plan Time", "TM", "1", 0, 0},
    { 0x300A0009, "Treatment Protocols", "LO", "1-n", 0, 0},
    { 0x300A000A, "Plan Intent", "CS", "1", 0, 0},
    { 0x300A000B, "Treatment Sites", "LO", "1-n", 0, 0},
    { 0x300A000C, "RT Plan Geometry", "CS", "1", 0, 0},
    { 0x300A000E, "Prescription Description", "ST", "1", 0, 0},
    { 0x300A0010, "Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x300A0012, "Dose Reference Number", "IS", "1", 0, 0},
    { 0x300A0013, "Dose Reference UID", "UI", "1", 0, 0},
    { 0x300A0014, "Dose Reference Structure Type", "CS", "1", 0, -1},
    { 0x300A0015, "Nominal Beam Energy Unit", "CS", "1", 0, 0},
    { 0x300A0016, "Dose Reference Description", "LO", "1", 0, -1},
    { 0x300A0018, "Dose Reference Point Coordinates", "DS", "3", 0, 0},
    { 0x300A001A, "Nominal Prior Dose", "DS", "1", 0, 0},
    { 0x300A0020, "Dose Reference Type", "CS", "1", 0, -1},
    { 0x300A0021, "Constraint Weight", "DS", "1", 0, 0},
    { 0x300A0022, "Delivery Warning Dose", "DS", "1", 0, 0},
    { 0x300A0023, "Delivery Maximum Dose", "DS", "1", 0, 0},
    { 0x300A0025, "Target Minimum Dose", "DS", "1", 0, 0},
    { 0x300A0026, "Target Prescription Dose", "DS", "1", 0, -1},
    { 0x300A0027, "Target Maximum Dose", "DS", "1", 0, 0},
    { 0x300A0028, "Target Underdose Volume Fraction", "DS", "1", 0, 0},
    { 0x300A002A, "Organ at Risk Full-volume Dose", "DS", "1", 0, 0},
    { 0x300A002B, "Organ at Risk Limit Dose", "DS", "1", 0, 0},
    { 0x300A002C, "Organ at Risk Maximum Dose", "DS", "1", 0, 0},
    { 0x300A002D, "Organ at Risk Overdose Volume Fraction", "DS", "1", 0, 0},
    { 0x300A0040, "Tolerance Table Sequence", "SQ", "1", 0, 0},
    { 0x300A0042, "Tolerance Table Number", "IS", "1", 0, 0},
    { 0x300A0043, "Tolerance Table Label", "SH", "1", 0, -1},
    { 0x300A0044, "Gantry Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A0046, "Beam Limiting Device Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A0048, "Beam Limiting Device Tolerance Sequence", "SQ", "1", 0, 0},
    { 0x300A004A, "Beam Limiting Device Position Tolerance", "DS", "1", 0, -1},
    { 0x300A004B, "Snout Position Tolerance", "FL", "1", 0, 0},
    { 0x300A004C, "Patient Support Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A004E, "Table Top Eccentric Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A004F, "Table Top Pitch Angle Tolerance", "FL", "1", 0, 0},
    { 0x300A0050, "Table Top Roll Angle Tolerance", "FL", "1", 0, 0},
    { 0x300A0051, "Table Top Vertical Position Tolerance", "DS", "1", 0, 0},
    { 0x300A0052, "Table Top Longitudinal Position Tolerance", "DS", "1", 0, 0},
    { 0x300A0053, "Table Top Lateral Position Tolerance", "DS", "1", 0, 0},
    { 0x300A0055, "RT Plan Relationship", "CS", "1", 0, 0},
    { 0x300A0070, "Fraction Group Sequence", "SQ", "1", 0, 0},
    { 0x300A0071, "Fraction Group Number", "IS", "1", 0, 0},
    { 0x300A0072, "Fraction Group Description", "LO", "1", 0, 0},
    { 0x300A0078, "Number of Fractions Planned", "IS", "1", 0, -1},
    { 0x300A0079, "Number of Fraction Pattern Digits Per Day", "IS", "1", 0, 0},
    { 0x300A007A, "Repeat Fraction Cycle Length", "IS", "1", 0, 0},
    { 0x300A007B, "Fraction Pattern", "LT", "1", 0, 0},
    { 0x300A0080, "Number of Beams", "IS", "1", 0, 0},
    { 0x300A0082, "Beam Dose Specification Point", "DS", "3", -1, 0},
    { 0x300A0083, "Referenced Dose Reference UID", "UI", "1", 0, 0},
    { 0x300A0084, "Beam Dose", "DS", "1", 0, 0},
    { 0x300A0086, "Beam Meterset", "DS", "1", 0, 0},
    { 0x300A0088, "Beam Dose Point Depth", "FL", "1", 0, 0},
    { 0x300A0089, "Beam Dose Point Equivalent Depth", "FL", "1", 0, 0},
    { 0x300A008A, "Beam Dose Point SSD", "FL", "1", 0, 0},
    { 0x300A008B, "Beam Dose Meaning", "CS", "1", 0, 0},
    { 0x300A008C, "Beam Dose Verification Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300A008D, "Average Beam Dose Point Depth", "FL", "1", -1, 0},
    { 0x300A008E, "Average Beam Dose Point Equivalent Depth", "FL", "1", -1, 0},
    { 0x300A008F, "Average Beam Dose Point SSD", "FL", "1", -1, 0},
    { 0x300A0090, "Beam Dose Type", "CS", "1", 0, 0},
    { 0x300A0091, "Alternate Beam Dose", "DS", "1", 0, 0},
    { 0x300A0092, "Alternate Beam Dose Type", "CS", "1", 0, 0},
    { 0x300A0093, "Depth Value Averaging Flag", "CS", "1", 0, 0},
    { 0x300A0094, "Beam Dose Point Source to External Contour Distance", "DS", "1", 0, 0},
    { 0x300A00A0, "Number of Brachy Application Setups", "IS", "1", 0, 0},
    { 0x300A00A2, "Brachy Application Setup Dose Specification Point", "DS", "3", 0, 0},
    { 0x300A00A4, "Brachy Application Setup Dose", "DS", "1", 0, 0},
    { 0x300A00B0, "Beam Sequence", "SQ", "1", 0, 0},
    { 0x300A00B2, "Treatment Machine Name", "SH", "1", 0, -1},
    { 0x300A00B3, "Primary Dosimeter Unit", "CS", "1", 0, 0},
    { 0x300A00B4, "Source-Axis Distance", "DS", "1", 0, 0},
    { 0x300A00B6, "Beam Limiting Device Sequence", "SQ", "1", 0, 0},
    { 0x300A00B8, "RT Beam Limiting Device Type", "CS", "1", 0, -1},
    { 0x300A00BA, "Source to Beam Limiting Device Distance", "DS", "1", 0, 0},
    { 0x300A00BB, "Isocenter to Beam Limiting Device Distance", "FL", "1", 0, 0},
    { 0x300A00BC, "Number of Leaf/Jaw Pairs", "IS", "1", 0, 0},
    { 0x300A00BE, "Leaf Position Boundaries", "DS", "3-n", 0, 0},
    { 0x300A00C0, "Beam Number", "IS", "1", 0, -1},
    { 0x300A00C2, "Beam Name", "LO", "1", 0, -1},
    { 0x300A00C3, "Beam Description", "ST", "1", 0, 0},
    { 0x300A00C4, "Beam Type", "CS", "1", 0, -1},
    { 0x300A00C5, "Beam Delivery Duration Limit", "FD", "1", 0, 0},
    { 0x300A00C6, "Radiation Type", "CS", "1", 0, -1},
    { 0x300A00C7, "High-Dose Technique Type", "CS", "1", 0, 0},
    { 0x300A00C8, "Reference Image Number", "IS", "1", 0, 0},
    { 0x300A00CA, "Planned Verification Image Sequence", "SQ", "1", 0, 0},
    { 0x300A00CC, "Imaging Device-Specific Acquisition Parameters", "LO", "1-n", 0, 0},
    { 0x300A00CE, "Treatment Delivery Type", "CS", "1", 0, 0},
    { 0x300A00D0, "Number of Wedges", "IS", "1", 0, 0},
    { 0x300A00D1, "Wedge Sequence", "SQ", "1", 0, 0},
    { 0x300A00D2, "Wedge Number", "IS", "1", 0, 0},
    { 0x300A00D3, "Wedge Type", "CS", "1", 0, -1},
    { 0x300A00D4, "Wedge ID", "SH", "1", 0, -1},
    { 0x300A00D5, "Wedge Angle", "IS", "1", 0, -1},
    { 0x300A00D6, "Wedge Factor", "DS", "1", 0, 0},
    { 0x300A00D7, "Total Wedge Tray Water-Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A00D8, "Wedge Orientation", "DS", "1", 0, 0},
    { 0x300A00D9, "Isocenter to Wedge Tray Distance", "FL", "1", 0, 0},
    { 0x300A00DA, "Source to Wedge Tray Distance", "DS", "1", 0, 0},
    { 0x300A00DB, "Wedge Thin Edge Position", "FL", "1", 0, 0},
    { 0x300A00DC, "Bolus ID", "SH", "1", 0, 0},
    { 0x300A00DD, "Bolus Description", "ST", "1", 0, 0},
    { 0x300A00DE, "Effective Wedge Angle", "DS", "1", 0, 0},
    { 0x300A00E0, "Number of Compensators", "IS", "1", 0, 0},
    { 0x300A00E1, "Material ID", "SH", "1", 0, -1},
    { 0x300A00E2, "Total Compensator Tray Factor", "DS", "1", 0, 0},
    { 0x300A00E3, "Compensator Sequence", "SQ", "1", 0, 0},
    { 0x300A00E4, "Compensator Number", "IS", "1", 0, 0},
    { 0x300A00E5, "Compensator ID", "SH", "1", 0, 0},
    { 0x300A00E6, "Source to Compensator Tray Distance", "DS", "1", 0, 0},
    { 0x300A00E7, "Compensator Rows", "IS", "1", 0, 0},
    { 0x300A00E8, "Compensator Columns", "IS", "1", 0, 0},
    { 0x300A00E9, "Compensator Pixel Spacing", "DS", "2", 0, 0},
    { 0x300A00EA, "Compensator Position", "DS", "2", 0, 0},
    { 0x300A00EB, "Compensator Transmission Data", "DS", "1-n", 0, 0},
    { 0x300A00EC, "Compensator Thickness Data", "DS", "1-n", 0, 0},
    { 0x300A00ED, "Number of Boli", "IS", "1", 0, 0},
    { 0x300A00EE, "Compensator Type", "CS", "1", 0, 0},
    { 0x300A00EF, "Compensator Tray ID", "SH", "1", 0, 0},
    { 0x300A00F0, "Number of Blocks", "IS", "1", 0, 0},
    { 0x300A00F2, "Total Block Tray Factor", "DS", "1", 0, 0},
    { 0x300A00F3, "Total Block Tray Water-Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A00F4, "Block Sequence", "SQ", "1", 0, 0},
    { 0x300A00F5, "Block Tray ID", "SH", "1", 0, -1},
    { 0x300A00F6, "Source to Block Tray Distance", "DS", "1", 0, 0},
    { 0x300A00F7, "Isocenter to Block Tray Distance", "FL", "1", 0, 0},
    { 0x300A00F8, "Block Type", "CS", "1", 0, 0},
    { 0x300A00F9, "Accessory Code", "LO", "1", 0, 0},
    { 0x300A00FA, "Block Divergence", "CS", "1", 0, 0},
    { 0x300A00FB, "Block Mounting Position", "CS", "1", 0, 0},
    { 0x300A00FC, "Block Number", "IS", "1", 0, 0},
    { 0x300A00FE, "Block Name", "LO", "1", 0, -1},
    { 0x300A0100, "Block Thickness", "DS", "1", 0, 0},
    { 0x300A0102, "Block Transmission", "DS", "1", 0, 0},
    { 0x300A0104, "Block Number of Points", "IS", "1", 0, 0},
    { 0x300A0106, "Block Data", "DS", "2-2n", 0, 0},
    { 0x300A0107, "Applicator Sequence", "SQ", "1", 0, 0},
    { 0x300A0108, "Applicator ID", "SH", "1", 0, -1},
    { 0x300A0109, "Applicator Type", "CS", "1", 0, -1},
    { 0x300A010A, "Applicator Description", "LO", "1", 0, 0},
    { 0x300A010C, "Cumulative Dose Reference Coefficient", "DS", "1", 0, 0},
    { 0x300A010E, "Final Cumulative Meterset Weight", "DS", "1", 0, 0},
    { 0x300A0110, "Number of Control Points", "IS", "1", 0, 0},
    { 0x300A0111, "Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300A0112, "Control Point Index", "IS", "1", 0, -1},
    { 0x300A0114, "Nominal Beam Energy", "DS", "1", 0, -1},
    { 0x300A0115, "Dose Rate Set", "DS", "1", 0, 0},
    { 0x300A0116, "Wedge Position Sequence", "SQ", "1", 0, 0},
    { 0x300A0118, "Wedge Position", "CS", "1", 0, 0},
    { 0x300A011A, "Beam Limiting Device Position Sequence", "SQ", "1", 0, 0},
    { 0x300A011C, "Leaf/Jaw Positions", "DS", "2-2n", 0, 0},
    { 0x300A011E, "Gantry Angle", "DS", "1", 0, 0},
    { 0x300A011F, "Gantry Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0120, "Beam Limiting Device Angle", "DS", "1", 0, 0},
    { 0x300A0121, "Beam Limiting Device Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0122, "Patient Support Angle", "DS", "1", 0, 0},
    { 0x300A0123, "Patient Support Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0124, "Table Top Eccentric Axis Distance", "DS", "1", 0, 0},
    { 0x300A0125, "Table Top Eccentric Angle", "DS", "1", 0, 0},
    { 0x300A0126, "Table Top Eccentric Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0128, "Table Top Vertical Position", "DS", "1", 0, 0},
    { 0x300A0129, "Table Top Longitudinal Position", "DS", "1", 0, 0},
    { 0x300A012A, "Table Top Lateral Position", "DS", "1", 0, 0},
    { 0x300A012C, "Isocenter Position", "DS", "3", 0, 0},
    { 0x300A012E, "Surface Entry Point", "DS", "3", 0, 0},
    { 0x300A0130, "Source to Surface Distance", "DS", "1", 0, 0},
    { 0x300A0131, "Average Beam Dose Point Source to External Contour Distance", "FL", "1", 0, 0},
    { 0x300A0132, "Source to External Contour Distance", "FL", "1", 0, 0},
    { 0x300A0133, "External Contour Entry Point", "FL", "3", 0, 0},
    { 0x300A0134, "Cumulative Meterset Weight", "DS", "1", 0, -1},
    { 0x300A0140, "Table Top Pitch Angle", "FL", "1", 0, 0},
    { 0x300A0142, "Table Top Pitch Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0144, "Table Top Roll Angle", "FL", "1", 0, 0},
    { 0x300A0146, "Table Top Roll Rotation Direction", "CS", "1", 0, 0},
    { 0x300A0148, "Head Fixation Angle", "FL", "1", 0, 0},
    { 0x300A014A, "Gantry Pitch Angle", "FL", "1", 0, 0},
    { 0x300A014C, "Gantry Pitch Rotation Direction", "CS", "1", 0, 0},
    { 0x300A014E, "Gantry Pitch Angle Tolerance", "FL", "1", 0, 0},
    { 0x300A0150, "Fixation Eye", "CS", "1", 0, 0},
    { 0x300A0151, "Chair Head Frame Position", "DS", "1", 0, 0},
    { 0x300A0152, "Head Fixation Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A0153, "Chair Head Frame Position Tolerance", "DS", "1", 0, 0},
    { 0x300A0154, "Fixation Light Azimuthal Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A0155, "Fixation Light Polar Angle Tolerance", "DS", "1", 0, 0},
    { 0x300A0180, "Patient Setup Sequence", "SQ", "1", 0, 0},
    { 0x300A0182, "Patient Setup Number", "IS", "1", 0, -1},
    { 0x300A0183, "Patient Setup Label", "LO", "1", 0, 0},
    { 0x300A0184, "Patient Additional Position", "LO", "1", 0, 0},
    { 0x300A0190, "Fixation Device Sequence", "SQ", "1", 0, 0},
    { 0x300A0192, "Fixation Device Type", "CS", "1", 0, 0},
    { 0x300A0194, "Fixation Device Label", "SH", "1", 0, 0},
    { 0x300A0196, "Fixation Device Description", "ST", "1", 0, 0},
    { 0x300A0198, "Fixation Device Position", "SH", "1", 0, 0},
    { 0x300A0199, "Fixation Device Pitch Angle", "FL", "1", 0, 0},
    { 0x300A019A, "Fixation Device Roll Angle", "FL", "1", 0, 0},
    { 0x300A01A0, "Shielding Device Sequence", "SQ", "1", 0, 0},
    { 0x300A01A2, "Shielding Device Type", "CS", "1", 0, 0},
    { 0x300A01A4, "Shielding Device Label", "SH", "1", 0, 0},
    { 0x300A01A6, "Shielding Device Description", "ST", "1", 0, 0},
    { 0x300A01A8, "Shielding Device Position", "SH", "1", 0, 0},
    { 0x300A01B0, "Setup Technique", "CS", "1", 0, 0},
    { 0x300A01B2, "Setup Technique Description", "ST", "1", 0, 0},
    { 0x300A01B4, "Setup Device Sequence", "SQ", "1", 0, 0},
    { 0x300A01B6, "Setup Device Type", "CS", "1", 0, 0},
    { 0x300A01B8, "Setup Device Label", "SH", "1", 0, 0},
    { 0x300A01BA, "Setup Device Description", "ST", "1", 0, 0},
    { 0x300A01BC, "Setup Device Parameter", "DS", "1", 0, 0},
    { 0x300A01D0, "Setup Reference Description", "ST", "1", 0, 0},
    { 0x300A01D2, "Table Top Vertical Setup Displacement", "DS", "1", 0, 0},
    { 0x300A01D4, "Table Top Longitudinal Setup Displacement", "DS", "1", 0, 0},
    { 0x300A01D6, "Table Top Lateral Setup Displacement", "DS", "1", 0, 0},
    { 0x300A0200, "Brachy Treatment Technique", "CS", "1", 0, 0},
    { 0x300A0202, "Brachy Treatment Type", "CS", "1", 0, 0},
    { 0x300A0206, "Treatment Machine Sequence", "SQ", "1", 0, 0},
    { 0x300A0210, "Source Sequence", "SQ", "1", 0, 0},
    { 0x300A0212, "Source Number", "IS", "1", 0, 0},
    { 0x300A0214, "Source Type", "CS", "1", 0, 0},
    { 0x300A0216, "Source Manufacturer", "LO", "1", 0, 0},
    { 0x300A0218, "Active Source Diameter", "DS", "1", 0, 0},
    { 0x300A021A, "Active Source Length", "DS", "1", 0, 0},
    { 0x300A021B, "Source Model ID", "SH", "1", 0, 0},
    { 0x300A021C, "Source Description", "LO", "1", 0, 0},
    { 0x300A0222, "Source Encapsulation Nominal Thickness", "DS", "1", 0, 0},
    { 0x300A0224, "Source Encapsulation Nominal Transmission", "DS", "1", 0, 0},
    { 0x300A0226, "Source Isotope Name", "LO", "1", 0, 0},
    { 0x300A0228, "Source Isotope Half Life", "DS", "1", 0, 0},
    { 0x300A0229, "Source Strength Units", "CS", "1", 0, 0},
    { 0x300A022A, "Reference Air Kerma Rate", "DS", "1", 0, 0},
    { 0x300A022B, "Source Strength", "DS", "1", 0, 0},
    { 0x300A022C, "Source Strength Reference Date", "DA", "1", 0, 0},
    { 0x300A022E, "Source Strength Reference Time", "TM", "1", 0, 0},
    { 0x300A0230, "Application Setup Sequence", "SQ", "1", 0, 0},
    { 0x300A0232, "Application Setup Type", "CS", "1", 0, 0},
    { 0x300A0234, "Application Setup Number", "IS", "1", 0, 0},
    { 0x300A0236, "Application Setup Name", "LO", "1", 0, 0},
    { 0x300A0238, "Application Setup Manufacturer", "LO", "1", 0, 0},
    { 0x300A0240, "Template Number", "IS", "1", 0, 0},
    { 0x300A0242, "Template Type", "SH", "1", 0, 0},
    { 0x300A0244, "Template Name", "LO", "1", 0, 0},
    { 0x300A0250, "Total Reference Air Kerma", "DS", "1", 0, 0},
    { 0x300A0260, "Brachy Accessory Device Sequence", "SQ", "1", 0, 0},
    { 0x300A0262, "Brachy Accessory Device Number", "IS", "1", 0, 0},
    { 0x300A0263, "Brachy Accessory Device ID", "SH", "1", 0, 0},
    { 0x300A0264, "Brachy Accessory Device Type", "CS", "1", 0, 0},
    { 0x300A0266, "Brachy Accessory Device Name", "LO", "1", 0, 0},
    { 0x300A026A, "Brachy Accessory Device Nominal Thickness", "DS", "1", 0, 0},
    { 0x300A026C, "Brachy Accessory Device Nominal Transmission", "DS", "1", 0, 0},
    { 0x300A0271, "Channel Effective Length", "DS", "1", 0, 0},
    { 0x300A0272, "Channel Inner Length", "DS", "1", 0, 0},
    { 0x300A0273, "Afterloader Channel ID", "SH", "1", 0, 0},
    { 0x300A0274, "Source Applicator Tip Length", "DS", "1", 0, 0},
    { 0x300A0280, "Channel Sequence", "SQ", "1", 0, 0},
    { 0x300A0282, "Channel Number", "IS", "1", 0, 0},
    { 0x300A0284, "Channel Length", "DS", "1", 0, 0},
    { 0x300A0286, "Channel Total Time", "DS", "1", 0, 0},
    { 0x300A0288, "Source Movement Type", "CS", "1", 0, 0},
    { 0x300A028A, "Number of Pulses", "IS", "1", 0, 0},
    { 0x300A028C, "Pulse Repetition Interval", "DS", "1", 0, 0},
    { 0x300A0290, "Source Applicator Number", "IS", "1", 0, 0},
    { 0x300A0291, "Source Applicator ID", "SH", "1", 0, 0},
    { 0x300A0292, "Source Applicator Type", "CS", "1", 0, 0},
    { 0x300A0294, "Source Applicator Name", "LO", "1", 0, 0},
    { 0x300A0296, "Source Applicator Length", "DS", "1", 0, 0},
    { 0x300A0298, "Source Applicator Manufacturer", "LO", "1", 0, 0},
    { 0x300A029C, "Source Applicator Wall Nominal Thickness", "DS", "1", 0, 0},
    { 0x300A029E, "Source Applicator Wall Nominal Transmission", "DS", "1", 0, 0},
    { 0x300A02A0, "Source Applicator Step Size", "DS", "1", 0, 0},
    { 0x300A02A2, "Transfer Tube Number", "IS", "1", 0, 0},
    { 0x300A02A4, "Transfer Tube Length", "DS", "1", 0, 0},
    { 0x300A02B0, "Channel Shield Sequence", "SQ", "1", 0, 0},
    { 0x300A02B2, "Channel Shield Number", "IS", "1", 0, 0},
    { 0x300A02B3, "Channel Shield ID", "SH", "1", 0, 0},
    { 0x300A02B4, "Channel Shield Name", "LO", "1", 0, 0},
    { 0x300A02B8, "Channel Shield Nominal Thickness", "DS", "1", 0, 0},
    { 0x300A02BA, "Channel Shield Nominal Transmission", "DS", "1", 0, 0},
    { 0x300A02C8, "Final Cumulative Time Weight", "DS", "1", 0, 0},
    { 0x300A02D0, "Brachy Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300A02D2, "Control Point Relative Position", "DS", "1", 0, 0},
    { 0x300A02D4, "Control Point 3D Position", "DS", "3", 0, 0},
    { 0x300A02D6, "Cumulative Time Weight", "DS", "1", 0, 0},
    { 0x300A02E0, "Compensator Divergence", "CS", "1", 0, 0},
    { 0x300A02E1, "Compensator Mounting Position", "CS", "1", 0, 0},
    { 0x300A02E2, "Source to Compensator Distance", "DS", "1-n", 0, 0},
    { 0x300A02E3, "Total Compensator Tray Water-Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A02E4, "Isocenter to Compensator Tray Distance", "FL", "1", 0, 0},
    { 0x300A02E5, "Compensator Column Offset", "FL", "1", 0, 0},
    { 0x300A02E6, "Isocenter to Compensator Distances", "FL", "1-n", 0, 0},
    { 0x300A02E7, "Compensator Relative Stopping Power Ratio", "FL", "1", 0, 0},
    { 0x300A02E8, "Compensator Milling Tool Diameter", "FL", "1", 0, 0},
    { 0x300A02EA, "Ion Range Compensator Sequence", "SQ", "1", 0, 0},
    { 0x300A02EB, "Compensator Description", "LT", "1", 0, 0},
    { 0x300A0302, "Radiation Mass Number", "IS", "1", 0, 0},
    { 0x300A0304, "Radiation Atomic Number", "IS", "1", 0, 0},
    { 0x300A0306, "Radiation Charge State", "SS", "1", 0, 0},
    { 0x300A0308, "Scan Mode", "CS", "1", 0, 0},
    { 0x300A0309, "Modulated Scan Mode Type", "CS", "1", 0, 0},
    { 0x300A030A, "Virtual Source-Axis Distances", "FL", "2", 0, 0},
    { 0x300A030C, "Snout Sequence", "SQ", "1", 0, 0},
    { 0x300A030D, "Snout Position", "FL", "1", 0, 0},
    { 0x300A030F, "Snout ID", "SH", "1", 0, 0},
    { 0x300A0312, "Number of Range Shifters", "IS", "1", 0, 0},
    { 0x300A0314, "Range Shifter Sequence", "SQ", "1", 0, 0},
    { 0x300A0316, "Range Shifter Number", "IS", "1", 0, 0},
    { 0x300A0318, "Range Shifter ID", "SH", "1", 0, 0},
    { 0x300A0320, "Range Shifter Type", "CS", "1", 0, 0},
    { 0x300A0322, "Range Shifter Description", "LO", "1", 0, 0},
    { 0x300A0330, "Number of Lateral Spreading Devices", "IS", "1", 0, 0},
    { 0x300A0332, "Lateral Spreading Device Sequence", "SQ", "1", 0, 0},
    { 0x300A0334, "Lateral Spreading Device Number", "IS", "1", 0, 0},
    { 0x300A0336, "Lateral Spreading Device ID", "SH", "1", 0, 0},
    { 0x300A0338, "Lateral Spreading Device Type", "CS", "1", 0, 0},
    { 0x300A033A, "Lateral Spreading Device Description", "LO", "1", 0, 0},
    { 0x300A033C, "Lateral Spreading Device Water Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A0340, "Number of Range Modulators", "IS", "1", 0, 0},
    { 0x300A0342, "Range Modulator Sequence", "SQ", "1", 0, 0},
    { 0x300A0344, "Range Modulator Number", "IS", "1", 0, 0},
    { 0x300A0346, "Range Modulator ID", "SH", "1", 0, 0},
    { 0x300A0348, "Range Modulator Type", "CS", "1", 0, 0},
    { 0x300A034A, "Range Modulator Description", "LO", "1", 0, 0},
    { 0x300A034C, "Beam Current Modulation ID", "SH", "1", 0, 0},
    { 0x300A0350, "Patient Support Type", "CS", "1", 0, 0},
    { 0x300A0352, "Patient Support ID", "SH", "1", 0, 0},
    { 0x300A0354, "Patient Support Accessory Code", "LO", "1", 0, 0},
    { 0x300A0355, "Tray Accessory Code", "LO", "1", 0, 0},
    { 0x300A0356, "Fixation Light Azimuthal Angle", "FL", "1", 0, 0},
    { 0x300A0358, "Fixation Light Polar Angle", "FL", "1", 0, 0},
    { 0x300A035A, "Meterset Rate", "FL", "1", 0, 0},
    { 0x300A0360, "Range Shifter Settings Sequence", "SQ", "1", 0, 0},
    { 0x300A0362, "Range Shifter Setting", "LO", "1", 0, 0},
    { 0x300A0364, "Isocenter to Range Shifter Distance", "FL", "1", 0, 0},
    { 0x300A0366, "Range Shifter Water Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A0370, "Lateral Spreading Device Settings Sequence", "SQ", "1", 0, 0},
    { 0x300A0372, "Lateral Spreading Device Setting", "LO", "1", 0, 0},
    { 0x300A0374, "Isocenter to Lateral Spreading Device Distance", "FL", "1", 0, 0},
    { 0x300A0380, "Range Modulator Settings Sequence", "SQ", "1", 0, 0},
    { 0x300A0382, "Range Modulator Gating Start Value", "FL", "1", 0, 0},
    { 0x300A0384, "Range Modulator Gating Stop Value", "FL", "1", 0, 0},
    { 0x300A0386, "Range Modulator Gating Start Water Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A0388, "Range Modulator Gating Stop Water Equivalent Thickness", "FL", "1", 0, 0},
    { 0x300A038A, "Isocenter to Range Modulator Distance", "FL", "1", 0, 0},
    { 0x300A038F, "Scan Spot Time Offset", "FL", "1-n", 0, 0},
    { 0x300A0390, "Scan Spot Tune ID", "SH", "1", 0, 0},
    { 0x300A0391, "Scan Spot Prescribed Indices", "IS", "1-n", 0, 0},
    { 0x300A0392, "Number of Scan Spot Positions", "IS", "1", 0, 0},
    { 0x300A0393, "Scan Spot Reordered", "CS", "1", 0, 0},
    { 0x300A0394, "Scan Spot Position Map", "FL", "1-n", 0, 0},
    { 0x300A0395, "Scan Spot Reordering Allowed", "CS", "1", 0, 0},
    { 0x300A0396, "Scan Spot Meterset Weights", "FL", "1-n", 0, 0},
    { 0x300A0398, "Scanning Spot Size", "FL", "2", 0, 0},
    { 0x300A039A, "Number of Paintings", "IS", "1", 0, 0},
    { 0x300A03A0, "Ion Tolerance Table Sequence", "SQ", "1", 0, 0},
    { 0x300A03A2, "Ion Beam Sequence", "SQ", "1", 0, 0},
    { 0x300A03A4, "Ion Beam Limiting Device Sequence", "SQ", "1", 0, 0},
    { 0x300A03A6, "Ion Block Sequence", "SQ", "1", 0, 0},
    { 0x300A03A8, "Ion Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300A03AA, "Ion Wedge Sequence", "SQ", "1", 0, 0},
    { 0x300A03AC, "Ion Wedge Position Sequence", "SQ", "1", 0, 0},
    { 0x300A0401, "Referenced Setup Image Sequence", "SQ", "1", 0, 0},
    { 0x300A0402, "Setup Image Comment", "ST", "1", 0, 0},
    { 0x300A0410, "Motion Synchronization Sequence", "SQ", "1", 0, 0},
    { 0x300A0412, "Control Point Orientation", "FL", "3", 0, 0},
    { 0x300A0420, "General Accessory Sequence", "SQ", "1", 0, 0},
    { 0x300A0421, "General Accessory ID", "SH", "1", 0, 0},
    { 0x300A0422, "General Accessory Description", "ST", "1", 0, 0},
    { 0x300A0423, "General Accessory Type", "CS", "1", 0, 0},
    { 0x300A0424, "General Accessory Number", "IS", "1", 0, 0},
    { 0x300A0425, "Source to General Accessory Distance", "FL", "1", 0, 0},
    { 0x300A0426, "Isocenter to General Accessory Distance", "DS", "1", 0, 0},
    { 0x300A0431, "Applicator Geometry Sequence", "SQ", "1", 0, 0},
    { 0x300A0432, "Applicator Aperture Shape", "CS", "1", 0, 0},
    { 0x300A0433, "Applicator Opening", "FL", "1", 0, 0},
    { 0x300A0434, "Applicator Opening X", "FL", "1", 0, 0},
    { 0x300A0435, "Applicator Opening Y", "FL", "1", 0, 0},
    { 0x300A0436, "Source to Applicator Mounting Position Distance", "FL", "1", 0, 0},
    { 0x300A0440, "Number of Block Slab Items", "IS", "1", 0, 0},
    { 0x300A0441, "Block Slab Sequence", "SQ", "1", 0, 0},
    { 0x300A0442, "Block Slab Thickness", "DS", "1", 0, 0},
    { 0x300A0443, "Block Slab Number", "US", "1", 0, 0},
    { 0x300A0450, "Device Motion Control Sequence", "SQ", "1", 0, 0},
    { 0x300A0451, "Device Motion Execution Mode", "CS", "1", 0, 0},
    { 0x300A0452, "Device Motion Observation Mode", "CS", "1", 0, 0},
    { 0x300A0453, "Device Motion Parameter Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0501, "Distal Depth Fraction", "FL", "1", 0, 0},
    { 0x300A0502, "Distal Depth", "FL", "1", 0, 0},
    { 0x300A0503, "Nominal Range Modulation Fractions", "FL", "2", 0, 0},
    { 0x300A0504, "Nominal Range Modulated Region Depths", "FL", "2", 0, 0},
    { 0x300A0505, "Depth Dose Parameters Sequence", "SQ", "1", 0, 0},
    { 0x300A0506, "Delivered Depth Dose Parameters Sequence", "SQ", "1", 0, 0},
    { 0x300A0507, "Delivered Distal Depth Fraction", "FL", "1", 0, 0},
    { 0x300A0508, "Delivered Distal Depth", "FL", "1", 0, 0},
    { 0x300A0509, "Delivered Nominal Range Modulation Fractions", "FL", "2", 0, 0},
    { 0x300A0510, "Delivered Nominal Range Modulated Region Depths", "FL", "2", 0, 0},
    { 0x300A0511, "Delivered Reference Dose Definition", "CS", "1", 0, 0},
    { 0x300A0512, "Reference Dose Definition", "CS", "1", 0, 0},
    { 0x300A0600, "RT Control Point Index", "US", "1", 0, 0},
    { 0x300A0601, "Radiation Generation Mode Index", "US", "1", 0, 0},
    { 0x300A0602, "Referenced Defined Device Index", "US", "1", 0, 0},
    { 0x300A0603, "Radiation Dose Identification Index", "US", "1", 0, 0},
    { 0x300A0604, "Number of RT Control Points", "US", "1", 0, 0},
    { 0x300A0605, "Referenced Radiation Generation Mode Index", "US", "1", 0, 0},
    { 0x300A0606, "Treatment Position Index", "US", "1", 0, 0},
    { 0x300A0607, "Referenced Device Index", "US", "1", 0, 0},
    { 0x300A0608, "Treatment Position Group Label", "LO", "1", 0, 0},
    { 0x300A0609, "Treatment Position Group UID", "UI", "1", 0, 0},
    { 0x300A060A, "Treatment Position Group Sequence", "SQ", "1", 0, 0},
    { 0x300A060B, "Referenced Treatment Position Index", "US", "1", 0, 0},
    { 0x300A060C, "Referenced Radiation Dose Identification Index", "US", "1", 0, 0},
    { 0x300A060D, "RT Accessory Holder Water-Equivalent Thickness", "FD", "1", 0, 0},
    { 0x300A060E, "Referenced RT Accessory Holder Device Index", "US", "1", 0, 0},
    { 0x300A060F, "RT Accessory Holder Slot Existence Flag", "CS", "1", 0, 0},
    { 0x300A0610, "RT Accessory Holder Slot Sequence", "SQ", "1", 0, 0},
    { 0x300A0611, "RT Accessory Holder Slot ID", "LO", "1", 0, 0},
    { 0x300A0612, "RT Accessory Holder Slot Distance", "FD", "1", 0, 0},
    { 0x300A0613, "RT Accessory Slot Distance", "FD", "1", 0, 0},
    { 0x300A0614, "RT Accessory Holder Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A0615, "RT Accessory Device Slot ID", "LO", "1", 0, 0},
    { 0x300A0616, "RT Radiation Sequence", "SQ", "1", 0, 0},
    { 0x300A0617, "Radiation Dose Sequence", "SQ", "1", 0, 0},
    { 0x300A0618, "Radiation Dose Identification Sequence", "SQ", "1", 0, 0},
    { 0x300A0619, "Radiation Dose Identification Label", "LO", "1", 0, 0},
    { 0x300A061A, "Reference Dose Type", "CS", "1", 0, 0},
    { 0x300A061B, "Primary Dose Value Indicator", "CS", "1", 0, 0},
    { 0x300A061C, "Dose Values Sequence", "SQ", "1", 0, 0},
    { 0x300A061D, "Dose Value Purpose", "CS", "1-n", 0, 0},
    { 0x300A061E, "Reference Dose Point Coordinates", "FD", "3", 0, 0},
    { 0x300A061F, "Radiation Dose Values Parameters Sequence", "SQ", "1", 0, 0},
    { 0x300A0620, "Meterset to Dose Mapping Sequence", "SQ", "1", 0, 0},
    { 0x300A0621, "Expected In-Vivo Measurement Values Sequence", "SQ", "1", 0, 0},
    { 0x300A0622, "Expected In-Vivo Measurement Value Index", "US", "1", 0, 0},
    { 0x300A0623, "Radiation Dose In-Vivo Measurement Label", "LO", "1", 0, 0},
    { 0x300A0624, "Radiation Dose Central Axis Displacement", "FD", "2", 0, 0},
    { 0x300A0625, "Radiation Dose Value", "FD", "1", 0, 0},
    { 0x300A0626, "Radiation Dose Source to Skin Distance", "FD", "1", 0, 0},
    { 0x300A0627, "Radiation Dose Measurement Point Coordinates", "FD", "3", 0, 0},
    { 0x300A0628, "Radiation Dose Source to External Contour Distance", "FD", "1", 0, 0},
    { 0x300A0629, "RT Tolerance Set Sequence", "SQ", "1", 0, 0},
    { 0x300A062A, "RT Tolerance Set Label", "LO", "1", 0, 0},
    { 0x300A062B, "Attribute Tolerance Values Sequence", "SQ", "1", 0, 0},
    { 0x300A062C, "Tolerance Value", "FD", "1", 0, 0},
    { 0x300A062D, "Patient Support Position Tolerance Sequence", "SQ", "1", 0, 0},
    { 0x300A062E, "Treatment Time Limit", "FD", "1", 0, 0},
    { 0x300A062F, "C-Arm Photon-Electron Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300A0630, "Referenced RT Radiation Sequence", "SQ", "1", 0, 0},
    { 0x300A0631, "Referenced RT Instance Sequence", "SQ", "1", 0, 0},
    { 0x300A0632, "Referenced RT Patient Setup Sequence", "SQ", "1", 0, 0},
    { 0x300A0634, "Source to Patient Surface Distance", "FD", "1", 0, 0},
    { 0x300A0635, "Treatment Machine Special Mode Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0636, "Intended Number of Fractions", "US", "1", 0, 0},
    { 0x300A0637, "RT Radiation Set Intent", "CS", "1", 0, 0},
    { 0x300A0638, "RT Radiation Physical and Geometric Content Detail Flag", "CS", "1", 0, 0},
    { 0x300A0639, "RT Record Flag", "CS", "1", 0, 0},
    { 0x300A063A, "Treatment Device Identification Sequence", "SQ", "1", 0, 0},
    { 0x300A063B, "Referenced RT Physician Intent Sequence", "SQ", "1", 0, 0},
    { 0x300A063C, "Cumulative Meterset", "FD", "1", 0, 0},
    { 0x300A063D, "Delivery Rate", "FD", "1", 0, 0},
    { 0x300A063E, "Delivery Rate Unit Sequence", "SQ", "1", 0, 0},
    { 0x300A063F, "Treatment Position Sequence", "SQ", "1", 0, 0},
    { 0x300A0640, "Radiation Source-Axis Distance", "FD", "1", 0, 0},
    { 0x300A0641, "Number of RT Beam Limiting Devices", "US", "1", 0, 0},
    { 0x300A0642, "RT Beam Limiting Device Proximal Distance", "FD", "1", 0, 0},
    { 0x300A0643, "RT Beam Limiting Device Distal Distance", "FD", "1", 0, 0},
    { 0x300A0644, "Parallel RT Beam Delimiter Device Orientation Label Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0645, "Beam Modifier Orientation Angle", "FD", "1", 0, 0},
    { 0x300A0646, "Fixed RT Beam Delimiter Device Sequence", "SQ", "1", 0, 0},
    { 0x300A0647, "Parallel RT Beam Delimiter Device Sequence", "SQ", "1", 0, 0},
    { 0x300A0648, "Number of Parallel RT Beam Delimiters", "US", "1", 0, 0},
    { 0x300A0649, "Parallel RT Beam Delimiter Boundaries", "FD", "2-n", 0, 0},
    { 0x300A064A, "Parallel RT Beam Delimiter Positions", "FD", "2-n", 0, 0},
    { 0x300A064B, "RT Beam Limiting Device Offset", "FD", "2", 0, 0},
    { 0x300A064C, "RT Beam Delimiter Geometry Sequence", "SQ", "1", 0, 0},
    { 0x300A064D, "RT Beam Limiting Device Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A064E, "Parallel RT Beam Delimiter Opening Mode", "CS", "1", 0, 0},
    { 0x300A064F, "Parallel RT Beam Delimiter Leaf Mounting Side", "CS", "1-n", 0, 0},
    { 0x300A0650, "Patient Setup UID", "UI", "1", 0, 0},
    { 0x300A0651, "Wedge Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A0652, "Radiation Beam Wedge Angle", "FD", "1", 0, 0},
    { 0x300A0653, "Radiation Beam Wedge Thin Edge Distance", "FD", "1", 0, 0},
    { 0x300A0654, "Radiation Beam Effective Wedge Angle", "FD", "1", 0, 0},
    { 0x300A0655, "Number of Wedge Positions", "US", "1", 0, 0},
    { 0x300A0656, "RT Beam Limiting Device Opening Sequence", "SQ", "1", 0, 0},
    { 0x300A0657, "Number of RT Beam Limiting Device Openings", "US", "1", 0, 0},
    { 0x300A0658, "Radiation Dosimeter Unit Sequence", "SQ", "1", 0, 0},
    { 0x300A0659, "RT Device Distance Reference Location Code Sequence", "SQ", "1", 0, 0},
    { 0x300A065A, "Radiation Device Configuration and Commissioning Key Sequence", "SQ", "1", 0, 0},
    { 0x300A065B, "Patient Support Position Parameter Sequence", "SQ", "1", 0, 0},
    { 0x300A065C, "Patient Support Position Specification Method", "CS", "1", 0, 0},
    { 0x300A065D, "Patient Support Position Device Parameter Sequence", "SQ", "1", 0, 0},
    { 0x300A065E, "Device Order Index", "US", "1", 0, 0},
    { 0x300A065F, "Patient Support Position Parameter Order Index", "US", "1", 0, 0},
    { 0x300A0660, "Patient Support Position Device Tolerance Sequence", "SQ", "1", 0, 0},
    { 0x300A0661, "Patient Support Position Tolerance Order Index", "US", "1", 0, 0},
    { 0x300A0662, "Compensator Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A0663, "Compensator Map Orientation", "CS", "1", 0, 0},
    { 0x300A0664, "Compensator Proximal Thickness Map", "OF", "1", 0, 0},
    { 0x300A0665, "Compensator Distal Thickness Map", "OF", "1", 0, 0},
    { 0x300A0666, "Compensator Base Plane Offset", "FD", "1", 0, 0},
    { 0x300A0667, "Compensator Shape Fabrication Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0668, "Compensator Shape Sequence", "SQ", "1", 0, 0},
    { 0x300A0669, "Radiation Beam Compensator Milling Tool Diameter", "FD", "1", 0, 0},
    { 0x300A066A, "Block Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A066B, "Block Edge Data", "OF", "1", 0, 0},
    { 0x300A066C, "Block Orientation", "CS", "1", 0, 0},
    { 0x300A066D, "Radiation Beam Block Thickness", "FD", "1", 0, 0},
    { 0x300A066E, "Radiation Beam Block Slab Thickness", "FD", "1", 0, 0},
    { 0x300A066F, "Block Edge Data Sequence", "SQ", "1", 0, 0},
    { 0x300A0670, "Number of RT Accessory Holders", "US", "1", 0, 0},
    { 0x300A0671, "General Accessory Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A0672, "Number of General Accessories", "US", "1", 0, 0},
    { 0x300A0673, "Bolus Definition Sequence", "SQ", "1", 0, 0},
    { 0x300A0674, "Number of Boluses", "US", "1", 0, 0},
    { 0x300A0675, "Equipment Frame of Reference UID", "UI", "1", 0, 0},
    { 0x300A0676, "Equipment Frame of Reference Description", "ST", "1", 0, 0},
    { 0x300A0677, "Equipment Reference Point Coordinates Sequence", "SQ", "1", 0, 0},
    { 0x300A0678, "Equipment Reference Point Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0679, "RT Beam Limiting Device Angle", "FD", "1", 0, 0},
    { 0x300A067A, "Source Roll Angle", "FD", "1", 0, 0},
    { 0x300A067B, "Radiation GenerationMode Sequence", "SQ", "1", 0, 0},
    { 0x300A067C, "Radiation GenerationMode Label", "SH", "1", 0, 0},
    { 0x300A067D, "Radiation GenerationMode Description", "ST", "1", 0, 0},
    { 0x300A067E, "Radiation GenerationMode Machine Code Sequence", "SQ", "1", 0, 0},
    { 0x300A067F, "Radiation Type Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0680, "Nominal Energy", "DS", "1", 0, 0},
    { 0x300A0681, "Minimum Nominal Energy", "DS", "1", 0, 0},
    { 0x300A0682, "Maximum Nominal Energy", "DS", "1", 0, 0},
    { 0x300A0683, "Radiation Fluence Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0684, "Energy Unit Code Sequence", "SQ", "1", 0, 0},
    { 0x300A0685, "Number of Radiation GenerationModes", "US", "1", 0, 0},
    { 0x300A0686, "Patient Support Devices Sequence", "SQ", "1", 0, 0},
    { 0x300A0687, "Number of Patient Support Devices", "US", "1", 0, 0},
    { 0x300A0688, "RT Beam Modifier Definition Distance", "FD", "1", 0, 0},
    { 0x300A0689, "Beam Area Limit Sequence", "SQ", "1", 0, 0},
    { 0x300A068A, "Referenced RT Prescription Sequence", "SQ", "1", 0, 0},
    { 0x300C0002, "Referenced RT Plan Sequence", "SQ", "1", 0, 0},
    { 0x300C0004, "Referenced Beam Sequence", "SQ", "1", 0, 0},
    { 0x300C0006, "Referenced Beam Number", "IS", "1", 0, 0},
    { 0x300C0007, "Referenced Reference Image Number", "IS", "1", 0, 0},
    { 0x300C0008, "Start Cumulative Meterset Weight", "DS", "1", 0, 0},
    { 0x300C0009, "End Cumulative Meterset Weight", "DS", "1", 0, 0},
    { 0x300C000A, "Referenced Brachy Application Setup Sequence", "SQ", "1", 0, 0},
    { 0x300C000C, "Referenced Brachy Application Setup Number", "IS", "1", 0, 0},
    { 0x300C000E, "Referenced Source Number", "IS", "1", 0, 0},
    { 0x300C0020, "Referenced Fraction Group Sequence", "SQ", "1", 0, 0},
    { 0x300C0022, "Referenced Fraction Group Number", "IS", "1", 0, 0},
    { 0x300C0040, "Referenced Verification Image Sequence", "SQ", "1", 0, 0},
    { 0x300C0042, "Referenced Reference Image Sequence", "SQ", "1", 0, 0},
    { 0x300C0050, "Referenced Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x300C0051, "Referenced Dose Reference Number", "IS", "1", 0, 0},
    { 0x300C0055, "Brachy Referenced Dose Reference Sequence", "SQ", "1", 0, 0},
    { 0x300C0060, "Referenced Structure Set Sequence", "SQ", "1", 0, 0},
    { 0x300C006A, "Referenced Patient Setup Number", "IS", "1", 0, 0},
    { 0x300C0080, "Referenced Dose Sequence", "SQ", "1", 0, 0},
    { 0x300C00A0, "Referenced Tolerance Table Number", "IS", "1", 0, 0},
    { 0x300C00B0, "Referenced Bolus Sequence", "SQ", "1", 0, 0},
    { 0x300C00C0, "Referenced Wedge Number", "IS", "1", 0, 0},
    { 0x300C00D0, "Referenced Compensator Number", "IS", "1", 0, 0},
    { 0x300C00E0, "Referenced Block Number", "IS", "1", 0, 0},
    { 0x300C00F0, "Referenced Control Point Index", "IS", "1", 0, 0},
    { 0x300C00F2, "Referenced Control Point Sequence", "SQ", "1", 0, 0},
    { 0x300C00F4, "Referenced Start Control Point Index", "IS", "1", 0, 0},
    { 0x300C00F6, "Referenced Stop Control Point Index", "IS", "1", 0, 0},
    { 0x300C0100, "Referenced Range Shifter Number", "IS", "1", 0, 0},
    { 0x300C0102, "Referenced Lateral Spreading Device Number", "IS", "1", 0, 0},
    { 0x300C0104, "Referenced Range Modulator Number", "IS", "1", 0, 0},
    { 0x300C0111, "Omitted Beam Task Sequence", "SQ", "1", 0, 0},
    { 0x300C0112, "Reason for Omission", "CS", "1", 0, 0},
    { 0x300C0113, "Reason for Omission Description", "LO", "1", 0, 0},
    { 0x300E0002, "Approval Status", "CS", "1", 0, 0},
    { 0x300E0004, "Review Date", "DA", "1", 0, 0},
    { 0x300E0005, "Review Time", "TM", "1", 0, 0},
    { 0x300E0008, "Reviewer Name", "PN", "1", 0, 0},
    { 0x30100001, "Radiobiological Dose Effect Sequence", "SQ", "1", 0, 0},
    { 0x30100002, "Radiobiological Dose Effect Flag", "CS", "1", 0, 0},
    { 0x30100003, "Effective Dose Calculation Method Category Code Sequence", "SQ", "1", 0, 0},
    { 0x30100004, "Effective Dose Calculation Method Code Sequence", "SQ", "1", 0, 0},
    { 0x30100005, "Effective Dose Calculation Method Description", "LO", "1", 0, 0},
    { 0x30100006, "Conceptual Volume UID", "UI", "1", 0, 0},
    { 0x30100007, "Originating SOP Instance Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100008, "Conceptual Volume Constituent Sequence", "SQ", "1", 0, 0},
    { 0x30100009, "Equivalent Conceptual Volume Instance Reference Sequence", "SQ", "1", 0, 0},
    { 0x3010000A, "Equivalent Conceptual Volumes Sequence", "SQ", "1", 0, 0},
    { 0x3010000B, "Referenced Conceptual Volume UID", "UI", "1", 0, 0},
    { 0x3010000C, "Conceptual Volume Combination Expression", "UT", "1", 0, 0},
    { 0x3010000D, "Conceptual Volume Constituent Index", "US", "1", 0, 0},
    { 0x3010000E, "Conceptual Volume Combination Flag", "CS", "1", 0, 0},
    { 0x3010000F, "Conceptual Volume Combination Description", "ST", "1", 0, 0},
    { 0x30100010, "Conceptual Volume Segmentation Defined Flag", "CS", "1", 0, 0},
    { 0x30100011, "Conceptual Volume Segmentation Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100012, "Conceptual Volume Constituent Segmentation Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100013, "Constituent Conceptual Volume UID", "UI", "1", 0, 0},
    { 0x30100014, "Derivation Conceptual Volume Sequence", "SQ", "1", 0, 0},
    { 0x30100015, "Source Conceptual Volume UID", "UI", "1", 0, 0},
    { 0x30100016, "Conceptual Volume Derivation Algorithm Sequence", "SQ", "1", 0, 0},
    { 0x30100017, "Conceptual Volume Description", "ST", "1", 0, 0},
    { 0x30100018, "Source Conceptual Volume Sequence", "SQ", "1", 0, 0},
    { 0x30100019, "Author Identification Sequence", "SQ", "1", 0, 0},
    { 0x3010001A, "Manufacturer's Model Version", "LO", "1", 0, 0},
    { 0x3010001B, "Device Alternate Identifier", "UC", "1", 0, 0},
    { 0x3010001C, "Device Alternate Identifier Type", "CS", "1", 0, 0},
    { 0x3010001D, "Device Alternate Identifier Format", "LT", "1", 0, 0},
    { 0x3010001E, "Segmentation Creation Template Label", "LO", "1", 0, 0},
    { 0x3010001F, "Segmentation Template UID", "UI", "1", 0, 0},
    { 0x30100020, "Referenced Segment Reference Index", "US", "1", 0, 0},
    { 0x30100021, "Segment Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100022, "Segment Reference Index", "US", "1", 0, 0},
    { 0x30100023, "Direct Segment Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100024, "Combination Segment Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100025, "Conceptual Volume Sequence", "SQ", "1", 0, 0},
    { 0x30100026, "Segmented RT Accessory Device Sequence", "SQ", "1", 0, 0},
    { 0x30100027, "Segment Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x30100028, "Related Segment Characteristics Sequence", "SQ", "1", 0, 0},
    { 0x30100029, "Segment Characteristics Precedence", "US", "1", 0, 0},
    { 0x3010002A, "RT Segment Annotation Sequence", "SQ", "1", 0, 0},
    { 0x3010002B, "Segment Annotation Category Code Sequence", "SQ", "1", 0, 0},
    { 0x3010002C, "Segment Annotation Type Code Sequence", "SQ", "1", 0, 0},
    { 0x3010002D, "Device Label", "LO", "1", 0, 0},
    { 0x3010002E, "Device Type Code Sequence", "SQ", "1", 0, 0},
    { 0x3010002F, "Segment Annotation Type Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x30100030, "Patient Equipment Relationship Code Sequence", "SQ", "1", 0, 0},
    { 0x30100031, "Referenced Fiducials UID", "UI", "1", 0, 0},
    { 0x30100032, "Patient Treatment Orientation Sequence", "SQ", "1", 0, 0},
    { 0x30100033, "User Content Label", "SH", "1", 0, 0},
    { 0x30100034, "User Content Long Label", "LO", "1", 0, 0},
    { 0x30100035, "Entity Label", "SH", "1", 0, 0},
    { 0x30100036, "Entity Name", "LO", "1", 0, 0},
    { 0x30100037, "Entity Description", "ST", "1", 0, 0},
    { 0x30100038, "Entity Long Label", "LO", "1", 0, 0},
    { 0x30100039, "Device Index", "US", "1", 0, 0},
    { 0x3010003A, "RT Treatment Phase Index", "US", "1", 0, 0},
    { 0x3010003B, "RT Treatment Phase UID", "UI", "1", 0, 0},
    { 0x3010003C, "RT Prescription Index", "US", "1", 0, 0},
    { 0x3010003D, "RT Segment Annotation Index", "US", "1", 0, 0},
    { 0x3010003E, "Basis RT Treatment Phase Index", "US", "1", 0, 0},
    { 0x3010003F, "Related RT Treatment Phase Index", "US", "1", 0, 0},
    { 0x30100040, "Referenced RT Treatment Phase Index", "US", "1", 0, 0},
    { 0x30100041, "Referenced RT Prescription Index", "US", "1", 0, 0},
    { 0x30100042, "Referenced Parent RT Prescription Index", "US", "1", 0, 0},
    { 0x30100043, "Manufacturer's Device Identifier", "ST", "1", 0, 0},
    { 0x30100044, "Instance-Level Referenced Performed Procedure Step Sequence", "SQ", "1", 0, 0},
    { 0x30100045, "RT Treatment Phase Intent Presence Flag", "CS", "1", 0, 0},
    { 0x30100046, "Radiotherapy Treatment Type", "CS", "1", 0, 0},
    { 0x30100047, "Teletherapy Radiation Type", "CS", "1-n", 0, 0},
    { 0x30100048, "Brachytherapy Source Type", "CS", "1-n", 0, 0},
    { 0x30100049, "Referenced RT Treatment Phase Sequence", "SQ", "1", 0, 0},
    { 0x3010004A, "Referenced Direct Segment Instance Sequence", "SQ", "1", 0, 0},
    { 0x3010004B, "Intended RT Treatment Phase Sequence", "SQ", "1", 0, 0},
    { 0x3010004C, "Intended Phase Start Date", "DA", "1", 0, 0},
    { 0x3010004D, "Intended Phase End Date", "DA", "1", 0, 0},
    { 0x3010004E, "RT Treatment Phase Interval Sequence", "SQ", "1", 0, 0},
    { 0x3010004F, "Temporal Relationship Interval Anchor", "CS", "1", 0, 0},
    { 0x30100050, "Minimum Number of Interval Days", "FD", "1", 0, 0},
    { 0x30100051, "Maximum Number of Interval Days", "FD", "1", 0, 0},
    { 0x30100052, "Pertinent SOP Classes in Study", "UI", "1-n", 0, 0},
    { 0x30100053, "Pertinent SOP Classes in Series", "UI", "1-n", 0, 0},
    { 0x30100054, "RT Prescription Label", "LO", "1", 0, 0},
    { 0x30100055, "RT Physician Intent Predecessor Sequence", "SQ", "1", 0, 0},
    { 0x30100056, "RT Treatment Approach Label", "LO", "1", 0, 0},
    { 0x30100057, "RT Physician Intent Sequence", "SQ", "1", 0, 0},
    { 0x30100058, "RT Physician Intent Index", "US", "1", 0, 0},
    { 0x30100059, "RT Treatment Intent Type", "CS", "1", 0, 0},
    { 0x3010005A, "RT Physician Intent Narrative", "UT", "1", 0, 0},
    { 0x3010005B, "RT Protocol Code Sequence", "SQ", "1", 0, 0},
    { 0x3010005C, "Reason for Superseding", "ST", "1", 0, 0},
    { 0x3010005D, "RT Diagnosis Code Sequence", "SQ", "1", 0, 0},
    { 0x3010005E, "Referenced RT Physician Intent Index", "US", "1", 0, 0},
    { 0x3010005F, "RT Physician Intent Input Instance Sequence", "SQ", "1", 0, 0},
    { 0x30100060, "RT Anatomic Prescription Sequence", "SQ", "1", 0, 0},
    { 0x30100061, "Prior Treatment Dose Description", "UT", "1", 0, 0},
    { 0x30100062, "Prior Treatment Reference Sequence", "SQ", "1", 0, 0},
    { 0x30100063, "Dosimetric Objective Evaluation Scope", "CS", "1", 0, 0},
    { 0x30100064, "Therapeutic Role Category Code Sequence", "SQ", "1", 0, 0},
    { 0x30100065, "Therapeutic Role Type Code Sequence", "SQ", "1", 0, 0},
    { 0x30100066, "Conceptual Volume Optimization Precedence", "US", "1", 0, 0},
    { 0x30100067, "Conceptual Volume Category Code Sequence", "SQ", "1", 0, 0},
    { 0x30100068, "Conceptual Volume Blocking Constraint", "CS", "1", 0, 0},
    { 0x30100069, "Conceptual Volume Type Code Sequence", "SQ", "1", 0, 0},
    { 0x3010006A, "Conceptual Volume Type Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x3010006B, "RT Prescription Sequence", "SQ", "1", 0, 0},
    { 0x3010006C, "Dosimetric Objective Sequence", "SQ", "1", 0, 0},
    { 0x3010006D, "Dosimetric Objective Type Code Sequence", "SQ", "1", 0, 0},
    { 0x3010006E, "Dosimetric Objective UID", "UI", "1", 0, 0},
    { 0x3010006F, "Referenced Dosimetric Objective UID", "UI", "1", 0, 0},
    { 0x30100070, "Dosimetric Objective Parameter Sequence", "SQ", "1", 0, 0},
    { 0x30100071, "Referenced Dosimetric Objectives Sequence", "SQ", "1", 0, 0},
    { 0x30100073, "Absolute Dosimetric Objective Flag", "CS", "1", 0, 0},
    { 0x30100074, "Dosimetric Objective Weight", "FD", "1", 0, 0},
    { 0x30100075, "Dosimetric Objective Purpose", "CS", "1", 0, 0},
    { 0x30100076, "Planning Input Information Sequence", "SQ", "1", 0, 0},
    { 0x30100077, "Treatment Site", "LO", "1", 0, 0},
    { 0x30100078, "Treatment Site Code Sequence", "SQ", "1", 0, 0},
    { 0x30100079, "Fraction Pattern Sequence", "SQ", "1", 0, 0},
    { 0x3010007A, "Treatment Technique Notes", "UT", "1", 0, 0},
    { 0x3010007B, "Prescription Notes", "UT", "1", 0, 0},
    { 0x3010007C, "Number of Interval Fractions", "IS", "1", 0, 0},
    { 0x3010007D, "Number of Fractions", "US", "1", 0, 0},
    { 0x3010007E, "Intended Delivery Duration", "US", "1", 0, 0},
    { 0x3010007F, "Fractionation Notes", "UT", "1", 0, 0},
    { 0x30100080, "RT Treatment Technique Code Sequence", "SQ", "1", 0, 0},
    { 0x30100081, "Prescription Notes Sequence", "SQ", "1", 0, 0},
    { 0x30100082, "Fraction-Based Relationship Sequence", "SQ", "1", 0, 0},
    { 0x30100083, "Fraction-Based Relationship Interval Anchor", "CS", "1", 0, 0},
    { 0x30100084, "Minimum Hours between Fractions", "FD", "1", 0, 0},
    { 0x30100085, "Intended Fraction Start Time", "TM", "1-n", 0, 0},
    { 0x30100086, "Intended Start Day of Week", "LT", "1", 0, 0},
    { 0x30100087, "Weekday Fraction Pattern Sequence", "SQ", "1", 0, 0},
    { 0x30100088, "Delivery Time Structure Code Sequence", "SQ", "1", 0, 0},
    { 0x30100089, "Treatment Site Modifier Code Sequence", "SQ", "1", 0, 0},
    { 0x40000010, "Arbitrary", "LT", "1", -1, 0},
    { 0x40004000, "Text Comments", "LT", "1", -1, 0},
    { 0x40080040, "Results ID", "SH", "1", -1, 0},
    { 0x40080042, "Results ID Issuer", "LO", "1", -1, 0},
    { 0x40080050, "Referenced Interpretation Sequence", "SQ", "1", -1, 0},
    { 0x400800FF, "Report Production Status (Trial)", "CS", "1", -1, 0},
    { 0x40080100, "Interpretation Recorded Date", "DA", "1", -1, 0},
    { 0x40080101, "Interpretation Recorded Time", "TM", "1", -1, 0},
    { 0x40080102, "Interpretation Recorder", "PN", "1", -1, 0},
    { 0x40080103, "Reference to Recorded Sound", "LO", "1", -1, 0},
    { 0x40080108, "Interpretation Transcription Date", "DA", "1", -1, 0},
    { 0x40080109, "Interpretation Transcription Time", "TM", "1", -1, 0},
    { 0x4008010A, "Interpretation Transcriber", "PN", "1", -1, 0},
    { 0x4008010B, "Interpretation Text", "ST", "1", -1, 0},
    { 0x4008010C, "Interpretation Author", "PN", "1", -1, 0},
    { 0x40080111, "Interpretation Approver Sequence", "SQ", "1", -1, 0},
    { 0x40080112, "Interpretation Approval Date", "DA", "1", -1, 0},
    { 0x40080113, "Interpretation Approval Time", "TM", "1", -1, 0},
    { 0x40080114, "Physician Approving Interpretation", "PN", "1", -1, 0},
    { 0x40080115, "Interpretation Diagnosis Description", "LT", "1", -1, 0},
    { 0x40080117, "Interpretation Diagnosis Code Sequence", "SQ", "1", -1, 0},
    { 0x40080118, "Results Distribution List Sequence", "SQ", "1", -1, 0},
    { 0x40080119, "Distribution Name", "PN", "1", -1, 0},
    { 0x4008011A, "Distribution Address", "LO", "1", -1, 0},
    { 0x40080200, "Interpretation ID", "SH", "1", -1, 0},
    { 0x40080202, "Interpretation ID Issuer", "LO", "1", -1, 0},
    { 0x40080210, "Interpretation Type ID", "CS", "1", -1, 0},
    { 0x40080212, "Interpretation Status ID", "CS", "1", -1, 0},
    { 0x40080300, "Impressions", "ST", "1", -1, 0},
    { 0x40084000, "Results Comments", "ST", "1", -1, 0},
    { 0x40100001, "Low Energy Detectors", "CS", "1", 0, 0},
    { 0x40100002, "High Energy Detectors", "CS", "1", 0, 0},
    { 0x40100004, "Detector Geometry Sequence", "SQ", "1", 0, 0},
    { 0x40101001, "Threat ROI Voxel Sequence", "SQ", "1", 0, 0},
    { 0x40101004, "Threat ROI Base", "FL", "3", 0, 0},
    { 0x40101005, "Threat ROI Extents", "FL", "3", 0, 0},
    { 0x40101006, "Threat ROI Bitmap", "OB", "1", 0, 0},
    { 0x40101007, "Route Segment ID", "SH", "1", 0, 0},
    { 0x40101008, "Gantry Type", "CS", "1", 0, 0},
    { 0x40101009, "OOI Owner Type", "CS", "1", 0, 0},
    { 0x4010100A, "Route Segment Sequence", "SQ", "1", 0, 0},
    { 0x40101010, "Potential Threat Object ID", "US", "1", 0, 0},
    { 0x40101011, "Threat Sequence", "SQ", "1", 0, 0},
    { 0x40101012, "Threat Category", "CS", "1", 0, 0},
    { 0x40101013, "Threat Category Description", "LT", "1", 0, 0},
    { 0x40101014, "ATD Ability Assessment", "CS", "1", 0, 0},
    { 0x40101015, "ATD Assessment Flag", "CS", "1", 0, 0},
    { 0x40101016, "ATD Assessment Probability", "FL", "1", 0, 0},
    { 0x40101017, "Mass", "FL", "1", 0, 0},
    { 0x40101018, "Density", "FL", "1", 0, 0},
    { 0x40101019, "Z Effective", "FL", "1", 0, 0},
    { 0x4010101A, "Boarding Pass ID", "SH", "1", 0, 0},
    { 0x4010101B, "Center of Mass", "FL", "3", 0, 0},
    { 0x4010101C, "Center of PTO", "FL", "3", 0, 0},
    { 0x4010101D, "Bounding Polygon", "FL", "6-n", 0, 0},
    { 0x4010101E, "Route Segment Start Location ID", "SH", "1", 0, 0},
    { 0x4010101F, "Route Segment End Location ID", "SH", "1", 0, 0},
    { 0x40101020, "Route Segment Location ID Type", "CS", "1", 0, 0},
    { 0x40101021, "Abort Reason", "CS", "1-n", 0, 0},
    { 0x40101023, "Volume of PTO", "FL", "1", 0, 0},
    { 0x40101024, "Abort Flag", "CS", "1", 0, 0},
    { 0x40101025, "Route Segment Start Time", "DT", "1", 0, 0},
    { 0x40101026, "Route Segment End Time", "DT", "1", 0, 0},
    { 0x40101027, "TDR Type", "CS", "1", 0, 0},
    { 0x40101028, "International Route Segment", "CS", "1", 0, 0},
    { 0x40101029, "Threat Detection Algorithm and Version", "LO", "1-n", 0, 0},
    { 0x4010102A, "Assigned Location", "SH", "1", 0, 0},
    { 0x4010102B, "Alarm Decision Time", "DT", "1", 0, 0},
    { 0x40101031, "Alarm Decision", "CS", "1", 0, 0},
    { 0x40101033, "Number of Total Objects", "US", "1", 0, 0},
    { 0x40101034, "Number of Alarm Objects", "US", "1", 0, 0},
    { 0x40101037, "PTO Representation Sequence", "SQ", "1", 0, 0},
    { 0x40101038, "ATD Assessment Sequence", "SQ", "1", 0, 0},
    { 0x40101039, "TIP Type", "CS", "1", 0, 0},
    { 0x4010103A, "DICOS Version", "CS", "1", 0, 0},
    { 0x40101041, "OOI Owner Creation Time", "DT", "1", 0, 0},
    { 0x40101042, "OOI Type", "CS", "1", 0, 0},
    { 0x40101043, "OOI Size", "FL", "3", 0, 0},
    { 0x40101044, "Acquisition Status", "CS", "1", 0, 0},
    { 0x40101045, "Basis Materials Code Sequence", "SQ", "1", 0, 0},
    { 0x40101046, "Phantom Type", "CS", "1", 0, 0},
    { 0x40101047, "OOI Owner Sequence", "SQ", "1", 0, 0},
    { 0x40101048, "Scan Type", "CS", "1", 0, 0},
    { 0x40101051, "Itinerary ID", "LO", "1", 0, 0},
    { 0x40101052, "Itinerary ID Type", "SH", "1", 0, 0},
    { 0x40101053, "Itinerary ID Assigning Authority", "LO", "1", 0, 0},
    { 0x40101054, "Route ID", "SH", "1", 0, 0},
    { 0x40101055, "Route ID Assigning Authority", "SH", "1", 0, 0},
    { 0x40101056, "Inbound Arrival Type", "CS", "1", 0, 0},
    { 0x40101058, "Carrier ID", "SH", "1", 0, 0},
    { 0x40101059, "Carrier ID Assigning Authority", "CS", "1", 0, 0},
    { 0x40101060, "Source Orientation", "FL", "3", 0, 0},
    { 0x40101061, "Source Position", "FL", "3", 0, 0},
    { 0x40101062, "Belt Height", "FL", "1", 0, 0},
    { 0x40101064, "Algorithm Routing Code Sequence", "SQ", "1", 0, 0},
    { 0x40101067, "Transport Classification", "CS", "1", 0, 0},
    { 0x40101068, "OOI Type Descriptor", "LT", "1", 0, 0},
    { 0x40101069, "Total Processing Time", "FL", "1", 0, 0},
    { 0x4010106C, "Detector Calibration Data", "OB", "1", 0, 0},
    { 0x4010106D, "Additional Screening Performed", "CS", "1", 0, 0},
    { 0x4010106E, "Additional Inspection Selection Criteria", "CS", "1", 0, 0},
    { 0x4010106F, "Additional Inspection Method Sequence", "SQ", "1", 0, 0},
    { 0x40101070, "AIT Device Type", "CS", "1", 0, 0},
    { 0x40101071, "QR Measurements Sequence", "SQ", "1", 0, 0},
    { 0x40101072, "Target Material Sequence", "SQ", "1", 0, 0},
    { 0x40101073, "SNR Threshold", "FD", "1", 0, 0},
    { 0x40101075, "Image Scale Representation", "DS", "1", 0, 0},
    { 0x40101076, "Referenced PTO Sequence", "SQ", "1", 0, 0},
    { 0x40101077, "Referenced TDR Instance Sequence", "SQ", "1", 0, 0},
    { 0x40101078, "PTO Location Description", "ST", "1", 0, 0},
    { 0x40101079, "Anomaly Locator Indicator Sequence", "SQ", "1", 0, 0},
    { 0x4010107A, "Anomaly Locator Indicator", "FL", "3", 0, 0},
    { 0x4010107B, "PTO Region Sequence", "SQ", "1", 0, 0},
    { 0x4010107C, "Inspection Selection Criteria", "CS", "1", 0, 0},
    { 0x4010107D, "Secondary Inspection Method Sequence", "SQ", "1", 0, 0},
    { 0x4010107E, "PRCS to RCS Orientation", "DS", "6", 0, 0},
    { 0x4FFE0001, "MAC Parameters Sequence", "SQ", "1", 0, 0},
    { 0x50000005, "Curve Dimensions", "US", "1", -1, 0},
    { 0x50000010, "Number of Points", "US", "1", -1, 0},
    { 0x50000020, "Type of Data", "CS", "1", -1, 0},
    { 0x50000022, "Curve Description", "LO", "1", -1, 0},
    { 0x50000030, "Axis Units", "SH", "1-n", -1, 0},
    { 0x50000040, "Axis Labels", "SH", "1-n", -1, 0},
    { 0x50000103, "Data Value Representation", "US", "1", -1, 0},
    { 0x50000104, "Minimum Coordinate Value", "US", "1-n", -1, 0},
    { 0x50000105, "Maximum Coordinate Value", "US", "1-n", -1, 0},
    { 0x50000106, "Curve Range", "SH", "1-n", -1, 0},
    { 0x50000110, "Curve Data Descriptor", "US", "1-n", -1, 0},
    { 0x50000112, "Coordinate Start Value", "US", "1-n", -1, 0},
    { 0x50000114, "Coordinate Step Value", "US", "1-n", -1, 0},
    { 0x50001001, "Curve Activation Layer", "CS", "1", -1, 0},
    { 0x50002000, "Audio Type", "US", "1", -1, 0},
    { 0x50002002, "Audio Sample Format", "US", "1", -1, 0},
    { 0x50002004, "Number of Channels", "US", "1", -1, 0},
    { 0x50002006, "Number of Samples", "UL", "1", -1, 0},
    { 0x50002008, "Sample Rate", "UL", "1", -1, 0},
    { 0x5000200A, "Total Time", "UL", "1", -1, 0},
    { 0x5000200C, "Audio Sample Data", "OB or OW", "1", -1, 0},
    { 0x5000200E, "Audio Comments", "LT", "1", -1, 0},
    { 0x50002500, "Curve Label", "LO", "1", -1, 0},
    { 0x50002600, "Curve Referenced Overlay Sequence", "SQ", "1", -1, 0},
    { 0x50002610, "Curve Referenced Overlay Group", "US", "1", -1, 0},
    { 0x50003000, "Curve Data", "OB or OW", "1", -1, 0},
    { 0x52009229, "Shared Functional Groups Sequence", "SQ", "1", 0, 0},
    { 0x52009230, "Per-frame Functional Groups Sequence", "SQ", "1", 0, 0},
    { 0x54000100, "Waveform Sequence", "SQ", "1", 0, 0},
    { 0x54000110, "Channel Minimum Value", "OB or OW", "1", 0, 0},
    { 0x54000112, "Channel Maximum Value", "OB or OW", "1", 0, 0},
    { 0x54001004, "Waveform Bits Allocated", "US", "1", 0, 0},
    { 0x54001006, "Waveform Sample Interpretation", "CS", "1", 0, 0},
    { 0x5400100A, "Waveform Padding Value", "OB or OW", "1", 0, 0},
    { 0x54001010, "Waveform Data", "OB or OW", "1", 0, 0},
    { 0x56000010, "First Order Phase Correction Angle", "OF", "1", 0, 0},
    { 0x56000020, "Spectroscopy Data", "OF", "1", 0, 0},
    { 0x60000010, "Overlay Rows", "US", "1", 0, 0},
    { 0x60000011, "Overlay Columns", "US", "1", 0, 0},
    { 0x60000012, "Overlay Planes", "US", "1", -1, 0},
    { 0x60000015, "Number of Frames in Overlay", "IS", "1", 0, 0},
    { 0x60000022, "Overlay Description", "LO", "1", 0, 0},
    { 0x60000040, "Overlay Type", "CS", "1", 0, 0},
    { 0x60000045, "Overlay Subtype", "LO", "1", 0, 0},
    { 0x60000050, "Overlay Origin", "SS", "2", 0, 0},
    { 0x60000051, "Image Frame Origin", "US", "1", 0, 0},
    { 0x60000052, "Overlay Plane Origin", "US", "1", -1, 0},
    { 0x60000060, "Overlay Compression Code", "CS", "1", -1, 0},
    { 0x60000061, "Overlay Compression Originator", "SH", "1", -1, 0},
    { 0x60000062, "Overlay Compression Label", "SH", "1", -1, 0},
    { 0x60000063, "Overlay Compression Description", "CS", "1", -1, 0},
    { 0x60000066, "Overlay Compression Step Pointers", "AT", "1-n", -1, 0},
    { 0x60000068, "Overlay Repeat Interval", "US", "1", -1, 0},
    { 0x60000069, "Overlay Bits Grouped", "US", "1", -1, 0},
    { 0x60000100, "Overlay Bits Allocated", "US", "1", 0, 0},
    { 0x60000102, "Overlay Bit Position", "US", "1", 0, 0},
    { 0x60000110, "Overlay Format", "CS", "1", -1, 0},
    { 0x60000200, "Overlay Location", "US", "1", -1, 0},
    { 0x60000800, "Overlay Code Label", "CS", "1-n", -1, 0},
    { 0x60000802, "Overlay Number of Tables", "US", "1", -1, 0},
    { 0x60000803, "Overlay Code Table Location", "AT", "1-n", -1, 0},
    { 0x60000804, "Overlay Bits For Code Word", "US", "1", -1, 0},
    { 0x60001001, "Overlay Activation Layer", "CS", "1", 0, 0},
    { 0x60001100, "Overlay Descriptor - Gray", "US", "1", -1, 0},
    { 0x60001101, "Overlay Descriptor - Red", "US", "1", -1, 0},
    { 0x60001102, "Overlay Descriptor - Green", "US", "1", -1, 0},
    { 0x60001103, "Overlay Descriptor - Blue", "US", "1", -1, 0},
    { 0x60001200, "Overlays - Gray", "US", "1-n", -1, 0},
    { 0x60001201, "Overlays - Red", "US", "1-n", -1, 0},
    { 0x60001202, "Overlays - Green", "US", "1-n", -1, 0},
    { 0x60001203, "Overlays - Blue", "US", "1-n", -1, 0},
    { 0x60001301, "ROI Area", "IS", "1", 0, 0},
    { 0x60001302, "ROI Mean", "DS", "1", 0, 0},
    { 0x60001303, "ROI Standard Deviation", "DS", "1", 0, 0},
    { 0x60001500, "Overlay Label", "LO", "1", 0, 0},
    { 0x60003000, "Overlay Data", "OB or OW", "1", 0, 0},
    { 0x60004000, "Overlay Comments", "LT", "1", -1, 0},
    { 0x7FE00001, "Extended Offset Table", "OV", "1", 0, 0},
    { 0x7FE00002, "Extended Offset Table Lengths", "OV", "1", 0, 0},
    { 0x7FE00008, "Float Pixel Data", "OF", "1", 0, 0},
    { 0x7FE00009, "Double Float Pixel Data", "OD", "1", 0, 0},
    { 0x7FE00010, "Pixel Data", "OB or OW", "1", 0, 0},
    { 0x7FE00020, "Coefficients SDVN", "OW", "1", -1, 0},
    { 0x7FE00030, "Coefficients SDHN", "OW", "1", -1, 0},
    { 0x7FE00040, "Coefficients SDDN", "OW", "1", -1, 0},
    { 0x7F000010, "Variable Pixel Data", "OB or OW", "1", -1, 0},
    { 0x7F000011, "Variable Next Data Group", "US", "1", -1, 0},
    { 0x7F000020, "Variable Coefficients SDVN", "OW", "1", -1, 0},
    { 0x7F000030, "Variable Coefficients SDHN", "OW", "1", -1, 0},
    { 0x7F000040, "Variable Coefficients SDDN", "OW", "1", -1, 0},
    { 0xFFFAFFFA, "Digital Signatures Sequence", "SQ", "1", 0, 0},
    { 0xFFFCFFFC, "Data Set Trailing Padding", "OB", "1", 0, 0},
    { 0xFFFEE000, "Item", "See Note", "1", 0, 0},
    { 0xFFFEE00D, "Item Delimitation Item", "See Note", "1", 0, 0},
    { 0xFFFEE0DD, "Sequence Delimitation Item", "See Note", "1", 0, 0},
    { 0x00020000, "File Meta Information Group Length", "UL", "1", 0, 0},
    { 0x00020001, "File Meta Information Version", "OB", "1", 0, 0},
    { 0x00020002, "Media Storage SOP Class UID", "UI", "1", 0, 0},
    { 0x00020003, "Media Storage SOP Instance UID", "UI", "1", 0, 0},
    { 0x00020010, "Transfer Syntax UID", "UI", "1", 0, 0},
    { 0x00020012, "Implementation Class UID", "UI", "1", 0, 0},
    { 0x00020013, "Implementation Version Name", "SH", "1", 0, 0},
    { 0x00020016, "Source Application Entity Title", "AE", "1", 0, 0},
    { 0x00020017, "Sending Application Entity Title", "AE", "1", 0, 0},
    { 0x00020018, "Receiving Application Entity Title", "AE", "1", 0, 0},
    { 0x00020026, "Source Presentation Address", "UR", "1", 0, 0},
    { 0x00020027, "Sending Presentation Address", "UR", "1", 0, 0},
    { 0x00020028, "Receiving Presentation Address", "UR", "1", 0, 0},
    { 0x00020031, "RTV Meta Information Version", "OB", "1", 0, 0},
    { 0x00020032, "RTV Communication SOP Class UID", "UI", "1", 0, 0},
    { 0x00020033, "RTV Communication SOP Instance UID", "UI", "1", 0, 0},
    { 0x00020035, "RTV Source Identifier", "OB", "1", 0, 0},
    { 0x00020036, "RTV Flow Identifier", "OB", "1", 0, 0},
    { 0x00020037, "RTV Flow RTP Sampling Rate", "UL", "1", 0, 0},
    { 0x00020038, "RTV Flow Actual Frame Duration", "FD", "1", 0, 0},
    { 0x00020100, "Private Information Creator UID", "UI", "1", 0, 0},
    { 0x00020102, "Private Information", "OB", "1", 0, 0},
    { 0x00041130, "File-set ID", "CS", "1", 0, 0},
    { 0x00041141, "File-set Descriptor File ID", "CS", "1-8", 0, 0},
    { 0x00041142, "Specific Character Set of File-set Descriptor File", "CS", "1", 0, 0},
    { 0x00041200, "Offset of the First Directory Record of the Root Directory Entity", "UL", "1", 0, 0},
    { 0x00041202, "Offset of the Last Directory Record of the Root Directory Entity", "UL", "1", 0, 0},
    { 0x00041212, "File-set Consistency Flag", "US", "1", 0, 0},
    { 0x00041220, "Directory Record Sequence", "SQ", "1", 0, 0},
    { 0x00041400, "Offset of the Next Directory Record", "UL", "1", 0, 0},
    { 0x00041410, "Record In-use Flag", "US", "1", 0, 0},
    { 0x00041420, "Offset of Referenced Lower-Level Directory Entity", "UL", "1", 0, 0},
    { 0x00041430, "Directory Record Type", "CS", "1", 0, 0},
    { 0x00041432, "Private Record UID", "UI", "1", 0, 0},
    { 0x00041500, "Referenced File ID", "CS", "1-8", 0, 0},
    { 0x00041504, "MRDR Directory Record Offset", "UL", "1", -1, 0},
    { 0x00041510, "Referenced SOP Class UID in File", "UI", "1", 0, 0},
    { 0x00041511, "Referenced SOP Instance UID in File", "UI", "1", 0, 0},
    { 0x00041512, "Referenced Transfer Syntax UID in File", "UI", "1", 0, 0},
    { 0x0004151A, "Referenced Related General SOP Class UID in File", "UI", "1-n", 0, 0},
    { 0x00041600, "Number of References", "UL", "1", -1, 0},
};

/* ---------------------------------------------------------------------
 * DICOM UID Definitions

 * Part 6 lists following different UID Types (2006-2008)

 * Application Context Name
 * Coding Scheme
 * DICOM UIDs as a Coding Scheme
 * LDAP OID
 * Meta SOP Class
 * SOP Class
 * Service Class
 * Transfer Syntax
 * Well-known Print Queue SOP Instance
 * Well-known Printer SOP Instance
 * Well-known SOP Instance
 * Well-known frame of reference
 */

typedef struct dcm_uid {
    const gchar *value;
    const gchar *name;
    const gchar *type;
} dcm_uid_t;

#define DCM_UID_SOP_CLASS_VERIFICATION "1.2.840.10008.1.1"
#define DCM_UID_TRANSFER_SYNTAX_IMPLICIT_VR_LITTLE_ENDIAN "1.2.840.10008.1.2"
#define DCM_UID_TRANSFER_SYNTAX_EXPLICIT_VR_LITTLE_ENDIAN "1.2.840.10008.1.2.1"
#define DCM_UID_TRANSFER_SYNTAX_DEFLATED_EXPLICIT_VR_LITTLE_ENDIAN "1.2.840.10008.1.2.1.99"
#define DCM_UID_TRANSFER_SYNTAX_EXPLICIT_VR_BIG_ENDIAN_RETIRED "1.2.840.10008.1.2.2"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_BASELINE_PROCESS_1 "1.2.840.10008.1.2.4.50"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_PROCESS_2_4 "1.2.840.10008.1.2.4.51"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_PROCESS_3_5_RETIRED "1.2.840.10008.1.2.4.52"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_NON_HIERARCHICAL_PROCESS_6_8_RETIRED "1.2.840.10008.1.2.4.53"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_NON_HIERARCHICAL_PROCESS_7_9_RETIRED "1.2.840.10008.1.2.4.54"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_NON_HIERARCHICAL_PROCESS_10_12_RETIRED "1.2.840.10008.1.2.4.55"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_NON_HIERARCHICAL_PROCESS_11_13_RETIRED "1.2.840.10008.1.2.4.56"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_PROCESS_14 "1.2.840.10008.1.2.4.57"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_PROCESS_15_RETIRED "1.2.840.10008.1.2.4.58"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_HIERARCHICAL_PROCESS_16_18_RETIRED "1.2.840.10008.1.2.4.59"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_HIERARCHICAL_PROCESS_17_19_RETIRED "1.2.840.10008.1.2.4.60"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_HIERARCHICAL_PROCESS_20_22_RETIRED "1.2.840.10008.1.2.4.61"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_HIERARCHICAL_PROCESS_21_23_RETIRED "1.2.840.10008.1.2.4.62"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_HIERARCHICAL_PROCESS_24_26_RETIRED "1.2.840.10008.1.2.4.63"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_HIERARCHICAL_PROCESS_25_27_RETIRED "1.2.840.10008.1.2.4.64"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_HIERARCHICAL_PROCESS_28_RETIRED "1.2.840.10008.1.2.4.65"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_HIERARCHICAL_PROCESS_29_RETIRED "1.2.840.10008.1.2.4.66"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_FIRST_ORDER_PREDICTION_PROCESS_14_SELECTION_VALUE_1 "1.2.840.10008.1.2.4.70"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LS_LOSSLESS_IMAGE_COMPRESSION "1.2.840.10008.1.2.4.80"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_LS_LOSSY_NEAR_LOSSLESS_IMAGE_COMPRESSION "1.2.840.10008.1.2.4.81"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_2000_IMAGE_COMPRESSION_LOSSLESS_ONLY "1.2.840.10008.1.2.4.90"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_2000_IMAGE_COMPRESSION "1.2.840.10008.1.2.4.91"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_2000_PART_2_MULTI_COMPONENT_IMAGE_COMPRESSION_LOSSLESS_ONLY "1.2.840.10008.1.2.4.92"
#define DCM_UID_TRANSFER_SYNTAX_JPEG_2000_PART_2_MULTI_COMPONENT_IMAGE_COMPRESSION "1.2.840.10008.1.2.4.93"
#define DCM_UID_TRANSFER_SYNTAX_JPIP_REFERENCED "1.2.840.10008.1.2.4.94"
#define DCM_UID_TRANSFER_SYNTAX_JPIP_REFERENCED_DEFLATE "1.2.840.10008.1.2.4.95"
#define DCM_UID_TRANSFER_SYNTAX_MPEG2_MAIN_PROFILE_MAIN_LEVEL "1.2.840.10008.1.2.4.100"
#define DCM_UID_TRANSFER_SYNTAX_MPEG2_MAIN_PROFILE_HIGH_LEVEL "1.2.840.10008.1.2.4.101"
#define DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_41 "1.2.840.10008.1.2.4.102"
#define DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_BD_COMPATIBLE_HIGH_PROFILE_LEVEL_41 "1.2.840.10008.1.2.4.103"
#define DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_42_FOR_2D_VIDEO "1.2.840.10008.1.2.4.104"
#define DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_42_FOR_3D_VIDEO "1.2.840.10008.1.2.4.105"
#define DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_STEREO_HIGH_PROFILE_LEVEL_42 "1.2.840.10008.1.2.4.106"
#define DCM_UID_TRANSFER_SYNTAX_HEVCH265_MAIN_PROFILE_LEVEL_51 "1.2.840.10008.1.2.4.107"
#define DCM_UID_TRANSFER_SYNTAX_HEVCH265_MAIN_10_PROFILE_LEVEL_51 "1.2.840.10008.1.2.4.108"
#define DCM_UID_TRANSFER_SYNTAX_RLE_LOSSLESS "1.2.840.10008.1.2.5"
#define DCM_UID_TRANSFER_SYNTAX_RFC_2557_MIME_ENCAPSULATION_RETIRED "1.2.840.10008.1.2.6.1"
#define DCM_UID_TRANSFER_SYNTAX_XML_ENCODING_RETIRED "1.2.840.10008.1.2.6.2"
#define DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_20_UNCOMPRESSED_PROGRESSIVE_ACTIVE_VIDEO "1.2.840.10008.1.2.7.1"
#define DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_20_UNCOMPRESSED_INTERLACED_ACTIVE_VIDEO "1.2.840.10008.1.2.7.2"
#define DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_30_PCM_DIGITAL_AUDIO "1.2.840.10008.1.2.7.3"
#define DCM_UID_SOP_CLASS_MEDIA_STORAGE_DIRECTORY_STORAGE "1.2.840.10008.1.3.10"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_TALAIRACH_BRAIN_ATLAS_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.1"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_T1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.2"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_T2_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.3"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_PD_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.4"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_EPI_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.5"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_FIL_T1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.6"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_PET_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.7"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_TRANSM_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.8"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_SPECT_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.9"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_GRAY_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.10"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_WHITE_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.11"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_CSF_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.12"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_BRAINMASK_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.13"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG305T1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.14"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152T1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.15"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152T2_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.16"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152PD_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.17"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_SINGLESUBJT1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.1.18"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_ICBM_452_T1_FRAME_OF_REFERENCE "1.2.840.10008.1.4.2.1"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_ICBM_SINGLE_SUBJECT_MRI_FRAME_OF_REFERENCE "1.2.840.10008.1.4.2.2"
#define DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_IEC_61217_FIXED_COORDINATE_SYSTEM_FRAME_OF_REFERENCE "1.2.840.10008.1.4.3.1"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_HOT_IRON_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.1"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_PET_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.2"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_HOT_METAL_BLUE_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.3"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_PET_20_STEP_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.4"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_SPRING_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.5"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_SUMMER_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.6"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_FALL_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.7"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_WINTER_COLOR_PALETTE_SOP_INSTANCE "1.2.840.10008.1.5.8"
#define DCM_UID_SOP_CLASS_BASIC_STUDY_CONTENT_NOTIFICATION_SOP_CLASS_RETIRED "1.2.840.10008.1.9"
#define DCM_UID_TRANSFER_SYNTAX_PAPYRUS_3_IMPLICIT_VR_LITTLE_ENDIAN_RETIRED "1.2.840.10008.1.20"
#define DCM_UID_SOP_CLASS_STORAGE_COMMITMENT_PUSH_MODEL "1.2.840.10008.1.20.1"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_STORAGE_COMMITMENT_PUSH_MODEL_SOP_INSTANCE "1.2.840.10008.1.20.1.1"
#define DCM_UID_SOP_CLASS_STORAGE_COMMITMENT_PULL_MODEL_SOP_CLASS_RETIRED "1.2.840.10008.1.20.2"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_STORAGE_COMMITMENT_PULL_MODEL_SOP_INSTANCE_RETIRED "1.2.840.10008.1.20.2.1"
#define DCM_UID_SOP_CLASS_PROCEDURAL_EVENT_LOGGING "1.2.840.10008.1.40"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_PROCEDURAL_EVENT_LOGGING_SOP_INSTANCE "1.2.840.10008.1.40.1"
#define DCM_UID_SOP_CLASS_SUBSTANCE_ADMINISTRATION_LOGGING "1.2.840.10008.1.42"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_SUBSTANCE_ADMINISTRATION_LOGGING_SOP_INSTANCE "1.2.840.10008.1.42.1"
#define DCM_UID_DICOM_UIDS_AS_A_CODING_SCHEME_DICOM_UID_REGISTRY "1.2.840.10008.2.6.1"
#define DCM_UID_CODING_SCHEME_DICOM_CONTROLLED_TERMINOLOGY "1.2.840.10008.2.16.4"
#define DCM_UID_CODING_SCHEME_ADULT_MOUSE_ANATOMY_ONTOLOGY "1.2.840.10008.2.16.5"
#define DCM_UID_CODING_SCHEME_UBERON_ONTOLOGY "1.2.840.10008.2.16.6"
#define DCM_UID_CODING_SCHEME_INTEGRATED_TAXONOMIC_INFORMATION_SYSTEM_ITIS_TAXONOMIC_SERIAL_NUMBER_TSN "1.2.840.10008.2.16.7"
#define DCM_UID_CODING_SCHEME_MOUSE_GENOME_INITIATIVE_MGI "1.2.840.10008.2.16.8"
#define DCM_UID_CODING_SCHEME_PUBCHEM_COMPOUND_CID "1.2.840.10008.2.16.9"
#define DCM_UID_CODING_SCHEME_ICD_11 "1.2.840.10008.2.16.10"
#define DCM_UID_CODING_SCHEME_NEW_YORK_UNIVERSITY_MELANOMA_CLINICAL_COOPERATIVE_GROUP "1.2.840.10008.2.16.11"
#define DCM_UID_CODING_SCHEME_MAYO_CLINIC_NON_RADIOLOGICAL_IMAGES_SPECIFIC_BODY_STRUCTURE_ANATOMICAL_SURFACE_REGION_GUIDE "1.2.840.10008.2.16.12"
#define DCM_UID_CODING_SCHEME_IMAGE_BIOMARKER_STANDARDISATION_INITIATIVE "1.2.840.10008.2.16.13"
#define DCM_UID_CODING_SCHEME_RADIOMICS_ONTOLOGY "1.2.840.10008.2.16.14"
#define DCM_UID_APPLICATION_CONTEXT_NAME_DICOM "1.2.840.10008.3.1.1.1"
#define DCM_UID_SOP_CLASS_DETACHED_PATIENT_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.1.1"
#define DCM_UID_META_SOP_CLASS_DETACHED_PATIENT_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.1.4"
#define DCM_UID_SOP_CLASS_DETACHED_VISIT_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.2.1"
#define DCM_UID_SOP_CLASS_DETACHED_STUDY_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.3.1"
#define DCM_UID_SOP_CLASS_STUDY_COMPONENT_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.3.2"
#define DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP "1.2.840.10008.3.1.2.3.3"
#define DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP_RETRIEVE "1.2.840.10008.3.1.2.3.4"
#define DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP_NOTIFICATION "1.2.840.10008.3.1.2.3.5"
#define DCM_UID_SOP_CLASS_DETACHED_RESULTS_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.5.1"
#define DCM_UID_META_SOP_CLASS_DETACHED_RESULTS_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.5.4"
#define DCM_UID_META_SOP_CLASS_DETACHED_STUDY_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.5.5"
#define DCM_UID_SOP_CLASS_DETACHED_INTERPRETATION_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.3.1.2.6.1"
#define DCM_UID_SERVICE_CLASS_STORAGE "1.2.840.10008.4.2"
#define DCM_UID_SOP_CLASS_BASIC_FILM_SESSION "1.2.840.10008.5.1.1.1"
#define DCM_UID_SOP_CLASS_BASIC_FILM_BOX "1.2.840.10008.5.1.1.2"
#define DCM_UID_SOP_CLASS_BASIC_GRAYSCALE_IMAGE_BOX "1.2.840.10008.5.1.1.4"
#define DCM_UID_SOP_CLASS_BASIC_COLOR_IMAGE_BOX "1.2.840.10008.5.1.1.4.1"
#define DCM_UID_SOP_CLASS_REFERENCED_IMAGE_BOX_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.4.2"
#define DCM_UID_META_SOP_CLASS_BASIC_GRAYSCALE_PRINT_MANAGEMENT "1.2.840.10008.5.1.1.9"
#define DCM_UID_META_SOP_CLASS_REFERENCED_GRAYSCALE_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.9.1"
#define DCM_UID_SOP_CLASS_PRINT_JOB "1.2.840.10008.5.1.1.14"
#define DCM_UID_SOP_CLASS_BASIC_ANNOTATION_BOX "1.2.840.10008.5.1.1.15"
#define DCM_UID_SOP_CLASS_PRINTER "1.2.840.10008.5.1.1.16"
#define DCM_UID_SOP_CLASS_PRINTER_CONFIGURATION_RETRIEVAL "1.2.840.10008.5.1.1.16.376"
#define DCM_UID_WELL_KNOWN_PRINTER_SOP_INSTANCE_PRINTER_SOP_INSTANCE "1.2.840.10008.5.1.1.17"
#define DCM_UID_WELL_KNOWN_PRINTER_SOP_INSTANCE_PRINTER_CONFIGURATION_RETRIEVAL_SOP_INSTANCE "1.2.840.10008.5.1.1.17.376"
#define DCM_UID_META_SOP_CLASS_BASIC_COLOR_PRINT_MANAGEMENT "1.2.840.10008.5.1.1.18"
#define DCM_UID_META_SOP_CLASS_REFERENCED_COLOR_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.18.1"
#define DCM_UID_SOP_CLASS_VOI_LUT_BOX "1.2.840.10008.5.1.1.22"
#define DCM_UID_SOP_CLASS_PRESENTATION_LUT "1.2.840.10008.5.1.1.23"
#define DCM_UID_SOP_CLASS_IMAGE_OVERLAY_BOX_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.24"
#define DCM_UID_SOP_CLASS_BASIC_PRINT_IMAGE_OVERLAY_BOX_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.24.1"
#define DCM_UID_WELL_KNOWN_PRINT_QUEUE_SOP_INSTANCE_PRINT_QUEUE_SOP_INSTANCE_RETIRED "1.2.840.10008.5.1.1.25"
#define DCM_UID_SOP_CLASS_PRINT_QUEUE_MANAGEMENT_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.26"
#define DCM_UID_SOP_CLASS_STORED_PRINT_STORAGE_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.27"
#define DCM_UID_SOP_CLASS_HARDCOPY_GRAYSCALE_IMAGE_STORAGE_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.29"
#define DCM_UID_SOP_CLASS_HARDCOPY_COLOR_IMAGE_STORAGE_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.30"
#define DCM_UID_SOP_CLASS_PULL_PRINT_REQUEST_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.31"
#define DCM_UID_META_SOP_CLASS_PULL_STORED_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.5.1.1.32"
#define DCM_UID_SOP_CLASS_MEDIA_CREATION_MANAGEMENT_SOP_CLASS_UID "1.2.840.10008.5.1.1.33"
#define DCM_UID_SOP_CLASS_DISPLAY_SYSTEM "1.2.840.10008.5.1.1.40"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_DISPLAY_SYSTEM_SOP_INSTANCE "1.2.840.10008.5.1.1.40.1"
#define DCM_UID_SOP_CLASS_COMPUTED_RADIOGRAPHY_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.1"
#define DCM_UID_SOP_CLASS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.1.1"
#define DCM_UID_SOP_CLASS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.1.1.1"
#define DCM_UID_SOP_CLASS_DIGITAL_MAMMOGRAPHY_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.1.2"
#define DCM_UID_SOP_CLASS_DIGITAL_MAMMOGRAPHY_X_RAY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.1.2.1"
#define DCM_UID_SOP_CLASS_DIGITAL_INTRA_ORAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.1.3"
#define DCM_UID_SOP_CLASS_DIGITAL_INTRA_ORAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.1.3.1"
#define DCM_UID_SOP_CLASS_CT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.2"
#define DCM_UID_SOP_CLASS_ENHANCED_CT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.2.1"
#define DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_CT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.2.2"
#define DCM_UID_SOP_CLASS_ULTRASOUND_MULTI_FRAME_IMAGE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.3"
#define DCM_UID_SOP_CLASS_ULTRASOUND_MULTI_FRAME_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.3.1"
#define DCM_UID_SOP_CLASS_MR_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.4"
#define DCM_UID_SOP_CLASS_ENHANCED_MR_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.4.1"
#define DCM_UID_SOP_CLASS_MR_SPECTROSCOPY_STORAGE "1.2.840.10008.5.1.4.1.1.4.2"
#define DCM_UID_SOP_CLASS_ENHANCED_MR_COLOR_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.4.3"
#define DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_MR_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.4.4"
#define DCM_UID_SOP_CLASS_NUCLEAR_MEDICINE_IMAGE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.5"
#define DCM_UID_SOP_CLASS_ULTRASOUND_IMAGE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.6"
#define DCM_UID_SOP_CLASS_ULTRASOUND_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.6.1"
#define DCM_UID_SOP_CLASS_ENHANCED_US_VOLUME_STORAGE "1.2.840.10008.5.1.4.1.1.6.2"
#define DCM_UID_SOP_CLASS_SECONDARY_CAPTURE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.7"
#define DCM_UID_SOP_CLASS_MULTI_FRAME_SINGLE_BIT_SECONDARY_CAPTURE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.7.1"
#define DCM_UID_SOP_CLASS_MULTI_FRAME_GRAYSCALE_BYTE_SECONDARY_CAPTURE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.7.2"
#define DCM_UID_SOP_CLASS_MULTI_FRAME_GRAYSCALE_WORD_SECONDARY_CAPTURE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.7.3"
#define DCM_UID_SOP_CLASS_MULTI_FRAME_TRUE_COLOR_SECONDARY_CAPTURE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.7.4"
#define DCM_UID_SOP_CLASS_STANDALONE_OVERLAY_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.8"
#define DCM_UID_SOP_CLASS_STANDALONE_CURVE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.9"
#define DCM_UID_SOP_CLASS_WAVEFORM_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.9.1"
#define DCM_UID_SOP_CLASS_12_LEAD_ECG_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.1.1"
#define DCM_UID_SOP_CLASS_GENERAL_ECG_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.1.2"
#define DCM_UID_SOP_CLASS_AMBULATORY_ECG_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.1.3"
#define DCM_UID_SOP_CLASS_HEMODYNAMIC_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.2.1"
#define DCM_UID_SOP_CLASS_CARDIAC_ELECTROPHYSIOLOGY_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.3.1"
#define DCM_UID_SOP_CLASS_BASIC_VOICE_AUDIO_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.4.1"
#define DCM_UID_SOP_CLASS_GENERAL_AUDIO_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.4.2"
#define DCM_UID_SOP_CLASS_ARTERIAL_PULSE_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.5.1"
#define DCM_UID_SOP_CLASS_RESPIRATORY_WAVEFORM_STORAGE "1.2.840.10008.5.1.4.1.1.9.6.1"
#define DCM_UID_SOP_CLASS_STANDALONE_MODALITY_LUT_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.10"
#define DCM_UID_SOP_CLASS_STANDALONE_VOI_LUT_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.11"
#define DCM_UID_SOP_CLASS_GRAYSCALE_SOFTCOPY_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.1"
#define DCM_UID_SOP_CLASS_COLOR_SOFTCOPY_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.2"
#define DCM_UID_SOP_CLASS_PSEUDO_COLOR_SOFTCOPY_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.3"
#define DCM_UID_SOP_CLASS_BLENDING_SOFTCOPY_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.4"
#define DCM_UID_SOP_CLASS_XAXRF_GRAYSCALE_SOFTCOPY_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.5"
#define DCM_UID_SOP_CLASS_GRAYSCALE_PLANAR_MPR_VOLUMETRIC_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.6"
#define DCM_UID_SOP_CLASS_COMPOSITING_PLANAR_MPR_VOLUMETRIC_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.7"
#define DCM_UID_SOP_CLASS_ADVANCED_BLENDING_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.8"
#define DCM_UID_SOP_CLASS_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.9"
#define DCM_UID_SOP_CLASS_SEGMENTED_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.10"
#define DCM_UID_SOP_CLASS_MULTIPLE_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE "1.2.840.10008.5.1.4.1.1.11.11"
#define DCM_UID_SOP_CLASS_X_RAY_ANGIOGRAPHIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.12.1"
#define DCM_UID_SOP_CLASS_ENHANCED_XA_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.12.1.1"
#define DCM_UID_SOP_CLASS_X_RAY_RADIOFLUOROSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.12.2"
#define DCM_UID_SOP_CLASS_ENHANCED_XRF_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.12.2.1"
#define DCM_UID_SOP_CLASS_X_RAY_ANGIOGRAPHIC_BI_PLANE_IMAGE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.12.3"
#define DCM_UID_SOP_CLASS_X_RAY_3D_ANGIOGRAPHIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.13.1.1"
#define DCM_UID_SOP_CLASS_X_RAY_3D_CRANIOFACIAL_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.13.1.2"
#define DCM_UID_SOP_CLASS_BREAST_TOMOSYNTHESIS_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.13.1.3"
#define DCM_UID_SOP_CLASS_BREAST_PROJECTION_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.13.1.4"
#define DCM_UID_SOP_CLASS_BREAST_PROJECTION_X_RAY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.13.1.5"
#define DCM_UID_SOP_CLASS_INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.14.1"
#define DCM_UID_SOP_CLASS_INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.14.2"
#define DCM_UID_SOP_CLASS_NUCLEAR_MEDICINE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.20"
#define DCM_UID_SOP_CLASS_PARAMETRIC_MAP_STORAGE "1.2.840.10008.5.1.4.1.1.30"
#define DCM_UID_SOP_CLASS_RAW_DATA_STORAGE "1.2.840.10008.5.1.4.1.1.66"
#define DCM_UID_SOP_CLASS_SPATIAL_REGISTRATION_STORAGE "1.2.840.10008.5.1.4.1.1.66.1"
#define DCM_UID_SOP_CLASS_SPATIAL_FIDUCIALS_STORAGE "1.2.840.10008.5.1.4.1.1.66.2"
#define DCM_UID_SOP_CLASS_DEFORMABLE_SPATIAL_REGISTRATION_STORAGE "1.2.840.10008.5.1.4.1.1.66.3"
#define DCM_UID_SOP_CLASS_SEGMENTATION_STORAGE "1.2.840.10008.5.1.4.1.1.66.4"
#define DCM_UID_SOP_CLASS_SURFACE_SEGMENTATION_STORAGE "1.2.840.10008.5.1.4.1.1.66.5"
#define DCM_UID_SOP_CLASS_TRACTOGRAPHY_RESULTS_STORAGE "1.2.840.10008.5.1.4.1.1.66.6"
#define DCM_UID_SOP_CLASS_REAL_WORLD_VALUE_MAPPING_STORAGE "1.2.840.10008.5.1.4.1.1.67"
#define DCM_UID_SOP_CLASS_SURFACE_SCAN_MESH_STORAGE "1.2.840.10008.5.1.4.1.1.68.1"
#define DCM_UID_SOP_CLASS_SURFACE_SCAN_POINT_CLOUD_STORAGE "1.2.840.10008.5.1.4.1.1.68.2"
#define DCM_UID_SOP_CLASS_VL_IMAGE_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.77.1"
#define DCM_UID_SOP_CLASS_VL_ENDOSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.1"
#define DCM_UID_SOP_CLASS_VIDEO_ENDOSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.1.1"
#define DCM_UID_SOP_CLASS_VL_MICROSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.2"
#define DCM_UID_SOP_CLASS_VIDEO_MICROSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.2.1"
#define DCM_UID_SOP_CLASS_VL_SLIDE_COORDINATES_MICROSCOPIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.3"
#define DCM_UID_SOP_CLASS_VL_PHOTOGRAPHIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.4"
#define DCM_UID_SOP_CLASS_VIDEO_PHOTOGRAPHIC_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.4.1"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_PHOTOGRAPHY_8_BIT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.1"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_PHOTOGRAPHY_16_BIT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.2"
#define DCM_UID_SOP_CLASS_STEREOMETRIC_RELATIONSHIP_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.3"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_TOMOGRAPHY_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.4"
#define DCM_UID_SOP_CLASS_WIDE_FIELD_OPHTHALMIC_PHOTOGRAPHY_STEREOGRAPHIC_PROJECTION_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.5"
#define DCM_UID_SOP_CLASS_WIDE_FIELD_OPHTHALMIC_PHOTOGRAPHY_3D_COORDINATES_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.6"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_OPTICAL_COHERENCE_TOMOGRAPHY_EN_FACE_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.7"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_OPTICAL_COHERENCE_TOMOGRAPHY_B_SCAN_VOLUME_ANALYSIS_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.5.8"
#define DCM_UID_SOP_CLASS_VL_WHOLE_SLIDE_MICROSCOPY_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.77.1.6"
#define DCM_UID_SOP_CLASS_VL_MULTI_FRAME_IMAGE_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.77.2"
#define DCM_UID_SOP_CLASS_LENSOMETRY_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.1"
#define DCM_UID_SOP_CLASS_AUTOREFRACTION_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.2"
#define DCM_UID_SOP_CLASS_KERATOMETRY_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.3"
#define DCM_UID_SOP_CLASS_SUBJECTIVE_REFRACTION_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.4"
#define DCM_UID_SOP_CLASS_VISUAL_ACUITY_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.5"
#define DCM_UID_SOP_CLASS_SPECTACLE_PRESCRIPTION_REPORT_STORAGE "1.2.840.10008.5.1.4.1.1.78.6"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_AXIAL_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.78.7"
#define DCM_UID_SOP_CLASS_INTRAOCULAR_LENS_CALCULATIONS_STORAGE "1.2.840.10008.5.1.4.1.1.78.8"
#define DCM_UID_SOP_CLASS_MACULAR_GRID_THICKNESS_AND_VOLUME_REPORT_STORAGE "1.2.840.10008.5.1.4.1.1.79.1"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_VISUAL_FIELD_STATIC_PERIMETRY_MEASUREMENTS_STORAGE "1.2.840.10008.5.1.4.1.1.80.1"
#define DCM_UID_SOP_CLASS_OPHTHALMIC_THICKNESS_MAP_STORAGE "1.2.840.10008.5.1.4.1.1.81.1"
#define DCM_UID_SOP_CLASS_CORNEAL_TOPOGRAPHY_MAP_STORAGE "1.2.840.10008.5.1.4.1.1.82.1"
#define DCM_UID_SOP_CLASS_TEXT_SR_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.88.1"
#define DCM_UID_SOP_CLASS_AUDIO_SR_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.88.2"
#define DCM_UID_SOP_CLASS_DETAIL_SR_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.88.3"
#define DCM_UID_SOP_CLASS_COMPREHENSIVE_SR_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.1.1.88.4"
#define DCM_UID_SOP_CLASS_BASIC_TEXT_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.11"
#define DCM_UID_SOP_CLASS_ENHANCED_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.22"
#define DCM_UID_SOP_CLASS_COMPREHENSIVE_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.33"
#define DCM_UID_SOP_CLASS_COMPREHENSIVE_3D_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.34"
#define DCM_UID_SOP_CLASS_EXTENSIBLE_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.35"
#define DCM_UID_SOP_CLASS_PROCEDURE_LOG_STORAGE "1.2.840.10008.5.1.4.1.1.88.40"
#define DCM_UID_SOP_CLASS_MAMMOGRAPHY_CAD_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.50"
#define DCM_UID_SOP_CLASS_KEY_OBJECT_SELECTION_DOCUMENT_STORAGE "1.2.840.10008.5.1.4.1.1.88.59"
#define DCM_UID_SOP_CLASS_CHEST_CAD_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.65"
#define DCM_UID_SOP_CLASS_X_RAY_RADIATION_DOSE_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.67"
#define DCM_UID_SOP_CLASS_RADIOPHARMACEUTICAL_RADIATION_DOSE_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.68"
#define DCM_UID_SOP_CLASS_COLON_CAD_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.69"
#define DCM_UID_SOP_CLASS_IMPLANTATION_PLAN_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.70"
#define DCM_UID_SOP_CLASS_ACQUISITION_CONTEXT_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.71"
#define DCM_UID_SOP_CLASS_SIMPLIFIED_ADULT_ECHO_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.72"
#define DCM_UID_SOP_CLASS_PATIENT_RADIATION_DOSE_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.73"
#define DCM_UID_SOP_CLASS_PLANNED_IMAGING_AGENT_ADMINISTRATION_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.74"
#define DCM_UID_SOP_CLASS_PERFORMED_IMAGING_AGENT_ADMINISTRATION_SR_STORAGE "1.2.840.10008.5.1.4.1.1.88.75"
#define DCM_UID_SOP_CLASS_CONTENT_ASSESSMENT_RESULTS_STORAGE "1.2.840.10008.5.1.4.1.1.90.1"
#define DCM_UID_SOP_CLASS_ENCAPSULATED_PDF_STORAGE "1.2.840.10008.5.1.4.1.1.104.1"
#define DCM_UID_SOP_CLASS_ENCAPSULATED_CDA_STORAGE "1.2.840.10008.5.1.4.1.1.104.2"
#define DCM_UID_SOP_CLASS_ENCAPSULATED_STL_STORAGE "1.2.840.10008.5.1.4.1.1.104.3"
#define DCM_UID_SOP_CLASS_POSITRON_EMISSION_TOMOGRAPHY_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.128"
#define DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_PET_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.128.1"
#define DCM_UID_SOP_CLASS_STANDALONE_PET_CURVE_STORAGE_RETIRED "1.2.840.10008.5.1.4.1.1.129"
#define DCM_UID_SOP_CLASS_ENHANCED_PET_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.130"
#define DCM_UID_SOP_CLASS_BASIC_STRUCTURED_DISPLAY_STORAGE "1.2.840.10008.5.1.4.1.1.131"
#define DCM_UID_SOP_CLASS_CT_DEFINED_PROCEDURE_PROTOCOL_STORAGE "1.2.840.10008.5.1.4.1.1.200.1"
#define DCM_UID_SOP_CLASS_CT_PERFORMED_PROCEDURE_PROTOCOL_STORAGE "1.2.840.10008.5.1.4.1.1.200.2"
#define DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_STORAGE "1.2.840.10008.5.1.4.1.1.200.3"
#define DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.1.1.200.4"
#define DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.1.1.200.5"
#define DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.1.1.200.6"
#define DCM_UID_SOP_CLASS_RT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.481.1"
#define DCM_UID_SOP_CLASS_RT_DOSE_STORAGE "1.2.840.10008.5.1.4.1.1.481.2"
#define DCM_UID_SOP_CLASS_RT_STRUCTURE_SET_STORAGE "1.2.840.10008.5.1.4.1.1.481.3"
#define DCM_UID_SOP_CLASS_RT_BEAMS_TREATMENT_RECORD_STORAGE "1.2.840.10008.5.1.4.1.1.481.4"
#define DCM_UID_SOP_CLASS_RT_PLAN_STORAGE "1.2.840.10008.5.1.4.1.1.481.5"
#define DCM_UID_SOP_CLASS_RT_BRACHY_TREATMENT_RECORD_STORAGE "1.2.840.10008.5.1.4.1.1.481.6"
#define DCM_UID_SOP_CLASS_RT_TREATMENT_SUMMARY_RECORD_STORAGE "1.2.840.10008.5.1.4.1.1.481.7"
#define DCM_UID_SOP_CLASS_RT_ION_PLAN_STORAGE "1.2.840.10008.5.1.4.1.1.481.8"
#define DCM_UID_SOP_CLASS_RT_ION_BEAMS_TREATMENT_RECORD_STORAGE "1.2.840.10008.5.1.4.1.1.481.9"
#define DCM_UID_SOP_CLASS_RT_PHYSICIAN_INTENT_STORAGE "1.2.840.10008.5.1.4.1.1.481.10"
#define DCM_UID_SOP_CLASS_RT_SEGMENT_ANNOTATION_STORAGE "1.2.840.10008.5.1.4.1.1.481.11"
#define DCM_UID_SOP_CLASS_RT_RADIATION_SET_STORAGE "1.2.840.10008.5.1.4.1.1.481.12"
#define DCM_UID_SOP_CLASS_C_ARM_PHOTON_ELECTRON_RADIATION_STORAGE "1.2.840.10008.5.1.4.1.1.481.13"
#define DCM_UID_SOP_CLASS_DICOS_CT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.501.1"
#define DCM_UID_SOP_CLASS_DICOS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION "1.2.840.10008.5.1.4.1.1.501.2.1"
#define DCM_UID_SOP_CLASS_DICOS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING "1.2.840.10008.5.1.4.1.1.501.2.2"
#define DCM_UID_SOP_CLASS_DICOS_THREAT_DETECTION_REPORT_STORAGE "1.2.840.10008.5.1.4.1.1.501.3"
#define DCM_UID_SOP_CLASS_DICOS_2D_AIT_STORAGE "1.2.840.10008.5.1.4.1.1.501.4"
#define DCM_UID_SOP_CLASS_DICOS_3D_AIT_STORAGE "1.2.840.10008.5.1.4.1.1.501.5"
#define DCM_UID_SOP_CLASS_DICOS_QUADRUPOLE_RESONANCE_QR_STORAGE "1.2.840.10008.5.1.4.1.1.501.6"
#define DCM_UID_SOP_CLASS_EDDY_CURRENT_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.601.1"
#define DCM_UID_SOP_CLASS_EDDY_CURRENT_MULTI_FRAME_IMAGE_STORAGE "1.2.840.10008.5.1.4.1.1.601.2"
#define DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.1.2.1.1"
#define DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.1.2.1.2"
#define DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.1.2.1.3"
#define DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.1.2.2.1"
#define DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.1.2.2.2"
#define DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.1.2.2.3"
#define DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_FIND_RETIRED "1.2.840.10008.5.1.4.1.2.3.1"
#define DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_MOVE_RETIRED "1.2.840.10008.5.1.4.1.2.3.2"
#define DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_GET_RETIRED "1.2.840.10008.5.1.4.1.2.3.3"
#define DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_ROOT_RETRIEVE_MOVE "1.2.840.10008.5.1.4.1.2.4.2"
#define DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_ROOT_RETRIEVE_GET "1.2.840.10008.5.1.4.1.2.4.3"
#define DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_RETRIEVE_WITHOUT_BULK_DATA_GET "1.2.840.10008.5.1.4.1.2.5.3"
#define DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.20.1"
#define DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.20.2"
#define DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.20.3"
#define DCM_UID_SOP_CLASS_MODALITY_WORKLIST_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.31"
#define DCM_UID_META_SOP_CLASS_GENERAL_PURPOSE_WORKLIST_MANAGEMENT_META_SOP_CLASS_RETIRED "1.2.840.10008.5.1.4.32"
#define DCM_UID_SOP_CLASS_GENERAL_PURPOSE_WORKLIST_INFORMATION_MODEL_FIND_RETIRED "1.2.840.10008.5.1.4.32.1"
#define DCM_UID_SOP_CLASS_GENERAL_PURPOSE_SCHEDULED_PROCEDURE_STEP_SOP_CLASS_RETIRED "1.2.840.10008.5.1.4.32.2"
#define DCM_UID_SOP_CLASS_GENERAL_PURPOSE_PERFORMED_PROCEDURE_STEP_SOP_CLASS_RETIRED "1.2.840.10008.5.1.4.32.3"
#define DCM_UID_SOP_CLASS_INSTANCE_AVAILABILITY_NOTIFICATION "1.2.840.10008.5.1.4.33"
#define DCM_UID_SOP_CLASS_RT_BEAMS_DELIVERY_INSTRUCTION_STORAGE_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.1"
#define DCM_UID_SOP_CLASS_RT_CONVENTIONAL_MACHINE_VERIFICATION_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.2"
#define DCM_UID_SOP_CLASS_RT_ION_MACHINE_VERIFICATION_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.3"
#define DCM_UID_SERVICE_CLASS_UNIFIED_WORKLIST_AND_PROCEDURE_STEP_SERVICE_CLASS_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.4"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PUSH_SOP_CLASS_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.4.1"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_WATCH_SOP_CLASS_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.4.2"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PULL_SOP_CLASS_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.4.3"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_EVENT_SOP_CLASS_TRIAL_RETIRED "1.2.840.10008.5.1.4.34.4.4"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_UPS_GLOBAL_SUBSCRIPTION_SOP_INSTANCE "1.2.840.10008.5.1.4.34.5"
#define DCM_UID_WELL_KNOWN_SOP_INSTANCE_UPS_FILTERED_GLOBAL_SUBSCRIPTION_SOP_INSTANCE "1.2.840.10008.5.1.4.34.5.1"
#define DCM_UID_SERVICE_CLASS_UNIFIED_WORKLIST_AND_PROCEDURE_STEP "1.2.840.10008.5.1.4.34.6"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PUSH "1.2.840.10008.5.1.4.34.6.1"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_WATCH "1.2.840.10008.5.1.4.34.6.2"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PULL "1.2.840.10008.5.1.4.34.6.3"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_EVENT "1.2.840.10008.5.1.4.34.6.4"
#define DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_QUERY "1.2.840.10008.5.1.4.34.6.5"
#define DCM_UID_SOP_CLASS_RT_BEAMS_DELIVERY_INSTRUCTION_STORAGE "1.2.840.10008.5.1.4.34.7"
#define DCM_UID_SOP_CLASS_RT_CONVENTIONAL_MACHINE_VERIFICATION "1.2.840.10008.5.1.4.34.8"
#define DCM_UID_SOP_CLASS_RT_ION_MACHINE_VERIFICATION "1.2.840.10008.5.1.4.34.9"
#define DCM_UID_SOP_CLASS_RT_BRACHY_APPLICATION_SETUP_DELIVERY_INSTRUCTION_STORAGE "1.2.840.10008.5.1.4.34.10"
#define DCM_UID_SOP_CLASS_GENERAL_RELEVANT_PATIENT_INFORMATION_QUERY "1.2.840.10008.5.1.4.37.1"
#define DCM_UID_SOP_CLASS_BREAST_IMAGING_RELEVANT_PATIENT_INFORMATION_QUERY "1.2.840.10008.5.1.4.37.2"
#define DCM_UID_SOP_CLASS_CARDIAC_RELEVANT_PATIENT_INFORMATION_QUERY "1.2.840.10008.5.1.4.37.3"
#define DCM_UID_SOP_CLASS_HANGING_PROTOCOL_STORAGE "1.2.840.10008.5.1.4.38.1"
#define DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.38.2"
#define DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.38.3"
#define DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.38.4"
#define DCM_UID_SOP_CLASS_COLOR_PALETTE_STORAGE "1.2.840.10008.5.1.4.39.1"
#define DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.39.2"
#define DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.39.3"
#define DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.39.4"
#define DCM_UID_SOP_CLASS_PRODUCT_CHARACTERISTICS_QUERY "1.2.840.10008.5.1.4.41"
#define DCM_UID_SOP_CLASS_SUBSTANCE_APPROVAL_QUERY "1.2.840.10008.5.1.4.42"
#define DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_STORAGE "1.2.840.10008.5.1.4.43.1"
#define DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.43.2"
#define DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.43.3"
#define DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.43.4"
#define DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_STORAGE "1.2.840.10008.5.1.4.44.1"
#define DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.44.2"
#define DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.44.3"
#define DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.44.4"
#define DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_STORAGE "1.2.840.10008.5.1.4.45.1"
#define DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_FIND "1.2.840.10008.5.1.4.45.2"
#define DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_MOVE "1.2.840.10008.5.1.4.45.3"
#define DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_GET "1.2.840.10008.5.1.4.45.4"
#define DCM_UID_APPLICATION_HOSTING_MODEL_NATIVE_DICOM_MODEL "1.2.840.10008.7.1.1"
#define DCM_UID_APPLICATION_HOSTING_MODEL_ABSTRACT_MULTI_DIMENSIONAL_IMAGE_MODEL "1.2.840.10008.7.1.2"
#define DCM_UID_MAPPING_RESOURCE_DICOM_CONTENT "1.2.840.10008.8.1.1"
#define DCM_UID_SOP_CLASS_VIDEO_ENDOSCOPIC_IMAGE_REAL_TIME_COMMUNICATION "1.2.840.10008.10.1"
#define DCM_UID_SOP_CLASS_VIDEO_PHOTOGRAPHIC_IMAGE_REAL_TIME_COMMUNICATION "1.2.840.10008.10.2"
#define DCM_UID_SOP_CLASS_AUDIO_WAVEFORM_REAL_TIME_COMMUNICATION "1.2.840.10008.10.3"
#define DCM_UID_SOP_CLASS_RENDITION_SELECTION_DOCUMENT_REAL_TIME_COMMUNICATION "1.2.840.10008.10.4"
#define DCM_UID_LDAP_OID_DICOMDEVICENAME "1.2.840.10008.15.0.3.1"
#define DCM_UID_LDAP_OID_DICOMDESCRIPTION "1.2.840.10008.15.0.3.2"
#define DCM_UID_LDAP_OID_DICOMMANUFACTURER "1.2.840.10008.15.0.3.3"
#define DCM_UID_LDAP_OID_DICOMMANUFACTURERMODELNAME "1.2.840.10008.15.0.3.4"
#define DCM_UID_LDAP_OID_DICOMSOFTWAREVERSION "1.2.840.10008.15.0.3.5"
#define DCM_UID_LDAP_OID_DICOMVENDORDATA "1.2.840.10008.15.0.3.6"
#define DCM_UID_LDAP_OID_DICOMAETITLE "1.2.840.10008.15.0.3.7"
#define DCM_UID_LDAP_OID_DICOMNETWORKCONNECTIONREFERENCE "1.2.840.10008.15.0.3.8"
#define DCM_UID_LDAP_OID_DICOMAPPLICATIONCLUSTER "1.2.840.10008.15.0.3.9"
#define DCM_UID_LDAP_OID_DICOMASSOCIATIONINITIATOR "1.2.840.10008.15.0.3.10"
#define DCM_UID_LDAP_OID_DICOMASSOCIATIONACCEPTOR "1.2.840.10008.15.0.3.11"
#define DCM_UID_LDAP_OID_DICOMHOSTNAME "1.2.840.10008.15.0.3.12"
#define DCM_UID_LDAP_OID_DICOMPORT "1.2.840.10008.15.0.3.13"
#define DCM_UID_LDAP_OID_DICOMSOPCLASS "1.2.840.10008.15.0.3.14"
#define DCM_UID_LDAP_OID_DICOMTRANSFERROLE "1.2.840.10008.15.0.3.15"
#define DCM_UID_LDAP_OID_DICOMTRANSFERSYNTAX "1.2.840.10008.15.0.3.16"
#define DCM_UID_LDAP_OID_DICOMPRIMARYDEVICETYPE "1.2.840.10008.15.0.3.17"
#define DCM_UID_LDAP_OID_DICOMRELATEDDEVICEREFERENCE "1.2.840.10008.15.0.3.18"
#define DCM_UID_LDAP_OID_DICOMPREFERREDCALLEDAETITLE "1.2.840.10008.15.0.3.19"
#define DCM_UID_LDAP_OID_DICOMTLSCYPHERSUITE "1.2.840.10008.15.0.3.20"
#define DCM_UID_LDAP_OID_DICOMAUTHORIZEDNODECERTIFICATEREFERENCE "1.2.840.10008.15.0.3.21"
#define DCM_UID_LDAP_OID_DICOMTHISNODECERTIFICATEREFERENCE "1.2.840.10008.15.0.3.22"
#define DCM_UID_LDAP_OID_DICOMINSTALLED "1.2.840.10008.15.0.3.23"
#define DCM_UID_LDAP_OID_DICOMSTATIONNAME "1.2.840.10008.15.0.3.24"
#define DCM_UID_LDAP_OID_DICOMDEVICESERIALNUMBER "1.2.840.10008.15.0.3.25"
#define DCM_UID_LDAP_OID_DICOMINSTITUTIONNAME "1.2.840.10008.15.0.3.26"
#define DCM_UID_LDAP_OID_DICOMINSTITUTIONADDRESS "1.2.840.10008.15.0.3.27"
#define DCM_UID_LDAP_OID_DICOMINSTITUTIONDEPARTMENTNAME "1.2.840.10008.15.0.3.28"
#define DCM_UID_LDAP_OID_DICOMISSUEROFPATIENTID "1.2.840.10008.15.0.3.29"
#define DCM_UID_LDAP_OID_DICOMPREFERREDCALLINGAETITLE "1.2.840.10008.15.0.3.30"
#define DCM_UID_LDAP_OID_DICOMSUPPORTEDCHARACTERSET "1.2.840.10008.15.0.3.31"
#define DCM_UID_LDAP_OID_DICOMCONFIGURATIONROOT "1.2.840.10008.15.0.4.1"
#define DCM_UID_LDAP_OID_DICOMDEVICESROOT "1.2.840.10008.15.0.4.2"
#define DCM_UID_LDAP_OID_DICOMUNIQUEAETITLESREGISTRYROOT "1.2.840.10008.15.0.4.3"
#define DCM_UID_LDAP_OID_DICOMDEVICE "1.2.840.10008.15.0.4.4"
#define DCM_UID_LDAP_OID_DICOMNETWORKAE "1.2.840.10008.15.0.4.5"
#define DCM_UID_LDAP_OID_DICOMNETWORKCONNECTION "1.2.840.10008.15.0.4.6"
#define DCM_UID_LDAP_OID_DICOMUNIQUEAETITLE "1.2.840.10008.15.0.4.7"
#define DCM_UID_LDAP_OID_DICOMTRANSFERCAPABILITY "1.2.840.10008.15.0.4.8"
#define DCM_UID_SYNCHRONIZATION_FRAME_OF_REFERENCE_UNIVERSAL_COORDINATED_TIME "1.2.840.10008.15.1.1"

static dcm_uid_t dcm_uid_data[] = {
    { DCM_UID_SOP_CLASS_VERIFICATION, "Verification SOP Class", "SOP Class"},
    { DCM_UID_TRANSFER_SYNTAX_IMPLICIT_VR_LITTLE_ENDIAN, "Implicit VR Little Endian: Default Transfer Syntax for DICOM", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_EXPLICIT_VR_LITTLE_ENDIAN, "Explicit VR Little Endian", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_DEFLATED_EXPLICIT_VR_LITTLE_ENDIAN, "Deflated Explicit VR Little Endian", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_EXPLICIT_VR_BIG_ENDIAN_RETIRED, "Explicit VR Big Endian (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_BASELINE_PROCESS_1, "JPEG Baseline (Process 1): Default Transfer Syntax for Lossy JPEG 8 Bit Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_PROCESS_2_4, "JPEG Extended (Process 2 & 4): Default Transfer Syntax for Lossy JPEG 12 Bit Image Compression (Process 4 only)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_PROCESS_3_5_RETIRED, "JPEG Extended (Process 3 & 5) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_NON_HIERARCHICAL_PROCESS_6_8_RETIRED, "JPEG Spectral Selection, Non-Hierarchical (Process 6 & 8) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_NON_HIERARCHICAL_PROCESS_7_9_RETIRED, "JPEG Spectral Selection, Non-Hierarchical (Process 7 & 9) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_NON_HIERARCHICAL_PROCESS_10_12_RETIRED, "JPEG Full Progression, Non-Hierarchical (Process 10 & 12) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_NON_HIERARCHICAL_PROCESS_11_13_RETIRED, "JPEG Full Progression, Non-Hierarchical (Process 11 & 13) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_PROCESS_14, "JPEG Lossless, Non-Hierarchical (Process 14)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_PROCESS_15_RETIRED, "JPEG Lossless, Non-Hierarchical (Process 15) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_HIERARCHICAL_PROCESS_16_18_RETIRED, "JPEG Extended, Hierarchical (Process 16 & 18) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_EXTENDED_HIERARCHICAL_PROCESS_17_19_RETIRED, "JPEG Extended, Hierarchical (Process 17 & 19) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_HIERARCHICAL_PROCESS_20_22_RETIRED, "JPEG Spectral Selection, Hierarchical (Process 20 & 22) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_SPECTRAL_SELECTION_HIERARCHICAL_PROCESS_21_23_RETIRED, "JPEG Spectral Selection, Hierarchical (Process 21 & 23) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_HIERARCHICAL_PROCESS_24_26_RETIRED, "JPEG Full Progression, Hierarchical (Process 24 & 26) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_FULL_PROGRESSION_HIERARCHICAL_PROCESS_25_27_RETIRED, "JPEG Full Progression, Hierarchical (Process 25 & 27) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_HIERARCHICAL_PROCESS_28_RETIRED, "JPEG Lossless, Hierarchical (Process 28) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_HIERARCHICAL_PROCESS_29_RETIRED, "JPEG Lossless, Hierarchical (Process 29) (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LOSSLESS_NON_HIERARCHICAL_FIRST_ORDER_PREDICTION_PROCESS_14_SELECTION_VALUE_1, "JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1]): Default Transfer Syntax for Lossless JPEG Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LS_LOSSLESS_IMAGE_COMPRESSION, "JPEG-LS Lossless Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_LS_LOSSY_NEAR_LOSSLESS_IMAGE_COMPRESSION, "JPEG-LS Lossy (Near-Lossless) Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_2000_IMAGE_COMPRESSION_LOSSLESS_ONLY, "JPEG 2000 Image Compression (Lossless Only)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_2000_IMAGE_COMPRESSION, "JPEG 2000 Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_2000_PART_2_MULTI_COMPONENT_IMAGE_COMPRESSION_LOSSLESS_ONLY, "JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPEG_2000_PART_2_MULTI_COMPONENT_IMAGE_COMPRESSION, "JPEG 2000 Part 2 Multi-component Image Compression", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPIP_REFERENCED, "JPIP Referenced", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_JPIP_REFERENCED_DEFLATE, "JPIP Referenced Deflate", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG2_MAIN_PROFILE_MAIN_LEVEL, "MPEG2 Main Profile / Main Level", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG2_MAIN_PROFILE_HIGH_LEVEL, "MPEG2 Main Profile / High Level", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_41, "MPEG-4 AVC/H.264 High Profile / Level 4.1", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_BD_COMPATIBLE_HIGH_PROFILE_LEVEL_41, "MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_42_FOR_2D_VIDEO, "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 2D Video", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_HIGH_PROFILE_LEVEL_42_FOR_3D_VIDEO, "MPEG-4 AVC/H.264 High Profile / Level 4.2 For 3D Video", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_MPEG_4_AVCH264_STEREO_HIGH_PROFILE_LEVEL_42, "MPEG-4 AVC/H.264 Stereo High Profile / Level 4.2", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_HEVCH265_MAIN_PROFILE_LEVEL_51, "HEVC/H.265 Main Profile / Level 5.1", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_HEVCH265_MAIN_10_PROFILE_LEVEL_51, "HEVC/H.265 Main 10 Profile / Level 5.1", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_RLE_LOSSLESS, "RLE Lossless", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_RFC_2557_MIME_ENCAPSULATION_RETIRED, "RFC 2557 MIME encapsulation (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_XML_ENCODING_RETIRED, "XML Encoding (Retired)", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_20_UNCOMPRESSED_PROGRESSIVE_ACTIVE_VIDEO, "SMPTE ST 2110-20 Uncompressed Progressive Active Video", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_20_UNCOMPRESSED_INTERLACED_ACTIVE_VIDEO, "SMPTE ST 2110-20 Uncompressed Interlaced Active Video", "Transfer Syntax"},
    { DCM_UID_TRANSFER_SYNTAX_SMPTE_ST_2110_30_PCM_DIGITAL_AUDIO, "SMPTE ST 2110-30 PCM Digital Audio", "Transfer Syntax"},
    { DCM_UID_SOP_CLASS_MEDIA_STORAGE_DIRECTORY_STORAGE, "Media Storage Directory Storage", "SOP Class"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_TALAIRACH_BRAIN_ATLAS_FRAME_OF_REFERENCE, "Talairach Brain Atlas Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_T1_FRAME_OF_REFERENCE, "SPM2 T1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_T2_FRAME_OF_REFERENCE, "SPM2 T2 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_PD_FRAME_OF_REFERENCE, "SPM2 PD Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_EPI_FRAME_OF_REFERENCE, "SPM2 EPI Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_FIL_T1_FRAME_OF_REFERENCE, "SPM2 FIL T1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_PET_FRAME_OF_REFERENCE, "SPM2 PET Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_TRANSM_FRAME_OF_REFERENCE, "SPM2 TRANSM Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_SPECT_FRAME_OF_REFERENCE, "SPM2 SPECT Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_GRAY_FRAME_OF_REFERENCE, "SPM2 GRAY Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_WHITE_FRAME_OF_REFERENCE, "SPM2 WHITE Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_CSF_FRAME_OF_REFERENCE, "SPM2 CSF Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_BRAINMASK_FRAME_OF_REFERENCE, "SPM2 BRAINMASK Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG305T1_FRAME_OF_REFERENCE, "SPM2 AVG305T1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152T1_FRAME_OF_REFERENCE, "SPM2 AVG152T1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152T2_FRAME_OF_REFERENCE, "SPM2 AVG152T2 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_AVG152PD_FRAME_OF_REFERENCE, "SPM2 AVG152PD Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_SPM2_SINGLESUBJT1_FRAME_OF_REFERENCE, "SPM2 SINGLESUBJT1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_ICBM_452_T1_FRAME_OF_REFERENCE, "ICBM 452 T1 Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_ICBM_SINGLE_SUBJECT_MRI_FRAME_OF_REFERENCE, "ICBM Single Subject MRI Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_FRAME_OF_REFERENCE_IEC_61217_FIXED_COORDINATE_SYSTEM_FRAME_OF_REFERENCE, "IEC 61217 Fixed Coordinate System Frame of Reference", "Well-known frame of reference"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_HOT_IRON_COLOR_PALETTE_SOP_INSTANCE, "Hot Iron Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_PET_COLOR_PALETTE_SOP_INSTANCE, "PET Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_HOT_METAL_BLUE_COLOR_PALETTE_SOP_INSTANCE, "Hot Metal Blue Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_PET_20_STEP_COLOR_PALETTE_SOP_INSTANCE, "PET 20 Step Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_SPRING_COLOR_PALETTE_SOP_INSTANCE, "Spring Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_SUMMER_COLOR_PALETTE_SOP_INSTANCE, "Summer Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_FALL_COLOR_PALETTE_SOP_INSTANCE, "Fall Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_WINTER_COLOR_PALETTE_SOP_INSTANCE, "Winter Color Palette SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_SOP_CLASS_BASIC_STUDY_CONTENT_NOTIFICATION_SOP_CLASS_RETIRED, "Basic Study Content Notification SOP Class (Retired)", "SOP Class"},
    { DCM_UID_TRANSFER_SYNTAX_PAPYRUS_3_IMPLICIT_VR_LITTLE_ENDIAN_RETIRED, "Papyrus 3 Implicit VR Little Endian (Retired)", "Transfer Syntax"},
    { DCM_UID_SOP_CLASS_STORAGE_COMMITMENT_PUSH_MODEL, "Storage Commitment Push Model SOP Class", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_STORAGE_COMMITMENT_PUSH_MODEL_SOP_INSTANCE, "Storage Commitment Push Model SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_SOP_CLASS_STORAGE_COMMITMENT_PULL_MODEL_SOP_CLASS_RETIRED, "Storage Commitment Pull Model SOP Class (Retired)", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_STORAGE_COMMITMENT_PULL_MODEL_SOP_INSTANCE_RETIRED, "Storage Commitment Pull Model SOP Instance (Retired)", "Well-known SOP Instance"},
    { DCM_UID_SOP_CLASS_PROCEDURAL_EVENT_LOGGING, "Procedural Event Logging SOP Class", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_PROCEDURAL_EVENT_LOGGING_SOP_INSTANCE, "Procedural Event Logging SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_SOP_CLASS_SUBSTANCE_ADMINISTRATION_LOGGING, "Substance Administration Logging SOP Class", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_SUBSTANCE_ADMINISTRATION_LOGGING_SOP_INSTANCE, "Substance Administration Logging SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_DICOM_UIDS_AS_A_CODING_SCHEME_DICOM_UID_REGISTRY, "DICOM UID Registry", "DICOM UIDs as a Coding Scheme"},
    { DCM_UID_CODING_SCHEME_DICOM_CONTROLLED_TERMINOLOGY, "DICOM Controlled Terminology", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_ADULT_MOUSE_ANATOMY_ONTOLOGY, "Adult Mouse Anatomy Ontology", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_UBERON_ONTOLOGY, "Uberon Ontology", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_INTEGRATED_TAXONOMIC_INFORMATION_SYSTEM_ITIS_TAXONOMIC_SERIAL_NUMBER_TSN, "Integrated Taxonomic Information System (ITIS) Taxonomic Serial Number (TSN)", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_MOUSE_GENOME_INITIATIVE_MGI, "Mouse Genome Initiative (MGI)", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_PUBCHEM_COMPOUND_CID, "PubChem Compound CID", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_ICD_11, "ICD-11", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_NEW_YORK_UNIVERSITY_MELANOMA_CLINICAL_COOPERATIVE_GROUP, "New York University Melanoma Clinical Cooperative Group", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_MAYO_CLINIC_NON_RADIOLOGICAL_IMAGES_SPECIFIC_BODY_STRUCTURE_ANATOMICAL_SURFACE_REGION_GUIDE, "Mayo Clinic Non-radiological Images Specific Body Structure Anatomical Surface Region Guide", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_IMAGE_BIOMARKER_STANDARDISATION_INITIATIVE, "Image Biomarker Standardisation Initiative", "Coding Scheme"},
    { DCM_UID_CODING_SCHEME_RADIOMICS_ONTOLOGY, "Radiomics Ontology", "Coding Scheme"},
    { DCM_UID_APPLICATION_CONTEXT_NAME_DICOM, "DICOM Application Context Name", "Application Context Name"},
    { DCM_UID_SOP_CLASS_DETACHED_PATIENT_MANAGEMENT_SOP_CLASS_RETIRED, "Detached Patient Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_META_SOP_CLASS_DETACHED_PATIENT_MANAGEMENT_META_SOP_CLASS_RETIRED, "Detached Patient Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_DETACHED_VISIT_MANAGEMENT_SOP_CLASS_RETIRED, "Detached Visit Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_DETACHED_STUDY_MANAGEMENT_SOP_CLASS_RETIRED, "Detached Study Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_STUDY_COMPONENT_MANAGEMENT_SOP_CLASS_RETIRED, "Study Component Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP, "Modality Performed Procedure Step SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP_RETRIEVE, "Modality Performed Procedure Step Retrieve SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_MODALITY_PERFORMED_PROCEDURE_STEP_NOTIFICATION, "Modality Performed Procedure Step Notification SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_DETACHED_RESULTS_MANAGEMENT_SOP_CLASS_RETIRED, "Detached Results Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_META_SOP_CLASS_DETACHED_RESULTS_MANAGEMENT_META_SOP_CLASS_RETIRED, "Detached Results Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_META_SOP_CLASS_DETACHED_STUDY_MANAGEMENT_META_SOP_CLASS_RETIRED, "Detached Study Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_DETACHED_INTERPRETATION_MANAGEMENT_SOP_CLASS_RETIRED, "Detached Interpretation Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SERVICE_CLASS_STORAGE, "Storage Service Class", "Service Class"},
    { DCM_UID_SOP_CLASS_BASIC_FILM_SESSION, "Basic Film Session SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_FILM_BOX, "Basic Film Box SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_GRAYSCALE_IMAGE_BOX, "Basic Grayscale Image Box SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_COLOR_IMAGE_BOX, "Basic Color Image Box SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_REFERENCED_IMAGE_BOX_SOP_CLASS_RETIRED, "Referenced Image Box SOP Class (Retired)", "SOP Class"},
    { DCM_UID_META_SOP_CLASS_BASIC_GRAYSCALE_PRINT_MANAGEMENT, "Basic Grayscale Print Management Meta SOP Class", "Meta SOP Class"},
    { DCM_UID_META_SOP_CLASS_REFERENCED_GRAYSCALE_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED, "Referenced Grayscale Print Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_PRINT_JOB, "Print Job SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_ANNOTATION_BOX, "Basic Annotation Box SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_PRINTER, "Printer SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_PRINTER_CONFIGURATION_RETRIEVAL, "Printer Configuration Retrieval SOP Class", "SOP Class"},
    { DCM_UID_WELL_KNOWN_PRINTER_SOP_INSTANCE_PRINTER_SOP_INSTANCE, "Printer SOP Instance", "Well-known Printer SOP Instance"},
    { DCM_UID_WELL_KNOWN_PRINTER_SOP_INSTANCE_PRINTER_CONFIGURATION_RETRIEVAL_SOP_INSTANCE, "Printer Configuration Retrieval SOP Instance", "Well-known Printer SOP Instance"},
    { DCM_UID_META_SOP_CLASS_BASIC_COLOR_PRINT_MANAGEMENT, "Basic Color Print Management Meta SOP Class", "Meta SOP Class"},
    { DCM_UID_META_SOP_CLASS_REFERENCED_COLOR_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED, "Referenced Color Print Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_VOI_LUT_BOX, "VOI LUT Box SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_PRESENTATION_LUT, "Presentation LUT SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMAGE_OVERLAY_BOX_SOP_CLASS_RETIRED, "Image Overlay Box SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_PRINT_IMAGE_OVERLAY_BOX_SOP_CLASS_RETIRED, "Basic Print Image Overlay Box SOP Class (Retired)", "SOP Class"},
    { DCM_UID_WELL_KNOWN_PRINT_QUEUE_SOP_INSTANCE_PRINT_QUEUE_SOP_INSTANCE_RETIRED, "Print Queue SOP Instance (Retired)", "Well-known Print Queue SOP Instance"},
    { DCM_UID_SOP_CLASS_PRINT_QUEUE_MANAGEMENT_SOP_CLASS_RETIRED, "Print Queue Management SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_STORED_PRINT_STORAGE_SOP_CLASS_RETIRED, "Stored Print Storage SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_HARDCOPY_GRAYSCALE_IMAGE_STORAGE_SOP_CLASS_RETIRED, "Hardcopy Grayscale Image Storage SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_HARDCOPY_COLOR_IMAGE_STORAGE_SOP_CLASS_RETIRED, "Hardcopy Color Image Storage SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_PULL_PRINT_REQUEST_SOP_CLASS_RETIRED, "Pull Print Request SOP Class (Retired)", "SOP Class"},
    { DCM_UID_META_SOP_CLASS_PULL_STORED_PRINT_MANAGEMENT_META_SOP_CLASS_RETIRED, "Pull Stored Print Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_MEDIA_CREATION_MANAGEMENT_SOP_CLASS_UID, "Media Creation Management SOP Class UID", "SOP Class"},
    { DCM_UID_SOP_CLASS_DISPLAY_SYSTEM, "Display System SOP Class", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_DISPLAY_SYSTEM_SOP_INSTANCE, "Display System SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_SOP_CLASS_COMPUTED_RADIOGRAPHY_IMAGE_STORAGE, "Computed Radiography Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION, "Digital X-Ray Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING, "Digital X-Ray Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_MAMMOGRAPHY_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION, "Digital Mammography X-Ray Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_MAMMOGRAPHY_X_RAY_IMAGE_STORAGE_FOR_PROCESSING, "Digital Mammography X-Ray Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_INTRA_ORAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION, "Digital Intra-Oral X-Ray Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_DIGITAL_INTRA_ORAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING, "Digital Intra-Oral X-Ray Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_CT_IMAGE_STORAGE, "CT Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_CT_IMAGE_STORAGE, "Enhanced CT Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_CT_IMAGE_STORAGE, "Legacy Converted Enhanced CT Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ULTRASOUND_MULTI_FRAME_IMAGE_STORAGE_RETIRED, "Ultrasound Multi-frame Image Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_ULTRASOUND_MULTI_FRAME_IMAGE_STORAGE, "Ultrasound Multi-frame Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MR_IMAGE_STORAGE, "MR Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_MR_IMAGE_STORAGE, "Enhanced MR Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MR_SPECTROSCOPY_STORAGE, "MR Spectroscopy Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_MR_COLOR_IMAGE_STORAGE, "Enhanced MR Color Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_MR_IMAGE_STORAGE, "Legacy Converted Enhanced MR Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_NUCLEAR_MEDICINE_IMAGE_STORAGE_RETIRED, "Nuclear Medicine Image Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_ULTRASOUND_IMAGE_STORAGE_RETIRED, "Ultrasound Image Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_ULTRASOUND_IMAGE_STORAGE, "Ultrasound Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_US_VOLUME_STORAGE, "Enhanced US Volume Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SECONDARY_CAPTURE_IMAGE_STORAGE, "Secondary Capture Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MULTI_FRAME_SINGLE_BIT_SECONDARY_CAPTURE_IMAGE_STORAGE, "Multi-frame Single Bit Secondary Capture Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MULTI_FRAME_GRAYSCALE_BYTE_SECONDARY_CAPTURE_IMAGE_STORAGE, "Multi-frame Grayscale Byte Secondary Capture Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MULTI_FRAME_GRAYSCALE_WORD_SECONDARY_CAPTURE_IMAGE_STORAGE, "Multi-frame Grayscale Word Secondary Capture Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MULTI_FRAME_TRUE_COLOR_SECONDARY_CAPTURE_IMAGE_STORAGE, "Multi-frame True Color Secondary Capture Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_STANDALONE_OVERLAY_STORAGE_RETIRED, "Standalone Overlay Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_STANDALONE_CURVE_STORAGE_RETIRED, "Standalone Curve Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_WAVEFORM_STORAGE_TRIAL_RETIRED, "Waveform Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_12_LEAD_ECG_WAVEFORM_STORAGE, "12-lead ECG Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_ECG_WAVEFORM_STORAGE, "General ECG Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_AMBULATORY_ECG_WAVEFORM_STORAGE, "Ambulatory ECG Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_HEMODYNAMIC_WAVEFORM_STORAGE, "Hemodynamic Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CARDIAC_ELECTROPHYSIOLOGY_WAVEFORM_STORAGE, "Cardiac Electrophysiology Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_VOICE_AUDIO_WAVEFORM_STORAGE, "Basic Voice Audio Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_AUDIO_WAVEFORM_STORAGE, "General Audio Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ARTERIAL_PULSE_WAVEFORM_STORAGE, "Arterial Pulse Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RESPIRATORY_WAVEFORM_STORAGE, "Respiratory Waveform Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_STANDALONE_MODALITY_LUT_STORAGE_RETIRED, "Standalone Modality LUT Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_STANDALONE_VOI_LUT_STORAGE_RETIRED, "Standalone VOI LUT Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_GRAYSCALE_SOFTCOPY_PRESENTATION_STATE_STORAGE, "Grayscale Softcopy Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLOR_SOFTCOPY_PRESENTATION_STATE_STORAGE, "Color Softcopy Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PSEUDO_COLOR_SOFTCOPY_PRESENTATION_STATE_STORAGE, "Pseudo-Color Softcopy Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_BLENDING_SOFTCOPY_PRESENTATION_STATE_STORAGE, "Blending Softcopy Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_XAXRF_GRAYSCALE_SOFTCOPY_PRESENTATION_STATE_STORAGE, "XA/XRF Grayscale Softcopy Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_GRAYSCALE_PLANAR_MPR_VOLUMETRIC_PRESENTATION_STATE_STORAGE, "Grayscale Planar MPR Volumetric Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPOSITING_PLANAR_MPR_VOLUMETRIC_PRESENTATION_STATE_STORAGE, "Compositing Planar MPR Volumetric Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ADVANCED_BLENDING_PRESENTATION_STATE_STORAGE, "Advanced Blending Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE, "Volume Rendering Volumetric Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SEGMENTED_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE, "Segmented Volume Rendering Volumetric Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MULTIPLE_VOLUME_RENDERING_VOLUMETRIC_PRESENTATION_STATE_STORAGE, "Multiple Volume Rendering Volumetric Presentation State Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_ANGIOGRAPHIC_IMAGE_STORAGE, "X-Ray Angiographic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_XA_IMAGE_STORAGE, "Enhanced XA Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_RADIOFLUOROSCOPIC_IMAGE_STORAGE, "X-Ray Radiofluoroscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_XRF_IMAGE_STORAGE, "Enhanced XRF Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_ANGIOGRAPHIC_BI_PLANE_IMAGE_STORAGE_RETIRED, "X-Ray Angiographic Bi-Plane Image Storage (Retired)", "SOP Class"},
    { "1.2.840.10008.5.1.4.1.1.12.77", "(Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_3D_ANGIOGRAPHIC_IMAGE_STORAGE, "X-Ray 3D Angiographic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_3D_CRANIOFACIAL_IMAGE_STORAGE, "X-Ray 3D Craniofacial Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_BREAST_TOMOSYNTHESIS_IMAGE_STORAGE, "Breast Tomosynthesis Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_BREAST_PROJECTION_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION, "Breast Projection X-Ray Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_BREAST_PROJECTION_X_RAY_IMAGE_STORAGE_FOR_PROCESSING, "Breast Projection X-Ray Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY_IMAGE_STORAGE_FOR_PRESENTATION, "Intravascular Optical Coherence Tomography Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY_IMAGE_STORAGE_FOR_PROCESSING, "Intravascular Optical Coherence Tomography Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_NUCLEAR_MEDICINE_IMAGE_STORAGE, "Nuclear Medicine Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PARAMETRIC_MAP_STORAGE, "Parametric Map Storage", "SOP Class"},
    { "1.2.840.10008.5.1.4.1.1.40", "(Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_RAW_DATA_STORAGE, "Raw Data Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SPATIAL_REGISTRATION_STORAGE, "Spatial Registration Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SPATIAL_FIDUCIALS_STORAGE, "Spatial Fiducials Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DEFORMABLE_SPATIAL_REGISTRATION_STORAGE, "Deformable Spatial Registration Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SEGMENTATION_STORAGE, "Segmentation Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SURFACE_SEGMENTATION_STORAGE, "Surface Segmentation Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_TRACTOGRAPHY_RESULTS_STORAGE, "Tractography Results Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_REAL_WORLD_VALUE_MAPPING_STORAGE, "Real World Value Mapping Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SURFACE_SCAN_MESH_STORAGE, "Surface Scan Mesh Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SURFACE_SCAN_POINT_CLOUD_STORAGE, "Surface Scan Point Cloud Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_IMAGE_STORAGE_TRIAL_RETIRED, "VL Image Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_ENDOSCOPIC_IMAGE_STORAGE, "VL Endoscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VIDEO_ENDOSCOPIC_IMAGE_STORAGE, "Video Endoscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_MICROSCOPIC_IMAGE_STORAGE, "VL Microscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VIDEO_MICROSCOPIC_IMAGE_STORAGE, "Video Microscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_SLIDE_COORDINATES_MICROSCOPIC_IMAGE_STORAGE, "VL Slide-Coordinates Microscopic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_PHOTOGRAPHIC_IMAGE_STORAGE, "VL Photographic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VIDEO_PHOTOGRAPHIC_IMAGE_STORAGE, "Video Photographic Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_PHOTOGRAPHY_8_BIT_IMAGE_STORAGE, "Ophthalmic Photography 8 Bit Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_PHOTOGRAPHY_16_BIT_IMAGE_STORAGE, "Ophthalmic Photography 16 Bit Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_STEREOMETRIC_RELATIONSHIP_STORAGE, "Stereometric Relationship Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_TOMOGRAPHY_IMAGE_STORAGE, "Ophthalmic Tomography Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_WIDE_FIELD_OPHTHALMIC_PHOTOGRAPHY_STEREOGRAPHIC_PROJECTION_IMAGE_STORAGE, "Wide Field Ophthalmic Photography Stereographic Projection Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_WIDE_FIELD_OPHTHALMIC_PHOTOGRAPHY_3D_COORDINATES_IMAGE_STORAGE, "Wide Field Ophthalmic Photography 3D Coordinates Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_OPTICAL_COHERENCE_TOMOGRAPHY_EN_FACE_IMAGE_STORAGE, "Ophthalmic Optical Coherence Tomography En Face Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_OPTICAL_COHERENCE_TOMOGRAPHY_B_SCAN_VOLUME_ANALYSIS_STORAGE, "Ophthalmic Optical Coherence Tomography B-scan Volume Analysis Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_WHOLE_SLIDE_MICROSCOPY_IMAGE_STORAGE, "VL Whole Slide Microscopy Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VL_MULTI_FRAME_IMAGE_STORAGE_TRIAL_RETIRED, "VL Multi-frame Image Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_LENSOMETRY_MEASUREMENTS_STORAGE, "Lensometry Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_AUTOREFRACTION_MEASUREMENTS_STORAGE, "Autorefraction Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_KERATOMETRY_MEASUREMENTS_STORAGE, "Keratometry Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SUBJECTIVE_REFRACTION_MEASUREMENTS_STORAGE, "Subjective Refraction Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_VISUAL_ACUITY_MEASUREMENTS_STORAGE, "Visual Acuity Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SPECTACLE_PRESCRIPTION_REPORT_STORAGE, "Spectacle Prescription Report Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_AXIAL_MEASUREMENTS_STORAGE, "Ophthalmic Axial Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_INTRAOCULAR_LENS_CALCULATIONS_STORAGE, "Intraocular Lens Calculations Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MACULAR_GRID_THICKNESS_AND_VOLUME_REPORT_STORAGE, "Macular Grid Thickness and Volume Report Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_VISUAL_FIELD_STATIC_PERIMETRY_MEASUREMENTS_STORAGE, "Ophthalmic Visual Field Static Perimetry Measurements Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_OPHTHALMIC_THICKNESS_MAP_STORAGE, "Ophthalmic Thickness Map Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CORNEAL_TOPOGRAPHY_MAP_STORAGE, "Corneal Topography Map Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_TEXT_SR_STORAGE_TRIAL_RETIRED, "Text SR Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_AUDIO_SR_STORAGE_TRIAL_RETIRED, "Audio SR Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_DETAIL_SR_STORAGE_TRIAL_RETIRED, "Detail SR Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPREHENSIVE_SR_STORAGE_TRIAL_RETIRED, "Comprehensive SR Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_TEXT_SR_STORAGE, "Basic Text SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_SR_STORAGE, "Enhanced SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPREHENSIVE_SR_STORAGE, "Comprehensive SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPREHENSIVE_3D_SR_STORAGE, "Comprehensive 3D SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_EXTENSIBLE_SR_STORAGE, "Extensible SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PROCEDURE_LOG_STORAGE, "Procedure Log Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_MAMMOGRAPHY_CAD_SR_STORAGE, "Mammography CAD SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_KEY_OBJECT_SELECTION_DOCUMENT_STORAGE, "Key Object Selection Document Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CHEST_CAD_SR_STORAGE, "Chest CAD SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_X_RAY_RADIATION_DOSE_SR_STORAGE, "X-Ray Radiation Dose SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RADIOPHARMACEUTICAL_RADIATION_DOSE_SR_STORAGE, "Radiopharmaceutical Radiation Dose SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLON_CAD_SR_STORAGE, "Colon CAD SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANTATION_PLAN_SR_STORAGE, "Implantation Plan SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ACQUISITION_CONTEXT_SR_STORAGE, "Acquisition Context SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_SIMPLIFIED_ADULT_ECHO_SR_STORAGE, "Simplified Adult Echo SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENT_RADIATION_DOSE_SR_STORAGE, "Patient Radiation Dose SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PLANNED_IMAGING_AGENT_ADMINISTRATION_SR_STORAGE, "Planned Imaging Agent Administration SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PERFORMED_IMAGING_AGENT_ADMINISTRATION_SR_STORAGE, "Performed Imaging Agent Administration SR Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CONTENT_ASSESSMENT_RESULTS_STORAGE, "Content Assessment Results Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENCAPSULATED_PDF_STORAGE, "Encapsulated PDF Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENCAPSULATED_CDA_STORAGE, "Encapsulated CDA Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENCAPSULATED_STL_STORAGE, "Encapsulated STL Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_POSITRON_EMISSION_TOMOGRAPHY_IMAGE_STORAGE, "Positron Emission Tomography Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_LEGACY_CONVERTED_ENHANCED_PET_IMAGE_STORAGE, "Legacy Converted Enhanced PET Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_STANDALONE_PET_CURVE_STORAGE_RETIRED, "Standalone PET Curve Storage (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_ENHANCED_PET_IMAGE_STORAGE, "Enhanced PET Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_BASIC_STRUCTURED_DISPLAY_STORAGE, "Basic Structured Display Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CT_DEFINED_PROCEDURE_PROTOCOL_STORAGE, "CT Defined Procedure Protocol Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_CT_PERFORMED_PROCEDURE_PROTOCOL_STORAGE, "CT Performed Procedure Protocol Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_STORAGE, "Protocol Approval Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_FIND, "Protocol Approval Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_MOVE, "Protocol Approval Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_PROTOCOL_APPROVAL_INFORMATION_MODEL_GET, "Protocol Approval Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_IMAGE_STORAGE, "RT Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_DOSE_STORAGE, "RT Dose Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_STRUCTURE_SET_STORAGE, "RT Structure Set Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_BEAMS_TREATMENT_RECORD_STORAGE, "RT Beams Treatment Record Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_PLAN_STORAGE, "RT Plan Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_BRACHY_TREATMENT_RECORD_STORAGE, "RT Brachy Treatment Record Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_TREATMENT_SUMMARY_RECORD_STORAGE, "RT Treatment Summary Record Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_ION_PLAN_STORAGE, "RT Ion Plan Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_ION_BEAMS_TREATMENT_RECORD_STORAGE, "RT Ion Beams Treatment Record Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_PHYSICIAN_INTENT_STORAGE, "RT Physician Intent Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_SEGMENT_ANNOTATION_STORAGE, "RT Segment Annotation Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_RADIATION_SET_STORAGE, "RT Radiation Set Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_C_ARM_PHOTON_ELECTRON_RADIATION_STORAGE, "C-Arm Photon-Electron Radiation Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_CT_IMAGE_STORAGE, "DICOS CT Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PRESENTATION, "DICOS Digital X-Ray Image Storage - For Presentation", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_DIGITAL_X_RAY_IMAGE_STORAGE_FOR_PROCESSING, "DICOS Digital X-Ray Image Storage - For Processing", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_THREAT_DETECTION_REPORT_STORAGE, "DICOS Threat Detection Report Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_2D_AIT_STORAGE, "DICOS 2D AIT Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_3D_AIT_STORAGE, "DICOS 3D AIT Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_DICOS_QUADRUPOLE_RESONANCE_QR_STORAGE, "DICOS Quadrupole Resonance (QR) Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_EDDY_CURRENT_IMAGE_STORAGE, "Eddy Current Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_EDDY_CURRENT_MULTI_FRAME_IMAGE_STORAGE, "Eddy Current Multi-frame Image Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_FIND, "Patient Root Query/Retrieve Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_MOVE, "Patient Root Query/Retrieve Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENT_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_GET, "Patient Root Query/Retrieve Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_FIND, "Study Root Query/Retrieve Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_MOVE, "Study Root Query/Retrieve Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_STUDY_ROOT_QUERYRETRIEVE_INFORMATION_MODEL_GET, "Study Root Query/Retrieve Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_FIND_RETIRED, "Patient/Study Only Query/Retrieve Information Model - FIND (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_MOVE_RETIRED, "Patient/Study Only Query/Retrieve Information Model - MOVE (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_PATIENTSTUDY_ONLY_QUERYRETRIEVE_INFORMATION_MODEL_GET_RETIRED, "Patient/Study Only Query/Retrieve Information Model - GET (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_ROOT_RETRIEVE_MOVE, "Composite Instance Root Retrieve - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_ROOT_RETRIEVE_GET, "Composite Instance Root Retrieve - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_COMPOSITE_INSTANCE_RETRIEVE_WITHOUT_BULK_DATA_GET, "Composite Instance Retrieve Without Bulk Data - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_FIND, "Defined Procedure Protocol Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_MOVE, "Defined Procedure Protocol Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_DEFINED_PROCEDURE_PROTOCOL_INFORMATION_MODEL_GET, "Defined Procedure Protocol Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_MODALITY_WORKLIST_INFORMATION_MODEL_FIND, "Modality Worklist Information Model - FIND", "SOP Class"},
    { DCM_UID_META_SOP_CLASS_GENERAL_PURPOSE_WORKLIST_MANAGEMENT_META_SOP_CLASS_RETIRED, "General Purpose Worklist Management Meta SOP Class (Retired)", "Meta SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_PURPOSE_WORKLIST_INFORMATION_MODEL_FIND_RETIRED, "General Purpose Worklist Information Model - FIND (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_PURPOSE_SCHEDULED_PROCEDURE_STEP_SOP_CLASS_RETIRED, "General Purpose Scheduled Procedure Step SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_PURPOSE_PERFORMED_PROCEDURE_STEP_SOP_CLASS_RETIRED, "General Purpose Performed Procedure Step SOP Class (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_INSTANCE_AVAILABILITY_NOTIFICATION, "Instance Availability Notification SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_BEAMS_DELIVERY_INSTRUCTION_STORAGE_TRIAL_RETIRED, "RT Beams Delivery Instruction Storage - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_CONVENTIONAL_MACHINE_VERIFICATION_TRIAL_RETIRED, "RT Conventional Machine Verification - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_ION_MACHINE_VERIFICATION_TRIAL_RETIRED, "RT Ion Machine Verification - Trial (Retired)", "SOP Class"},
    { DCM_UID_SERVICE_CLASS_UNIFIED_WORKLIST_AND_PROCEDURE_STEP_SERVICE_CLASS_TRIAL_RETIRED, "Unified Worklist and Procedure Step Service Class - Trial (Retired)", "Service Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PUSH_SOP_CLASS_TRIAL_RETIRED, "Unified Procedure Step - Push SOP Class - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_WATCH_SOP_CLASS_TRIAL_RETIRED, "Unified Procedure Step - Watch SOP Class - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PULL_SOP_CLASS_TRIAL_RETIRED, "Unified Procedure Step - Pull SOP Class - Trial (Retired)", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_EVENT_SOP_CLASS_TRIAL_RETIRED, "Unified Procedure Step - Event SOP Class - Trial (Retired)", "SOP Class"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_UPS_GLOBAL_SUBSCRIPTION_SOP_INSTANCE, "UPS Global Subscription SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_WELL_KNOWN_SOP_INSTANCE_UPS_FILTERED_GLOBAL_SUBSCRIPTION_SOP_INSTANCE, "UPS Filtered Global Subscription SOP Instance", "Well-known SOP Instance"},
    { DCM_UID_SERVICE_CLASS_UNIFIED_WORKLIST_AND_PROCEDURE_STEP, "Unified Worklist and Procedure Step Service Class", "Service Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PUSH, "Unified Procedure Step - Push SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_WATCH, "Unified Procedure Step - Watch SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_PULL, "Unified Procedure Step - Pull SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_EVENT, "Unified Procedure Step - Event SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_UNIFIED_PROCEDURE_STEP_QUERY, "Unified Procedure Step - Query SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_BEAMS_DELIVERY_INSTRUCTION_STORAGE, "RT Beams Delivery Instruction Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_CONVENTIONAL_MACHINE_VERIFICATION, "RT Conventional Machine Verification", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_ION_MACHINE_VERIFICATION, "RT Ion Machine Verification", "SOP Class"},
    { DCM_UID_SOP_CLASS_RT_BRACHY_APPLICATION_SETUP_DELIVERY_INSTRUCTION_STORAGE, "RT Brachy Application Setup Delivery Instruction Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERAL_RELEVANT_PATIENT_INFORMATION_QUERY, "General Relevant Patient Information Query", "SOP Class"},
    { DCM_UID_SOP_CLASS_BREAST_IMAGING_RELEVANT_PATIENT_INFORMATION_QUERY, "Breast Imaging Relevant Patient Information Query", "SOP Class"},
    { DCM_UID_SOP_CLASS_CARDIAC_RELEVANT_PATIENT_INFORMATION_QUERY, "Cardiac Relevant Patient Information Query", "SOP Class"},
    { DCM_UID_SOP_CLASS_HANGING_PROTOCOL_STORAGE, "Hanging Protocol Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_FIND, "Hanging Protocol Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_MOVE, "Hanging Protocol Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_HANGING_PROTOCOL_INFORMATION_MODEL_GET, "Hanging Protocol Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLOR_PALETTE_STORAGE, "Color Palette Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_FIND, "Color Palette Query/Retrieve Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_MOVE, "Color Palette Query/Retrieve Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_COLOR_PALETTE_QUERYRETRIEVE_INFORMATION_MODEL_GET, "Color Palette Query/Retrieve Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_PRODUCT_CHARACTERISTICS_QUERY, "Product Characteristics Query SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_SUBSTANCE_APPROVAL_QUERY, "Substance Approval Query SOP Class", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_STORAGE, "Generic Implant Template Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_FIND, "Generic Implant Template Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_MOVE, "Generic Implant Template Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_GENERIC_IMPLANT_TEMPLATE_INFORMATION_MODEL_GET, "Generic Implant Template Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_STORAGE, "Implant Assembly Template Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_FIND, "Implant Assembly Template Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_MOVE, "Implant Assembly Template Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_ASSEMBLY_TEMPLATE_INFORMATION_MODEL_GET, "Implant Assembly Template Information Model - GET", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_STORAGE, "Implant Template Group Storage", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_FIND, "Implant Template Group Information Model - FIND", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_MOVE, "Implant Template Group Information Model - MOVE", "SOP Class"},
    { DCM_UID_SOP_CLASS_IMPLANT_TEMPLATE_GROUP_INFORMATION_MODEL_GET, "Implant Template Group Information Model - GET", "SOP Class"},
    { DCM_UID_APPLICATION_HOSTING_MODEL_NATIVE_DICOM_MODEL, "Native DICOM Model", "Application Hosting Model"},
    { DCM_UID_APPLICATION_HOSTING_MODEL_ABSTRACT_MULTI_DIMENSIONAL_IMAGE_MODEL, "Abstract Multi-Dimensional Image Model", "Application Hosting Model"},
    { DCM_UID_MAPPING_RESOURCE_DICOM_CONTENT, "DICOM Content Mapping Resource", "Mapping Resource"},
    { DCM_UID_SOP_CLASS_VIDEO_ENDOSCOPIC_IMAGE_REAL_TIME_COMMUNICATION, "Video Endoscopic Image Real-Time Communication", "SOP Class"},
    { DCM_UID_SOP_CLASS_VIDEO_PHOTOGRAPHIC_IMAGE_REAL_TIME_COMMUNICATION, "Video Photographic Image Real-Time Communication", "SOP Class"},
    { DCM_UID_SOP_CLASS_AUDIO_WAVEFORM_REAL_TIME_COMMUNICATION, "Audio Waveform Real-Time Communication", "SOP Class"},
    { DCM_UID_SOP_CLASS_RENDITION_SELECTION_DOCUMENT_REAL_TIME_COMMUNICATION, "Rendition Selection Document Real-Time Communication", "SOP Class"},
    { DCM_UID_LDAP_OID_DICOMDEVICENAME, "dicomDeviceName", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMDESCRIPTION, "dicomDescription", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMMANUFACTURER, "dicomManufacturer", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMMANUFACTURERMODELNAME, "dicomManufacturerModelName", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMSOFTWAREVERSION, "dicomSoftwareVersion", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMVENDORDATA, "dicomVendorData", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMAETITLE, "dicomAETitle", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMNETWORKCONNECTIONREFERENCE, "dicomNetworkConnectionReference", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMAPPLICATIONCLUSTER, "dicomApplicationCluster", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMASSOCIATIONINITIATOR, "dicomAssociationInitiator", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMASSOCIATIONACCEPTOR, "dicomAssociationAcceptor", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMHOSTNAME, "dicomHostname", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMPORT, "dicomPort", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMSOPCLASS, "dicomSOPClass", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMTRANSFERROLE, "dicomTransferRole", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMTRANSFERSYNTAX, "dicomTransferSyntax", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMPRIMARYDEVICETYPE, "dicomPrimaryDeviceType", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMRELATEDDEVICEREFERENCE, "dicomRelatedDeviceReference", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMPREFERREDCALLEDAETITLE, "dicomPreferredCalledAETitle", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMTLSCYPHERSUITE, "dicomTLSCyphersuite", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMAUTHORIZEDNODECERTIFICATEREFERENCE, "dicomAuthorizedNodeCertificateReference", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMTHISNODECERTIFICATEREFERENCE, "dicomThisNodeCertificateReference", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMINSTALLED, "dicomInstalled", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMSTATIONNAME, "dicomStationName", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMDEVICESERIALNUMBER, "dicomDeviceSerialNumber", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMINSTITUTIONNAME, "dicomInstitutionName", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMINSTITUTIONADDRESS, "dicomInstitutionAddress", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMINSTITUTIONDEPARTMENTNAME, "dicomInstitutionDepartmentName", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMISSUEROFPATIENTID, "dicomIssuerOfPatientID", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMPREFERREDCALLINGAETITLE, "dicomPreferredCallingAETitle", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMSUPPORTEDCHARACTERSET, "dicomSupportedCharacterSet", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMCONFIGURATIONROOT, "dicomConfigurationRoot", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMDEVICESROOT, "dicomDevicesRoot", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMUNIQUEAETITLESREGISTRYROOT, "dicomUniqueAETitlesRegistryRoot", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMDEVICE, "dicomDevice", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMNETWORKAE, "dicomNetworkAE", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMNETWORKCONNECTION, "dicomNetworkConnection", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMUNIQUEAETITLE, "dicomUniqueAETitle", "LDAP OID"},
    { DCM_UID_LDAP_OID_DICOMTRANSFERCAPABILITY, "dicomTransferCapability", "LDAP OID"},
    { DCM_UID_SYNCHRONIZATION_FRAME_OF_REFERENCE_UNIVERSAL_COORDINATED_TIME, "Universal Coordinated Time", "Synchronization Frame of Reference"},
};

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* packet-dcm.h */
